<?php
session_start();

// Check if user is logged in
if (!isset($_SESSION['user_id']) && !isset($_SESSION['user_email'])) {
    // User not logged in, redirect to index page
    header('Location: index.php');
    exit();
}
?>
<!DOCTYPE html>
<html dir="ltr" lang="en-US">

<head>
    <!-- Document Meta
    ============================================= -->
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <!--IE Compatibility Meta-->
    <meta name="author" content="zytheme">
    <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1">
    <meta name="description" content="Elegant Restaurant & Cafe Html5 Template">
    <link href="assets/images/favicon/favicon.png" rel="icon">

    <!-- Fonts
    ============================================= -->
    <link
        href="../css?family=Great+Vibes%7CKaushan+Script%7CRaleway:100,100i,200,200i,300,300i,400,400i,500,500i,600,600i,700,700i,800,800i,900,900i"
        rel="stylesheet" type="text/css">

    <!-- Font Awesome Icons
    ============================================= -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">

    <!-- Swiper CSS -->
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/swiper@11/swiper-bundle.min.css">

    <!-- Stylesheets
    ============================================= -->
    <link href="assets/css/external.css" rel="stylesheet">
    <link href="assets/css/bootstrap.min.css" rel="stylesheet">
    <link href="assets/css/style.css" rel="stylesheet">
    <link href="assets/css/custom-sections.css" rel="stylesheet">
    <link href="assets/css/menu-showcase.css" rel="stylesheet">
    <link href="assets/css/testimonial-new.css" rel="stylesheet">
    <link href="assets/css/blog-section.css" rel="stylesheet">
    <link href="assets/css/cart.css" rel="stylesheet">

    <!-- RS5.0 Main Stylesheet -->
    <link rel="stylesheet" type="text/css" href="assets/revolution/css/settings.css">
    <link rel="stylesheet" type="text/css" href="assets/revolution/css/layers.css">
    <link rel="stylesheet" type="text/css" href="assets/revolution/css/navigation.css">

    <!-- HTML5 shim, for IE6-8 support of HTML5 elements. All other JS at the end of file. -->
    <!--[if lt IE 9]>
      <script src="assets/js/html5shiv.js"></script>
      <script src="assets/js/respond.min.js"></script>
    <![endif]-->

    <!-- Document Title
    ============================================= -->
    <title>Home Page</title>
</head>

<body>
    <div class="preloader">
        <div class="spinner">
            <div class="bounce1"></div>
            <div class="bounce2"></div>
            <div class="bounce3"></div>
        </div>
    </div>
    <!-- Document Wrapper
	============================================= -->
    <div id="wrapper" class="wrapper clearfix">
        <!-- New Header -->
        <!-- Top Announcement Bar -->
        <div class="header-top-bar">
            <div class="container">
                <div class="header-top-bar-text">Welcome to Granny Restaurant & Catering Services</div>
                <div class="header-social-icons">
                    <a href="#" title="Facebook"><i class="fab fa-facebook-f"></i></a>
                    <a href="#" title="Twitter"><i class="fab fa-twitter"></i></a>
                    <a href="#" title="Instagram"><i class="fab fa-instagram"></i></a>
                    <a href="#" title="WhatsApp"><i class="fab fa-whatsapp"></i></a>
                    <a href="#" title="YouTube"><i class="fab fa-youtube"></i></a>
                </div>
            </div>
        </div>
        <!-- Main Header -->
        <header class="header-main">
            <div class="container">
                <div class="header-logo">
                    <a href="index.php"><img src="assets/images/logo/logo-dark.png" alt="Granny Logo"></a>
                </div>

                <div style="display: flex; align-items: center; gap: 20px; flex: 1;">
                    <div class="header-contact-info">
                        <a href="tel:+919876543210" class="header-contact-item">
                            <i class="fas fa-phone"></i>
                            <div class="header-contact-text">
                                <span class="header-contact-label">Call Us:</span>
                                <span class="header-contact-value">+91 98765 43210</span>
                            </div>
                        </a>
                        <a href="mailto:info@granny.com" class="header-contact-item">
                            <i class="fas fa-envelope"></i>
                            <div class="header-contact-text">
                                <span class="header-contact-label">Mail Us:</span>
                                <span class="header-contact-value">info@granny.com</span>
                            </div>
                        </a>
                        <a href="#" class="header-contact-item">
                            <i class="fas fa-map-marker-alt"></i>
                            <div class="header-contact-text">
                                <span class="header-contact-label">Location:</span>
                                <span class="header-contact-value">Egypt</span>
                            </div>
                        </a>
                    </div>
                    <div class="header-booking-section" id="bookingSection">
                        <button class="header-booking-btn" data-toggle="modal" data-target="#reservationPopup">Table Booking</button>
                    </div>
                    <div class="user-profile-dropdown" id="userProfileDropdown" style="display: none;">
                        <button class="user-profile-btn" id="userProfileBtn">
                            <i class="fas fa-user-circle"></i>
                            <span class="user-name" id="userName"></span>
                        </button>
                        <div class="user-dropdown-menu" id="userDropdownMenu">
                            <a href="#" class="dropdown-item user-profile-link">
                                <i class="fas fa-user"></i> My Profile
                            </a>
                            <a href="#" class="dropdown-item user-settings-link">
                                <i class="fas fa-cog"></i> Settings
                            </a>
                            <div class="dropdown-divider"></div>
                            <a href="#" class="dropdown-item user-logout-link" id="logoutBtn">
                                <i class="fas fa-sign-out-alt"></i> Logout
                            </a>
                        </div>
                    </div>
                </div>
                </div>
        </header>
        <!-- Navigation Bar -->
        <nav class="header-nav-bar">
            <div class="container"
                style="display: flex; justify-content: space-between; align-items: center; padding: 0;">
                <div class="header-navbar-logo">
                    <a href="index.php"><img src="assets/images/logo/logo-light.png" alt="Granny Logo"></a>
                </div>
                <ul class="header-nav-menu" id="headerNavMenu">
                    <li><a href="index.php">Home</a></li>
                    <li>
                        <a href="about.php">About Us</a>

                    </li>
                    <li>
                        <a href="menu.php">Menu</a>

                    </li>
                    <li><a href="chefs.php">Our Chefs</a></li>
                    <li><a href="blog.php">Blog</a></li>
                    <!-- <li><a href="shop-4cols.html">Shop</a></li> -->
                    <li><a href="gallery.php">Gallery</a></li>
                    <li><a href="contacts.php">Contact Us</a></li>
                    <!-- Mobile Only Cart Icon -->
                    <li class="mobile-cart-item"
                        style="border-top: 2px solid #c59d5f; margin: 10px 0; padding: 10px 15px;">
                        <a href="cart.php" class="header-cart-icon"
                            style="display: flex; align-items: center; gap: 10px; color: #ffffff; text-decoration: none; padding: 0; font-size: 16px;">
                            <i class="fas fa-shopping-cart"></i>
                            <span>Cart</span>
                            <span class="header-cart-count">0</span>
                        </a>
                    </li>
                    <!-- Mobile Only Booking Button -->
                    <li class="mobile-booking-item">
                        <button class="header-booking-btn" data-toggle="modal" data-target="#reservationPopup"
                            style="width: 100%; display: block; padding: 12px 15px; background-color: #c59d5f; color: #ffffff; border: none; border-radius: 4px; font-size: 14px; font-weight: 700; text-transform: uppercase; cursor: pointer; transition: all 0.3s ease;">Booking</button>
                    </li>
                    <!-- Mobile Only Auth Section -->
                    <li class="mobile-auth-divider" id="mobileAuthSection"
                        style="border-top: 2px solid #c59d5f; margin: 10px 0; padding: 10px 0;">
                        <a href="#" class="header-auth-btn header-signin-btn" data-toggle="modal"
                            data-target="#signInModal"
                            style="display: block; padding: 12px 15px; text-align: center; width: 100%; box-sizing: border-box; margin-bottom: 10px; border: 2px solid #c59d5f; background-color: transparent; color: #c59d5f; border-radius: 4px; font-size: 14px; font-weight: 600;">Sign
                            In</a>
                        <a href="#" class="header-auth-btn header-signup-btn" data-toggle="modal"
                            data-target="#signUpModal"
                            style="display: block; padding: 12px 15px; text-align: center; width: 100%; box-sizing: border-box; background-color: #c59d5f; color: #ffffff; border: 2px solid #c59d5f; border-radius: 4px; font-size: 14px; font-weight: 600;">Sign
                            Up</a>
                    </li>
        
                </ul>
                <div class="header-nav-right">
                    <a href="cart.php" class="header-cart-icon">
                        <i class="fas fa-shopping-cart"></i>
                        <span class="header-cart-count">0</span>
                    </a>
                    <div class="header-auth-section" id="navAuthSection">
                        <a href="#" class="header-auth-btn header-signin-btn" data-toggle="modal"
                            data-target="#signInModal">Sign In</a>
                        <a href="#" class="header-auth-btn header-signup-btn" data-toggle="modal"
                            data-target="#signUpModal">Sign Up</a>
                    </div>
                    <div class="nav-user-profile-dropdown" id="navUserProfileDropdown" style="display: none;">
                        <button class="nav-user-profile-btn" id="navUserProfileBtn">
                            <i class="fas fa-user-circle"></i>
                            <span class="nav-user-name" id="navUserName"></span>
                        </button>
                        <div class="nav-user-dropdown-menu" id="navUserDropdownMenu">
                            <a href="dashboard.php" class="dropdown-item user-profile-link">
                                <i class="fa-solid fa-gauge"></i> Dashboard
                            </a>
                            <!-- <a href="#" class="dropdown-item user-settings-link">
                                <i class="fas fa-cog"></i> Settings
                            </a> -->
                            <!-- <div class="dropdown-divider"></div> -->
                            <a href="#" class="dropdown-item user-logout-link" id="navLogoutBtn">
                                <i class="fas fa-sign-out-alt"></i> Logout
                            </a>
                        </div>
                    </div>
                </div>
                <!-- Mobile Profile Icon (shown when logged in) -->
                <div class="mobile-profile-icon-container" id="mobileProfileIconContainer" style="display: none;">
                    <button class="mobile-profile-icon-btn" id="mobileProfileIconBtn">
                        <i class="fas fa-user-circle"></i>
                        <span class="mobile-user-name" id="mobileUserName"></span>
                    </button>
                    <div class="mobile-profile-dropdown-menu" id="mobileProfileDropdownMenu">
                        <a href="dashboard.php" class="dropdown-item user-profile-link">
                            <i class="fa-solid fa-gauge"></i> Dashboard
                        </a>
                        <!-- <a href="#" class="dropdown-item user-settings-link">
                            <i class="fas fa-cog"></i> Settings
                        </a> -->
                        <!-- <div class="dropdown-divider"></div> -->
                        <a href="#" class="dropdown-item user-logout-link" id="mobileProfileLogoutBtn">
                            <i class="fas fa-sign-out-alt"></i> Logout
                        </a>
                    </div>
                </div>
                <button class="header-mobile-toggle" id="headerMenuToggle">
                    <i class="fas fa-bars"></i>
                    <span class="hamburger-cart-badge header-cart-count">0</span>
                </button>
            </div>
        </nav>

        <!-- Table Bookings Content Section -->
        <div class="bookings-section" style="min-height: 100vh; padding: 60px 20px; background: #f8f8f8;">
            <div class="container" style="max-width: 1200px;">
                
                <!-- Page Header -->
                <div class="bookings-header" style="margin-bottom: 50px;">
                    <h1 style="color: #333; font-size: 36px; margin: 0 0 10px 0; font-weight: 600;">My Table Bookings</h1>
                    <p style="color: #666; font-size: 16px; margin: 0;">View and manage all your restaurant reservations</p>
                </div>

                <!-- Stats Cards -->
                <div style="display: grid; grid-template-columns: repeat(auto-fit, minmax(200px, 1fr)); gap: 20px; margin-bottom: 40px;">
                    
                    <!-- Total Bookings -->
                    <div style="background: white; padding: 20px; border-radius: 10px; box-shadow: 0 2px 8px rgba(0,0,0,0.08); text-align: center; border-left: 4px solid #c59d5f;">
                        <div style="font-size: 32px; color: #c59d5f; font-weight: 600; margin-bottom: 5px;" id="totalBookings">0</div>
                        <div style="color: #666; font-size: 14px; font-weight: 600;">Total Bookings</div>
                    </div>

                    <!-- Confirmed Bookings -->
                    <div style="background: white; padding: 20px; border-radius: 10px; box-shadow: 0 2px 8px rgba(0,0,0,0.08); text-align: center; border-left: 4px solid #27ae60;">
                        <div style="font-size: 32px; color: #27ae60; font-weight: 600; margin-bottom: 5px;" id="confirmedBookings">0</div>
                        <div style="color: #666; font-size: 14px; font-weight: 600;">Confirmed</div>
                    </div>

                    <!-- Pending Bookings -->
                    <div style="background: white; padding: 20px; border-radius: 10px; box-shadow: 0 2px 8px rgba(0,0,0,0.08); text-align: center; border-left: 4px solid #f39c12;">
                        <div style="font-size: 32px; color: #f39c12; font-weight: 600; margin-bottom: 5px;" id="pendingBookings">0</div>
                        <div style="color: #666; font-size: 14px; font-weight: 600;">Pending</div>
                    </div>

                    <!-- Cancelled Bookings -->
                    <div style="background: white; padding: 20px; border-radius: 10px; box-shadow: 0 2px 8px rgba(0,0,0,0.08); text-align: center; border-left: 4px solid #e74c3c;">
                        <div style="font-size: 32px; color: #e74c3c; font-weight: 600; margin-bottom: 5px;" id="cancelledBookings">0</div>
                        <div style="color: #666; font-size: 14px; font-weight: 600;">Cancelled</div>
                    </div>

                </div>

                <!-- Action Button -->
                <div style="margin-bottom: 40px;">
                    <button id="newBookingBtn" style="display: inline-block; background: #c59d5f; color: white; padding: 12px 30px; border-radius: 8px; text-decoration: none; font-weight: 600; transition: background 0.3s ease; border: none; cursor: pointer; font-size: 15px;" onmouseover="this.style.background='#b8855a';" onmouseout="this.style.background='#c59d5f';">
                        <i class="fas fa-plus-circle" style="margin-right: 8px;"></i> New Booking
                    </button>
                </div>

                <!-- Bookings Container -->
                <div id="bookingsContainer" style="background: white; border-radius: 10px; box-shadow: 0 2px 8px rgba(0,0,0,0.08); overflow: hidden; width: fit-content; max-width: 100%;">
                    
                    <!-- Loading State -->
                    <div id="loadingState" style="padding: 60px 20px; text-align: center;">
                        <i class="fas fa-spinner fa-spin" style="font-size: 40px; color: #c59d5f; margin-bottom: 20px; display: block;"></i>
                        <p style="color: #666; font-size: 16px;">Loading your bookings...</p>
                    </div>

                    <!-- Empty State -->
                    <div id="emptyState" style="padding: 60px 40px; text-align: center; display: none; background: linear-gradient(135deg, #f9f7f2 0%, #ffffff 100%);">
                        <i class="fas fa-calendar-times" style="font-size: 72px; color: #d4a574; margin-bottom: 25px; display: block; opacity: 0.6;"></i>
                        <h3 style="color: #333; font-size: 26px; margin: 0 0 12px 0; font-weight: 700;">No Bookings Yet</h3>
                        <p style="color: #666; margin: 0 0 30px 0; font-size: 15px; line-height: 1.6;">You haven't made any table bookings yet. Create your first booking today!</p>
                        <button id="emptyStateBookingBtn" style="display: inline-block; background: #c59d5f; color: white; padding: 12px 35px; border-radius: 6px; text-decoration: none; font-weight: 600; border: none; cursor: pointer; font-size: 15px; transition: all 0.3s ease; box-shadow: 0 3px 10px rgba(197, 157, 95, 0.3);" onmouseover="this.style.background='#b8855a'; this.style.boxShadow='0 5px 15px rgba(197, 157, 95, 0.5)';" onmouseout="this.style.background='#c59d5f'; this.style.boxShadow='0 3px 10px rgba(197, 157, 95, 0.3)';">Make a Booking</button>
                    </div>

                    <!-- Desktop View - Table -->
                    <div id="tableView" style="display: none; overflow-x: auto; width: 100%;">
                        <table style="width: 100%; border-collapse: collapse; table-layout: auto;">
                            <thead>
                                <tr style="background: #f9f9f9; border-bottom: 2px solid #c59d5f;">
                                    <th style="padding: 15px; text-align: left; color: #333; font-weight: 700; font-size: 14px; white-space: nowrap;">Date & Time</th>
                                    <th style="padding: 15px; text-align: left; color: #333; font-weight: 700; font-size: 14px; white-space: nowrap;">Guest Name</th>
                                    <th style="padding: 15px; text-align: left; color: #333; font-weight: 700; font-size: 14px; white-space: nowrap;">Email</th>
                                    <th style="padding: 15px; text-align: left; color: #333; font-weight: 700; font-size: 14px; white-space: nowrap;">Phone</th>
                                    <th style="padding: 15px; text-align: center; color: #333; font-weight: 700; font-size: 14px; white-space: nowrap;">Guests</th>
                                    <th style="padding: 15px; text-align: center; color: #333; font-weight: 700; font-size: 14px; white-space: nowrap;">Occasion</th>
                                    <th style="padding: 15px; text-align: center; color: #333; font-weight: 700; font-size: 14px; white-space: nowrap;">Status</th>
                                    <th style="padding: 15px; text-align: center; color: #333; font-weight: 700; font-size: 14px; white-space: nowrap;">Action</th>
                                </tr>
                            </thead>
                            <tbody id="bookingsTableBody">
                                <!-- Bookings will be populated here -->
                            </tbody>
                        </table>
                    </div>

                    <!-- Mobile View - Cards -->
                    <div id="cardsView" style="display: none; padding: 20px;">
                        <div id="bookingsCardsContainer">
                            <!-- Booking cards will be populated here -->
                        </div>
                    </div>

                </div>

            </div>
        </div>

        <!-- Responsive CSS -->
        <style>
            @media (max-width: 768px) {
                .bookings-section {
                    padding: 40px 15px !important;
                }
                .bookings-header h1 {
                    font-size: 28px !important;
                }
                #tableView {
                    display: none !important;
                }
                #cardsView {
                    display: block !important;
                }
            }

            @media (min-width: 769px) {
                #tableView {
                    display: table !important;
                }
                #cardsView {
                    display: none !important;
                }
            }

            @media (max-width: 480px) {
                .bookings-section {
                    padding: 30px 15px !important;
                }
                .bookings-header h1 {
                    font-size: 22px !important;
                }
                .bookings-header p {
                    font-size: 14px !important;
                }
            }

            table tr {
                border-bottom: 1px solid #e8e8e8;
                transition: background 0.2s ease;
            }

            table tbody tr:hover {
                background: #fafafa;
            }

            .status-badge {
                display: inline-block;
                padding: 6px 12px;
                border-radius: 20px;
                font-size: 12px;
                font-weight: 600;
                text-transform: uppercase;
                letter-spacing: 0.5px;
            }

            .status-pending {
                background: #fff3cd;
                color: #856404;
                border: 1px solid #ffeaa7;
            }

            .status-confirmed {
                background: #d4edda;
                color: #155724;
                border: 1px solid #c3e6cb;
            }

            .status-cancelled {
                background: #f8d7da;
                color: #721c24;
                border: 1px solid #f5c6cb;
            }

            .booking-card {
                background: white;
                border: 1px solid #e8e8e8;
                border-radius: 8px;
                padding: 20px;
                margin-bottom: 15px;
                transition: box-shadow 0.3s ease, transform 0.3s ease;
            }

            .booking-card:hover {
                box-shadow: 0 4px 12px rgba(0,0,0,0.1);
                transform: translateY(-2px);
            }

            .action-btn {
                padding: 8px 12px;
                border: none;
                border-radius: 6px;
                font-size: 12px;
                font-weight: 600;
                cursor: pointer;
                transition: all 0.3s ease;
                text-decoration: none;
                display: inline-block;
                margin: 0 4px;
            }

            .view-btn {
                background: #c59d5f;
                color: white;
            }

            .view-btn:hover {
                background: #b8855a;
            }

            .cancel-btn {
                background: #e74c3c;
                color: white;
            }

            .cancel-btn:hover {
                background: #c0392b;
            }

            .cancel-btn:disabled {
                background: #bdc3c7;
                cursor: not-allowed;
            }
        </style>

        <footer id="footer" class="footer footer-premium">
            <!-- Premium Footer Widget Section -->
            <div class="footer--widget-premium">
                <div class="container">
                    <div class="row">
                        <!-- Footer Logo & Description -->
                        <div class="col-xs-12 col-sm-12 col-md-3 footer--col-about">
                            <div class="footer--logo-section">
                                <img src="assets/images/logo/logo-light.png" alt="Granny Logo" class="footer--logo">
                                <p class="footer--tagline">Crafted with passion and served with love since 2015</p>
                                <div class="footer--description">
                                    <p>Experience culinary excellence at Granny. Our award-winning chefs blend
                                        traditional flavors with modern techniques to create unforgettable dining
                                        moments.</p>
                                </div>
                            </div>
                            <!-- Follow Us Section -->
                            <div class="footer--social-icons-widget">
                                <p
                                    style="font-size: 14px; margin-top: 20px; margin-bottom: 10px; color: #c59d5f; font-weight: 600;">
                                    Follow Us</p>
                                <div class="social-icons-list">
                                    <a href="#" class="social-icon-widget" title="Facebook"><i
                                            class="fa fa-facebook"></i></a>
                                    <a href="#" class="social-icon-widget" title="Instagram"><i
                                            class="fa fa-instagram"></i></a>
                                    <a href="#" class="social-icon-widget" title="Twitter"><i
                                            class="fa fa-twitter"></i></a>
                                    <a href="#" class="social-icon-widget" title="Pinterest"><i
                                            class="fa fa-pinterest"></i></a>
                                    <a href="#" class="social-icon-widget" title="TripAdvisor"><i
                                            class="fa fa-tripadvisor"></i></a>
                                </div>
                            </div>
                        </div>
                        <!-- .col-md-3 end -->

                        <!-- Quick Links -->
                        <div class="col-xs-12 col-sm-6 col-md-3 footer--col-links">
                            <h4 class="footer--title">Quick Links</h4>
                            <ul class="footer--menu">
                                <li><a href="index.html">Home</a></li>
                                <li><a href="menu-board.html">Our Menu</a></li>
                                <li><a href="page-about.html">About Us</a></li>
                                <li><a href="page-gallery.html">Gallery</a></li>
                                <li><a href="page-contacts.html">Contact</a></li>
                                <li><a href="blog-carousel.html">Blog</a></li>
                            </ul>
                        </div>
                        <!-- .col-md-3 end -->

                        <!-- Location & Hours -->
                        <div class="col-xs-12 col-sm-6 col-md-3 footer--col-info">
                            <h4 class="footer--title">Visit Us</h4>
                            <div class="footer--info-item">
                                <i class="fa fa-map-marker"></i>
                                <div class="footer--info-content">
                                    <p><strong>Address</strong><br>22 Alnahas Building, 2 AlBahr St<br>Tanta,
                                        Al-Gharbia, Egypt</p>
                                </div>
                            </div>
                            <div class="footer--info-item">
                                <i class="fa fa-clock-o"></i>
                                <div class="footer--info-content">
                                    <p><strong>Hours</strong><br>Mon-Fri: 9:00 AM � 12:00 AM<br>Sat: 8:00 AM � 3:00
                                        AM<br>Sun: Closed</p>
                                </div>
                            </div>
                        </div>
                        <!-- .col-md-3 end -->

                        <!-- Contact -->
                        <div class="col-xs-12 col-sm-12 col-md-3 footer--col-contact">
                            <h4 class="footer--title">Connect</h4>
                            <div class="footer--contact-info">
                                <p><i class="fa fa-phone"></i> <a href="tel:+201065370701">(+20) 106-537-0701</a></p>
                                <p><i class="fa fa-envelope"></i> <a href="mailto:info@granny.com">info@granny.com</a>
                                </p>
                            </div>

                        </div>
                    </div>
                    <!-- .col-md-3 end -->
                </div>
                <!-- .row end -->
            </div>
            <!-- .container end -->
    </div>
    <!-- .footer-widget-premium end -->

    <!-- Divider -->
    <div class="footer--divider"></div>

    <!-- Premium Copyright Section -->
    <div class="footer--copyright-premium">
        <div class="container">
            <div class="row">
                <div class="col-xs-12 col-sm-12 col-md-12">
                    <div class="footer--copyright-wrapper">
                        <p class="footer--copyright-text">&copy; 2026 <strong>Granny Restaurant & Cafe</strong>. All
                            rights reserved. | Crafted with <i class="fa fa-heart"></i> for food lovers.</p>
                        <div class="footer--links-legal">
                            <a href="#">Privacy Policy</a>
                            <span class="separator">�</span>
                            <a href="#">Terms of Service</a>
                            <span class="separator">�</span>
                            <a href="#">Cookies</a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- .container end -->
    </div>
    <!-- .footer-copyright-premium end -->
    </footer>
    </div>
    <!-- #wrapper end -->

    <!-- Footer Scripts
============================================= -->
    <script data-cfasync="false" src="/cdn-cgi/scripts/5c5dd728/cloudflare-static/email-decode.min.js"></script>
    <script src="assets/js/jquery-2.2.4.min.js"></script>
    <script src="assets/js/plugins.js"></script>
    <script src="assets/js/functions.js"></script>
    <script src="assets/js/cart-manager.js"></script>
    <!-- Swiper JS -->
    <script src="https://cdn.jsdelivr.net/npm/swiper@11/swiper-bundle.min.js"></script>
    <!-- Slider Init -->
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            const testimonialSlider = new Swiper('.testimonial-slider', {
                slidesPerView: 1,
                spaceBetween: 30,
                speed: 800,
                effect: 'slide',
                pagination: {
                    el: '.testimonial-slider .swiper-pagination',
                    clickable: true,
                    dynamicBullets: true,
                    dynamicMainBullets: 3
                },
                autoplay: {
                    delay: 5000,
                    disableOnInteraction: false,
                    pauseOnMouseEnter: true
                },
                easing: 'cubic-bezier(0.25, 0.46, 0.45, 0.94)',
                breakpoints: {
                    768: {
                        slidesPerView: 2,
                        spaceBetween: 25
                    },
                    1024: {
                        slidesPerView: 3,
                        spaceBetween: 30
                    }
                }
            });

            const blogSlider = new Swiper('.blog-slider', {
                slidesPerView: 1,
                spaceBetween: 30,
                speed: 800,
                effect: 'slide',
                pagination: {
                    el: '.blog-slider .swiper-pagination',
                    clickable: true,
                    dynamicBullets: true,
                    dynamicMainBullets: 3
                },
                autoplay: {
                    delay: 6000,
                    disableOnInteraction: false,
                    pauseOnMouseEnter: true
                },
                easing: 'cubic-bezier(0.25, 0.46, 0.45, 0.94)',
                breakpoints: {
                    768: {
                        slidesPerView: 2,
                        spaceBetween: 25
                    },
                    1024: {
                        slidesPerView: 3,
                        spaceBetween: 30
                    }
                }
            });
        });
    </script>
    <!-- RS5.0 Core JS Files -->
    <script src="assets/revolution/js/jquery.themepunch.tools.min.js?rev=5.0"></script>
    <script src="assets/revolution/js/jquery.themepunch.revolution.min.js?rev=5.0"></script>
    <script src="assets/revolution/js/extensions/revolution.extension.video.min.js"></script>
    <script src="assets/revolution/js/extensions/revolution.extension.slideanims.min.js"></script>
    <script src="assets/revolution/js/extensions/revolution.extension.actions.min.js"></script>
    <script src="assets/revolution/js/extensions/revolution.extension.layeranimation.min.js"></script>
    <script src="assets/revolution/js/extensions/revolution.extension.kenburn.min.js"></script>
    <script src="assets/revolution/js/extensions/revolution.extension.navigation.min.js"></script>
    <script src="assets/revolution/js/extensions/revolution.extension.migration.min.js"></script>
    <script src="assets/revolution/js/extensions/revolution.extension.parallax.min.js"></script>
    <!-- RS Configration JS Files -->
    <script src="assets/js/rsconfig.js"></script>

    <!-- Professional Table Booking Modal -->
    <div class="modal fade reservation-popup" tabindex="-1" role="dialog" id="reservationPopup">
        <div class="modal-dialog modal-lg" role="document">
            <div class="modal-content professional-booking-modal">
                <div class="modal-header professional-booking-header">
                    <div class="booking-header-content">
                        <h2 class="modal-title">Reserve Your Table</h2>
                    </div>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <i class="fa fa-times"></i>
                    </button>
                </div>
                <div class="modal-body professional-booking-body">
                    <form id="professionalBookingForm" class="professional-booking-form" method="POST" action="#">
                        <!-- Section 1: Guest Details -->
                        <div class="booking-section">
                            <h4 class="booking-section-title"><i class="fa fa-user-circle"></i> Guest Details</h4>
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="bookingName">Full Name *</label>
                                        <input type="text" class="form-control" id="bookingName"
                                            name="booking_name" placeholder="Enter your full name" required>
                                        <small class="form-text text-muted">We'll use this to identify your reservation</small>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="bookingEmail">Email Address *</label>
                                        <input type="email" class="form-control" id="bookingEmail"
                                            name="booking_email" placeholder="your.email@example.com" required>
                                        <small class="form-text text-muted">Confirmation will be sent here</small>
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="bookingPhone">Phone Number *</label>
                                        <input type="tel" class="form-control" id="bookingPhone"
                                            name="booking_phone" placeholder="+1 (555) 000-0000" required>
                                        <small class="form-text text-muted">Contact number for reservation</small>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="bookingOccasion">Occasion (Optional)</label>
                                        <select class="form-control" id="bookingOccasion" name="booking_occasion">
                                            <option value="">Select an occasion</option>
                                            <option value="birthday">Birthday Celebration</option>
                                            <option value="anniversary">Anniversary</option>
                                            <option value="business">Business Meeting</option>
                                            <option value="family">Family Gathering</option>
                                            <option value="date">Date Night</option>
                                            <option value="other">Other</option>
                                        </select>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <hr class="booking-divider">

                        <!-- Section 2: Reservation Details -->
                        <div class="booking-section">
                            <h4 class="booking-section-title"><i class="fa fa-calendar-alt"></i> Reservation Details</h4>
                            <div class="row">
                                <div class="col-md-4">
                                    <div class="form-group">
                                        <label for="bookingDate">Date *</label>
                                        <input type="date" class="form-control" id="bookingDate"
                                            name="booking_date" required>
                                        <small class="form-text text-muted">Select your preferred date</small>
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="form-group">
                                        <label for="bookingTime">Time *</label>
                                        <input type="time" class="form-control" id="bookingTime"
                                            name="booking_time" required>
                                        <small class="form-text text-muted">Select your preferred time</small>
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="form-group">
                                        <label for="bookingGuests">Number of Guests *</label>
                                        <select class="form-control" id="bookingGuests" name="booking_guests" required>
                                            <option value="">Select number</option>
                                            <option value="1">1 Person</option>
                                            <option value="2">2 People</option>
                                            <option value="3">3 People</option>
                                            <option value="4">4 People</option>
                                            <option value="5">5 People</option>
                                            <option value="6">6 People</option>
                                            <option value="7">7 People</option>
                                            <option value="8">8 People</option>
                                            <option value="10">10 People</option>
                                            <option value="12">12 People</option>
                                            <option value="15">15+ People</option>
                                        </select>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <hr class="booking-divider">

                        <!-- Section 3: Preferences & Special Requests -->
                      

                        <!-- Form Actions -->
                        <div class="booking-actions">
                            <button type="reset" class="btn btn-outline-secondary">Clear Form</button>
                            <button type="submit" class="btn btn--secondary">Complete Booking</button>
                        </div>

                        <!-- Booking Status Message -->
                        <div class="alert alert-success booking-success-message" style="display: none; margin-top: 20px;">
                            <div style="display: flex; align-items: flex-start; gap: 15px;">
                                <div style="font-size: 24px; color: #28a745;">
                                    <i class="fa fa-check-circle"></i>
                                </div>
                                <div style="flex: 1;">
                                    <h5 style="margin: 0 0 10px 0; color: #155724;">Booking Confirmed!</h5>
                                    <p style="margin: 5px 0; font-size: 14px;" id="bookingConfirmation"></p>
                                    <p style="margin: 5px 0; font-size: 12px; color: #666;">Confirmation email has been sent to your email address.</p>
                                </div>
                            </div>
                        </div>
                        <div class="alert alert-danger booking-error-message" style="display: none; margin-top: 20px;">
                            <i class="fa fa-exclamation-circle"></i> <span class="error-message"></span>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>

    <!-- Professional Booking Modal Styles -->
    <style>
        .professional-booking-modal {
            border: none;
            border-radius: 12px;
            box-shadow: 0 10px 50px rgba(0, 0, 0, 0.2);
            overflow: hidden;
        }

        .professional-booking-header {
            background: linear-gradient(135deg, #d4a574 0%, #8b6f47 100%);
            border: none;
            color: white;
            padding: 30px;
            position: relative;
        }

        .booking-header-content h2 {
            font-size: 28px;
            font-weight: 600;
            margin: 0;
            margin-bottom: 8px;
            font-family: 'Raleway', sans-serif;
        }

        .booking-subtitle {
            font-size: 14px;
            margin: 0;
            opacity: 0.95;
            font-weight: 300;
        }

        .professional-booking-header .close {
            position: absolute;
            right: 20px;
            top: 20px;
            color: white;
            opacity: 0.8;
            font-size: 24px;
        }

        .professional-booking-header .close:hover {
            opacity: 1;
        }

        .professional-booking-body {
            padding: 40px;
            background: #f9f7f4;
        }

        .professional-booking-form {
            background: white;
            padding: 30px;
            border-radius: 8px;
            box-shadow: 0 2px 10px rgba(0, 0, 0, 0.05);
        }

        .booking-section {
            margin-bottom: 30px;
        }

        .booking-section-title {
            font-size: 16px;
            font-weight: 600;
            color: #333;
            margin-bottom: 20px;
            padding-bottom: 12px;
            border-bottom: 2px solid #d4a574;
            display: flex;
            align-items: center;
            gap: 10px;
        }

        .booking-section-title i {
            color: #d4a574;
            font-size: 18px;
        }

        .booking-divider {
            margin: 30px 0;
            border: none;
            border-top: 2px solid #e8e8e8;
        }

        .professional-booking-form .form-group {
            margin-bottom: 20px;
        }

        .professional-booking-form .form-group label {
            font-weight: 600;
            color: #333;
            margin-bottom: 8px;
            font-size: 13px;
            text-transform: uppercase;
            letter-spacing: 0.5px;
        }

        .professional-booking-form .form-control {
            border: 2px solid #e8e8e8;
            border-radius: 6px;
            padding: 12px 15px;
            font-size: 14px;
            transition: all 0.3s ease;
            background: #fafafa;
        }

        .professional-booking-form .form-control:focus {
            border-color: #d4a574;
            background: white;
            box-shadow: 0 0 0 3px rgba(212, 165, 116, 0.1);
            outline: none;
        }

        .professional-booking-form .form-control::placeholder {
            color: #999;
        }

        .professional-booking-form textarea.form-control {
            resize: vertical;
            min-height: 100px;
            font-family: 'Raleway', sans-serif;
        }

        .form-text {
            font-size: 12px;
            color: #999;
            margin-top: 5px;
        }

        .booking-actions {
            display: flex !important;
            gap: 15px !important;
            margin-top: 30px !important;
            justify-content: center !important;
            flex-wrap: wrap !important;
        }

        .professional-booking-form .booking-actions button {
            padding: 14px 35px !important;
            font-weight: 700 !important;
            border-radius: 8px !important;
            font-size: 15px !important;
            transition: all 0.3s cubic-bezier(0.25, 0.46, 0.45, 0.94) !important;
            min-width: 140px !important;
            line-height: 1.6 !important;
            display: inline-flex !important;
            align-items: center !important;
            justify-content: center !important;
            text-align: center !important;
            vertical-align: middle !important;
            cursor: pointer !important;
            letter-spacing: 0.5px !important;
            text-transform: uppercase !important;
            box-shadow: 0 4px 15px rgba(0, 0, 0, 0.1) !important;
        }

        .professional-booking-form .booking-actions .btn-outline-secondary {
            border: 2px solid #d4a574 !important;
            color: #d4a574 !important;
            background: white !important;
            box-shadow: 0 2px 10px rgba(212, 165, 116, 0.15) !important;
        }

        .professional-booking-form .booking-actions .btn-outline-secondary:hover,
        .professional-booking-form .booking-actions .btn-outline-secondary:active,
        .professional-booking-form .booking-actions .btn-outline-secondary:focus {
            border-color: #8b6f47 !important;
            color: white !important;
            background: linear-gradient(135deg, #d4a574 0%, #8b6f47 100%) !important;
            box-shadow: 0 6px 20px rgba(212, 165, 116, 0.35) !important;
            transform: translateY(-3px) !important;
        }

        .professional-booking-form .booking-actions .btn--secondary {
            background: linear-gradient(135deg, #d4a574 0%, #8b6f47 100%) !important;
            color: white !important;
            border: none !important;
            box-shadow: 0 4px 15px rgba(212, 165, 116, 0.25) !important;
            position: relative !important;
            overflow: hidden !important;
        }

        .professional-booking-form .booking-actions .btn--secondary::before {
            content: '' !important;
            position: absolute !important;
            top: 0 !important;
            left: -100% !important;
            width: 100% !important;
            height: 100% !important;
            background: rgba(255, 255, 255, 0.1) !important;
            transition: left 0.3s ease !important;
            z-index: 0 !important;
        }

        .professional-booking-form .booking-actions .btn--secondary:hover::before,
        .professional-booking-form .booking-actions .btn--secondary:active::before,
        .professional-booking-form .booking-actions .btn--secondary:focus::before {
            left: 100% !important;
        }

        .professional-booking-form .booking-actions .btn--secondary:hover,
        .professional-booking-form .booking-actions .btn--secondary:active,
        .professional-booking-form .booking-actions .btn--secondary:focus {
            transform: translateY(-3px) !important;
            box-shadow: 0 8px 25px rgba(212, 165, 116, 0.4) !important;
            background: linear-gradient(135deg, #8b6f47 0%, #d4a574 100%) !important;
            color: white !important;
            border: none !important;
        }

        .professional-booking-form .booking-actions button:active {
            transform: translateY(-1px) !important;
        }

        /* Mobile Responsiveness */
        @media (max-width: 576px) {
            .booking-actions {
                flex-direction: column !important;
                gap: 12px !important;
            }

            .professional-booking-form .booking-actions button {
                width: 100% !important;
                padding: 12px 20px !important;
                font-size: 14px !important;
                min-width: unset !important;
            }
        }

        @media (max-width: 768px) {
            .professional-booking-form .booking-actions button {
                padding: 12px 28px !important;
                font-size: 14px !important;
                min-width: 130px !important;
            }
        }

        @media (min-width: 769px) and (max-width: 992px) {
            .professional-booking-form .booking-actions button {
                padding: 13px 32px !important;
                font-size: 14px !important;
                min-width: 135px !important;
            }
        }

        .alert {
            border-radius: 6px;
            border: none;
            padding: 15px 20px;
            display: flex;
            align-items: center;
            gap: 12px;
        }

        .alert-success {
            background-color: #d4edda;
            color: #155724;
        }

        .alert-danger {
            background-color: #f8d7da;
            color: #721c24;
        }

        @media (max-width: 768px) {
            .professional-booking-body {
                padding: 20px;
            }

            .professional-booking-form {
                padding: 20px;
            }

            .booking-header-content h2 {
                font-size: 22px;
            }

            .booking-actions {
                flex-direction: column;
            }

            .booking-actions button {
                width: 100%;
            }
        }
    </style>

    <!-- Professional Booking Modal Scripts -->
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            const bookingForm = document.getElementById('professionalBookingForm');
            const successMessage = document.querySelector('.booking-success-message');
            const errorMessage = document.querySelector('.booking-error-message');

            // Set minimum date to today
            const today = new Date().toISOString().split('T')[0];
            document.getElementById('bookingDate').setAttribute('min', today);

            // Form submission
            if (bookingForm) {
                bookingForm.addEventListener('submit', function(e) {
                    e.preventDefault();

                    // Reset messages
                    successMessage.style.display = 'none';
                    errorMessage.style.display = 'none';

                    // Collect form data
                    const formData = new FormData(bookingForm);
                    const data = Object.fromEntries(formData);

                    // Validate data
                    if (!data.booking_name || !data.booking_email || !data.booking_phone ||
                        !data.booking_date || !data.booking_time || !data.booking_guests) {
                        errorMessage.querySelector('.error-message').textContent = 'Please fill in all required fields.';
                        errorMessage.style.display = 'flex';
                        return;
                    }

                    // Send booking data (you can modify this to your backend API)
                    console.log('Booking Data:', data);

                    // Show success message
                    successMessage.style.display = 'flex';

                    // Optional: Reset form and close modal after delay
                    setTimeout(function() {
                        bookingForm.reset();
                        $('#reservationPopup').modal('hide');
                    }, 2000);
                });
            }

            // Clear messages when modal is closed
            $('#reservationPopup').on('hidden.bs.modal', function() {
                successMessage.style.display = 'none';
                errorMessage.style.display = 'none';
            });
        });
    </script>
    <!-- End Professional Table Booking Modal -->

    <!-- Sign In Modal -->
    <div class="modal fade" tabindex="-1" role="dialog" id="signInModal">
        <div class="modal-dialog modal-lg" role="document">
            <div class="modal-content auth-modal-content">
                <button type="button" class="close auth-close-btn" data-dismiss="modal" aria-label="Close"><i
                        class="fa fa-times"></i></button>
                <div class="auth-modal-body">
                    <div class="auth-header">
                        <h2>Welcome Back</h2>
                        <p class="auth-subtitle">Sign in to your account</p>
                    </div>
                    <div id="signinMessage" class="auth-message" style="display: none;"></div>
                    <form class="auth-form" id="signInForm">
                        <div class="auth-form-group">
                            <label for="signinEmail" class="auth-label">Email Address</label>
                            <div class="auth-input-wrapper">
                                <i class="fas fa-envelope auth-input-icon"></i>
                                <input type="email" class="auth-input" id="signinEmail" name="email" placeholder="your@email.com"
                                    required>
                            </div>
                        </div>
                        <div class="auth-form-group">
                            <label for="signinPassword" class="auth-label">Password</label>
                            <div class="auth-input-wrapper">
                                <i class="fas fa-lock auth-input-icon"></i>
                                <input type="password" class="auth-input" id="signinPassword" name="password" placeholder="*********"
                                    required>
                            </div>
                        </div>
                        <div class="auth-form-group auth-remember">
                            <input type="checkbox" id="rememberMe" name="rememberMe">
                            <label for="rememberMe" class="auth-checkbox-label">Remember me</label>
                        </div>
                        <button type="submit" class="auth-btn">Sign In</button>
                    </form>
                    <div class="auth-divider">
                        <span>Don't have an account?</span>
                    </div>
                    <p class="auth-footer">
                        <a href="#" data-toggle="modal" data-dismiss="modal" data-target="#signUpModal"
                            class="auth-link">Create a new account</a>
                    </p>
                </div>
            </div>
        </div>
    </div>
    <!-- End Sign In Modal -->

    <!-- Sign Up Modal -->
    <div class="modal fade" tabindex="-1" role="dialog" id="signUpModal">
        <div class="modal-dialog modal-lg" role="document">
            <div class="modal-content auth-modal-content">
                <button type="button" class="close auth-close-btn" data-dismiss="modal" aria-label="Close"><i
                        class="fa fa-times"></i></button>
                <div class="auth-modal-body">
                    <div class="auth-header">
                        <h2>Create Account</h2>
                        <p class="auth-subtitle">Join us today</p>
                    </div>
                    <div id="signupMessage" class="auth-message" style="display: none;"></div>
                    <form class="auth-form" id="signUpForm">
                        <div class="auth-form-group">
                            <label for="signupName" class="auth-label">Full Name</label>
                            <div class="auth-input-wrapper">
                                <i class="fas fa-user auth-input-icon"></i>
                                <input type="text" class="auth-input" id="signupName" name="name" placeholder="John Doe" required>
                            </div>
                        </div>
                        <div class="auth-form-group">
                            <label for="signupEmail" class="auth-label">Email Address</label>
                            <div class="auth-input-wrapper">
                                <i class="fas fa-envelope auth-input-icon"></i>
                                <input type="email" class="auth-input" id="signupEmail" name="email" placeholder="your@email.com"
                                    required>
                            </div>
                        </div>
                        <div class="auth-form-group">
                            <label for="signupPassword" class="auth-label">Password</label>
                            <div class="auth-input-wrapper">
                                <i class="fas fa-lock auth-input-icon"></i>
                                <input type="password" class="auth-input" id="signupPassword" name="password" placeholder="*********"
                                    required>
                            </div>
                        </div>
                        <div class="auth-form-group">
                            <label for="signupConfirmPassword" class="auth-label">Confirm Password</label>
                            <div class="auth-input-wrapper">
                                <i class="fas fa-check-circle auth-input-icon"></i>
                                <input type="password" class="auth-input" id="signupConfirmPassword" name="confirmPassword"
                                    placeholder="*********" required>
                            </div>
                        </div>
                        <div class="auth-form-group auth-checkbox">
                            <input type="checkbox" id="agreeTerms" required>
                            <label for="agreeTerms" class="auth-checkbox-label">I agree to the <a href="#"
                                    class="auth-link-inline">Terms & Conditions</a></label>
                        </div>
                        <button type="submit" class="auth-btn">Create Account</button>
                    </form>
                    <div class="auth-divider">
                        <span>Already have an account?</span>
                    </div>
                    <p class="auth-footer">
                        <a href="#" data-toggle="modal" data-dismiss="modal" data-target="#signInModal"
                            class="auth-link">Sign In here</a>
                    </p>
                </div>
            </div>
        </div>
    </div>
    <!-- End Sign Up Modal -->

    <!-- Backend Integration Scripts -->
    <style>
        .auth-message {
            padding: 12px;
            border-radius: 6px;
            margin-bottom: 20px;
            font-weight: 500;
            display: flex;
            align-items: center;
            gap: 10px;
        }

        .auth-message.success {
            background: #d4edda;
            color: #155724;
            border: 1px solid #c3e6cb;
        }

        .auth-message.error {
            background: #f8d7da;
            color: #721c24;
            border: 1px solid #f5c6cb;
        }
    </style>
   

    <script>
        // Update header with user profile
        function updateHeaderWithUserProfile(userData) {
            // Desktop header auth section
            const navAuthSection = document.getElementById('navAuthSection');
            const navUserProfileDropdown = document.getElementById('navUserProfileDropdown');
            const navUserName = document.getElementById('navUserName');
            
            // Mobile auth section (inside menu)
            const mobileAuthSection = document.getElementById('mobileAuthSection');
            const mobileUserProfileSection = document.getElementById('mobileUserProfileSection');
            
            // Mobile profile icon (next to hamburger)
            const mobileProfileIconContainer = document.getElementById('mobileProfileIconContainer');
            const mobileUserName = document.getElementById('mobileUserName');
            
            // Hide sign in/sign up buttons (desktop)
            if (navAuthSection) {
                navAuthSection.style.display = 'none';
            }
            
            // Show user profile dropdown with username (desktop)
            if (navUserProfileDropdown) {
                navUserProfileDropdown.style.display = 'inline-block';
                navUserName.textContent = userData.name || userData.email;
            }
            
            // Hide mobile auth buttons inside hamburger menu and show mobile user profile
            if (mobileAuthSection) {
                mobileAuthSection.classList.add('hide-auth');
            }
            if (mobileUserProfileSection) {
                mobileUserProfileSection.style.display = 'block';
            }
            
            // Show mobile profile icon next to hamburger
            if (mobileProfileIconContainer) {
                mobileProfileIconContainer.classList.add('show');
                // Remove inline style to let CSS handle it
                mobileProfileIconContainer.style.display = '';
            }
            
            // Set mobile username
            if (mobileUserName) {
                mobileUserName.textContent = userData.name || userData.email;
            }
            
            console.log('Header updated for user:', userData.name);
        }


        // Check if user is already logged in on page load
        document.addEventListener('DOMContentLoaded', function() {
            const user = localStorage.getItem('user');
            if (user) {
                try {
                    const userData = JSON.parse(user);
                    updateHeaderWithUserProfile(userData);
                    console.log('User already logged in:', userData.name);
                } catch (e) {
                    console.error('Error parsing user data:', e);
                }
            }
        });

        // Reset header to show auth buttons (used on logout)
        function resetHeaderAuthSection() {
            // Desktop header auth section
            const navAuthSection = document.getElementById('navAuthSection');
            const navUserProfileDropdown = document.getElementById('navUserProfileDropdown');
            
            // Mobile auth section
            const mobileAuthSection = document.getElementById('mobileAuthSection');
            const mobileUserProfileSection = document.getElementById('mobileUserProfileSection');
            
            // Mobile profile icon (next to hamburger)
            const mobileProfileIconContainer = document.getElementById('mobileProfileIconContainer');
            
            // Show sign in/sign up buttons (desktop)
            if (navAuthSection) {
                navAuthSection.style.display = 'flex';
            }
            
            // Hide user profile dropdown (desktop)
            if (navUserProfileDropdown) {
                navUserProfileDropdown.style.display = 'none';
            }
            
            // Show mobile auth buttons and hide mobile user profile
            if (mobileAuthSection) {
                mobileAuthSection.classList.remove('hide-auth');
            }
            if (mobileUserProfileSection) {
                mobileUserProfileSection.style.display = 'none';
            }
            
            // Hide mobile profile icon
            if (mobileProfileIconContainer) {
                mobileProfileIconContainer.classList.remove('show');
                mobileProfileIconContainer.style.display = 'none';
            }
            
            console.log('Header reset to show auth buttons');
        }

        // Logout function
        function logout() {
            console.log('Logout function called');
            // Remove user data from localStorage first
            localStorage.removeItem('user');
            // Clear cart from localStorage on logout
            localStorage.removeItem('granny_cart');
            
            fetch('backend/logout.php')
            .then(response => response.json())
            .then(data => {
                console.log('Logout response:', data);
                if (data.success) {
                    // Redirect to index page after logout is complete
                    setTimeout(() => {
                        window.location.href = 'index.php';
                    }, 500);
                }
            })
            .catch(error => {
                console.error('Logout error:', error);
                // Still logout on client side even if server fails
                setTimeout(() => {
                    window.location.href = 'index.php';
                }, 500);
            });
        }

        // Logout button click handler
        document.addEventListener('DOMContentLoaded', function() {
            const logoutBtn = document.getElementById('navLogoutBtn');
            const mobileLogoutBtn = document.getElementById('mobileLogoutBtn');
            const mobileProfileLogoutBtn = document.getElementById('mobileProfileLogoutBtn');
            
            if (logoutBtn) {
                logoutBtn.addEventListener('click', function(e) {
                    e.preventDefault();
                    logout();
                });
            }
            
            if (mobileLogoutBtn) {
                mobileLogoutBtn.addEventListener('click', function(e) {
                    e.preventDefault();
                    logout();
                });
            }
            
            if (mobileProfileLogoutBtn) {
                mobileProfileLogoutBtn.addEventListener('click', function(e) {
                    e.preventDefault();
                    logout();
                });
            }
        });

        // Sign Up Handler
        document.getElementById('signUpForm').addEventListener('submit', function(e) {
            e.preventDefault();

            const formData = {
                name: document.getElementById('signupName').value,
                email: document.getElementById('signupEmail').value,
                password: document.getElementById('signupPassword').value,
                confirmPassword: document.getElementById('signupConfirmPassword').value
            };

            const messageDiv = document.getElementById('signupMessage');

            fetch('backend/signup.php', {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json'
                },
                body: JSON.stringify(formData)
            })
            .then(response => response.json())
            .then(data => {
                messageDiv.style.display = 'flex';
                if (data.success) {
                    messageDiv.className = 'auth-message success';
                    messageDiv.innerHTML = '<i class="fas fa-check-circle"></i> ' + data.message + ' Please sign in to continue.';
                    
                    // Clear form
                    document.getElementById('signUpForm').reset();
                    
                    // Do NOT store user data in localStorage - user must sign in first
                    
                    // Close sign up modal and open sign in modal
                    setTimeout(() => {
                        $('#signUpModal').modal('hide');
                        messageDiv.style.display = 'none';
                        // Show sign in modal after a short delay
                        setTimeout(() => {
                            $('#signInModal').modal('show');
                        }, 500);
                    }, 2000);
                } else {
                    messageDiv.className = 'auth-message error';
                    messageDiv.innerHTML = '<i class="fas fa-exclamation-circle"></i> ' + data.message;
                }
            })
            .catch(error => {
                messageDiv.style.display = 'flex';
                messageDiv.className = 'auth-message error';
                messageDiv.innerHTML = '<i class="fas fa-exclamation-circle"></i> Error: ' + error.message;
                console.error('Error:', error);
            });
        });

        // Sign In Handler
        document.getElementById('signInForm').addEventListener('submit', function(e) {
            e.preventDefault();

            const formData = {
                email: document.getElementById('signinEmail').value,
                password: document.getElementById('signinPassword').value,
                rememberMe: document.getElementById('rememberMe').checked
            };

            const messageDiv = document.getElementById('signinMessage');

            fetch('backend/signin.php', {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json'
                },
                body: JSON.stringify(formData)
            })
            .then(response => response.json())
            .then(data => {
                messageDiv.style.display = 'flex';
                if (data.success) {
                    messageDiv.className = 'auth-message success';
                    messageDiv.innerHTML = '<i class="fas fa-check-circle"></i> ' + data.message;
                    
                    // Clear form
                    document.getElementById('signInForm').reset();
                    
                    // Store user data in localStorage
                    localStorage.setItem('user', JSON.stringify(data.data));
                    
                    // Close modal
                    setTimeout(() => {
                        $('#signInModal').modal('hide');
                        messageDiv.style.display = 'none';
                        // Update header with user profile
                        updateHeaderWithUserProfile(data.data);
                        // Refresh page after successful sign-in
                        setTimeout(() => {
                            window.location.reload();
                        }, 500);
                    }, 2000);
                } else {
                    messageDiv.className = 'auth-message error';
                    messageDiv.innerHTML = '<i class="fas fa-exclamation-circle"></i> ' + data.message;
                }
            })
            .catch(error => {
                messageDiv.style.display = 'flex';
                messageDiv.className = 'auth-message error';
                messageDiv.innerHTML = '<i class="fas fa-exclamation-circle"></i> Error: ' + error.message;
                console.error('Error:', error);
            });
        });

        // Booking Handler
        document.getElementById('professionalBookingForm').addEventListener('submit', function(e) {
            e.preventDefault();

            const formData = {
                booking_name: document.getElementById('bookingName')?.value || '',
                booking_email: document.getElementById('bookingEmail')?.value || '',
                booking_phone: document.getElementById('bookingPhone')?.value || '',
                booking_date: document.getElementById('bookingDate')?.value || '',
                booking_time: document.getElementById('bookingTime')?.value || '',
                booking_guests: document.getElementById('bookingGuests')?.value || '',
                booking_occasion: document.getElementById('bookingOccasion')?.value || '',
                booking_table_type: document.getElementById('bookingTableType')?.value || '',
                booking_dietary: document.getElementById('bookingDietaryNeeds')?.value || '',
                booking_special_requests: document.getElementById('bookingSpecialRequests')?.value || ''
            };

            const successMessage = document.querySelector('.booking-success-message');
            const errorMessage = document.querySelector('.booking-error-message');

            console.log('Sending booking data:', formData);
            
            // Validate required fields
            if (!formData.booking_name || !formData.booking_email || !formData.booking_phone || !formData.booking_date || !formData.booking_time || !formData.booking_guests) {
                errorMessage.style.display = 'flex';
                errorMessage.querySelector('.error-message').textContent = 'Please fill in all required fields';
                successMessage.style.display = 'none';
                console.error('Validation failed: Missing required fields');
                return;
            }

            fetch('backend/booking.php', {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json'
                },
                body: JSON.stringify(formData)
            })
            .then(response => {
                console.log('Response status:', response.status);
                return response.json();
            })
            .then(data => {
                console.log('Booking response:', data);
                if (data.success) {
                    successMessage.style.display = 'flex';
                    errorMessage.style.display = 'none';
                    
                    // Update confirmation message with booking details
                    const confirmationDiv = document.getElementById('bookingConfirmation');
                    if (confirmationDiv && data.data) {
                        confirmationDiv.innerHTML = `
                            <strong>Booking ID:</strong> #${data.data.booking_id}<br>
                            <strong>Date:</strong> ${data.data.booking_date} at ${data.data.booking_time}<br>
                            <strong>Guests:</strong> ${data.data.guests} person(s)
                        `;
                    }
                    
                    // Store booking data
                    localStorage.setItem('lastBooking', JSON.stringify(data.data));
                    console.log('Booking saved to localStorage:', data.data);
                    
                    // Reset and close
                    setTimeout(() => {
                        document.getElementById('professionalBookingForm').reset();
                        $('#reservationPopup').modal('hide');
                        successMessage.style.display = 'none';
                        confirmationDiv.innerHTML = '';
                    }, 3500);
                } else {
                    errorMessage.style.display = 'flex';
                    errorMessage.querySelector('.error-message').textContent = data.message;
                    successMessage.style.display = 'none';
                    console.error('Booking error:', data.message);
                }
            })
            .catch(error => {
                errorMessage.style.display = 'flex';
                errorMessage.querySelector('.error-message').textContent = 'Error: ' + error.message;
                successMessage.style.display = 'none';
                console.error('Fetch error:', error);
            });
        });

        // Initialize user session on page load
        document.addEventListener('DOMContentLoaded', function() {
            const user = localStorage.getItem('user');
            if (user) {
                const userData = JSON.parse(user);
                console.log('User logged in:', userData);
                
                // Update dashboard banner with user information
                const dashboardUserNameBanner = document.getElementById('dashboardUserNameBanner');
                const dashboardUserEmailBanner = document.getElementById('dashboardUserEmailBanner');
                
                if (dashboardUserNameBanner) {
                    dashboardUserNameBanner.textContent = userData.name || userData.email || 'User';
                }
                if (dashboardUserEmailBanner) {
                    dashboardUserEmailBanner.textContent = userData.email || 'user@email.com';
                }
                
                // Header is already updated by the earlier DOMContentLoaded event
            }

            // Add dashboard logout button handler
            const dashboardLogoutBtn = document.getElementById('dashboardLogoutBtn');
            if (dashboardLogoutBtn) {
                dashboardLogoutBtn.addEventListener('click', function(e) {
                    e.preventDefault();
                    logout();
                });
            }

            // Load bookings for table_booking.php
            if (document.getElementById('bookingsTableBody')) {
                loadBookings();
            }

            // Handle "New Booking" button click to open modal
            const newBookingBtn = document.getElementById('newBookingBtn');
            if (newBookingBtn) {
                newBookingBtn.addEventListener('click', function(e) {
                    e.preventDefault();
                    openBookingModal();
                });
            }

            // Handle "Make a Booking" button in empty state
            const emptyStateBookingBtn = document.getElementById('emptyStateBookingBtn');
            if (emptyStateBookingBtn) {
                emptyStateBookingBtn.addEventListener('click', function(e) {
                    e.preventDefault();
                    openBookingModal();
                });
            }
        });

        // Function to open booking modal
        function openBookingModal() {
            // Check if Bootstrap is available
            if (typeof jQuery !== 'undefined' && typeof jQuery.fn.modal !== 'undefined') {
                // Use Bootstrap modal
                jQuery('#reservationPopup').modal('show');
            } else if (document.getElementById('reservationPopup')) {
                // Fallback: manually show modal
                const modal = document.getElementById('reservationPopup');
                modal.style.display = 'block';
                modal.classList.add('show');
                document.body.style.overflow = 'hidden';
            }
        }

        // Fetch and display all user bookings
        function loadBookings() {
            const bookingsContainer = document.getElementById('bookingsContainer');
            const loadingState = document.getElementById('loadingState');
            const emptyState = document.getElementById('emptyState');
            const bookingsTableBody = document.getElementById('bookingsTableBody');
            const bookingsCardsContainer = document.getElementById('bookingsCardsContainer');

            // Show loading state
            if (loadingState) loadingState.style.display = 'flex';
            if (emptyState) emptyState.style.display = 'none';
            if (bookingsTableBody) bookingsTableBody.innerHTML = '';
            if (bookingsCardsContainer) bookingsCardsContainer.innerHTML = '';

            fetch('backend/bookings_api.php?action=get')
                .then(response => {
                    console.log('Response status:', response.status);
                    if (!response.ok) {
                        throw new Error('HTTP error, status=' + response.status);
                    }
                    return response.text();
                })
                .then(text => {
                    console.log('Raw response:', text);
                    try {
                        const data = JSON.parse(text);
                        console.log('Parsed data:', data);
                        
                        if (data.success && data.bookings && data.bookings.length > 0) {
                            // Hide loading state
                            if (loadingState) loadingState.style.display = 'none';
                            if (emptyState) emptyState.style.display = 'none';
                            
                            // Show table/card views
                            const tableView = document.getElementById('tableView');
                            const cardsView = document.getElementById('cardsView');
                            if (tableView) tableView.style.display = 'block';
                            if (cardsView) cardsView.style.display = 'block';
                            
                            // Update stats cards
                            updateStatsCards(data.bookings);
                            
                            // Render bookings
                            renderTableView(data.bookings);
                            renderCardsView(data.bookings);
                        } else {
                            // Show empty state
                            if (loadingState) loadingState.style.display = 'none';
                            if (emptyState) emptyState.style.display = 'flex';
                            
                            // Hide table/card views
                            const tableView = document.getElementById('tableView');
                            const cardsView = document.getElementById('cardsView');
                            if (tableView) tableView.style.display = 'none';
                            if (cardsView) cardsView.style.display = 'none';
                            
                            // Update stats to 0
                            document.getElementById('totalBookings').textContent = '0';
                            document.getElementById('confirmedBookings').textContent = '0';
                            document.getElementById('pendingBookings').textContent = '0';
                            document.getElementById('cancelledBookings').textContent = '0';
                        }
                    } catch (e) {
                        console.error('JSON parse error:', e);
                        console.error('Failed to parse:', text);
                        throw new Error('Invalid JSON response: ' + e.message);
                    }
                })
                .catch(error => {
                    console.error('Error loading bookings:', error);
                    if (loadingState) loadingState.style.display = 'none';
                    if (emptyState) emptyState.style.display = 'flex';
                    if (emptyState) {
                        emptyState.innerHTML = '<div style="text-align: center;"><i class="fa fa-exclamation-circle" style="font-size: 48px; color: #e74c3c; margin-bottom: 15px; display: block;"></i><h3 style="margin: 10px 0; color: #333;">Error Loading Bookings</h3><p style="color: #666; font-size: 14px;">Error: ' + error.message + '</p><p style="color: #999; font-size: 13px;">Check your browser console (F12) for more details.</p></div>';
                    }
                });
        }

        // Update statistics cards
        function updateStatsCards(bookings) {
            let totalCount = bookings.length;
            let confirmedCount = bookings.filter(b => b.status === 'confirmed').length;
            let pendingCount = bookings.filter(b => b.status === 'pending').length;
            let cancelledCount = bookings.filter(b => b.status === 'cancelled').length;

            document.getElementById('totalBookings').textContent = totalCount;
            document.getElementById('confirmedBookings').textContent = confirmedCount;
            document.getElementById('pendingBookings').textContent = pendingCount;
            document.getElementById('cancelledBookings').textContent = cancelledCount;
        }

        // Render bookings table view (desktop)
        function renderTableView(bookings) {
            const tableBody = document.getElementById('bookingsTableBody');
            if (!tableBody) return;

            tableBody.innerHTML = bookings.map(booking => {
                const bookingDate = new Date(booking.booking_date + ' ' + booking.booking_time);
                const formattedDate = bookingDate.toLocaleDateString('en-US', { month: 'short', day: 'numeric', year: 'numeric' });
                const formattedTime = bookingDate.toLocaleTimeString('en-US', { hour: '2-digit', minute: '2-digit' });
                
                const statusColor = booking.status === 'confirmed' ? '#27ae60' : 
                                   booking.status === 'pending' ? '#f39c12' : '#e74c3c';
                const statusText = booking.status.charAt(0).toUpperCase() + booking.status.slice(1);

                return `
                    <tr style="border-bottom: 1px solid #eee; transition: background-color 0.3s;">
                        <td style="padding: 15px; font-size: 14px; white-space: nowrap;">
                            <strong style="color: #333;">${formattedDate}</strong><br>
                            <span style="color: #666; font-size: 12px;">${formattedTime}</span>
                        </td>
                        <td style="padding: 15px; font-size: 14px; color: #333; font-weight: 500; white-space: nowrap;">${booking.name}</td>
                        <td style="padding: 15px; font-size: 13px; color: #666;">${booking.email}</td>
                        <td style="padding: 15px; font-size: 13px; color: #666;">${booking.phone}</td>
                        <td style="padding: 15px; font-size: 14px; text-align: center; white-space: nowrap;"><span style="color: #c59d5f; font-weight: 600;">${booking.guests}</span> ${booking.guests == 1 ? 'Guest' : 'Guests'}</td>
                        <td style="padding: 15px; font-size: 13px; color: #666; text-align: center;">${booking.occasion || '-'}</td>
                        <td style="padding: 15px; text-align: center; white-space: nowrap;">
                            <span class="status-badge" style="
                                background-color: ${statusColor}15;
                                color: ${statusColor};
                                padding: 6px 14px;
                                border-radius: 20px;
                                font-size: 12px;
                                font-weight: 600;
                                display: inline-block;
                                border: 1.5px solid ${statusColor}40;
                            ">${statusText}</span>
                        </td>
                        <td style="padding: 15px; text-align: center; white-space: nowrap;">
                            ${booking.status !== 'cancelled' ? `<button class="cancel-btn" onclick="cancelBooking(${booking.id}, this)" style="
                                background-color: #e74c3c;
                                color: white;
                                border: none;
                                padding: 7px 15px;
                                border-radius: 5px;
                                cursor: pointer;
                                font-size: 12px;
                                font-weight: 600;
                                transition: all 0.3s;
                            " onmouseover="this.style.backgroundColor='#c0392b'; this.style.transform='scale(1.05)'" onmouseout="this.style.backgroundColor='#e74c3c'; this.style.transform='scale(1)'">Cancel</button>` : '<span style="color: #999; font-size: 13px;">-</span>'}
                        </td>
                    </tr>
                `;
            }).join('');
        }

        // Render bookings card view (mobile)
        function renderCardsView(bookings) {
            const cardsContainer = document.getElementById('bookingsCardsContainer');
            if (!cardsContainer) return;

            cardsContainer.innerHTML = bookings.map(booking => {
                const bookingDate = new Date(booking.booking_date + ' ' + booking.booking_time);
                const formattedDate = bookingDate.toLocaleDateString('en-US', { month: 'short', day: 'numeric', year: 'numeric' });
                const formattedTime = bookingDate.toLocaleTimeString('en-US', { hour: '2-digit', minute: '2-digit' });
                
                const statusColor = booking.status === 'confirmed' ? '#27ae60' : 
                                   booking.status === 'pending' ? '#f39c12' : '#e74c3c';
                const statusText = booking.status.charAt(0).toUpperCase() + booking.status.slice(1);

                return `
                    <div class="booking-card" style="
                        background: white;
                        border: 1px solid #e0e0e0;
                        border-radius: 8px;
                        padding: 16px;
                        margin-bottom: 14px;
                        box-shadow: 0 2px 4px rgba(0,0,0,0.05);
                        transition: all 0.3s;
                    " onmouseover="this.style.boxShadow='0 4px 12px rgba(0,0,0,0.15)'" onmouseout="this.style.boxShadow='0 2px 4px rgba(0,0,0,0.05)'">
                        <div style="display: flex; justify-content: space-between; align-items: start; margin-bottom: 12px;">
                            <div>
                                <div style="font-size: 13px; color: #999; margin-bottom: 4px;">Date & Time</div>
                                <div style="font-weight: 600; color: #333; font-size: 15px;">${formattedDate}</div>
                                <div style="color: #666; font-size: 14px;">${formattedTime}</div>
                            </div>
                            <span class="status-badge" style="
                                background-color: ${statusColor}20;
                                color: ${statusColor};
                                padding: 6px 12px;
                                border-radius: 20px;
                                font-size: 12px;
                                font-weight: 600;
                                display: inline-block;
                                border: 1px solid ${statusColor}40;
                                white-space: nowrap;
                            ">${statusText}</span>
                        </div>

                        <div style="display: grid; grid-template-columns: 1fr 1fr; gap: 12px; margin-bottom: 12px;">
                            <div>
                                <div style="font-size: 13px; color: #999; margin-bottom: 4px;">Guest Name</div>
                                <div style="font-weight: 500; color: #333;">${booking.name}</div>
                            </div>
                            <div>
                                <div style="font-size: 13px; color: #999; margin-bottom: 4px;">Guests</div>
                                <div style="font-weight: 500; color: #c59d5f;"><strong>${booking.guests}</strong> ${booking.guests == 1 ? 'Guest' : 'Guests'}</div>
                            </div>
                        </div>

                        <div style="margin-bottom: 12px; padding-bottom: 12px; border-bottom: 1px solid #f0f0f0;">
                            <div style="font-size: 13px; color: #999; margin-bottom: 4px;">Table Type</div>
                            <div style="font-weight: 500; color: #333;">${booking.table_type}</div>
                        </div>

                        ${booking.occasion ? `<div style="margin-bottom: 12px;"><div style="font-size: 13px; color: #999; margin-bottom: 4px;">Occasion</div><div style="font-weight: 500; color: #333;">${booking.occasion}</div></div>` : ''}

                        ${booking.status !== 'cancelled' ? `<button class="cancel-btn" onclick="cancelBooking(${booking.id}, this)" style="
                            width: 100%;
                            background-color: #e74c3c;
                            color: white;
                            border: none;
                            padding: 10px 14px;
                            border-radius: 4px;
                            cursor: pointer;
                            font-size: 14px;
                            font-weight: 500;
                            transition: background-color 0.3s;
                        " onmouseover="this.style.backgroundColor='#c0392b'" onmouseout="this.style.backgroundColor='#e74c3c'">Cancel Booking</button>` : '<div style="text-align: center; color: #999; font-size: 13px;">This booking has been cancelled</div>'}
                    </div>
                `;
            }).join('');
        }

        // Cancel booking function
        function cancelBooking(bookingId, button) {
            if (!confirm('Are you sure you want to cancel this booking? This action cannot be undone.')) {
                return;
            }

            // Disable button and show loading state
            const originalText = button.textContent;
            button.disabled = true;
            button.style.opacity = '0.6';
            button.style.cursor = 'not-allowed';
            button.textContent = 'Cancelling...';

            fetch('backend/bookings_api.php', {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json',
                },
                body: JSON.stringify({
                    action: 'delete',
                    booking_id: bookingId
                })
            })
            .then(response => response.json())
            .then(data => {
                console.log('Cancel response:', data);
                if (data.success) {
                    // Show success message
                    showNotification('Booking cancelled successfully', 'success');
                    // Reload bookings
                    setTimeout(() => {
                        loadBookings();
                    }, 500);
                } else {
                    // Show error message
                    showNotification(data.message || 'Failed to cancel booking', 'error');
                    // Restore button
                    button.disabled = false;
                    button.style.opacity = '1';
                    button.style.cursor = 'pointer';
                    button.textContent = originalText;
                }
            })
            .catch(error => {
                console.error('Cancel error:', error);
                showNotification('Error cancelling booking', 'error');
                // Restore button
                button.disabled = false;
                button.style.opacity = '1';
                button.style.cursor = 'pointer';
                button.textContent = originalText;
            });
        }

        // Show notification message
        function showNotification(message, type) {
            const notificationDiv = document.createElement('div');
            notificationDiv.textContent = message;
            notificationDiv.style.cssText = `
                position: fixed;
                top: 100px;
                right: 20px;
                padding: 15px 20px;
                background-color: ${type === 'success' ? '#27ae60' : '#e74c3c'};
                color: white;
                border-radius: 4px;
                font-size: 14px;
                z-index: 9999;
                box-shadow: 0 2px 8px rgba(0,0,0,0.2);
                animation: slideIn 0.3s ease-out;
            `;
            
            // Add animation
            const style = document.createElement('style');
            style.textContent = `
                @keyframes slideIn {
                    from {
                        transform: translateX(400px);
                        opacity: 0;
                    }
                    to {
                        transform: translateX(0);
                        opacity: 1;
                    }
                }
            `;
            if (!document.querySelector('style[data-notification]')) {
                style.setAttribute('data-notification', 'true');
                document.head.appendChild(style);
            }
            
            document.body.appendChild(notificationDiv);
            
            // Auto remove after 4 seconds
            setTimeout(() => {
                notificationDiv.style.animation = 'slideIn 0.3s ease-out reverse';
                setTimeout(() => {
                    notificationDiv.remove();
                }, 300);
            }, 4000);
        }
    </script>

</body>

</html>