<?php
// Quick diagnostic page to show system status
$logFile = __DIR__ . '/assets/uploads/otp_test_log.txt';
$testMode = defined('TEST_MODE') ? TEST_MODE : 'Unknown';
$otpCount = 0;

if (file_exists($logFile)) {
    $lines = file($logFile, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES);
    $otpCount = count($lines);
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Email Verification System - Status</title>
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        
        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            min-height: 100vh;
            padding: 40px 20px;
        }
        
        .container {
            max-width: 1000px;
            margin: 0 auto;
        }
        
        .header {
            text-align: center;
            color: white;
            margin-bottom: 40px;
        }
        
        .header h1 {
            font-size: 36px;
            margin-bottom: 10px;
        }
        
        .header p {
            font-size: 16px;
            opacity: 0.9;
        }
        
        .grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(300px, 1fr));
            gap: 20px;
            margin-bottom: 40px;
        }
        
        .card {
            background: white;
            border-radius: 12px;
            padding: 25px;
            box-shadow: 0 10px 30px rgba(0, 0, 0, 0.2);
            transition: transform 0.3s ease;
        }
        
        .card:hover {
            transform: translateY(-5px);
        }
        
        .card h3 {
            color: #333;
            margin-bottom: 15px;
            font-size: 18px;
            display: flex;
            align-items: center;
            gap: 10px;
        }
        
        .card p {
            color: #666;
            font-size: 14px;
            line-height: 1.6;
        }
        
        .card a {
            display: inline-block;
            margin-top: 15px;
            background: #667eea;
            color: white;
            padding: 10px 20px;
            border-radius: 6px;
            text-decoration: none;
            transition: background 0.3s ease;
        }
        
        .card a:hover {
            background: #764ba2;
        }
        
        .status {
            display: inline-block;
            padding: 4px 12px;
            border-radius: 20px;
            font-size: 12px;
            font-weight: bold;
            margin-left: 10px;
        }
        
        .status.active {
            background: #4caf50;
            color: white;
        }
        
        .status.inactive {
            background: #f44336;
            color: white;
        }
        
        .status.warning {
            background: #ff9800;
            color: white;
        }
        
        .icon {
            font-size: 24px;
        }
        
        .stat {
            background: #f5f5f5;
            padding: 15px;
            border-radius: 8px;
            margin-bottom: 15px;
            border-left: 4px solid #667eea;
        }
        
        .stat-label {
            color: #999;
            font-size: 12px;
            margin-bottom: 5px;
        }
        
        .stat-value {
            color: #333;
            font-size: 20px;
            font-weight: bold;
        }
        
        .quick-access {
            background: white;
            border-radius: 12px;
            padding: 25px;
            box-shadow: 0 10px 30px rgba(0, 0, 0, 0.2);
            margin-bottom: 40px;
        }
        
        .quick-access h2 {
            color: #333;
            margin-bottom: 20px;
            font-size: 20px;
        }
        
        .quick-links {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
            gap: 15px;
        }
        
        .quick-link {
            display: flex;
            align-items: center;
            gap: 15px;
            padding: 15px;
            background: #f9f9f9;
            border-radius: 8px;
            border: 2px solid #e0e0e0;
            transition: all 0.3s ease;
            text-decoration: none;
            color: #333;
        }
        
        .quick-link:hover {
            background: #667eea;
            color: white;
            border-color: #667eea;
        }
        
        .quick-link-icon {
            font-size: 28px;
        }
        
        .quick-link-text {
            flex: 1;
        }
        
        .quick-link-text strong {
            display: block;
            margin-bottom: 5px;
        }
        
        .quick-link-text small {
            font-size: 12px;
            opacity: 0.8;
        }
        
        .feature-list {
            list-style: none;
            margin-top: 15px;
        }
        
        .feature-list li {
            padding: 10px 0;
            border-bottom: 1px solid #e0e0e0;
            font-size: 14px;
        }
        
        .feature-list li:last-child {
            border-bottom: none;
        }
        
        .feature-list li:before {
            content: "✓ ";
            color: #4caf50;
            font-weight: bold;
            margin-right: 8px;
        }
        
        .footer {
            text-align: center;
            color: white;
            font-size: 12px;
            margin-top: 40px;
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="header">
            <h1>📧 Email Verification System</h1>
            <p>OTP-based Authentication for Granny Restaurant</p>
        </div>
        
        <div class="quick-access">
            <h2>Quick Access</h2>
            <div class="quick-links">
                <a href="otp_viewer.php" class="quick-link">
                    <div class="quick-link-icon">🔍</div>
                    <div class="quick-link-text">
                        <strong>View OTPs</strong>
                        <small>See all generated OTPs</small>
                    </div>
                </a>
                <a href="index.php" class="quick-link">
                    <div class="quick-link-icon">📝</div>
                    <div class="quick-link-text">
                        <strong>Test Signup</strong>
                        <small>Try the signup form</small>
                    </div>
                </a>
                <a href="SOLUTION_EMAIL_TESTING.md" class="quick-link">
                    <div class="quick-link-icon">📖</div>
                    <div class="quick-link-text">
                        <strong>How to Use</strong>
                        <small>Complete testing guide</small>
                    </div>
                </a>
                <a href="GMAIL_SETUP_FIX.md" class="quick-link">
                    <div class="quick-link-icon">🔧</div>
                    <div class="quick-link-text">
                        <strong>Setup Gmail</strong>
                        <small>Real email configuration</small>
                    </div>
                </a>
            </div>
        </div>
        
        <div class="grid">
            <div class="card">
                <h3>
                    <span class="icon">🧪</span>
                    Test Mode Status
                    <span class="status active">ACTIVE</span>
                </h3>
                <div class="stat">
                    <div class="stat-label">Mode</div>
                    <div class="stat-value">Development</div>
                </div>
                <p>The system is in TEST_MODE. All OTPs are logged to a file instead of being sent via email. Perfect for development and testing without external SMTP.</p>
                <p style="margin-top: 10px; font-size: 12px; color: #999;">
                    <strong>Log File:</strong> assets/uploads/otp_test_log.txt
                </p>
            </div>
            
            <div class="card">
                <h3>
                    <span class="icon">📊</span>
                    System Statistics
                </h3>
                <div class="stat">
                    <div class="stat-label">OTPs Generated</div>
                    <div class="stat-value"><?php echo $otpCount; ?></div>
                </div>
                <div class="stat">
                    <div class="stat-label">OTP Length</div>
                    <div class="stat-value">6 digits</div>
                </div>
                <div class="stat">
                    <div class="stat-label">Expiry Time</div>
                    <div class="stat-value">15 minutes</div>
                </div>
            </div>
            
            <div class="card">
                <h3>
                    <span class="icon">⚙️</span>
                    Configuration
                </h3>
                <p><strong>SMTP Host:</strong> smtp.gmail.com</p>
                <p><strong>Port:</strong> 587</p>
                <p><strong>Email:</strong> mak.6052413@gmail.com</p>
                <p><strong>Mode:</strong> TEST (logs to file)</p>
                <p style="margin-top: 15px; font-size: 12px; color: #999;">
                    Edit <strong>backend/mail_config.php</strong> to change settings
                </p>
            </div>
            
            <div class="card">
                <h3>
                    <span class="icon">✨</span>
                    Features
                </h3>
                <ul class="feature-list">
                    <li>6-digit OTP generation</li>
                    <li>Email verification</li>
                    <li>Account auto-creation</li>
                    <li>Forgot password support</li>
                    <li>Rate limiting (30s)</li>
                    <li>Attempt tracking (max 5)</li>
                </ul>
            </div>
            
            <div class="card">
                <h3>
                    <span class="icon">🔐</span>
                    Security
                </h3>
                <ul class="feature-list">
                    <li>Bcrypt password hashing</li>
                    <li>Prepared SQL statements</li>
                    <li>15-min OTP expiry</li>
                    <li>Max 5 attempts limit</li>
                    <li>Rate limiting on resend</li>
                    <li>Email verification required</li>
                </ul>
            </div>
            
            <div class="card">
                <h3>
                    <span class="icon">📚</span>
                    Documentation
                </h3>
                <p>Complete guides available:</p>
                <ul class="feature-list">
                    <li>How to test the system</li>
                    <li>Gmail setup instructions</li>
                    <li>API documentation</li>
                    <li>Database schema</li>
                    <li>Frontend integration</li>
                    <li>Troubleshooting guide</li>
                </ul>
            </div>
        </div>
        
        <div class="quick-access">
            <h2>How It Works</h2>
            <ol style="color: #333; line-height: 1.8; margin-left: 20px;">
                <li><strong>User signs up</strong> with email, password, phone, etc.</li>
                <li><strong>OTP is generated</strong> and logged to file (TEST_MODE) or sent via email</li>
                <li><strong>Modal appears</strong> asking user to enter OTP</li>
                <li><strong>User verifies OTP</strong> by entering code from email or log file</li>
                <li><strong>Account is created</strong> and email is marked as verified</li>
                <li><strong>User can signin</strong> with verified email and password</li>
            </ol>
        </div>
        
        <div class="quick-access">
            <h2>Next Steps</h2>
            <div style="color: #333;">
                <h3 style="margin-bottom: 15px;">For Development/Testing (Now):</h3>
                <p>✓ Open: <a href="otp_viewer.php" style="color: #667eea;">OTP Viewer</a></p>
                <p>✓ Go to: <a href="index.php" style="color: #667eea;">Signup Form</a></p>
                <p>✓ Test the complete flow using OTPs from the log file</p>
                
                <h3 style="margin-bottom: 15px; margin-top: 20px;">For Production (When Ready):</h3>
                <p>1. Read: <a href="GMAIL_SETUP_FIX.md" style="color: #667eea;">Gmail Setup Guide</a></p>
                <p>2. Generate Gmail App Password</p>
                <p>3. Update credentials in <strong>backend/mail_config.php</strong></p>
                <p>4. Change <strong>TEST_MODE to false</strong></p>
                <p>5. Real emails will send automatically</p>
            </div>
        </div>
        
        <div class="footer">
            <p>✅ System Status: WORKING | 🧪 Mode: TEST | 📧 Email Delivery: LOGGING (DEV MODE)</p>
            <p style="margin-top: 10px;">Version 1.0 | Last Updated: February 2, 2026</p>
        </div>
    </div>
</body>
</html>
