<!DOCTYPE html>
<html dir="ltr" lang="en-US">

<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="author" content="Granny Restaurant">
    <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1">
    <meta name="description" content="Server Login - Granny Restaurant">
    <link href="../assets/images/favicon/favicon.png" rel="icon">

    <!-- Fonts -->
    <link href="https://fonts.googleapis.com/css?family=Raleway:100,100i,200,200i,300,300i,400,400i,500,500i,600,600i,700,700i,800,800i,900,900i" rel="stylesheet" type="text/css">

    <!-- Font Awesome Icons -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">

    <!-- SweetAlert2 CSS -->
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/sweetalert2@11/dist/sweetalert2.min.css">

    <title>Server Login - Granny Restaurant</title>

    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            font-family: 'Raleway', sans-serif;
            background: linear-gradient(135deg, #d4a574 0%, #b8860b 100%);
            min-height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
            padding: 20px;
        }

        .login-wrapper {
            width: 100%;
            max-width: 1200px;
            display: grid;
            grid-template-columns: 1fr 1fr;
            gap: 0;
            border-radius: 20px;
            overflow: hidden;
            box-shadow: 0 30px 60px rgba(0, 0, 0, 0.3);
            background: white;
            min-height: 500px;
        }

        /* Left Side - Welcome Section */
        .login-welcome {
            background: linear-gradient(135deg, #d4a574 0%, #b8860b 100%);
            padding: 60px 50px;
            display: flex;
            flex-direction: column;
            justify-content: center;
            color: white;
            position: relative;
            overflow: hidden;
        }

        .login-welcome::before {
            content: '';
            position: absolute;
            top: -50%;
            right: -50%;
            width: 600px;
            height: 600px;
            background: radial-gradient(circle, rgba(255,255,255,0.1) 1px, transparent 1px);
            background-size: 30px 30px;
            animation: moveBackground 15s linear infinite;
        }

        @keyframes moveBackground {
            0% { transform: translate(0, 0); }
            100% { transform: translate(30px, 30px); }
        }

        .welcome-content {
            position: relative;
            z-index: 1;
        }

        .welcome-title {
            font-size: 48px;
            font-weight: 700;
            margin-bottom: 20px;
            line-height: 1.2;
        }

        .welcome-emoji {
            font-size: 48px;
            margin-left: 10px;
            display: inline-block;
            animation: wave 2s ease-in-out infinite;
        }

        @keyframes wave {
            0%, 100% { transform: rotate(0deg); }
            10%, 30% { transform: rotate(14deg); }
            20% { transform: rotate(-8deg); }
            40%, 60% { transform: rotate(0deg); }
        }

        .welcome-description {
            font-size: 16px;
            color: rgba(255, 255, 255, 0.95);
            line-height: 1.6;
            margin-bottom: 30px;
        }

        .welcome-features {
            list-style: none;
        }

        .welcome-features li {
            margin-bottom: 12px;
            display: flex;
            align-items: center;
            font-size: 15px;
        }

        .welcome-features i {
            margin-right: 12px;
            font-size: 20px;
        }

        /* Right Side - Login Form */
        .login-form-section {
            padding: 60px 50px;
            display: flex;
            flex-direction: column;
            justify-content: center;
        }

        .form-header {
            margin-bottom: 30px;
        }

        .form-header h2 {
            font-size: 32px;
            color: #333;
            margin-bottom: 10px;
        }

        .form-header p {
            color: #999;
            font-size: 14px;
        }

        .form-group {
            margin-bottom: 25px;
        }

        .form-group label {
            display: block;
            margin-bottom: 8px;
            color: #555;
            font-weight: 600;
            font-size: 14px;
        }

        .form-group input {
            width: 100%;
            padding: 12px 15px;
            border: 1px solid #ddd;
            border-radius: 8px;
            font-size: 14px;
            font-family: inherit;
            transition: all 0.3s ease;
        }

        .form-group input:focus {
            outline: none;
            border-color: #b8860b;
            box-shadow: 0 0 0 3px rgba(184, 134, 11, 0.1);
        }

        .login-btn {
            width: 100%;
            padding: 14px;
            background: linear-gradient(135deg, #d4a574 0%, #b8860b 100%);
            color: white;
            border: none;
            border-radius: 8px;
            font-size: 16px;
            font-weight: 600;
            cursor: pointer;
            transition: all 0.3s ease;
            display: flex;
            align-items: center;
            justify-content: center;
            gap: 8px;
        }

        .login-btn:hover {
            transform: translateY(-2px);
            box-shadow: 0 10px 20px rgba(184, 134, 11, 0.3);
        }

        .login-btn:disabled {
            opacity: 0.6;
            cursor: not-allowed;
            transform: none;
        }

        .error-message {
            color: #dc3545;
            font-size: 13px;
            margin-top: 5px;
            display: none;
        }

        .form-links {
            margin-top: 20px;
            text-align: center;
            font-size: 13px;
        }

        .form-links a {
            color: #b8860b;
            text-decoration: none;
            font-weight: 600;
        }

        .form-links a:hover {
            text-decoration: underline;
        }

        /* Responsive */
        @media (max-width: 768px) {
            .login-wrapper {
                grid-template-columns: 1fr;
            }

            .login-welcome {
                display: none;
            }

            .login-form-section {
                padding: 40px 30px;
            }

            .welcome-title {
                font-size: 28px;
            }
        }

        .loading-spinner {
            border: 3px solid rgba(255, 255, 255, 0.3);
            border-top: 3px solid white;
            border-radius: 50%;
            width: 16px;
            height: 16px;
            animation: spin 0.8s linear infinite;
        }

        @keyframes spin {
            0% { transform: rotate(0deg); }
            100% { transform: rotate(360deg); }
        }
    </style>
</head>

<body>
    <div class="login-wrapper">
        <!-- Left Side - Welcome -->
        <div class="login-welcome">
            <div class="welcome-content">
                <div class="welcome-title">
                    Welcome to Your Server <span class="welcome-emoji">💁‍♂️</span>
                </div>
                <p class="welcome-description">
                    Manage your assigned tables, take customer orders, and deliver exceptional service.
                </p>
                <ul class="welcome-features">
                    <li><i class="fas fa-check-circle"></i> View your assigned tables</li>
                    <li><i class="fas fa-list"></i> Take and manage orders</li>
                    <li><i class="fas fa-clock"></i> Track service time</li>
                    <li><i class="fas fa-star"></i> Real-time notifications</li>
                </ul>
            </div>
        </div>

        <!-- Right Side - Login Form -->
        <div class="login-form-section">
            <div class="form-header">
                <h2>Login</h2>
                <p>Enter your credentials to access your dashboard</p>
            </div>

            <form id="loginForm">
                <div class="form-group">
                    <label for="employee_id"><i class="fas fa-id-card"></i> Employee ID</label>
                    <input type="text" id="employee_id" name="employee_id" required placeholder="Enter your employee ID">
                    <div class="error-message" id="employeeIdError"></div>
                </div>

                <div class="form-group">
                    <label for="password"><i class="fas fa-lock"></i> Password</label>
                    <input type="password" id="password" name="password" required placeholder="Enter your password">
                    <div class="error-message" id="passwordError"></div>
                </div>

                <button type="submit" class="login-btn" id="submitBtn">
                    <span id="btnText">Login to Dashboard</span>
                    <span class="loading-spinner" id="spinner" style="display: none;"></span>
                </button>

                <div class="form-links">
                    <p>Don't have an account? <a href="#" onclick="alert('Please contact your manager'); return false;">Contact Manager</a></p>
                </div>
            </form>
        </div>
    </div>

    <!-- SweetAlert2 -->
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11/dist/sweetalert2.all.min.js"></script>

    <script>
        const loginForm = document.getElementById('loginForm');
        const submitBtn = document.getElementById('submitBtn');
        const spinner = document.getElementById('spinner');
        const btnText = document.getElementById('btnText');

        loginForm.addEventListener('submit', async (e) => {
            e.preventDefault();

            // Clear previous errors
            document.querySelectorAll('.error-message').forEach(el => el.style.display = 'none');

            const employee_id = document.getElementById('employee_id').value.trim();
            const password = document.getElementById('password').value;

            // Validation
            if (!employee_id) {
                document.getElementById('employeeIdError').textContent = 'Employee ID is required';
                document.getElementById('employeeIdError').style.display = 'block';
                return;
            }

            if (!password) {
                document.getElementById('passwordError').textContent = 'Password is required';
                document.getElementById('passwordError').style.display = 'block';
                return;
            }

            // Show loading
            submitBtn.disabled = true;
            spinner.style.display = 'inline-block';
            btnText.textContent = 'Logging in...';

            try {
                const response = await fetch('../backend/server_signin.php', {
                    method: 'POST',
                    headers: {
                        'Content-Type': 'application/json',
                    },
                    body: JSON.stringify({ employee_id, password })
                });

                const data = await response.json();

                if (data.success) {
                    // Store user data in localStorage
                    localStorage.setItem('serverData', JSON.stringify(data.data));

                    // Show success and redirect
                    Swal.fire({
                        title: 'Login Successful!',
                        text: `Welcome back, ${data.data.name}!`,
                        icon: 'success',
                        timer: 1500,
                        showConfirmButton: false
                    }).then(() => {
                        window.location.href = 'dashboard.php';
                    });
                } else {
                    Swal.fire({
                        title: 'Login Failed',
                        text: data.message || 'Invalid credentials',
                        icon: 'error',
                        confirmButtonColor: '#b8860b'
                    });
                }
            } catch (error) {
                console.error('Error:', error);
                Swal.fire({
                    title: 'Error',
                    text: 'An error occurred. Please try again.',
                    icon: 'error',
                    confirmButtonColor: '#b8860b'
                });
            } finally {
                // Hide loading
                submitBtn.disabled = false;
                spinner.style.display = 'none';
                btnText.textContent = 'Login to Dashboard';
            }
        });

        // Auto-fill for demo purposes (optional)
        // document.getElementById('employee_id').value = 'SRV001';
        // document.getElementById('password').value = 'password123';
    </script>
</body>

</html>
