<?php
// OTP Viewer for Testing - Simple page to view all generated OTPs

$logFile = __DIR__ . '/assets/uploads/otp_test_log.txt';
$otps = [];
$lastEmail = '';

if (file_exists($logFile)) {
    $lines = file($logFile, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES);
    $otps = array_reverse($lines); // Most recent first
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>OTP Viewer - Test Mode</title>
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        
        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            min-height: 100vh;
            display: flex;
            justify-content: center;
            align-items: center;
            padding: 20px;
        }
        
        .container {
            background: white;
            border-radius: 15px;
            box-shadow: 0 20px 60px rgba(0, 0, 0, 0.3);
            max-width: 800px;
            width: 100%;
            padding: 40px;
        }
        
        .header {
            text-align: center;
            margin-bottom: 40px;
        }
        
        .header h1 {
            color: #333;
            margin-bottom: 10px;
            font-size: 28px;
        }
        
        .header p {
            color: #666;
            font-size: 14px;
        }
        
        .mode-badge {
            display: inline-block;
            background: #ff9800;
            color: white;
            padding: 8px 16px;
            border-radius: 20px;
            font-size: 12px;
            font-weight: bold;
            margin-bottom: 20px;
        }
        
        .info-box {
            background: #e3f2fd;
            border-left: 4px solid #2196f3;
            padding: 15px;
            border-radius: 5px;
            margin-bottom: 30px;
            color: #1565c0;
            font-size: 14px;
        }
        
        .otps-section h2 {
            color: #333;
            margin-bottom: 20px;
            font-size: 18px;
        }
        
        .otp-item {
            background: #f5f5f5;
            border: 1px solid #e0e0e0;
            border-radius: 8px;
            padding: 15px;
            margin-bottom: 12px;
            transition: all 0.3s ease;
        }
        
        .otp-item:hover {
            background: #fafafa;
            border-color: #667eea;
            box-shadow: 0 2px 8px rgba(102, 126, 234, 0.15);
        }
        
        .otp-time {
            color: #999;
            font-size: 12px;
            margin-bottom: 8px;
        }
        
        .otp-email {
            color: #666;
            font-size: 14px;
            margin-bottom: 8px;
        }
        
        .otp-code {
            display: flex;
            align-items: center;
            justify-content: space-between;
        }
        
        .otp-value {
            font-size: 24px;
            font-weight: bold;
            color: #667eea;
            font-family: 'Courier New', monospace;
            letter-spacing: 3px;
        }
        
        .copy-btn {
            background: #667eea;
            color: white;
            border: none;
            padding: 8px 16px;
            border-radius: 5px;
            cursor: pointer;
            font-size: 12px;
            transition: background 0.3s ease;
        }
        
        .copy-btn:hover {
            background: #764ba2;
        }
        
        .copy-btn.copied {
            background: #4caf50;
        }
        
        .empty-state {
            text-align: center;
            padding: 40px 20px;
            color: #999;
        }
        
        .empty-state svg {
            width: 60px;
            height: 60px;
            margin-bottom: 20px;
            opacity: 0.3;
        }
        
        .refresh-btn {
            background: #667eea;
            color: white;
            border: none;
            padding: 12px 24px;
            border-radius: 8px;
            cursor: pointer;
            font-size: 14px;
            transition: background 0.3s ease;
            display: block;
            margin: 0 auto;
        }
        
        .refresh-btn:hover {
            background: #764ba2;
        }
        
        .footer {
            text-align: center;
            margin-top: 30px;
            padding-top: 20px;
            border-top: 1px solid #e0e0e0;
            color: #999;
            font-size: 12px;
        }
        
        .footer a {
            color: #667eea;
            text-decoration: none;
        }
        
        .footer a:hover {
            text-decoration: underline;
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="header">
            <div class="mode-badge">🧪 TEST MODE ACTIVE</div>
            <h1>OTP Viewer</h1>
            <p>View all generated OTPs for testing</p>
        </div>
        
        <div class="info-box">
            ℹ️ In TEST MODE, emails are not sent. Instead, all OTPs are logged here. 
            Copy an OTP below and paste it into the verification modal to test the system.
        </div>
        
        <?php if (empty($otps)): ?>
            <div class="empty-state">
                <p>No OTPs generated yet.</p>
                <p style="font-size: 12px; margin-top: 10px;">
                    Go to the signup form and try to register. The OTP will appear here.
                </p>
            </div>
        <?php else: ?>
            <div class="otps-section">
                <h2>Generated OTPs (Most Recent First)</h2>
                <?php foreach ($otps as $line): 
                    // Parse: 2026-02-02 12:55:50 - Email: newemail1770033350@example.com, OTP: 732003, Purpose: signup
                    if (preg_match('/^(\d{4}-\d{2}-\d{2} \d{2}:\d{2}:\d{2}).*Email: ([^,]+).*OTP: (\d+).*Purpose: (.+)$/', $line, $matches)):
                        $timestamp = $matches[1];
                        $email = $matches[2];
                        $otp = $matches[3];
                        $purpose = $matches[4];
                ?>
                    <div class="otp-item">
                        <div class="otp-time">⏰ <?php echo htmlspecialchars($timestamp); ?></div>
                        <div class="otp-email">📧 <?php echo htmlspecialchars($email); ?> (<?php echo htmlspecialchars($purpose); ?>)</div>
                        <div class="otp-code">
                            <div class="otp-value"><?php echo htmlspecialchars($otp); ?></div>
                            <button class="copy-btn" onclick="copyToClipboard('<?php echo htmlspecialchars($otp); ?>', this)">📋 Copy</button>
                        </div>
                    </div>
                <?php 
                    endif;
                endforeach; 
                ?>
            </div>
        <?php endif; ?>
        
        <button class="refresh-btn" onclick="location.reload()">🔄 Refresh</button>
        
        <div class="footer">
            <p><strong>Remember:</strong> This is TEST MODE. No emails are actually sent.</p>
            <p><a href="GMAIL_SETUP_FIX.md">Ready to send real emails? Read the Gmail Setup Guide →</a></p>
        </div>
    </div>
    
    <script>
        function copyToClipboard(text, button) {
            navigator.clipboard.writeText(text).then(function() {
                // Visual feedback
                const originalText = button.textContent;
                button.textContent = '✓ Copied!';
                button.classList.add('copied');
                
                setTimeout(function() {
                    button.textContent = originalText;
                    button.classList.remove('copied');
                }, 2000);
            }).catch(function(err) {
                alert('Failed to copy: ' + err);
            });
        }
    </script>
</body>
</html>
