<!DOCTYPE html>
<html dir="ltr" lang="en-US">

<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1">
    <meta name="description" content="Settings - Granny Restaurant Manager">
    <link href="../assets/images/favicon/favicon.png" rel="icon">

    <link href="https://fonts.googleapis.com/css?family=Raleway:100,100i,200,200i,300,300i,400,400i,500,500i,600,600i,700,700i,800,800i,900,900i" rel="stylesheet" type="text/css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/sweetalert2@11/dist/sweetalert2.min.css">
    <link rel="stylesheet" href="manager-styles.css">

    <title>Settings - Granny Restaurant</title>

    <style>
        .main-content {
            padding: 30px 30px;
        }

        .container {
            max-width: 800px;
            margin: 0 auto;
            padding: 0;
        }

        .page-header {
            margin-bottom: 30px;
            background: white;
            padding: 20px 30px;
            border-radius: 10px;
            box-shadow: 0 2px 10px rgba(0, 0, 0, 0.05);
        }

        .page-header h1 {
            color: #1e3c72;
            font-size: 28px;
            margin: 0;
        }



        .settings-card {
            background: white;
            border-radius: 10px;
            box-shadow: 0 2px 10px rgba(0, 0, 0, 0.05);
            margin-bottom: 20px;
            overflow: hidden;
        }

        .card-header {
            background: linear-gradient(135deg, #1e3c72 0%, #2a5298 100%);
            color: white;
            padding: 20px 30px;
            font-weight: 600;
            font-size: 16px;
            display: flex;
            align-items: center;
            gap: 10px;
        }

        .card-body {
            padding: 30px;
        }

        .form-group {
            margin-bottom: 25px;
        }

        .form-group:last-child {
            margin-bottom: 0;
        }

        .form-group label {
            display: block;
            margin-bottom: 10px;
            color: #333;
            font-weight: 600;
            font-size: 14px;
        }

        .form-group input,
        .form-group select,
        .form-group textarea {
            width: 100%;
            padding: 12px 15px;
            border: 1px solid #ddd;
            border-radius: 6px;
            font-family: inherit;
            font-size: 14px;
        }

        .form-group textarea {
            resize: vertical;
            min-height: 80px;
        }

        .form-group input:focus,
        .form-group select:focus,
        .form-group textarea:focus {
            outline: none;
            border-color: #2a5298;
            box-shadow: 0 0 0 3px rgba(42, 82, 152, 0.1);
        }

        .btn {
            padding: 12px 24px;
            border: none;
            border-radius: 6px;
            cursor: pointer;
            font-size: 14px;
            font-weight: 600;
            transition: all 0.3s ease;
            display: inline-flex;
            align-items: center;
            gap: 8px;
        }

        .btn-primary {
            background: linear-gradient(135deg, #1e3c72 0%, #2a5298 100%);
            color: white;
        }

        .btn-primary:hover {
            transform: translateY(-2px);
            box-shadow: 0 5px 15px rgba(42, 82, 152, 0.3);
        }

        .btn-danger {
            background: #dc3545;
            color: white;
        }

        .btn-danger:hover {
            background: #c82333;
        }

        .button-group {
            display: flex;
            gap: 10px;
            margin-top: 30px;
        }

        .button-group button {
            flex: 1;
        }

        .info-box {
            background: #f8f9fa;
            padding: 15px;
            border-radius: 6px;
            border-left: 4px solid #2a5298;
            margin-bottom: 20px;
        }

        .info-box strong {
            color: #1e3c72;
        }

        .danger-zone {
            border: 2px solid #dc3545;
            background: #fff5f5;
        }

        .danger-zone .card-header {
            background: #dc3545;
        }

        @media (max-width: 768px) {
            .container {
                padding: 20px;
            }

            .card-body {
                padding: 20px;
            }

            .button-group {
                flex-direction: column;
            }

            .button-group button {
                width: 100%;
            }
        }

        .setting-row {
            display: flex;
            justify-content: space-between;
            align-items: center;
            padding: 15px 0;
            border-bottom: 1px solid #eee;
        }

        .setting-row:last-child {
            border-bottom: none;
        }

        .setting-label {
            flex: 1;
        }

        .setting-label strong {
            color: #333;
            display: block;
        }

        .setting-label p {
            font-size: 12px;
            color: #999;
            margin-top: 3px;
        }

        .setting-value {
            text-align: right;
        }

        .badge {
            display: inline-block;
            padding: 4px 10px;
            border-radius: 20px;
            font-size: 12px;
            font-weight: 600;
        }

        .badge-success {
            background: #d4edda;
            color: #155724;
        }

        .badge-warning {
            background: #fff3cd;
            color: #856404;
        }
    </style>
</head>

<body>
    <div class="dashboard-container">
        <?php include 'sidebar.php'; ?>
        <div class="main-content">
            <div class="container">
                <div class="page-header">
            <h1><i class="fas fa-cog"></i> Settings</h1>
        </div>

        <!-- Profile Settings -->
        <div class="settings-card">
            <div class="card-header">
                <i class="fas fa-user"></i> Profile Information
            </div>
            <div class="card-body">
                <div class="info-box">
                    Your profile information helps us keep your account secure and up to date.
                </div>

                <form id="profileForm">
                    <div class="form-group">
                        <label>Full Name</label>
                        <input type="text" id="fullName" placeholder="Enter your full name">
                    </div>

                    <div class="form-group">
                        <label>Email Address</label>
                        <input type="email" id="email" placeholder="Enter your email" readonly>
                    </div>

                    <div class="form-group">
                        <label>Phone Number</label>
                        <input type="tel" id="phone" placeholder="Enter your phone number">
                    </div>

                    <div class="form-group">
                        <label>Employee ID</label>
                        <input type="text" id="employeeId" placeholder="Enter your employee ID" readonly>
                    </div>

                    <div class="form-group">
                        <label>Shift Type</label>
                        <select id="shiftType">
                            <option value="day">Day Shift (10:00 AM - 5:00 PM)</option>
                            <option value="evening">Evening Shift (5:00 PM - 11:00 PM)</option>
                            <option value="night">Night Shift (11:00 PM - 10:00 AM)</option>
                        </select>
                    </div>

                    <button type="submit" class="btn btn-primary">
                        <i class="fas fa-save"></i> Update Profile
                    </button>
                </form>
            </div>
        </div>

        <!-- Security Settings -->
        <div class="settings-card">
            <div class="card-header">
                <i class="fas fa-lock"></i> Security & Password
            </div>
            <div class="card-body">
                <div class="info-box">
                    Keep your account secure by using a strong, unique password.
                </div>

                <form id="passwordForm">
                    <div class="form-group">
                        <label>Current Password</label>
                        <input type="password" id="currentPassword" placeholder="Enter your current password" required>
                    </div>

                    <div class="form-group">
                        <label>New Password</label>
                        <input type="password" id="newPassword" placeholder="Enter new password" required>
                    </div>

                    <div class="form-group">
                        <label>Confirm New Password</label>
                        <input type="password" id="confirmPassword" placeholder="Confirm new password" required>
                    </div>

                    <button type="submit" class="btn btn-primary">
                        <i class="fas fa-key"></i> Change Password
                    </button>
                </form>
            </div>
        </div>

        <!-- Notifications Settings -->
        <div class="settings-card">
            <div class="card-header">
                <i class="fas fa-bell"></i> Notification Preferences
            </div>
            <div class="card-body">
                <div class="setting-row">
                    <div class="setting-label">
                        <strong>Email Notifications</strong>
                        <p>Receive important updates via email</p>
                    </div>
                    <div class="setting-value">
                        <label style="display: flex; align-items: center; margin: 0;">
                            <input type="checkbox" id="emailNotif" checked style="width: auto; margin-right: 8px;">
                            Enabled
                        </label>
                    </div>
                </div>

                <div class="setting-row">
                    <div class="setting-label">
                        <strong>Daily Reports</strong>
                        <p>Receive daily operational summaries</p>
                    </div>
                    <div class="setting-value">
                        <label style="display: flex; align-items: center; margin: 0;">
                            <input type="checkbox" id="dailyReports" checked style="width: auto; margin-right: 8px;">
                            Enabled
                        </label>
                    </div>
                </div>

                <div class="setting-row">
                    <div class="setting-label">
                        <strong>Alerts</strong>
                        <p>Get alerts for critical issues</p>
                    </div>
                    <div class="setting-value">
                        <label style="display: flex; align-items: center; margin: 0;">
                            <input type="checkbox" id="alerts" checked style="width: auto; margin-right: 8px;">
                            Enabled
                        </label>
                    </div>
                </div>

                <button class="btn btn-primary" style="margin-top: 20px;" onclick="saveNotificationPreferences()">
                    <i class="fas fa-save"></i> Save Preferences
                </button>
            </div>
        </div>

        <!-- Account Status -->
        <div class="settings-card">
            <div class="card-header">
                <i class="fas fa-info-circle"></i> Account Status
            </div>
            <div class="card-body">
                <div class="setting-row">
                    <div class="setting-label">
                        <strong>Account Status</strong>
                        <p>Your current account status</p>
                    </div>
                    <div class="setting-value">
                        <span class="badge badge-success">Active</span>
                    </div>
                </div>

                <div class="setting-row">
                    <div class="setting-label">
                        <strong>Last Login</strong>
                        <p>Your last login time</p>
                    </div>
                    <div class="setting-value" id="lastLogin">
                        Just now
                    </div>
                </div>

                <div class="setting-row">
                    <div class="setting-label">
                        <strong>Member Since</strong>
                        <p>When you joined</p>
                    </div>
                    <div class="setting-value" id="memberSince">
                        2024
                    </div>
                </div>
            </div>
        </div>

        <!-- Danger Zone -->
        <div class="settings-card danger-zone">
            <div class="card-header">
                <i class="fas fa-exclamation-triangle"></i> Danger Zone
            </div>
            <div class="card-body">
                <div class="form-group">
                    <p style="color: #dc3545; margin-bottom: 15px;">
                        <strong>Warning:</strong> These actions are irreversible. Please proceed with caution.
                    </p>
                </div>

                <button class="btn btn-danger" onclick="confirmLogout()">
                    <i class="fas fa-sign-out-alt"></i> Logout All Devices
                </button>

                <button class="btn btn-danger" style="margin-top: 10px;" onclick="contactAdmin()">
                    <i class="fas fa-envelope"></i> Request Account Deactivation
                </button>
            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11/dist/sweetalert2.all.min.js"></script>
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>

    <script>
        $(document).ready(function() {
            checkAuthentication();
            loadManagerProfile();
        });

        function checkAuthentication() {
            if (!localStorage.getItem('manager_id')) {
                window.location.href = 'login.php';
            }
        }

        function loadManagerProfile() {
            // Load from backend API instead of just localStorage
            $.ajax({
                url: '../backend/manager_profile_api.php?action=getProfile',
                type: 'GET',
                success: function(response) {
                    if (response.success && response.data) {
                        const manager = response.data;
                        $('#fullName').val(manager.name || '');
                        $('#email').val(manager.email || '');
                        $('#phone').val(manager.phone || '');
                        $('#employeeId').val(manager.employee_id || '');
                        $('#shiftType').val(manager.shift_type || 'day');
                        
                        // Update localStorage as backup
                        localStorage.setItem('manager_name', manager.name);
                        localStorage.setItem('manager_email', manager.email);
                        localStorage.setItem('manager_shift', manager.shift_type);
                    }
                }
            });

            // Load account status
            $.ajax({
                url: '../backend/manager_profile_api.php?action=getStatus',
                type: 'GET',
                success: function(response) {
                    if (response.success && response.data) {
                        const manager = response.data;
                        const lastLogin = manager.last_login ? new Date(manager.last_login).toLocaleString() : 'Never';
                        const memberSince = manager.created_at ? new Date(manager.created_at).toLocaleDateString('en-US', { year: 'numeric', month: 'short' }) : 'Unknown';
                        
                        $('#lastLogin').text(lastLogin);
                        $('#memberSince').text(memberSince);
                    }
                }
            });

            // Load preferences
            $.ajax({
                url: '../backend/manager_profile_api.php?action=getPreferences',
                type: 'GET',
                success: function(response) {
                    if (response.success && response.data) {
                        const prefs = response.data;
                        $('#emailNotif').prop('checked', prefs.emailNotifications);
                        $('#dailyReports').prop('checked', prefs.dailyReports);
                        $('#alerts').prop('checked', prefs.criticalAlerts);
                    }
                }
            });
        }

        $('#profileForm').on('submit', function(e) {
            e.preventDefault();

            const fullName = $('#fullName').val();
            const phone = $('#phone').val();
            const shiftType = $('#shiftType').val();

            if (!fullName.trim()) {
                Swal.fire('Error', 'Please enter your full name', 'error');
                return;
            }

            // Show loading state
            Swal.fire({
                title: 'Updating Profile...',
                allowOutsideClick: false,
                didOpen: () => {
                    Swal.showLoading();
                }
            });

            // Call backend API
            $.ajax({
                url: '../backend/manager_profile_api.php?action=updateProfile',
                type: 'POST',
                contentType: 'application/json',
                data: JSON.stringify({
                    name: fullName,
                    phone: phone,
                    shift_type: shiftType
                }),
                success: function(response) {
                    if (response.success) {
                        // Update localStorage with new data
                        localStorage.setItem('manager_name', fullName);
                        localStorage.setItem('manager_shift', shiftType);
                        
                        Swal.fire('Success', 'Profile updated successfully', 'success');
                    } else {
                        Swal.fire('Error', response.message, 'error');
                    }
                },
                error: function() {
                    Swal.fire('Error', 'Failed to update profile. Please try again.', 'error');
                }
            });
        });

        $('#passwordForm').on('submit', function(e) {
            e.preventDefault();

            const currentPassword = $('#currentPassword').val();
            const newPassword = $('#newPassword').val();
            const confirmPassword = $('#confirmPassword').val();

            if (!currentPassword || !newPassword || !confirmPassword) {
                Swal.fire('Error', 'Please fill all password fields', 'error');
                return;
            }

            if (newPassword.length < 8) {
                Swal.fire('Error', 'Password must be at least 8 characters', 'error');
                return;
            }

            if (newPassword !== confirmPassword) {
                Swal.fire('Error', 'Passwords do not match', 'error');
                return;
            }

            // Show loading state
            Swal.fire({
                title: 'Changing Password...',
                allowOutsideClick: false,
                didOpen: () => {
                    Swal.showLoading();
                }
            });

            // Call backend API
            $.ajax({
                url: '../backend/manager_profile_api.php?action=changePassword',
                type: 'POST',
                contentType: 'application/json',
                dataType: 'json',
                data: JSON.stringify({
                    currentPassword: currentPassword,
                    newPassword: newPassword,
                    confirmPassword: confirmPassword
                }),
                success: function(response) {
                    console.log('Success response:', response);
                    if (response.success) {
                        Swal.fire('Success', 'Password changed successfully. Please login with your new password.', 'success');
                        // Clear the form
                        document.getElementById('passwordForm').reset();
                        // Optional: Redirect to login after 2 seconds
                        setTimeout(() => {
                            window.location.href = 'login.php';
                        }, 2000);
                    } else {
                        Swal.fire('Error', response.message || 'Failed to change password', 'error');
                    }
                },
                error: function(xhr, status, error) {
                    console.error('XHR Status:', xhr.status);
                    console.error('XHR Response:', xhr.responseText);
                    console.error('Error:', error);
                    try {
                        const jsonResponse = JSON.parse(xhr.responseText);
                        if (jsonResponse && jsonResponse.message) {
                            Swal.fire('Error', jsonResponse.message, 'error');
                        } else {
                            Swal.fire('Error', 'Failed to change password. Please try again.', 'error');
                        }
                    } catch(e) {
                        Swal.fire('Error', 'Failed to change password. Server error: ' + xhr.status, 'error');
                    }
                }
            });
        });

        function saveNotificationPreferences() {
            // Show loading state
            Swal.fire({
                title: 'Saving Preferences...',
                allowOutsideClick: false,
                didOpen: () => {
                    Swal.showLoading();
                }
            });

            const preferences = {
                emailNotifications: $('#emailNotif').is(':checked'),
                dailyReports: $('#dailyReports').is(':checked'),
                alerts: $('#alerts').is(':checked')
            };

            // Call backend API
            $.ajax({
                url: '../backend/manager_profile_api.php?action=savePreferences',
                type: 'POST',
                contentType: 'application/json',
                data: JSON.stringify(preferences),
                success: function(response) {
                    if (response.success) {
                        Swal.fire('Success', 'Notification preferences saved successfully', 'success');
                    } else {
                        Swal.fire('Error', response.message, 'error');
                    }
                },
                error: function() {
                    Swal.fire('Error', 'Failed to save preferences. Please try again.', 'error');
                }
            });
        }

        function confirmLogout() {
            Swal.fire({
                icon: 'warning',
                title: 'Logout All Devices?',
                text: 'This will logout your account from all devices',
                showCancelButton: true,
                confirmButtonColor: '#dc3545',
                confirmButtonText: 'Yes, Logout All'
            }).then((result) => {
                if (result.isConfirmed) {
                    localStorage.removeItem('manager_id');
                    localStorage.removeItem('manager_name');
                    localStorage.removeItem('manager_email');
                    localStorage.removeItem('manager_shift');
                    window.location.href = 'login.php';
                }
            });
        }

        function contactAdmin() {
            Swal.fire({
                icon: 'info',
                title: 'Contact Administrator',
                text: 'Please contact the restaurant administrator to deactivate your account',
                confirmButtonText: 'Understood'
            });
        }
    </script>

    <!-- Manager Sidebar Script -->
    <script src="manager-sidebar.js"></script>
</body>

</html>
