<!DOCTYPE html>
<html dir="ltr" lang="en-US">

<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="author" content="Granny Restaurant">
    <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1">
    <meta name="description" content="Manager Login - Granny Restaurant">
    <link href="../assets/images/favicon/favicon.png" rel="icon">

    <!-- Fonts -->
    <link href="https://fonts.googleapis.com/css?family=Raleway:100,100i,200,200i,300,300i,400,400i,500,500i,600,600i,700,700i,800,800i,900,900i" rel="stylesheet" type="text/css">

    <!-- Font Awesome Icons -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">

    <!-- SweetAlert2 CSS -->
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/sweetalert2@11/dist/sweetalert2.min.css">

    <title>Manager Login - Granny Restaurant</title>

    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            font-family: 'Raleway', sans-serif;
            background: linear-gradient(135deg, #1e3c72 0%, #2a5298 100%);
            min-height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
            padding: 20px;
        }

        .login-wrapper {
            width: 100%;
            max-width: 1200px;
            display: grid;
            grid-template-columns: 1fr 1fr;
            gap: 0;
            border-radius: 20px;
            overflow: hidden;
            box-shadow: 0 30px 60px rgba(0, 0, 0, 0.3);
            background: white;
            min-height: 500px;
        }

        /* Left Side - Welcome Section */
        .login-welcome {
            background: linear-gradient(135deg, #1e3c72 0%, #2a5298 100%);
            padding: 60px 50px;
            display: flex;
            flex-direction: column;
            justify-content: center;
            color: white;
            position: relative;
            overflow: hidden;
        }

        .login-welcome::before {
            content: '';
            position: absolute;
            top: -50%;
            right: -50%;
            width: 600px;
            height: 600px;
            background: radial-gradient(circle, rgba(255,255,255,0.1) 1px, transparent 1px);
            background-size: 30px 30px;
            animation: moveBackground 15s linear infinite;
        }

        @keyframes moveBackground {
            0% { transform: translate(0, 0); }
            100% { transform: translate(30px, 30px); }
        }

        .welcome-content {
            position: relative;
            z-index: 1;
        }

        .welcome-title {
            font-size: 48px;
            font-weight: 700;
            margin-bottom: 20px;
            line-height: 1.2;
        }

        .welcome-emoji {
            font-size: 48px;
            margin-left: 10px;
            display: inline-block;
            animation: wave 2s ease-in-out infinite;
        }

        @keyframes wave {
            0%, 100% { transform: rotate(0deg); }
            25% { transform: rotate(20deg); }
            75% { transform: rotate(-20deg); }
        }

        .welcome-subtitle {
            font-size: 20px;
            margin-bottom: 30px;
            line-height: 1.6;
            opacity: 0.9;
            font-weight: 300;
        }

        .welcome-features {
            list-style: none;
        }

        .welcome-features li {
            margin-bottom: 15px;
            font-size: 16px;
            display: flex;
            align-items: center;
        }

        .welcome-features li i {
            margin-right: 15px;
            font-size: 20px;
            width: 30px;
            text-align: center;
        }

        /* Right Side - Login Form */
        .login-form-container {
            padding: 60px 50px;
            display: flex;
            flex-direction: column;
            justify-content: center;
        }

        .login-header {
            margin-bottom: 40px;
        }

        .login-header h1 {
            font-size: 32px;
            color: #1e3c72;
            margin-bottom: 10px;
            font-weight: 700;
        }

        .login-header p {
            color: #666;
            font-size: 14px;
        }

        .form-group {
            margin-bottom: 25px;
        }

        .form-group label {
            display: block;
            margin-bottom: 10px;
            color: #333;
            font-weight: 600;
            font-size: 14px;
        }

        .form-group input {
            width: 100%;
            padding: 14px 18px;
            border: 2px solid #e0e0e0;
            border-radius: 8px;
            font-size: 15px;
            transition: all 0.3s ease;
            font-family: 'Raleway', sans-serif;
        }

        .form-group input:focus {
            outline: none;
            border-color: #2a5298;
            box-shadow: 0 0 0 3px rgba(42, 82, 152, 0.1);
        }

        .form-group input::placeholder {
            color: #999;
        }

        .login-button {
            width: 100%;
            padding: 14px 20px;
            background: linear-gradient(135deg, #1e3c72 0%, #2a5298 100%);
            color: white;
            border: none;
            border-radius: 8px;
            font-size: 16px;
            font-weight: 600;
            cursor: pointer;
            transition: all 0.3s ease;
            margin-top: 20px;
            font-family: 'Raleway', sans-serif;
        }

        .login-button:hover {
            transform: translateY(-2px);
            box-shadow: 0 10px 20px rgba(42, 82, 152, 0.2);
        }

        .login-button:active {
            transform: translateY(0);
        }

        .login-button.loading {
            opacity: 0.7;
            pointer-events: none;
        }

        .login-footer {
            margin-top: 30px;
            text-align: center;
            color: #666;
            font-size: 14px;
        }

        .login-footer a {
            color: #2a5298;
            text-decoration: none;
            font-weight: 600;
        }

        .login-footer a:hover {
            text-decoration: underline;
        }

        .back-link {
            display: inline-flex;
            align-items: center;
            color: #2a5298;
            text-decoration: none;
            margin-bottom: 20px;
            font-size: 14px;
            font-weight: 600;
        }

        .back-link i {
            margin-right: 8px;
        }

        .back-link:hover {
            color: #1e3c72;
        }

        /* Responsive */
        @media (max-width: 768px) {
            .login-wrapper {
                grid-template-columns: 1fr;
            }

            .login-welcome {
                display: none;
            }

            .login-form-container {
                padding: 40px 30px;
            }

            .welcome-title {
                font-size: 28px;
            }
        }

        .form-group input::-webkit-autofill {
            -webkit-box-shadow: inset 0 0 0 1000px white !important;
            -webkit-text-fill-color: #333 !important;
        }

        .remember-me {
            display: flex;
            align-items: center;
            margin-bottom: 20px;
        }

        .remember-me input {
            width: auto;
            margin-right: 10px;
            cursor: pointer;
        }

        .remember-me label {
            margin: 0;
            font-weight: 400;
            cursor: pointer;
            color: #666;
        }

        .form-error {
            color: #dc3545;
            font-size: 13px;
            margin-top: 5px;
            display: none;
        }

        .form-error.show {
            display: block;
        }
    </style>
</head>

<body>
    <div class="login-wrapper">
        <!-- Left Side: Welcome Content -->
        <div class="login-welcome">
            <div class="welcome-content">
                <h2 class="welcome-title">
                    Welcome to Manager Portal
                    <span class="welcome-emoji">👨‍💼</span>
                </h2>
                <p class="welcome-subtitle">
                    Manage your restaurant operations with ease and efficiency
                </p>
                <ul class="welcome-features">
                    <li>
                        <i class="fas fa-table"></i>
                        <span>Table Management & Allocation</span>
                    </li>
                    <li>
                        <i class="fas fa-cash-register"></i>
                        <span>Billing & POS System</span>
                    </li>
                    <li>
                        <i class="fas fa-calendar-check"></i>
                        <span>Reservation Management</span>
                    </li>
                    <li>
                        <i class="fas fa-chart-bar"></i>
                        <span>Real-time Reports</span>
                    </li>
                    <li>
                        <i class="fas fa-tasks"></i>
                        <span>Daily Operations</span>
                    </li>
                </ul>
            </div>
        </div>

        <!-- Right Side: Login Form -->
        <div class="login-form-container">
            <a href="../index.php" class="back-link">
                <i class="fas fa-arrow-left"></i>
                Back to Home
            </a>

            <div class="login-header">
                <h1>Manager Login</h1>
                <p>Sign in to your account</p>
            </div>

            <form id="loginForm">
                <div class="form-group">
                    <label for="email">Email Address</label>
                    <input 
                        type="email" 
                        id="email" 
                        name="email" 
                        placeholder="Enter your email"
                        required
                    >
                    <div class="form-error" id="emailError"></div>
                </div>

                <div class="form-group">
                    <label for="password">Password</label>
                    <input 
                        type="password" 
                        id="password" 
                        name="password" 
                        placeholder="Enter your password"
                        required
                    >
                    <div class="form-error" id="passwordError"></div>
                </div>

                <div class="remember-me">
                    <input type="checkbox" id="rememberMe" name="rememberMe">
                    <label for="rememberMe">Remember me</label>
                </div>

                <button type="submit" class="login-button" id="loginBtn">
                    <i class="fas fa-sign-in-alt"></i> Sign In
                </button>
            </form>

            <div class="login-footer">
                <p>
                    Having trouble?
                    <a href="javascript:void(0)" onclick="alert('Please contact the restaurant administrator')">Get help</a>
                </p>
            </div>
        </div>
    </div>

    <!-- SweetAlert2 -->
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11/dist/sweetalert2.all.min.js"></script>
    <!-- jQuery -->
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>

    <script>
        $(document).ready(function() {
            const form = $('#loginForm');
            const loginBtn = $('#loginBtn');

            form.on('submit', function(e) {
                e.preventDefault();

                // Clear previous errors
                $('.form-error').removeClass('show').text('');

                const email = $('#email').val().trim();
                const password = $('#password').val();

                // Validation
                if (!email) {
                    $('#emailError').addClass('show').text('Email is required');
                    return;
                }

                if (!password) {
                    $('#passwordError').addClass('show').text('Password is required');
                    return;
                }

                // Show loading state
                loginBtn.addClass('loading').html('<i class="fas fa-spinner fa-spin"></i> Logging in...');

                // API call
                $.ajax({
                    url: '../backend/manager_signin.php',
                    method: 'POST',
                    contentType: 'application/json',
                    dataType: 'json',
                    data: JSON.stringify({
                        email: email,
                        password: password
                    }),
                    success: function(response) {
                        if (response.success) {
                            // Store manager info in localStorage
                            localStorage.setItem('manager_id', response.data.id);
                            localStorage.setItem('manager_name', response.data.name);
                            localStorage.setItem('manager_email', response.data.email);
                            localStorage.setItem('manager_shift', response.data.shift_type);

                            Swal.fire({
                                icon: 'success',
                                title: 'Login Successful',
                                text: 'Welcome back, ' + response.data.name + '!',
                                timer: 1500,
                                showConfirmButton: false
                            }).then(function() {
                                window.location.href = 'dashboard.php';
                            });
                        } else {
                            Swal.fire({
                                icon: 'error',
                                title: 'Login Failed',
                                text: response.message
                            });
                        }
                    },
                    error: function() {
                        Swal.fire({
                            icon: 'error',
                            title: 'Error',
                            text: 'An error occurred. Please try again.'
                        });
                    },
                    complete: function() {
                        loginBtn.removeClass('loading').html('<i class="fas fa-sign-in-alt"></i> Sign In');
                    }
                });
            });

            // Remember me functionality
            if (localStorage.getItem('rememberMe') === 'true') {
                $('#email').val(localStorage.getItem('rememberedEmail'));
                $('#rememberMe').prop('checked', true);
            }

            $('#rememberMe').on('change', function() {
                if ($(this).prop('checked')) {
                    localStorage.setItem('rememberMe', 'true');
                    localStorage.setItem('rememberedEmail', $('#email').val());
                } else {
                    localStorage.removeItem('rememberMe');
                    localStorage.removeItem('rememberedEmail');
                }
            });
        });
    </script>
</body>

</html>
