<!DOCTYPE html>
<html dir="ltr" lang="en-US">

<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="author" content="Granny Restaurant">
    <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1">
    <meta name="description" content="Manager Dashboard - Granny Restaurant">
    <link href="../assets/images/favicon/favicon.png" rel="icon">

    <!-- Fonts -->
    <link href="https://fonts.googleapis.com/css?family=Raleway:100,100i,200,200i,300,300i,400,400i,500,500i,600,600i,700,700i,800,800i,900,900i" rel="stylesheet" type="text/css">

    <!-- Font Awesome Icons -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">

    <!-- SweetAlert2 CSS -->
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/sweetalert2@11/dist/sweetalert2.min.css">

    <!-- Manager Layout Styles -->
    <link rel="stylesheet" href="manager-styles.css">

    <title>Manager Dashboard - Granny Restaurant</title>

    <style>
        /* Header */
        .header {
            background: white;
            padding: 20px 30px;
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 30px;
            border-radius: 10px;
            box-shadow: 0 2px 10px rgba(0, 0, 0, 0.05);
            position: sticky;
            top: 0;
            z-index: 100;
        }

        .header h1 {
            font-size: 24px;
            color: #1e3c72;
            margin: 0;
        }

        .header-right {
            display: flex;
            align-items: center;
            gap: 20px;
        }

        .user-info {
            text-align: right;
        }

        .user-name {
            font-weight: 600;
            color: #333;
            font-size: 14px;
        }

        .user-role {
            font-size: 12px;
            color: #666;
        }

        .logout-btn {
            padding: 8px 15px;
            background: #dc3545;
            color: white;
            border: none;
            border-radius: 6px;
            cursor: pointer;
            font-size: 12px;
            font-weight: 600;
            transition: all 0.3s ease;
        }

        .logout-btn:hover {
            background: #c82333;
        }

        /* Dashboard Grid */
        .dashboard-grid {
            display: grid;
            grid-template-columns: repeat(4, 1fr);
            gap: 20px;
            margin-bottom: 40px;
        }

        .card {
            background: white;
            padding: 25px;
            border-radius: 10px;
            box-shadow: 0 2px 10px rgba(0, 0, 0, 0.05);
            transition: all 0.3s ease;
        }

        .card:hover {
            box-shadow: 0 5px 20px rgba(0, 0, 0, 0.1);
            transform: translateY(-5px);
        }

        .card-title {
            font-size: 14px;
            color: #666;
            margin-bottom: 10px;
            text-transform: uppercase;
            letter-spacing: 0.5px;
            font-weight: 600;
        }

        .card-value {
            font-size: 32px;
            font-weight: 700;
            color: #1e3c72;
            margin-bottom: 10px;
        }

        .card-footer {
            font-size: 12px;
            color: #999;
        }

        .card-icon {
            position: absolute;
            top: 20px;
            right: 25px;
            font-size: 40px;
            opacity: 0.1;
        }

        .stat-card {
            position: relative;
            overflow: hidden;
        }

        .stat-card.success .card-value {
            color: #28a745;
        }

        .stat-card.warning .card-value {
            color: #ffc107;
        }

        .stat-card.danger .card-value {
            color: #dc3545;
        }

        .stat-card.info .card-value {
            color: #17a2b8;
        }

        /* Functions Grid */
        .functions-grid {
            display: grid;
            grid-template-columns: repeat(3, 1fr);
            gap: 20px;
            margin-bottom: 40px;
        }

        .function-card {
            background: white;
            padding: 30px;
            border-radius: 10px;
            text-align: center;
            cursor: pointer;
            transition: all 0.3s ease;
            box-shadow: 0 2px 10px rgba(0, 0, 0, 0.05);
            text-decoration: none;
            color: inherit;
            display: flex;
            flex-direction: column;
            align-items: center;
            justify-content: center;
        }

        .function-card:hover {
            box-shadow: 0 5px 20px rgba(0, 0, 0, 0.1);
            transform: translateY(-10px);
        }

        .function-card i {
            font-size: 40px;
            color: #2a5298;
            margin-bottom: 15px;
        }

        .function-card h3 {
            font-size: 16px;
            margin-bottom: 8px;
            color: #333;
        }

        .function-card p {
            font-size: 12px;
            color: #999;
        }

        /* Recent Activity */
        .section-title {
            font-size: 20px;
            color: #1e3c72;
            margin-bottom: 20px;
            font-weight: 700;
        }

        .activity-list {
            background: white;
            border-radius: 10px;
            overflow: hidden;
            box-shadow: 0 2px 10px rgba(0, 0, 0, 0.05);
        }

        .activity-item {
            padding: 15px 25px;
            border-bottom: 1px solid #f0f0f0;
            display: flex;
            align-items: center;
            justify-content: space-between;
        }

        .activity-item:last-child {
            border-bottom: none;
        }

        .activity-info {
            display: flex;
            align-items: center;
        }

        .activity-icon {
            width: 45px;
            height: 45px;
            border-radius: 50%;
            background: #f0f0f0;
            display: flex;
            align-items: center;
            justify-content: center;
            margin-right: 15px;
            font-size: 18px;
            color: #2a5298;
        }

        .activity-text h4 {
            font-size: 14px;
            color: #333;
            margin-bottom: 3px;
        }

        .activity-text p {
            font-size: 12px;
            color: #999;
        }

        .activity-time {
            font-size: 12px;
            color: #999;
        }

        /* Dashboard-specific responsive styles */
        @media (max-width: 1440px) and (min-width: 1025px) {
            .dashboard-grid {
                grid-template-columns: repeat(3, 1fr);
            }
        }

        @media (max-width: 1200px) {
            .dashboard-grid {
                grid-template-columns: repeat(2, 1fr);
            }

            .functions-grid {
                grid-template-columns: repeat(2, 1fr);
            }
        }

        @media (max-width: 1024px) {
            .dashboard-grid {
                grid-template-columns: 1fr;
            }

            .functions-grid {
                grid-template-columns: 1fr;
            }

            .header {
                flex-direction: row;
                gap: 10px;
            }

            .header-right {
                gap: 15px;
            }
        }

        @media (max-width: 768px) {
            .dashboard-grid {
                grid-template-columns: 1fr;
            }

            .functions-grid {
                grid-template-columns: 1fr;
            }

            .header {
                flex-direction: column;
                text-align: center;
                gap: 15px;
            }

            .header-right {
                justify-content: center;
                width: 100%;
            }
        }

        .empty-state {
            text-align: center;
            padding: 40px 20px;
            color: #999;
        }

        .empty-state i {
            font-size: 48px;
            margin-bottom: 15px;
            opacity: 0.5;
        }
    </style>
</head>

<body>
    <div class="dashboard-container">
        <?php include 'sidebar.php'; ?>

        <!-- Main Content -->
        <div class="main-content">
            <!-- Header -->
            <div class="header">
                <h1>Dashboard</h1>
                <div class="header-right">
                    <div class="user-info">
                        <div class="user-name" id="managerName">Manager</div>
                        <div class="user-role">Manager</div>
                    </div>
                    <button class="logout-btn" onclick="logout()">
                        <i class="fas fa-sign-out-alt"></i> Logout
                    </button>
                </div>
            </div>

            <!-- Statistics Cards -->
            <div class="dashboard-grid">
                <div class="card stat-card success">
                    <div class="card-title">Today's Revenue</div>
                    <div class="card-value" id="todayRevenue">₹0</div>
                    <div class="card-footer">From completed bills</div>
                    <i class="fas fa-rupee-sign card-icon"></i>
                </div>

                <div class="card stat-card info">
                    <div class="card-title">Tables Served</div>
                    <div class="card-value" id="tablesServed">0</div>
                    <div class="card-footer">Today</div>
                    <i class="fas fa-table card-icon"></i>
                </div>

                <div class="card stat-card warning">
                    <div class="card-title">Open Bills</div>
                    <div class="card-value" id="openBills">0</div>
                    <div class="card-footer">Pending payment</div>
                    <i class="fas fa-file-invoice card-icon"></i>
                </div>

                <div class="card stat-card danger">
                    <div class="card-title">Today's Bookings</div>
                    <div class="card-value" id="todayBookings">0</div>
                    <div class="card-footer">Confirmed</div>
                    <i class="fas fa-calendar-alt card-icon"></i>
                </div>
            </div>

            <!-- Functions Grid -->
            <h2 class="section-title">Quick Actions</h2>
            <div class="functions-grid">
                <a href="tables.php" class="function-card">
                    <i class="fas fa-chair"></i>
                    <h3>Allocate Tables</h3>
                    <p>Assign tables to customers</p>
                </a>

                <a href="pos.php" class="function-card">
                    <i class="fas fa-cash-register"></i>
                    <h3>Billing & POS</h3>
                    <p>Process payments</p>
                </a>

                <a href="reservations.php" class="function-card">
                    <i class="fas fa-book"></i>
                    <h3>Reservations</h3>
                    <p>Check bookings</p>
                </a>

                <a href="reports.php" class="function-card">
                    <i class="fas fa-chart-line"></i>
                    <h3>Reports</h3>
                    <p>View analytics</p>
                </a>

                <a href="daily_operations.php" class="function-card">
                    <i class="fas fa-clipboard-list"></i>
                    <h3>Daily Ops</h3>
                    <p>Manage operations</p>
                </a>

                <a href="settings.php" class="function-card">
                    <i class="fas fa-cog"></i>
                    <h3>Settings</h3>
                    <p>Profile & preferences</p>
                </a>
            </div>

            <!-- Recent Activity -->
            <h2 class="section-title">Recent Transactions</h2>
            <div class="activity-list" id="activityList">
                <div class="empty-state">
                    <i class="fas fa-inbox"></i>
                    <p>No recent activity</p>
                </div>
            </div>
        </div>
    </div>

    <!-- SweetAlert2 -->
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11/dist/sweetalert2.all.min.js"></script>
    <!-- jQuery -->
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>

    <script>
        $(document).ready(function() {
            // Check authentication
            checkAuthentication();
            
            // Load dashboard data
            loadDashboardStats();
            loadRecentActivity();
            
            // Refresh data every 30 seconds
            setInterval(function() {
                loadDashboardStats();
                loadRecentActivity();
            }, 30000);
        });

        function checkAuthentication() {
            const managerId = localStorage.getItem('manager_id');
            const managerName = localStorage.getItem('manager_name');

            if (!managerId) {
                window.location.href = 'login.php';
                return;
            }

            $('#managerName').text(managerName || 'Manager');
        }

        function loadDashboardStats() {
            const today = new Date().toISOString().split('T')[0];

            // Load daily summary
            $.ajax({
                url: '../backend/manager_reports_api.php?action=daily_summary&date=' + today,
                method: 'GET',
                success: function(response) {
                    if (response.success) {
                        const data = response.data;
                        $('#todayRevenue').text('₹' + parseFloat(data.total_revenue).toFixed(2));
                        $('#tablesServed').text(data.tables_served);
                    }
                }
            });

            // Load open bills
            $.ajax({
                url: '../backend/manager_pos_api.php?action=get_open_bills',
                method: 'GET',
                success: function(response) {
                    if (response.success) {
                        $('#openBills').text(response.data.length);
                    }
                }
            });

            // Load today's bookings
            $.ajax({
                url: '../backend/manager_bookings_api.php?action=today',
                method: 'GET',
                success: function(response) {
                    if (response.success) {
                        const confirmed = response.data.filter(b => b.status === 'confirmed').length;
                        $('#todayBookings').text(confirmed);
                    }
                }
            });
        }

        function loadRecentActivity() {
            $.ajax({
                url: '../backend/manager_pos_api.php?action=get_bill_history&days=1',
                method: 'GET',
                success: function(response) {
                    if (response.success && response.data.length > 0) {
                        let html = '';
                        response.data.slice(0, 5).forEach(bill => {
                            html += `
                                <div class="activity-item">
                                    <div class="activity-info">
                                        <div class="activity-icon">
                                            <i class="fas fa-file-invoice"></i>
                                        </div>
                                        <div class="activity-text">
                                            <h4>Table ${bill.table_number} - ${bill.billing_number}</h4>
                                            <p>₹${parseFloat(bill.total).toFixed(2)} - ${bill.payment_method}</p>
                                        </div>
                                    </div>
                                    <div class="activity-time">${new Date(bill.completed_at).toLocaleTimeString()}</div>
                                </div>
                            `;
                        });
                        $('#activityList').html(html);
                    }
                }
            });
        }

        function logout() {
            Swal.fire({
                title: 'Logout Confirmation',
                text: 'Are you sure you want to logout?',
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#dc3545',
                cancelButtonColor: '#6c757d',
                confirmButtonText: 'Yes, logout'
            }).then((result) => {
                if (result.isConfirmed) {
                    $.ajax({
                        url: '../backend/manager_logout.php',
                        method: 'POST',
                        success: function() {
                            localStorage.removeItem('manager_id');
                            localStorage.removeItem('manager_name');
                            localStorage.removeItem('manager_email');
                            localStorage.removeItem('manager_shift');
                            window.location.href = 'login.php';
                        }
                    });
                }
            });
        }

    </script>

    <!-- Manager Sidebar Script -->
    <script src="manager-sidebar.js"></script>
</body>

</html>
