<!DOCTYPE html>
<html dir="ltr" lang="en-US">

<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1">
    <meta name="description" content="Daily Operations - Granny Restaurant Manager">
    <link href="../assets/images/favicon/favicon.png" rel="icon">

    <link href="https://fonts.googleapis.com/css?family=Raleway:100,100i,200,200i,300,300i,400,400i,500,500i,600,600i,700,700i,800,800i,900,900i" rel="stylesheet" type="text/css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/sweetalert2@11/dist/sweetalert2.min.css">
    <link rel="stylesheet" href="manager-styles.css">

    <title>Daily Operations - Granny Restaurant</title>

    <style>
        .main-content {
            padding: 30px 30px;
        }

        .container {
            max-width: 1000px;
            margin: 0 auto;
            padding: 0;
        }

        .page-header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 30px;
            background: white;
            padding: 20px 30px;
            border-radius: 10px;
            box-shadow: 0 2px 10px rgba(0, 0, 0, 0.05);
        }

        .page-header h1 {
            color: #1e3c72;
            font-size: 28px;
        }



        .main-content {
            background: white;
            border-radius: 10px;
            box-shadow: 0 2px 10px rgba(0, 0, 0, 0.05);
            overflow: hidden;
        }

        .card-section {
            padding: 25px;
            border-bottom: 1px solid #eee;
        }

        .card-section:last-child {
            border-bottom: none;
        }

        .card-title {
            font-size: 18px;
            font-weight: 700;
            color: #1e3c72;
            margin-bottom: 20px;
            display: flex;
            align-items: center;
            gap: 10px;
        }

        .card-title i {
            font-size: 20px;
        }

        .form-group {
            margin-bottom: 20px;
        }

        .flex-group {
            display: grid;
            grid-template-columns: 1fr 1fr;
            gap: 20px;
            margin-bottom: 20px;
        }

        .form-group label {
            display: block;
            margin-bottom: 8px;
            color: #333;
            font-weight: 600;
            font-size: 14px;
        }

        .form-group input,
        .form-group select,
        .form-group textarea {
            width: 100%;
            padding: 12px 15px;
            border: 1px solid #ddd;
            border-radius: 6px;
            font-family: inherit;
            font-size: 14px;
        }

        .form-group textarea {
            resize: vertical;
            min-height: 100px;
        }

        .stats-grid {
            display: grid;
            grid-template-columns: repeat(3, 1fr);
            gap: 15px;
            margin-bottom: 20px;
        }

        .stat-box {
            background: linear-gradient(135deg, #e8f4fd 0%, #d4e8f7 100%);
            padding: 15px;
            border-radius: 8px;
            border-left: 4px solid #2a5298;
        }

        .stat-label {
            font-size: 12px;
            color: #666;
            text-transform: uppercase;
            font-weight: 600;
            margin-bottom: 5px;
        }

        .stat-value {
            font-size: 24px;
            font-weight: 700;
            color: #1e3c72;
        }

        .checklist {
            list-style: none;
        }

        .checklist li {
            padding: 12px;
            border-bottom: 1px solid #eee;
            display: flex;
            align-items: center;
            gap: 12px;
        }

        .checklist li:last-child {
            border-bottom: none;
        }

        .checklist input[type="checkbox"] {
            width: 18px;
            height: 18px;
            cursor: pointer;
        }

        .checklist label {
            margin: 0;
            cursor: pointer;
            flex: 1;
        }

        .btn {
            padding: 12px 24px;
            border: none;
            border-radius: 6px;
            cursor: pointer;
            font-size: 14px;
            font-weight: 600;
            transition: all 0.3s ease;
            display: inline-flex;
            align-items: center;
            gap: 8px;
        }

        .btn-primary {
            background: linear-gradient(135deg, #1e3c72 0%, #2a5298 100%);
            color: white;
        }

        .btn-primary:hover {
            transform: translateY(-2px);
            box-shadow: 0 5px 15px rgba(42, 82, 152, 0.3);
        }

        .btn-success {
            background: #28a745;
            color: white;
        }

        .btn-success:hover {
            background: #218838;
        }

        .btn-danger {
            background: #dc3545;
            color: white;
        }

        .button-group {
            display: flex;
            gap: 10px;
            margin-top: 20px;
        }

        .button-group button {
            flex: 1;
        }

        .status-badge {
            display: inline-block;
            padding: 5px 12px;
            border-radius: 20px;
            font-size: 12px;
            font-weight: 600;
        }

        .status-open {
            background: #cce5ff;
            color: #004085;
        }

        .status-closed {
            background: #d4edda;
            color: #155724;
        }

        .timeline {
            position: relative;
            padding: 20px 0;
        }

        .timeline-item {
            display: flex;
            gap: 15px;
            margin-bottom: 20px;
            position: relative;
        }

        .timeline-item::before {
            content: '';
            position: absolute;
            left: 8px;
            top: 40px;
            width: 2px;
            height: calc(100% + 20px);
            background: #ddd;
        }

        .timeline-item:last-child::before {
            display: none;
        }

        .timeline-marker {
            width: 20px;
            height: 20px;
            border-radius: 50%;
            background: #2a5298;
            border: 3px solid white;
            box-shadow: 0 0 0 2px #2a5298;
            position: relative;
            z-index: 1;
            margin-top: 2px;
        }

        .timeline-content {
            flex: 1;
        }

        .timeline-time {
            font-size: 12px;
            color: #999;
            font-weight: 600;
        }

        .timeline-text {
            color: #333;
            margin-top: 3px;
        }

        /* Responsive Grid Layout */
        @media (max-width: 1440px) and (min-width: 1025px) {
            .flex-group {
                grid-template-columns: 1fr 1fr;
            }

            .stats-grid {
                grid-template-columns: repeat(2, 1fr);
            }
        }

        @media (max-width: 1024px) {
            .flex-group {
                grid-template-columns: 1fr;
            }

            .stats-grid {
                grid-template-columns: repeat(2, 1fr);
            }
        }

        @media (max-width: 768px) {
            .flex-group {
                grid-template-columns: 1fr;
            }

            .stats-grid {
                grid-template-columns: 1fr;
            }

            .button-group {
                flex-direction: column;
            }

            .button-group button {
                width: 100%;
            }
        }

        .empty-state {
            text-align: center;
            padding: 40px 20px;
            color: #999;
        }

        .empty-state i {
            font-size: 48px;
            margin-bottom: 15px;
            opacity: 0.5;
        }
    </style>
</head>

<body>
    <div class="dashboard-container">
        <?php include 'sidebar.php'; ?>
        <div class="main-content">
            <div class="container">
                <div class="page-header">
            <h1><i class="fas fa-clipboard-list"></i> Daily Operations</h1>
            <span class="status-badge status-open" id="operationStatus">No Shift Open</span>
        </div>

        <div class="main-content">
            <!-- Today's Summary -->
            <div class="card-section">
                <div class="card-title">
                    <i class="fas fa-tachometer-alt"></i> Today's Summary
                </div>

                <div class="stats-grid">
                    <div class="stat-box">
                        <div class="stat-label">Revenue</div>
                        <div class="stat-value" id="todayRevenue">₹0</div>
                    </div>
                    <div class="stat-box">
                        <div class="stat-label">Tables Served</div>
                        <div class="stat-value" id="tablesServed">0</div>
                    </div>
                    <div class="stat-box">
                        <div class="stat-label">Total Orders</div>
                        <div class="stat-value" id="totalOrders">0</div>
                    </div>
                </div>
            </div>

            <!-- Shift Management -->
            <div class="card-section">
                <div class="card-title">
                    <i class="fas fa-clock"></i> Shift Management
                </div>

                <div class="flex-group">
                    <div class="form-group">
                        <label>Shift Type</label>
                        <select id="shiftType">
                            <option value="day">Day Shift (10:00 AM - 5:00 PM)</option>
                            <option value="evening">Evening Shift (5:00 PM - 11:00 PM)</option>
                            <option value="night">Night Shift (11:00 PM - 10:00 AM)</option>
                        </select>
                    </div>

                    <div class="form-group">
                        <label>Date</label>
                        <input type="date" id="operationDate" readonly>
                    </div>
                </div>

                <div class="button-group">
                    <button class="btn btn-primary" onclick="openShift()">
                        <i class="fas fa-folder-open"></i> Open Shift
                    </button>
                    <button class="btn btn-danger" onclick="closeShift()">
                        <i class="fas fa-folder"></i> Close Shift
                    </button>
                </div>
            </div>

            <!-- Opening Checklist -->
            <div class="card-section">
                <div class="card-title">
                    <i class="fas fa-list-check"></i> Opening Checklist
                </div>

                <ul class="checklist">
                    <li>
                        <input type="checkbox" id="check1">
                        <label for="check1">All tables are clean and ready</label>
                    </li>
                    <li>
                        <input type="checkbox" id="check2">
                        <label for="check2">Menus and cutlery are properly arranged</label>
                    </li>
                    <li>
                        <input type="checkbox" id="check3">
                        <label for="check3">Staff briefing completed</label>
                    </li>
                    <li>
                        <input type="checkbox" id="check4">
                        <label for="check4">Kitchen and equipment are ready</label>
                    </li>
                    <li>
                        <input type="checkbox" id="check5">
                        <label for="check5">Payment systems are working</label>
                    </li>
                </ul>
            </div>

            <!-- Daily Notes -->
            <div class="card-section">
                <div class="card-title">
                    <i class="fas fa-sticky-note"></i> Daily Notes & Observations
                </div>

                <div class="form-group">
                    <label>Notes</label>
                    <textarea id="operationNotes" placeholder="Record any important events, staffing issues, or special incidents..."></textarea>
                </div>

                <button class="btn btn-primary" onclick="saveNotes()">
                    <i class="fas fa-save"></i> Save Notes
                </button>
            </div>

            <!-- Closing Checklist -->
            <div class="card-section">
                <div class="card-title">
                    <i class="fas fa-list-check"></i> Closing Checklist
                </div>

                <ul class="checklist">
                    <li>
                        <input type="checkbox" id="close1">
                        <label for="close1">All bills cleared and payments confirmed</label>
                    </li>
                    <li>
                        <input type="checkbox" id="close2">
                        <label for="close2">Cash count completed</label>
                    </li>
                    <li>
                        <input type="checkbox" id="close3">
                        <label for="close3">All tables cleaned and chairs arranged</label>
                    </li>
                    <li>
                        <input type="checkbox" id="close4">
                        <label for="close4">Kitchen cleaned and shut down</label>
                    </li>
                    <li>
                        <input type="checkbox" id="close5">
                        <label for="close5">All lights and equipment turned off</label>
                    </li>
                </ul>
            </div>

            <!-- Activity Timeline -->
            <div class="card-section">
                <div class="card-title">
                    <i class="fas fa-history"></i> Activity Timeline
                </div>

                <div class="timeline" id="activityTimeline">
                    <div class="empty-state">
                        <i class="fas fa-inbox"></i>
                        <p>No activity recorded yet</p>
                    </div>
                </div>
            </div>

            <!-- Save Shift Summary -->
            <div class="card-section">
                <div class="button-group">
                    <button class="btn btn-primary" onclick="saveShiftSummary()">
                        <i class="fas fa-check-circle"></i> Save Shift Summary
                    </button>
                </div>
            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11/dist/sweetalert2.all.min.js"></script>
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>

    <script>
        let shiftOpen = false;

        $(document).ready(function() {
            checkAuthentication();
            setToday();
            loadDailyData();
        });

        function checkAuthentication() {
            if (!localStorage.getItem('manager_id')) {
                window.location.href = 'login.php';
            }
        }

        function setToday() {
            const today = new Date().toISOString().split('T')[0];
            $('#operationDate').val(today);
        }

        function loadDailyData() {
            const today = new Date().toISOString().split('T')[0];

            $.ajax({
                url: `../backend/manager_reports_api.php?action=daily_summary&date=${today}`,
                method: 'GET',
                success: function(response) {
                    if (response.success) {
                        const data = response.data;
                        $('#todayRevenue').text('₹' + parseFloat(data.total_revenue).toFixed(2));
                        $('#tablesServed').text(data.tables_served);
                        $('#totalOrders').text(data.total_bills);
                    }
                }
            });
        }

        function openShift() {
            const shiftType = $('#shiftType').val();
            const date = $('#operationDate').val();

            Swal.fire({
                icon: 'question',
                title: 'Open Shift?',
                text: `Starting ${shiftType} shift for ${date}`,
                showCancelButton: true,
                confirmButtonColor: '#28a745',
                confirmButtonText: 'Yes, Open Shift'
            }).then((result) => {
                if (result.isConfirmed) {
                    shiftOpen = true;
                    $('#operationStatus').removeClass('status-open').addClass('status-open').text('Shift Open - ' + shiftType);
                    Swal.fire('Success', 'Shift opened successfully', 'success');
                    loadDailyData();
                }
            });
        }

        function closeShift() {
            if (!shiftOpen) {
                Swal.fire('Error', 'No shift is currently open', 'error');
                return;
            }

            Swal.fire({
                icon: 'warning',
                title: 'Close Shift?',
                text: 'Make sure all bills are finalized and payments confirmed',
                showCancelButton: true,
                confirmButtonColor: '#dc3545',
                confirmButtonText: 'Yes, Close Shift'
            }).then((result) => {
                if (result.isConfirmed) {
                    shiftOpen = false;
                    $('#operationStatus').removeClass('status-open').addClass('status-closed').text('Shift Closed');
                    Swal.fire('Success', 'Shift closed successfully', 'success');
                }
            });
        }

        function saveNotes() {
            const notes = $('#operationNotes').val();
            const date = $('#operationDate').val();

            if (!notes.trim()) {
                Swal.fire('Error', 'Please enter some notes', 'error');
                return;
            }

            Swal.fire('Success', 'Notes saved successfully', 'success');
            // Here you would typically send the notes to the server
        }

        function saveShiftSummary() {
            const notes = $('#operationNotes').val();
            const date = $('#operationDate').val();
            const shiftType = $('#shiftType').val();

            if (!shiftOpen) {
                Swal.fire('Error', 'Please close the shift first', 'error');
                return;
            }

            Swal.fire({
                icon: 'question',
                title: 'Save Shift Summary?',
                text: 'This will finalize the shift details',
                showCancelButton: true,
                confirmButtonColor: '#28a745',
                confirmButtonText: 'Yes, Save Summary'
            }).then((result) => {
                if (result.isConfirmed) {
                    Swal.fire('Success', 'Shift summary saved successfully', 'success');
                    shiftOpen = false;
                    $('#operationStatus').removeClass('status-open').addClass('status-closed').text('Shift Closed');
                    // Reset form
                    $('#operationNotes').val('');
                    $('.checklist input').prop('checked', false);
                }
            });
        }

        // Refresh data every 5 minutes
        setInterval(loadDailyData, 300000);

        // Set initial date
        setToday();
    </script>

    <!-- Manager Sidebar Script -->
    <script src="manager-sidebar.js"></script>
</body>

</html>
