﻿<?php 
session_start(); 
?>
<!DOCTYPE html>
<html dir="ltr" lang="en-US">
<head>
    <!-- Document Meta
    ============================================= -->
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <!--IE Compatibility Meta-->
    <meta name="author" content="zytheme">
    <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1">
    <meta name="description" content="Elegant Restaurant & Cafe Html5 Template">
    <link href="assets/images/favicon/favicon.png" rel="icon">
    <!-- Fonts
    ============================================= -->
    <link
        href="../css?family=Great+Vibes%7CKaushan+Script%7CRaleway:100,100i,200,200i,300,300i,400,400i,500,500i,600,600i,700,700i,800,800i,900,900i"
        rel="stylesheet" type="text/css">

    <!-- Font Awesome Icons
    ============================================= -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <!-- Swiper CSS -->
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/swiper@11/swiper-bundle.min.css">

    <!-- Stylesheets
    ============================================= -->
    <link href="assets/css/external.css" rel="stylesheet">
    <link href="assets/css/bootstrap.min.css" rel="stylesheet">
    <link href="assets/css/style.css" rel="stylesheet">
    <link href="assets/css/custom-sections.css" rel="stylesheet">
    <link href="assets/css/menu-showcase.css" rel="stylesheet">
    <link href="assets/css/testimonial-new.css" rel="stylesheet">
    <link href="assets/css/blog-section.css" rel="stylesheet">
    <link href="assets/css/cart.css" rel="stylesheet">

    <!-- RS5.0 Main Stylesheet -->
    <link rel="stylesheet" type="text/css" href="assets/revolution/css/settings.css">
    <link rel="stylesheet" type="text/css" href="assets/revolution/css/layers.css">
    <link rel="stylesheet" type="text/css" href="assets/revolution/css/navigation.css">

    <!-- HTML5 shim, for IE6-8 support of HTML5 elements. All other JS at the end of file. -->
    <!--[if lt IE 9]>
      <script src="assets/js/html5shiv.js"></script>
      <script src="assets/js/respond.min.js"></script>
    <![endif]-->

    <!-- Document Title
    ============================================= -->
    <title>Home Page</title>
</head>

<body>
    <div class="preloader">
        <div class="spinner">
            <div class="bounce1"></div>
            <div class="bounce2"></div>
            <div class="bounce3"></div>
        </div>
    </div>
    <!-- Document Wrapper
	============================================= -->
    <div id="wrapper" class="wrapper clearfix">
        <!-- New Header -->
        <!-- Top Announcement Bar -->
        <div class="header-top-bar">
            <div class="container">
                <div class="header-top-bar-text">Welcome to Granny Restaurant & Catering Services</div>
                <div class="header-social-icons">
                    <a href="#" title="Facebook"><i class="fab fa-facebook-f"></i></a>
                    <a href="#" title="Twitter"><i class="fab fa-twitter"></i></a>
                    <a href="#" title="Instagram"><i class="fab fa-instagram"></i></a>
                    <a href="#" title="WhatsApp"><i class="fab fa-whatsapp"></i></a>
                    <a href="#" title="YouTube"><i class="fab fa-youtube"></i></a>
                </div>
            </div>
        </div>
        <!-- Main Header -->
        <header class="header-main">
            <div class="container">
                <div class="header-logo">
                    <a href="index.php"><img src="assets/images/logo/logo-dark.png" alt="Granny Logo"></a>
                </div>

                <div style="display: flex; align-items: center; gap: 20px; flex: 1;">
                    <div class="header-contact-info">
                        <a href="tel:+919876543210" class="header-contact-item">
                            <i class="fas fa-phone"></i>
                            <div class="header-contact-text">
                                <span class="header-contact-label">Call Us:</span>
                                <span class="header-contact-value">+91 98765 43210</span>
                            </div>
                        </a>
                        <a href="mailto:info@granny.com" class="header-contact-item">
                            <i class="fas fa-envelope"></i>
                            <div class="header-contact-text">
                                <span class="header-contact-label">Mail Us:</span>
                                <span class="header-contact-value">info@granny.com</span>
                            </div>
                        </a>
                        <a href="#" class="header-contact-item">
                            <i class="fas fa-map-marker-alt"></i>
                            <div class="header-contact-text">
                                <span class="header-contact-label">Location:</span>
                                <span class="header-contact-value">Egypt</span>
                            </div>
                        </a>
                    </div>
                    <div class="header-booking-section" id="bookingSection">
                        <button class="header-booking-btn" data-toggle="modal" data-target="#reservationPopup">Table Booking</button>
                    </div>
                    <div class="user-profile-dropdown" id="userProfileDropdown" style="display: none;">
                        <button class="user-profile-btn" id="userProfileBtn">
                            <i class="fas fa-user-circle"></i>
                            <span class="user-name" id="userName"></span>
                        </button>
                        <div class="user-dropdown-menu" id="userDropdownMenu">
                            <a href="#" class="dropdown-item user-profile-link">
                                <i class="fas fa-user"></i> My Profile
                            </a>
                            <a href="#" class="dropdown-item user-settings-link">
                                <i class="fas fa-cog"></i> Settings
                            </a>
                            <div class="dropdown-divider"></div>
                            <a href="#" class="dropdown-item user-logout-link" id="logoutBtn">
                                <i class="fas fa-sign-out-alt"></i> Logout
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </header>
        <!-- Navigation Bar -->
        <nav class="header-nav-bar">
            <div class="container"
                style="display: flex; justify-content: space-between; align-items: center; padding: 0;">
                <div class="header-navbar-logo">
                    <a href="index.php"><img src="assets/images/logo/logo-light.png" alt="Granny Logo"></a>
                </div>
                <ul class="header-nav-menu" id="headerNavMenu">
                    <li><a href="index.php">Home</a></li>
                    <li>
                        <a href="about.php">About Us</a>

                    </li>
                    <li>
                        <a href="menu.php">Menu</a>

                    </li>
                    <li><a href="chefs.php">Our Chefs</a></li>
                    <li><a href="blog.php">Blog</a></li>
                    <!-- <li><a href="shop-4cols.html">Shop</a></li> -->
                    <li><a href="gallery.php">Gallery</a></li>
                    <li><a href="contacts.php">Contact Us</a></li>
                    <!-- Mobile Only Cart Icon -->
                    <li class="mobile-cart-item"
                        style="border-top: 2px solid #c59d5f; margin: 10px 0; padding: 10px 15px;">
                        <a href="cart.php" class="header-cart-icon"
                            style="display: flex; align-items: center; gap: 10px; color: #ffffff; text-decoration: none; padding: 0; font-size: 16px;">
                            <i class="fas fa-shopping-cart"></i>
                            <span>Cart</span>
                            <span class="header-cart-count">0</span>
                        </a>
                    </li>
                    <!-- Mobile Only Booking Button -->
                    <li class="mobile-booking-item">
                        <button class="header-booking-btn" data-toggle="modal" data-target="#reservationPopup"
                            style="width: 100%; display: block; padding: 12px 15px; background-color: #c59d5f; color: #ffffff; border: none; border-radius: 4px; font-size: 14px; font-weight: 700; text-transform: uppercase; cursor: pointer; transition: all 0.3s ease;">Booking</button>
                    </li>
                    <!-- Mobile Only Auth Section -->
                    <li class="mobile-auth-divider" id="mobileAuthSection"
                        style="border-top: 2px solid #c59d5f; margin: 10px 0; padding: 10px 0;">
                        <a href="#" class="header-auth-btn header-signin-btn" data-toggle="modal"
                            data-target="#signInModal"
                            style="display: block; padding: 12px 15px; text-align: center; width: 100%; box-sizing: border-box; margin-bottom: 10px; border: 2px solid #c59d5f; background-color: transparent; color: #c59d5f; border-radius: 4px; font-size: 14px; font-weight: 600;">Sign
                            In</a>
                        <a href="#" class="header-auth-btn header-signup-btn" data-toggle="modal"
                            data-target="#signUpModal"
                            style="display: block; padding: 12px 15px; text-align: center; width: 100%; box-sizing: border-box; background-color: #c59d5f; color: #ffffff; border: 2px solid #c59d5f; border-radius: 4px; font-size: 14px; font-weight: 600;">Sign
                            Up</a>
                    </li>

                </ul>
                <div class="header-nav-right">
                    <a href="cart.php" class="header-cart-icon">
                        <i class="fas fa-shopping-cart"></i>
                        <span class="header-cart-count">0</span>
                    </a>
                    <div class="header-auth-section" id="navAuthSection">
                        <a href="#" class="header-auth-btn header-signin-btn" data-toggle="modal"
                            data-target="#signInModal">Sign In</a>
                        <a href="#" class="header-auth-btn header-signup-btn" data-toggle="modal"
                            data-target="#signUpModal">Sign Up</a>
                    </div>
                    <div class="nav-user-profile-dropdown" id="navUserProfileDropdown" style="display: none;">
                        <button class="nav-user-profile-btn" id="navUserProfileBtn">
                            <i class="fas fa-user-circle"></i>
                            <span class="nav-user-name" id="navUserName"></span>
                        </button>
                        <div class="nav-user-dropdown-menu" id="navUserDropdownMenu">
                            <a href="dashboard.php" class="dropdown-item user-profile-link">
                                <i class="fa-solid fa-gauge"></i> Dashboard
                            </a>
                            <!-- <a href="#" class="dropdown-item user-settings-link">
                                <i class="fas fa-cog"></i> Settings
                            </a> -->
                            <!-- <div class="dropdown-divider"></div> -->
                            <a href="#" class="dropdown-item user-logout-link" id="navLogoutBtn">
                                <i class="fas fa-sign-out-alt"></i> Logout
                            </a>
                        </div>
                    </div>
                </div>
                <!-- Mobile Profile Icon (shown when logged in) -->
                <div class="mobile-profile-icon-container" id="mobileProfileIconContainer" style="display: none;">
                    <button class="mobile-profile-icon-btn" id="mobileProfileIconBtn">
                        <i class="fas fa-user-circle"></i>
                        <span class="mobile-user-name" id="mobileUserName"></span>
                    </button>
                    <div class="mobile-profile-dropdown-menu" id="mobileProfileDropdownMenu">
                        <a href="dashboard.php" class="dropdown-item user-profile-link">
                            <i class="fa-solid fa-gauge"></i> Dashboard
                        </a>
                        <!-- <a href="#" class="dropdown-item user-settings-link">
                            <i class="fas fa-cog"></i> Settings
                        </a> -->
                        <!-- <div class="dropdown-divider"></div> -->
                        <a href="#" class="dropdown-item user-logout-link" id="mobileProfileLogoutBtn">
                            <i class="fas fa-sign-out-alt"></i> Logout
                        </a>
                    </div>
                </div>
                <button class="header-mobile-toggle" id="headerMenuToggle">
                    <i class="fas fa-bars"></i>
                    <span class="hamburger-cart-badge header-cart-count">0</span>
                </button>
            </div>
        </nav>
        <!-- End Header -->
        <!-- Hero Section
====================================== -->
        <section id="slider" class="slider slide-overlay-black">
            <div class="carousel-wrapper">
                <div class="carousel-container" id="carouselContainer">
                </div>

                <button class="carousel-nav carousel-nav-prev" aria-label="Previous slide">
                    <i class="fas fa-chevron-left"></i>
                </button>
                <button class="carousel-nav carousel-nav-next" aria-label="Next slide">
                    <i class="fas fa-chevron-right"></i>
                </button>

                <div class="carousel-indicators" id="carouselIndicators">
                </div>
            </div>
        </section>
        <!-- tabs
============================================= -->
        <section id="tabs1" class="tabs text-center bg-white pb-90">
            <div class="container">
                <div class="row clearfix">
                    <div class="col-xs-12 col-sm-12 col-md-8 col-md-offset-2">
                        <div class="heading heading-1 mb-50 text--center">
                            <p class="heading--subtitle">Hello dear</p>
                            <h2 class="heading--title mb-0">Welcome To Granny</h2>
                            <div class="divider--shape-4"></div>
                            <p class="heading--desc">Granny was the first retaurant to open in Egypt, the resturant was
                                designed with the history in mind we have created a soft industrial dining room,
                                combined with an open kitchen, coffee take out bar and on site coffee roastery.</p>
                        </div>
                    </div>
                    <!-- .col-md-8 end -->
                </div>
                <!-- .row end -->
            </div>
            <!-- .container end -->
            <!-- ABOUT SECTION -->
            <div class="container about-section">
                <div class="row">
                    <div class="col-xs-12 col-sm-12 col-md-12">
                        <h2 class="section-title mb-40">About Us</h2>
                        <div class="about-content">
                            <div class="row">
                                <div class="col-xs-12 col-sm-12 col-md-4">
                                    <div class="about-panel">
                                        <div class="about-icon">
                                            <i class="fas fa-utensils"></i>
                                        </div>
                                        <h3>Start Eating Better</h3>
                                        <h4>Daily New Fresh Menus</h4>
                                        <p>Granny help you treat yourself with a different meal everyday, thanks to our
                                            daily changing menus and our awesome creative chefs! We believe that dining
                                            should be an experience that excites your senses and nourishes your body.
                                        </p>
                                    </div>
                                </div>
                                <!-- .col-md-4 end -->

                                <div class="col-xs-12 col-sm-12 col-md-4">
                                    <div class="about-panel">
                                        <div class="about-icon">
                                            <i class="fas fa-heart"></i>
                                        </div>
                                        <h3>Quality is the Heart</h3>
                                        <h4>Fresh Ingredient, Tasty Meals</h4>
                                        <p>Who said healthy food can't also be delicious? Granny creative chefs use
                                            fresh and seasonal ingredients to create affordable yet premium dishes.
                                            Every ingredient is carefully selected to ensure the highest quality and
                                            taste in every bite.</p>
                                    </div>
                                </div>
                                <!-- .col-md-4 end -->

                                <div class="col-xs-12 col-sm-12 col-md-4">
                                    <div class="about-panel">
                                        <div class="about-icon">
                                            <i class="fas fa-fire"></i>
                                        </div>
                                        <h3>Hot & Ready to Serve</h3>
                                        <h4>Creative & Talented Chefs</h4>
                                        <p>Granny have offered a team of culinary professionals that make delectable
                                            dishes at memorable events for both private clientele. Our chefs bring
                                            passion, expertise, and innovation to every plate they create.</p>
                                    </div>
                                </div>
                                <!-- .col-md-4 end -->
                            </div>
                            <!-- .row end -->
                        </div>
                    </div>
                    <!-- .col-md-12 end -->
                </div>
                <!-- .row end -->
            </div>

            <!-- CHEFS SECTION -->
            <div class="container chefs-section">
                <div class="row">
                    <div class="col-xs-12 col-sm-12 col-md-12">
                        <h2 class="section-title mb-40">Our Chefs</h2>
                        <div class="team team-2 pb-0">
                            <div class="row" id="chefsContainer">
                                <!-- Chefs will be loaded here dynamically -->
                            </div>
                            <!-- .row end -->
                        </div>
                    </div>
                    <!-- .col-md-12 end -->
                </div>
                <!-- .row end -->
            </div>
            <!-- .container end -->
        </section>
        <!-- #tabs1 end -->



        <!-- Menu Mixed Grid ============================================= -->
        <section id="menuMixedGrid" class="bg-white menu-showcase">
            <div class="container">
                <div class="row clearfix">
                    <div class="col-xs-12 col-sm-12 col-md-8 col-md-offset-2">
                        <div class="heading heading-1 mb-50 text--center">
                            <p class="heading--subtitle">Taste the best</p>
                            <h2 class="heading--title mb-0">Discover Our Menu</h2>
                            <div class="divider--shape-4"></div>
                            <p class="heading--desc">Everyone has taste, even if they don't realize it. Even if you're
                                not a great chef, there's nothing to stop you understanding the difference between what
                                tastes good and what doesn't.</p>
                        </div>
                    </div>
                </div>
            </div>

            <div class="container-fluid pr-0 pl-0 pb-0 tabs menu-showcase-tabs">
                <div class="menu-tabs-header">
                    <ul class="nav nav-tabs menu-category-nav" id="menuCategoryNav">
                        <!-- Dynamically loaded categories -->
                    </ul>
                </div>

                <div class="tab-content menu-showcase-content" id="menuTabsContent">
                    <!-- Dynamically loaded menu items -->
                </div>


                <div class="row text-center mt-0">
                    <div class="col-xs-12 col-sm-12 col-md-12">
                        <a class="btn btn--secondary btn--lg" href="menu.php">Discover Full Menu</a>
                    </div>
                </div>
                <!-- .row end -->
            </div>
            <!-- .container end -->
        </section>
        <!-- #menuMixedGrid end -->

        <!-- Testimonial #1
============================================= -->
        <section id="testimonial1" class="testimonial-section">
            <div class="testimonial-wrapper">
                <div class="testimonial-content">
                    <div class="testimonial-header">
                        <h2>Guest Reviews</h2>
                        <p>What our guests are saying about us</p>
                    </div>

                    <div class="swiper testimonial-slider">
                        <div class="swiper-wrapper" id="testimonialSwiperWrapper">
                            <!-- Reviews will be loaded dynamically here -->
                        </div>

                        <!-- Pagination -->
                        <div class="swiper-pagination"></div>
                    </div>
                </div>
            </div>
        </section>
        <!-- #testimonial1 end -->

        <!-- Blog Carousel
============================================= -->
        <section id="blog" class="blog-section">
            <div class="blog-header">
                <h2>Our News &amp; Events</h2>
                <p class="heading--desc">Follow our latest news updates to know about our offers, recipes and events.</p>
            </div>

            <div class="swiper blog-slider">
                <div class="swiper-wrapper" id="blogSwiperWrapper">
                    <!-- Blog entries will be loaded here dynamically -->
                </div>
                <!-- swiper-wrapper end -->

                <!-- Pagination -->
                <div class="swiper-pagination"></div>
            </div>
            <!-- swiper end -->
        </section>
        <!-- #blog end -->

        <footer id="footer" class="footer footer-premium">
            <!-- Premium Footer Widget Section -->
            <div class="footer--widget-premium">
                <div class="container">
                    <div class="row">
                        <!-- Footer Logo & Description -->
                        <div class="col-xs-12 col-sm-12 col-md-3 footer--col-about">
                            <div class="footer--logo-section">
                                <img src="assets/images/logo/logo-light.png" alt="Granny Logo" class="footer--logo">
                                <p class="footer--tagline">Crafted with passion and served with love since 2015</p>
                                <div class="footer--description">
                                    <p>Experience culinary excellence at Granny. Our award-winning chefs blend
                                        traditional flavors with modern techniques to create unforgettable dining
                                        moments.</p>
                                </div>
                            </div>
                            <!-- Follow Us Section -->
                            <div class="footer--social-icons-widget">
                                <p
                                    style="font-size: 14px; margin-top: 20px; margin-bottom: 10px; color: #c59d5f; font-weight: 600;">
                                    Follow Us</p>
                                <div class="social-icons-list">
                                    <a href="#" class="social-icon-widget" title="Facebook"><i
                                            class="fa fa-facebook"></i></a>
                                    <a href="#" class="social-icon-widget" title="Instagram"><i
                                            class="fa fa-instagram"></i></a>
                                    <a href="#" class="social-icon-widget" title="Twitter"><i
                                            class="fa fa-twitter"></i></a>
                                    <a href="#" class="social-icon-widget" title="Pinterest"><i
                                            class="fa fa-pinterest"></i></a>
                                    <a href="#" class="social-icon-widget" title="TripAdvisor"><i
                                            class="fa fa-tripadvisor"></i></a>
                                </div>
                            </div>
                        </div>
                        <!-- .col-md-3 end -->

                        <!-- Quick Links -->
                        <div class="col-xs-12 col-sm-6 col-md-3 footer--col-links">
                            <h4 class="footer--title">Quick Links</h4>
                            <ul class="footer--menu">
                                <li><a href="index.html">Home</a></li>
                                <li><a href="menu-board.html">Our Menu</a></li>
                                <li><a href="page-about.html">About Us</a></li>
                                <li><a href="page-gallery.html">Gallery</a></li>
                                <li><a href="page-contacts.html">Contact</a></li>
                                <li><a href="blog-carousel.html">Blog</a></li>
                            </ul>
                        </div>
                        <!-- .col-md-3 end -->

                        <!-- Location & Hours -->
                        <div class="col-xs-12 col-sm-6 col-md-3 footer--col-info">
                            <h4 class="footer--title">Visit Us</h4>
                            <div class="footer--info-item">
                                <i class="fa fa-map-marker"></i>
                                <div class="footer--info-content">
                                    <p><strong>Address</strong><br>22 Alnahas Building, 2 AlBahr St<br>Tanta,
                                        Al-Gharbia, Egypt</p>
                                </div>
                            </div>
                            <div class="footer--info-item">
                                <i class="fa fa-clock-o"></i>
                                <div class="footer--info-content">
                                    <p><strong>Hours</strong><br>Mon-Fri: 9:00 AM � 12:00 AM<br>Sat: 8:00 AM � 3:00
                                        AM<br>Sun: Closed</p>
                                </div>
                            </div>
                        </div>
                        <!-- .col-md-3 end -->

                        <!-- Contact -->
                        <div class="col-xs-12 col-sm-12 col-md-3 footer--col-contact">
                            <h4 class="footer--title">Connect</h4>
                            <div class="footer--contact-info">
                                <p><i class="fa fa-phone"></i> <a href="tel:+201065370701">(+20) 106-537-0701</a></p>
                                <p><i class="fa fa-envelope"></i> <a href="mailto:info@granny.com">info@granny.com</a>
                                </p>
                            </div>

                        </div>
                    </div>
                    <!-- .col-md-3 end -->
                </div>
                <!-- .row end -->
            </div>
            <!-- .container end -->
    </div>
    <!-- .footer-widget-premium end -->

    <!-- Divider -->
    <div class="footer--divider"></div>

    <!-- Premium Copyright Section -->
    <div class="footer--copyright-premium">
        <div class="container">
            <div class="row">
                <div class="col-xs-12 col-sm-12 col-md-12">
                    <div class="footer--copyright-wrapper">
                        <p class="footer--copyright-text">&copy; 2026 <strong>Granny Restaurant & Cafe</strong>. All
                            rights reserved. | Crafted with <i class="fa fa-heart"></i> for food lovers.</p>
                        <div class="footer--links-legal">
                            <a href="#">Privacy Policy</a>
                            <span class="separator">�</span>
                            <a href="#">Terms of Service</a>
                            <span class="separator">�</span>
                            <a href="#">Cookies</a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- .container end -->
    </div>
    <!-- .footer-copyright-premium end -->
    </footer>
    </div>
    <!-- #wrapper end -->

    <!-- Footer Scripts
============================================= -->
    <script data-cfasync="false" src="/cdn-cgi/scripts/5c5dd728/cloudflare-static/email-decode.min.js"></script>
    <script src="assets/js/jquery-2.2.4.min.js"></script>
    <script src="assets/js/plugins.js"></script>
    <script src="assets/js/functions.js"></script>
    <script src="assets/js/cart-manager.js"></script>
    <!-- Swiper JS -->
    <script src="https://cdn.jsdelivr.net/npm/swiper@11/swiper-bundle.min.js"></script>
    <!-- Slider Init -->
    <script>
        // Load dynamic testimonials
        async function loadDynamicTestimonials() {
            try {
                const response = await fetch('backend/feedback_api.php?action=get_public_reviews');
                const result = await response.json();

                console.log('Testimonials API Response:', result);

                if (result.success && result.data && result.data.length > 0) {
                    renderTestimonials(result.data);
                } else {
                    console.log('No approved feedback found');
                    renderTestimonials(getDefaultTestimonials());
                }
            } catch (error) {
                console.error('Error loading testimonials:', error);
                renderTestimonials(getDefaultTestimonials());
            }
        }

        function renderTestimonials(reviews) {
            const wrapper = document.getElementById('testimonialSwiperWrapper');
            if (!wrapper) return;

            wrapper.innerHTML = reviews.map(review => {
                const starCount = parseInt(review.rating) || 5;
                const stars = Array(starCount).fill('<i class="fas fa-star"></i>').join('');
                const username = escapeHtml(review.username || 'Guest');
                const message = escapeHtml(review.message || '');

                return `
                    <div class="swiper-slide">
                        <div class="testimonial-item">
                            <div class="testimonial-quote-mark">"</div>
                            <p class="testimonial-text">${message}</p>
                            <div class="testimonial-rating">
                                ${stars}
                            </div>
                            <div class="testimonial-author-info">
                                <div class="author-avatar" style="display: flex; align-items: center; justify-content: center; width: 50px; height: 50px; border-radius: 50%; background: linear-gradient(135deg, #d4a574 0%, #c99560 100%); color: white; font-size: 24px;">
                                    <i class="fas fa-user"></i>
                                </div>
                                <div class="author-details">
                                    <h4>${username}</h4>
                                    <span>Guest Review</span>
                                </div>
                            </div>
                        </div>
                    </div>
                `;
            }).join('');
        }

        function getDefaultTestimonials() {
            return [{
                    username: 'Todd Stephen',
                    message: 'Granny is simply the best. Great Food, nice atmosphere and very reasonable prices. It just doesn\'t get any better',
                    rating: 5
                },
                {
                    username: 'David Casper',
                    message: 'We\'ve been to Granny many times over the years. We know what to expect: great food and awesome prices',
                    rating: 5
                },
                {
                    username: 'John Arax',
                    message: 'The reasonable prices, the great atmosphere are only topped by the delicious food. Keep up the great work',
                    rating: 5
                },
                {
                    username: 'Anthony Kevin',
                    message: 'Granny is simply the best. Great Food, nice atmosphere and very reasonable prices. It just doesn\'t get any better',
                    rating: 5
                }
            ];
        }

        function escapeHtml(text) {
            const div = document.createElement('div');
            div.textContent = text;
            return div.innerHTML;
        }

        document.addEventListener('DOMContentLoaded', function() {
            // Load testimonials first
            loadDynamicTestimonials();

            // Initialize Swiper after a short delay to ensure content is rendered
            setTimeout(function() {
                const testimonialSlider = new Swiper('.testimonial-slider', {
                    slidesPerView: 1,
                    spaceBetween: 30,
                    speed: 800,
                    effect: 'slide',
                    pagination: {
                        el: '.testimonial-slider .swiper-pagination',
                        clickable: true,
                        dynamicBullets: true,
                        dynamicMainBullets: 3
                    },
                    autoplay: {
                        delay: 5000,
                        disableOnInteraction: false,
                        pauseOnMouseEnter: true
                    },
                    easing: 'cubic-bezier(0.25, 0.46, 0.45, 0.94)',
                    breakpoints: {
                        768: {
                            slidesPerView: 2,
                            spaceBetween: 25
                        },
                        1024: {
                            slidesPerView: 3,
                            spaceBetween: 30
                        }
                    }
                });

                // Store reference for testimonials
                window.testimonialSwiperInstance = testimonialSlider;
            }, 300);

            // Initialize blog slider
            setTimeout(function() {
                const blogSlider = new Swiper('.blog-slider', {
                    slidesPerView: 1,
                    spaceBetween: 30,
                    speed: 800,
                    effect: 'slide',
                    pagination: {
                        el: '.blog-slider .swiper-pagination',
                        clickable: true,
                        dynamicBullets: true,
                        dynamicMainBullets: 3
                    },
                    autoplay: {
                        delay: 6000,
                        disableOnInteraction: false,
                        pauseOnMouseEnter: true
                    },
                    easing: 'cubic-bezier(0.25, 0.46, 0.45, 0.94)',
                    breakpoints: {
                        640: {
                            slidesPerView: 1,
                        },
                        768: {
                            slidesPerView: 2,
                            spaceBetween: 30
                        },
                        1024: {
                            slidesPerView: 3,
                            spaceBetween: 30
                        }
                    }
                });

                // Store reference for later reinitialize
                window.blogSwiperInstance = blogSlider;
            }, 300);
        });
    </script>
    <!-- RS5.0 Core JS Files -->
    <script src="assets/revolution/js/jquery.themepunch.tools.min.js?rev=5.0"></script>
    <script src="assets/revolution/js/jquery.themepunch.revolution.min.js?rev=5.0"></script>
    <script src="assets/revolution/js/extensions/revolution.extension.video.min.js"></script>
    <script src="assets/revolution/js/extensions/revolution.extension.slideanims.min.js"></script>
    <script src="assets/revolution/js/extensions/revolution.extension.actions.min.js"></script>
    <script src="assets/revolution/js/extensions/revolution.extension.layeranimation.min.js"></script>
    <script src="assets/revolution/js/extensions/revolution.extension.kenburn.min.js"></script>
    <script src="assets/revolution/js/extensions/revolution.extension.navigation.min.js"></script>
    <script src="assets/revolution/js/extensions/revolution.extension.migration.min.js"></script>
    <script src="assets/revolution/js/extensions/revolution.extension.parallax.min.js"></script>
    <!-- RS Configration JS Files -->
    <script src="assets/js/rsconfig.js"></script>

    <!-- Dynamic Menu Loading Script -->
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            loadDynamicMenu();
        });

        function loadDynamicMenu() {
            fetch('backend/menu_api.php?action=get_menu')
                .then(response => response.json())
                .then(data => {
                    if (data.success && data.data) {
                        renderMenu(data.data);
                        // Reinitialize Bootstrap tabs after rendering
                        $('[data-toggle="tab"]').on('show.bs.tab', function(e) {
                            // Handle tab change if needed
                        });
                    }
                })
                .catch(error => console.error('Error loading menu:', error));
        }

        function renderMenu(menuData) {
            const categoryNav = document.getElementById('menuCategoryNav');
            const tabsContent = document.getElementById('menuTabsContent');

            // Limit to first 4-5 filters
            const maxFilters = 5;
            const filteredMenu = menuData.slice(0, maxFilters);

            // Clear existing content
            categoryNav.innerHTML = '';
            tabsContent.innerHTML = '';

            // Create tabs and content
            filteredMenu.forEach((filter, index) => {
                const filterId = `filter-${filter.filter_id}`;
                const isActive = index === 0;

                // Create tab button
                const tabButton = document.createElement('li');
                tabButton.className = isActive ? 'active' : '';
                tabButton.innerHTML = `<a href="#${filterId}" data-toggle="tab">${escapeHtml(filter.filter_name)}</a>`;
                categoryNav.appendChild(tabButton);

                // Collect all items from all subcategories (without showing subcategory names)
                let allItems = [];
                if (filter.subcategories) {
                    filter.subcategories.forEach(subcategory => {
                        if (subcategory.items) {
                            allItems = allItems.concat(subcategory.items);
                        }
                    });
                }

                // Limit to 4-5 items per filter
                const maxItems = 5;
                const limitedItems = allItems.slice(0, maxItems);

                // Create tab content
                const tabPane = document.createElement('div');
                tabPane.className = `tab-pane fade ${isActive ? 'in active' : ''}`;
                tabPane.id = filterId;

                const menuGrid = document.createElement('div');
                menuGrid.className = 'menu-grid';

                // Create menu items
                limitedItems.forEach(item => {
                    const menuItem = document.createElement('div');
                    menuItem.className = 'menu-item';

                    // Use uploaded image if available, otherwise use placeholder
                    const imageSrc = item.image_path ? item.image_path : 'assets/images/menu/menu-mixed-grid/placeholder.jpg';
                    const itemName = escapeHtml(item.item_name);
                    const itemPrice = parseFloat(item.price).toFixed(2);

                    menuItem.innerHTML = `
                        <img src="${imageSrc}" alt="${itemName}" onerror="this.src='assets/images/menu/menu-mixed-grid/placeholder.jpg'">
                        <div class="menu-item-info">
                            <h3>${itemName}</h3>
                            <p>$${itemPrice}</p>
                        </div>
                    `;

                    menuGrid.appendChild(menuItem);
                });

                tabPane.appendChild(menuGrid);
                tabsContent.appendChild(tabPane);
            });

            // Reinitialize Bootstrap tabs functionality
            if (window.$ && $.fn.tab) {
                $('[data-toggle="tab"]').tab();
            }
        }

        function escapeHtml(text) {
            const div = document.createElement('div');
            div.textContent = text;
            return div.innerHTML;
        }
    </script>

    <!-- Professional Table Booking Modal -->
    <div class="modal fade reservation-popup" tabindex="-1" role="dialog" id="reservationPopup">
        <div class="modal-dialog modal-lg" role="document">
            <div class="modal-content professional-booking-modal">
                <div class="modal-header professional-booking-header">
                    <div class="booking-header-content">
                        <h2 class="modal-title">Reserve Your Table</h2>
                    </div>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <i class="fa fa-times"></i>
                    </button>
                </div>
                <div class="modal-body professional-booking-body">
                    <form id="professionalBookingForm" class="professional-booking-form" method="POST" action="#">
                        <!-- Section 1: Guest Details -->
                        <div class="booking-section">
                            <h4 class="booking-section-title"><i class="fa fa-user-circle"></i> Guest Details</h4>
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="bookingName">Full Name *</label>
                                        <input type="text" class="form-control" id="bookingName"
                                            name="booking_name" placeholder="Enter your full name" required>
                                        <small class="form-text text-muted">We'll use this to identify your reservation</small>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="bookingEmail">Email Address *</label>
                                        <input type="email" class="form-control" id="bookingEmail"
                                            name="booking_email" placeholder="your.email@example.com" required>
                                        <small class="form-text text-muted">Confirmation will be sent here</small>
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="bookingPhone">Phone Number *</label>
                                        <input type="tel" class="form-control" id="bookingPhone"
                                            name="booking_phone" placeholder="+1 (555) 000-0000" required>
                                        <small class="form-text text-muted">Contact number for reservation</small>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="bookingOccasion">Occasion (Optional)</label>
                                        <select class="form-control" id="bookingOccasion" name="booking_occasion">
                                            <option value="">Select an occasion</option>
                                            <option value="birthday">Birthday Celebration</option>
                                            <option value="anniversary">Anniversary</option>
                                            <option value="business">Business Meeting</option>
                                            <option value="family">Family Gathering</option>
                                            <option value="date">Date Night</option>
                                            <option value="other">Other</option>
                                        </select>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <hr class="booking-divider">

                        <!-- Section 2: Reservation Details -->
                        <div class="booking-section">
                            <h4 class="booking-section-title"><i class="fa fa-calendar-alt"></i> Reservation Details</h4>
                            <div class="row">
                                <div class="col-md-4">
                                    <div class="form-group">
                                        <label for="bookingDate">Date *</label>
                                        <input type="date" class="form-control" id="bookingDate"
                                            name="booking_date" required>
                                        <small class="form-text text-muted">Select your preferred date</small>
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="form-group">
                                        <label for="bookingTime">Time *</label>
                                        <input type="time" class="form-control" id="bookingTime"
                                            name="booking_time" required>
                                        <small class="form-text text-muted">Select your preferred time</small>
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="form-group">
                                        <label for="bookingGuests">Number of Guests *</label>
                                        <select class="form-control" id="bookingGuests" name="booking_guests" required>
                                            <option value="">Select number</option>
                                            <option value="1">1 Person</option>
                                            <option value="2">2 People</option>
                                            <option value="3">3 People</option>
                                            <option value="4">4 People</option>
                                            <option value="5">5 People</option>
                                            <option value="6">6 People</option>
                                            <option value="7">7 People</option>
                                            <option value="8">8 People</option>
                                            <option value="10">10 People</option>
                                            <option value="12">12 People</option>
                                            <option value="15">15+ People</option>
                                        </select>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <hr class="booking-divider">

                        <!-- Section 3: Preferences & Special Requests -->


                        <!-- Form Actions -->
                        <div class="booking-actions">
                            <button type="reset" class="btn btn-outline-secondary">Clear Form</button>
                            <button type="submit" class="btn btn--secondary">Complete Booking</button>
                        </div>

                        <!-- Booking Status Message -->
                        <div class="alert alert-success booking-success-message" style="display: none; margin-top: 20px;">
                            <div style="display: flex; align-items: flex-start; gap: 15px;">
                                <div style="font-size: 24px; color: #28a745;">
                                    <i class="fa fa-check-circle"></i>
                                </div>
                                <div style="flex: 1;">
                                    <h5 style="margin: 0 0 10px 0; color: #155724;">Booking Confirmed!</h5>
                                    <p style="margin: 5px 0; font-size: 14px;" id="bookingConfirmation"></p>
                                    <p style="margin: 5px 0; font-size: 12px; color: #666;">Confirmation email has been sent to your email address.</p>
                                </div>
                            </div>
                        </div>
                        <div class="alert alert-danger booking-error-message" style="display: none; margin-top: 20px;">
                            <i class="fa fa-exclamation-circle"></i> <span class="error-message"></span>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>

    <!-- Professional Booking Modal Styles -->
    <style>
        .professional-booking-modal {
            border: none;
            border-radius: 12px;
            box-shadow: 0 10px 50px rgba(0, 0, 0, 0.2);
            overflow: hidden;
        }

        .professional-booking-header {
            background: linear-gradient(135deg, #d4a574 0%, #8b6f47 100%);
            border: none;
            color: white;
            padding: 30px;
            position: relative;
        }

        .booking-header-content h2 {
            font-size: 28px;
            font-weight: 600;
            margin: 0;
            margin-bottom: 8px;
            font-family: 'Raleway', sans-serif;
        }

        .booking-subtitle {
            font-size: 14px;
            margin: 0;
            opacity: 0.95;
            font-weight: 300;
        }

        .professional-booking-header .close {
            position: absolute;
            right: 20px;
            top: 20px;
            color: white;
            opacity: 0.8;
            font-size: 24px;
        }

        .professional-booking-header .close:hover {
            opacity: 1;
        }

        .professional-booking-body {
            padding: 40px;
            background: #f9f7f4;
        }

        .professional-booking-form {
            background: white;
            padding: 30px;
            border-radius: 8px;
            box-shadow: 0 2px 10px rgba(0, 0, 0, 0.05);
        }

        .booking-section {
            margin-bottom: 30px;
        }

        .booking-section-title {
            font-size: 16px;
            font-weight: 600;
            color: #333;
            margin-bottom: 20px;
            padding-bottom: 12px;
            border-bottom: 2px solid #d4a574;
            display: flex;
            align-items: center;
            gap: 10px;
        }

        .booking-section-title i {
            color: #d4a574;
            font-size: 18px;
        }

        .booking-divider {
            margin: 30px 0;
            border: none;
            border-top: 2px solid #e8e8e8;
        }

        .professional-booking-form .form-group {
            margin-bottom: 20px;
        }

        .professional-booking-form .form-group label {
            font-weight: 600;
            color: #333;
            margin-bottom: 8px;
            font-size: 13px;
            text-transform: uppercase;
            letter-spacing: 0.5px;
        }

        .professional-booking-form .form-control {
            border: 2px solid #e8e8e8;
            border-radius: 6px;
            padding: 12px 15px;
            font-size: 14px;
            transition: all 0.3s ease;
            background: #fafafa;
        }

        .professional-booking-form .form-control:focus {
            border-color: #d4a574;
            background: white;
            box-shadow: 0 0 0 3px rgba(212, 165, 116, 0.1);
            outline: none;
        }

        .professional-booking-form .form-control::placeholder {
            color: #999;
        }

        .professional-booking-form textarea.form-control {
            resize: vertical;
            min-height: 100px;
            font-family: 'Raleway', sans-serif;
        }

        .form-text {
            font-size: 12px;
            color: #999;
            margin-top: 5px;
        }

        .booking-actions {
            display: flex !important;
            gap: 15px !important;
            margin-top: 30px !important;
            justify-content: center !important;
            flex-wrap: wrap !important;
        }

        .professional-booking-form .booking-actions button {
            padding: 14px 35px !important;
            font-weight: 700 !important;
            border-radius: 8px !important;
            font-size: 15px !important;
            transition: all 0.3s cubic-bezier(0.25, 0.46, 0.45, 0.94) !important;
            min-width: 140px !important;
            line-height: 1.6 !important;
            display: inline-flex !important;
            align-items: center !important;
            justify-content: center !important;
            text-align: center !important;
            vertical-align: middle !important;
            cursor: pointer !important;
            letter-spacing: 0.5px !important;
            text-transform: uppercase !important;
            box-shadow: 0 4px 15px rgba(0, 0, 0, 0.1) !important;
        }

        .professional-booking-form .booking-actions .btn-outline-secondary {
            border: 2px solid #d4a574 !important;
            color: #d4a574 !important;
            background: white !important;
            box-shadow: 0 2px 10px rgba(212, 165, 116, 0.15) !important;
        }

        .professional-booking-form .booking-actions .btn-outline-secondary:hover,
        .professional-booking-form .booking-actions .btn-outline-secondary:active,
        .professional-booking-form .booking-actions .btn-outline-secondary:focus {
            border-color: #8b6f47 !important;
            color: white !important;
            background: linear-gradient(135deg, #d4a574 0%, #8b6f47 100%) !important;
            box-shadow: 0 6px 20px rgba(212, 165, 116, 0.35) !important;
            transform: translateY(-3px) !important;
        }

        .professional-booking-form .booking-actions .btn--secondary {
            background: linear-gradient(135deg, #d4a574 0%, #8b6f47 100%) !important;
            color: white !important;
            border: none !important;
            box-shadow: 0 4px 15px rgba(212, 165, 116, 0.25) !important;
            position: relative !important;
            overflow: hidden !important;
        }

        .professional-booking-form .booking-actions .btn--secondary::before {
            content: '' !important;
            position: absolute !important;
            top: 0 !important;
            left: -100% !important;
            width: 100% !important;
            height: 100% !important;
            background: rgba(255, 255, 255, 0.1) !important;
            transition: left 0.3s ease !important;
            z-index: 0 !important;
        }

        .professional-booking-form .booking-actions .btn--secondary:hover::before,
        .professional-booking-form .booking-actions .btn--secondary:active::before,
        .professional-booking-form .booking-actions .btn--secondary:focus::before {
            left: 100% !important;
        }

        .professional-booking-form .booking-actions .btn--secondary:hover,
        .professional-booking-form .booking-actions .btn--secondary:active,
        .professional-booking-form .booking-actions .btn--secondary:focus {
            transform: translateY(-3px) !important;
            box-shadow: 0 8px 25px rgba(212, 165, 116, 0.4) !important;
            background: linear-gradient(135deg, #8b6f47 0%, #d4a574 100%) !important;
            color: white !important;
            border: none !important;
        }

        .professional-booking-form .booking-actions button:active {
            transform: translateY(-1px) !important;
        }

        /* Mobile Responsiveness */
        @media (max-width: 576px) {
            .booking-actions {
                flex-direction: column !important;
                gap: 12px !important;
            }

            .professional-booking-form .booking-actions button {
                width: 100% !important;
                padding: 12px 20px !important;
                font-size: 14px !important;
                min-width: unset !important;
            }
        }

        @media (max-width: 768px) {
            .professional-booking-form .booking-actions button {
                padding: 12px 28px !important;
                font-size: 14px !important;
                min-width: 130px !important;
            }
        }

        @media (min-width: 769px) and (max-width: 992px) {
            .professional-booking-form .booking-actions button {
                padding: 13px 32px !important;
                font-size: 14px !important;
                min-width: 135px !important;
            }
        }

        .alert {
            border-radius: 6px;
            border: none;
            padding: 15px 20px;
            display: flex;
            align-items: center;
            gap: 12px;
        }

        .alert-success {
            background-color: #d4edda;
            color: #155724;
        }

        .alert-danger {
            background-color: #f8d7da;
            color: #721c24;
        }

        @media (max-width: 768px) {
            .professional-booking-body {
                padding: 20px;
            }

            .professional-booking-form {
                padding: 20px;
            }

            .booking-header-content h2 {
                font-size: 22px;
            }

            .booking-actions {
                flex-direction: column;
            }

            .booking-actions button {
                width: 100%;
            }
        }
    </style>

    <!-- Professional Booking Modal Scripts -->
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            const bookingForm = document.getElementById('professionalBookingForm');
            const successMessage = document.querySelector('.booking-success-message');
            const errorMessage = document.querySelector('.booking-error-message');

            // Set minimum date to today
            const today = new Date().toISOString().split('T')[0];
            document.getElementById('bookingDate').setAttribute('min', today);

            // Form submission
            if (bookingForm) {
                bookingForm.addEventListener('submit', function(e) {
                    e.preventDefault();

                    // Reset messages
                    successMessage.style.display = 'none';
                    errorMessage.style.display = 'none';

                    // Collect form data
                    const formData = new FormData(bookingForm);
                    const data = Object.fromEntries(formData);

                    // Validate data
                    if (!data.booking_name || !data.booking_email || !data.booking_phone ||
                        !data.booking_date || !data.booking_time || !data.booking_guests) {
                        errorMessage.querySelector('.error-message').textContent = 'Please fill in all required fields.';
                        errorMessage.style.display = 'flex';
                        return;
                    }

                    // Send booking data (you can modify this to your backend API)
                    console.log('Booking Data:', data);

                    // Show success message
                    successMessage.style.display = 'flex';

                    // Optional: Reset form and close modal after delay
                    setTimeout(function() {
                        bookingForm.reset();
                        $('#reservationPopup').modal('hide');
                    }, 2000);
                });
            }

            // Clear messages when modal is closed
            $('#reservationPopup').on('hidden.bs.modal', function() {
                successMessage.style.display = 'none';
                errorMessage.style.display = 'none';
            });
        });
    </script>
    <!-- End Professional Table Booking Modal -->

    <!-- Sign In Modal -->
    <div class="modal fade" tabindex="-1" role="dialog" id="signInModal">
        <div class="modal-dialog modal-lg" role="document">
            <div class="modal-content auth-modal-content">
                <button type="button" class="close auth-close-btn" data-dismiss="modal" aria-label="Close"><i
                        class="fa fa-times"></i></button>
                <div class="auth-modal-body">
                    <div class="auth-header">
                        <h2>Welcome Back</h2>
                        <p class="auth-subtitle">Sign in to your account</p>
                    </div>
                    <div id="signinMessage" class="auth-message" style="display: none;"></div>
                    <form class="auth-form" id="signInForm">
                        <div class="auth-form-group">
                            <label for="signinEmail" class="auth-label">Email Address</label>
                            <div class="auth-input-wrapper">
                                <i class="fas fa-envelope auth-input-icon"></i>
                                <input type="email" class="auth-input" id="signinEmail" name="email" placeholder="your@email.com"
                                    required>
                            </div>
                        </div>
                        <div class="auth-form-group">
                            <label for="signinPassword" class="auth-label">Password</label>
                            <div class="auth-input-wrapper">
                                <i class="fas fa-lock auth-input-icon"></i>
                                <input type="password" class="auth-input" id="signinPassword" name="password" placeholder="*********"
                                    required>
                            </div>
                        </div>
                        <div class="auth-form-group auth-remember">
                            <input type="checkbox" id="rememberMe" name="rememberMe">
                            <label for="rememberMe" class="auth-checkbox-label">Remember me</label>
                        </div>
                        <a href="#" data-toggle="modal" data-dismiss="modal" data-target="#forgotPasswordModal" class="auth-forgot-password" style="float: right; margin-top: 5px;">Forgot Password?</a>

                        <button type="submit" class="auth-btn">Sign In</button>
                    </form>
                    <div class="auth-divider">
                        <span>Don't have an account?</span>
                    </div>
                    <p class="auth-footer">
                        <a href="#" data-toggle="modal" data-dismiss="modal" data-target="#signUpModal"
                            class="auth-link">Create a new account</a>
                    </p>
                </div>
            </div>
        </div>
    </div>
    <!-- End Sign In Modal -->

    <!-- Sign Up Modal -->
    <div class="modal fade" tabindex="-1" role="dialog" id="signUpModal">
        <div class="modal-dialog modal-lg" role="document">
            <div class="modal-content auth-modal-content">
                <button type="button" class="close auth-close-btn" data-dismiss="modal" aria-label="Close"><i
                        class="fa fa-times"></i></button>
                <div class="auth-modal-body">
                    <div class="auth-header">
                        <h2>Create Account</h2>
                        <p class="auth-subtitle">Join us today</p>
                    </div>
                    <div id="signupMessage" class="auth-message" style="display: none;"></div>
                    <form class="auth-form" id="signUpForm">
                        <div class="auth-form-group">
                            <label for="signupName" class="auth-label">Full Name</label>
                            <div class="auth-input-wrapper">
                                <i class="fas fa-user auth-input-icon"></i>
                                <input type="text" class="auth-input" id="signupName" name="name" placeholder="John Doe" required>
                            </div>
                        </div>
                        <div class="auth-form-group">
                            <label for="signupEmail" class="auth-label">Email Address</label>
                            <div class="auth-input-wrapper">
                                <i class="fas fa-envelope auth-input-icon"></i>
                                <input type="email" class="auth-input" id="signupEmail" name="email" placeholder="your@email.com"
                                    required>
                            </div>
                        </div>
                        <div class="auth-form-group">
                            <label for="signupPhone" class="auth-label">Phone Number</label>
                            <div class="auth-input-wrapper">
                                <i class="fas fa-phone auth-input-icon"></i>
                                <input type="tel" class="auth-input" id="signupPhone" name="phone" placeholder="9876543210"
                                    required>
                            </div>
                        </div>
                        <div class="auth-form-group">
                            <label for="signupPassword" class="auth-label">Password</label>
                            <div class="auth-input-wrapper">
                                <i class="fas fa-lock auth-input-icon"></i>
                                <input type="password" class="auth-input" id="signupPassword" name="password" placeholder="*********"
                                    required>
                            </div>
                        </div>
                        <div class="auth-form-group">
                            <label for="signupConfirmPassword" class="auth-label">Confirm Password</label>
                            <div class="auth-input-wrapper">
                                <i class="fas fa-check-circle auth-input-icon"></i>
                                <input type="password" class="auth-input" id="signupConfirmPassword" name="confirmPassword"
                                    placeholder="*********" required>
                            </div>
                        </div>
                        <div class="auth-form-group auth-checkbox">
                            <input type="checkbox" id="agreeTerms" required>
                            <label for="agreeTerms" class="auth-checkbox-label">I agree to the <a href="#"
                                    class="auth-link-inline">Terms & Conditions</a></label>
                        </div>
                        <button type="submit" class="auth-btn">Create Account</button>
                    </form>
                    <div class="auth-divider">
                        <span>Already have an account?</span>
                    </div>
                    <p class="auth-footer">
                        <a href="#" data-toggle="modal" data-dismiss="modal" data-target="#signInModal"
                            class="auth-link">Sign In here</a>
                    </p>
                </div>
            </div>
        </div>
    </div>
    <!-- End Sign Up Modal -->

    <!-- Email Verification Modal -->
    <div class="modal fade" tabindex="-1" role="dialog" id="emailVerificationModal">
        <div class="modal-dialog modal-lg" role="document">
            <div class="modal-content auth-modal-content">
                <button type="button" class="close auth-close-btn" data-dismiss="modal" aria-label="Close"><i
                        class="fa fa-times"></i></button>
                <div class="auth-modal-body">
                    <div class="auth-header">
                        <h2>Verify Email</h2>
                        <p class="auth-subtitle">Enter the OTP sent to your email</p>
                    </div>
                    <div id="verifyEmailMessage" class="auth-message" style="display: none;"></div>
                    <form class="auth-form" id="emailVerificationForm">
                        <input type="hidden" id="verifyEmailAddress" value="">
                        <div class="auth-form-group">
                            <label for="emailOTP" class="auth-label">One-Time Password (OTP)</label>
                            <div class="auth-input-wrapper">
                                <i class="fas fa-key auth-input-icon"></i>
                                <input type="text" class="auth-input" id="emailOTP" name="otp" placeholder="000000" maxlength="6" required>
                            </div>
                            <small style="color: #666; margin-top: 5px;">Check your email for the 6-digit code</small>
                        </div>
                        <button type="submit" class="auth-btn">Verify Email</button>
                        <div style="text-align: center; margin-top: 15px;">
                            <p style="color: #666; font-size: 14px;">Didn't receive the code?
                                <a href="#" id="resendEmailOTP" class="auth-link" style="text-decoration: underline;">Resend OTP</a>
                            </p>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
    <!-- End Email Verification Modal -->

    <!-- Forgot Password Modal -->
    <div class="modal fade" tabindex="-1" role="dialog" id="forgotPasswordModal">
        <div class="modal-dialog modal-lg" role="document">
            <div class="modal-content auth-modal-content">
                <button type="button" class="close auth-close-btn" data-dismiss="modal" aria-label="Close"><i
                        class="fa fa-times"></i></button>
                <div class="auth-modal-body">
                    <div class="auth-header">
                        <h2>Reset Password</h2>
                        <p class="auth-subtitle">We'll send you an OTP to reset your password</p>
                    </div>
                    <div id="forgotPasswordMessage" class="auth-message" style="display: none;"></div>
                    <form class="auth-form" id="forgotPasswordForm" name="step">
                        <!-- Step 1: Enter Email -->
                        <div id="forgotPasswordStep1">
                            <div class="auth-form-group">
                                <label for="forgotEmail" class="auth-label">Email Address</label>
                                <div class="auth-input-wrapper">
                                    <i class="fas fa-envelope auth-input-icon"></i>
                                    <input type="email" class="auth-input" id="forgotEmail" name="email" placeholder="your@email.com" required>
                                </div>
                            </div>
                            <button type="button" class="auth-btn" id="sendResetOTPBtn">Send OTP</button>
                        </div>

                        <!-- Step 2: Enter OTP -->
                        <div id="forgotPasswordStep2" style="display: none;">
                            <input type="hidden" id="resetToken" value="">
                            <div class="auth-form-group">
                                <label for="resetOTP" class="auth-label">One-Time Password (OTP)</label>
                                <div class="auth-input-wrapper">
                                    <i class="fas fa-key auth-input-icon"></i>
                                    <input type="text" class="auth-input" id="resetOTP" name="otp" placeholder="000000" maxlength="6">
                                </div>
                                <small style="color: #666; margin-top: 5px;">Check your email for the 6-digit code</small>
                            </div>
                            <div class="auth-form-group">
                                <label for="newPassword" class="auth-label">New Password</label>
                                <div class="auth-input-wrapper">
                                    <i class="fas fa-lock auth-input-icon"></i>
                                    <input type="password" class="auth-input" id="newPassword" name="password" placeholder="*********">
                                </div>
                            </div>
                            <div class="auth-form-group">
                                <label for="confirmNewPassword" class="auth-label">Confirm Password</label>
                                <div class="auth-input-wrapper">
                                    <i class="fas fa-check-circle auth-input-icon"></i>
                                    <input type="password" class="auth-input" id="confirmNewPassword" name="confirmPassword" placeholder="*********">
                                </div>
                            </div>
                            <button type="button" class="auth-btn" id="resetPasswordBtn">Reset Password</button>
                            <button type="button" class="auth-btn" style="background-color: #6c757d; margin-top: 10px;" id="backToEmailBtn">Back</button>
                            <div style="text-align: center; margin-top: 15px;">
                                <p style="color: #666; font-size: 14px;">
                                    <a href="#" id="resendResetOTP" class="auth-link" style="text-decoration: underline;">Resend OTP</a>
                                </p>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
    <!-- End Forgot Password Modal -->

    <!-- Backend Integration Scripts -->
    <style>
        .auth-message {
            padding: 12px;
            border-radius: 6px;
            margin-bottom: 20px;
            font-weight: 500;
            display: flex;
            align-items: center;
            gap: 10px;
        }

        .auth-message.success {
            background: #d4edda;
            color: #155724;
            border: 1px solid #c3e6cb;
        }

        .auth-message.error {
            background: #f8d7da;
            color: #721c24;
            border: 1px solid #f5c6cb;
        }

        .auth-forgot-password {
            color: #8B4513;
            font-size: 13px;
        }

        .auth-forgot-password:hover {
            color: #A0522D;
        }
    </style>


    <script>
        // Update header with user profile
        function updateHeaderWithUserProfile(userData) {
            // Desktop header auth section
            const navAuthSection = document.getElementById('navAuthSection');
            const navUserProfileDropdown = document.getElementById('navUserProfileDropdown');
            const navUserName = document.getElementById('navUserName');

            // Mobile auth section (inside menu)
            const mobileAuthSection = document.getElementById('mobileAuthSection');
            const mobileUserProfileSection = document.getElementById('mobileUserProfileSection');

            // Mobile profile icon (next to hamburger)
            const mobileProfileIconContainer = document.getElementById('mobileProfileIconContainer');
            const mobileUserName = document.getElementById('mobileUserName');

            // Hide sign in/sign up buttons (desktop)
            if (navAuthSection) {
                navAuthSection.style.display = 'none';
            }

            // Show user profile dropdown with username (desktop)
            if (navUserProfileDropdown) {
                navUserProfileDropdown.style.display = 'inline-block';
                navUserName.textContent = userData.name || userData.email;
            }

            // Hide mobile auth buttons inside hamburger menu and show mobile user profile
            if (mobileAuthSection) {
                mobileAuthSection.classList.add('hide-auth');
            }
            if (mobileUserProfileSection) {
                mobileUserProfileSection.style.display = 'block';
            }

            // Show mobile profile icon next to hamburger
            if (mobileProfileIconContainer) {
                mobileProfileIconContainer.classList.add('show');
                // Remove inline style to let CSS handle it
                mobileProfileIconContainer.style.display = '';
            }

            // Set mobile username
            if (mobileUserName) {
                mobileUserName.textContent = userData.name || userData.email;
            }

            console.log('Header updated for user:', userData.name);
        }


        // Check if user is already logged in on page load
        document.addEventListener('DOMContentLoaded', function() {
            const user = localStorage.getItem('user');
            if (user) {
                try {
                    const userData = JSON.parse(user);
                    updateHeaderWithUserProfile(userData);
                    console.log('User already logged in:', userData.name);
                } catch (e) {
                    console.error('Error parsing user data:', e);
                }
            }
        });

        // Reset header to show auth buttons (used on logout)
        function resetHeaderAuthSection() {
            // Desktop header auth section
            const navAuthSection = document.getElementById('navAuthSection');
            const navUserProfileDropdown = document.getElementById('navUserProfileDropdown');

            // Mobile auth section
            const mobileAuthSection = document.getElementById('mobileAuthSection');
            const mobileUserProfileSection = document.getElementById('mobileUserProfileSection');

            // Mobile profile icon (next to hamburger)
            const mobileProfileIconContainer = document.getElementById('mobileProfileIconContainer');

            // Show sign in/sign up buttons (desktop)
            if (navAuthSection) {
                navAuthSection.style.display = 'flex';
            }

            // Hide user profile dropdown (desktop)
            if (navUserProfileDropdown) {
                navUserProfileDropdown.style.display = 'none';
            }

            // Show mobile auth buttons and hide mobile user profile
            if (mobileAuthSection) {
                mobileAuthSection.classList.remove('hide-auth');
            }
            if (mobileUserProfileSection) {
                mobileUserProfileSection.style.display = 'none';
            }

            // Hide mobile profile icon
            if (mobileProfileIconContainer) {
                mobileProfileIconContainer.classList.remove('show');
                mobileProfileIconContainer.style.display = 'none';
            }

            console.log('Header reset to show auth buttons');
        }

        // Logout function
        function logout() {
            console.log('Logout function called');
            // Remove user data from localStorage first
            localStorage.removeItem('user');
            // Clear cart from localStorage on logout
            localStorage.removeItem('granny_cart');

            fetch('backend/logout.php')
                .then(response => response.json())
                .then(data => {
                    console.log('Logout response:', data);
                    if (data.success) {
                        // Reload after logout is complete
                        setTimeout(() => {
                            window.location.reload();
                        }, 500);
                    }
                })
                .catch(error => {
                    console.error('Logout error:', error);
                    // Still logout on client side even if server fails
                    setTimeout(() => {
                        window.location.reload();
                    }, 500);
                });
        }

        // Logout button click handler
        document.addEventListener('DOMContentLoaded', function() {
            const logoutBtn = document.getElementById('navLogoutBtn');
            const mobileLogoutBtn = document.getElementById('mobileLogoutBtn');
            const mobileProfileLogoutBtn = document.getElementById('mobileProfileLogoutBtn');

            if (logoutBtn) {
                logoutBtn.addEventListener('click', function(e) {
                    e.preventDefault();
                    logout();
                });
            }

            if (mobileLogoutBtn) {
                mobileLogoutBtn.addEventListener('click', function(e) {
                    e.preventDefault();
                    logout();
                });
            }

            if (mobileProfileLogoutBtn) {
                mobileProfileLogoutBtn.addEventListener('click', function(e) {
                    e.preventDefault();
                    logout();
                });
            }
        });

        // Sign Up Handler - Step 1: Send OTP
        document.getElementById('signUpForm').addEventListener('submit', function(e) {
            e.preventDefault();

            const formData = {
                action: 'send_signup_otp',
                name: document.getElementById('signupName').value,
                email: document.getElementById('signupEmail').value,
                phone: document.getElementById('signupPhone').value,
                password: document.getElementById('signupPassword').value,
                confirmPassword: document.getElementById('signupConfirmPassword').value
            };

            const messageDiv = document.getElementById('signupMessage');
            messageDiv.style.display = 'flex';
            messageDiv.className = 'auth-message';
            messageDiv.innerHTML = '<i class="fas fa-spinner fa-spin"></i> Sending OTP...';

            fetch('backend/send_otp.php', {
                    method: 'POST',
                    headers: {
                        'Content-Type': 'application/json'
                    },
                    body: JSON.stringify(formData)
                })
                .then(response => response.json())
                .then(data => {
                    messageDiv.style.display = 'flex';
                    if (data.success) {
                        messageDiv.className = 'auth-message success';
                        messageDiv.innerHTML = '<i class="fas fa-check-circle"></i> ' + data.message;

                        // Store email for verification
                        document.getElementById('verifyEmailAddress').value = data.data.email;

                        // Close sign up modal and open email verification modal after a delay
                        setTimeout(() => {
                            $('#signUpModal').modal('hide');
                            setTimeout(() => {
                                $('#emailVerificationModal').modal('show');
                                document.getElementById('verifyEmailMessage').style.display = 'none';
                            }, 500);
                        }, 2000);
                    } else {
                        messageDiv.className = 'auth-message error';
                        messageDiv.innerHTML = '<i class="fas fa-exclamation-circle"></i> ' + data.message;
                    }
                })
                .catch(error => {
                    messageDiv.style.display = 'flex';
                    messageDiv.className = 'auth-message error';
                    messageDiv.innerHTML = '<i class="fas fa-exclamation-circle"></i> Error: ' + error.message;
                    console.error('Error:', error);
                });
        });

        // Email Verification Handler
        document.getElementById('emailVerificationForm').addEventListener('submit', function(e) {
            e.preventDefault();

            const email = document.getElementById('verifyEmailAddress').value;
            const otp = document.getElementById('emailOTP').value;
            const messageDiv = document.getElementById('verifyEmailMessage');

            const formData = {
                action: 'verify_signup_otp',
                email: email,
                otp: otp
            };

            messageDiv.style.display = 'flex';
            messageDiv.className = 'auth-message';
            messageDiv.innerHTML = '<i class="fas fa-spinner fa-spin"></i> Verifying OTP...';

            fetch('backend/verify_otp.php', {
                    method: 'POST',
                    headers: {
                        'Content-Type': 'application/json'
                    },
                    body: JSON.stringify(formData)
                })
                .then(response => response.json())
                .then(data => {
                    messageDiv.style.display = 'flex';
                    if (data.success) {
                        messageDiv.className = 'auth-message success';
                        messageDiv.innerHTML = '<i class="fas fa-check-circle"></i> ' + data.message + ' Redirecting to sign in...';

                        // Clear form
                        document.getElementById('emailVerificationForm').reset();
                        document.getElementById('signUpForm').reset();

                        // Close modal and show sign in
                        setTimeout(() => {
                            $('#emailVerificationModal').modal('hide');
                            setTimeout(() => {
                                messageDiv.style.display = 'none';
                                $('#signInModal').modal('show');
                            }, 500);
                        }, 2000);
                    } else {
                        messageDiv.className = 'auth-message error';
                        messageDiv.innerHTML = '<i class="fas fa-exclamation-circle"></i> ' + data.message;
                    }
                })
                .catch(error => {
                    messageDiv.style.display = 'flex';
                    messageDiv.className = 'auth-message error';
                    messageDiv.innerHTML = '<i class="fas fa-exclamation-circle"></i> Error: ' + error.message;
                    console.error('Error:', error);
                });
        });

        // Resend Email OTP
        document.getElementById('resendEmailOTP').addEventListener('click', function(e) {
            e.preventDefault();
            const email = document.getElementById('verifyEmailAddress').value;
            const messageDiv = document.getElementById('verifyEmailMessage');

            const formData = {
                action: 'resend_otp',
                email: email,
                purpose: 'signup'
            };

            messageDiv.style.display = 'flex';
            messageDiv.className = 'auth-message';
            messageDiv.innerHTML = '<i class="fas fa-spinner fa-spin"></i> Resending OTP...';

            fetch('backend/send_otp.php', {
                    method: 'POST',
                    headers: {
                        'Content-Type': 'application/json'
                    },
                    body: JSON.stringify(formData)
                })
                .then(response => response.json())
                .then(data => {
                    messageDiv.style.display = 'flex';
                    if (data.success) {
                        messageDiv.className = 'auth-message success';
                        messageDiv.innerHTML = '<i class="fas fa-check-circle"></i> ' + data.message;
                    } else {
                        messageDiv.className = 'auth-message error';
                        messageDiv.innerHTML = '<i class="fas fa-exclamation-circle"></i> ' + data.message;
                    }
                })
                .catch(error => {
                    messageDiv.style.display = 'flex';
                    messageDiv.className = 'auth-message error';
                    messageDiv.innerHTML = '<i class="fas fa-exclamation-circle"></i> Error: ' + error.message;
                });
        });

        // Forgot Password - Send OTP
        document.getElementById('sendResetOTPBtn').addEventListener('click', function(e) {
            e.preventDefault();
            const email = document.getElementById('forgotEmail').value;
            const messageDiv = document.getElementById('forgotPasswordMessage');

            if (!email) {
                messageDiv.style.display = 'flex';
                messageDiv.className = 'auth-message error';
                messageDiv.innerHTML = '<i class="fas fa-exclamation-circle"></i> Please enter your email address';
                return;
            }

            const formData = {
                action: 'send_reset_otp',
                email: email
            };

            messageDiv.style.display = 'flex';
            messageDiv.className = 'auth-message';
            messageDiv.innerHTML = '<i class="fas fa-spinner fa-spin"></i> Sending OTP...';

            fetch('backend/send_otp.php', {
                    method: 'POST',
                    headers: {
                        'Content-Type': 'application/json'
                    },
                    body: JSON.stringify(formData)
                })
                .then(response => response.json())
                .then(data => {
                    messageDiv.style.display = 'flex';
                    if (data.success) {
                        messageDiv.className = 'auth-message success';
                        messageDiv.innerHTML = '<i class="fas fa-check-circle"></i> ' + data.message;

                        // Store token for verification
                        document.getElementById('resetToken').value = data.data.token;

                        // Show step 2 after 2 seconds
                        setTimeout(() => {
                            document.getElementById('forgotPasswordStep1').style.display = 'none';
                            document.getElementById('forgotPasswordStep2').style.display = 'block';
                            messageDiv.style.display = 'none';
                        }, 2000);
                    } else {
                        messageDiv.className = 'auth-message error';
                        messageDiv.innerHTML = '<i class="fas fa-exclamation-circle"></i> ' + data.message;
                    }
                })
                .catch(error => {
                    messageDiv.style.display = 'flex';
                    messageDiv.className = 'auth-message error';
                    messageDiv.innerHTML = '<i class="fas fa-exclamation-circle"></i> Error: ' + error.message;
                });
        });

        // Back to email button
        document.getElementById('backToEmailBtn').addEventListener('click', function(e) {
            e.preventDefault();
            document.getElementById('forgotPasswordStep2').style.display = 'none';
            document.getElementById('forgotPasswordStep1').style.display = 'block';
            document.getElementById('forgotPasswordMessage').style.display = 'none';
        });

        // Reset Password with OTP
        document.getElementById('resetPasswordBtn').addEventListener('click', function(e) {
            e.preventDefault();

            const email = document.getElementById('forgotEmail').value;
            const token = document.getElementById('resetToken').value;
            const otp = document.getElementById('resetOTP').value;
            const newPassword = document.getElementById('newPassword').value;
            const confirmPassword = document.getElementById('confirmNewPassword').value;
            const messageDiv = document.getElementById('forgotPasswordMessage');

            if (!otp || !newPassword || !confirmPassword) {
                messageDiv.style.display = 'flex';
                messageDiv.className = 'auth-message error';
                messageDiv.innerHTML = '<i class="fas fa-exclamation-circle"></i> Please fill in all fields';
                return;
            }

            const formData = {
                action: 'verify_reset_otp',
                email: email,
                token: token,
                otp: otp,
                newPassword: newPassword,
                confirmPassword: confirmPassword
            };

            messageDiv.style.display = 'flex';
            messageDiv.className = 'auth-message';
            messageDiv.innerHTML = '<i class="fas fa-spinner fa-spin"></i> Resetting password...';

            fetch('backend/verify_otp.php', {
                    method: 'POST',
                    headers: {
                        'Content-Type': 'application/json'
                    },
                    body: JSON.stringify(formData)
                })
                .then(response => response.json())
                .then(data => {
                    messageDiv.style.display = 'flex';
                    if (data.success) {
                        messageDiv.className = 'auth-message success';
                        messageDiv.innerHTML = '<i class="fas fa-check-circle"></i> ' + data.message + ' Redirecting to sign in...';

                        // Clear form
                        document.getElementById('forgotPasswordForm').reset();
                        document.getElementById('forgotPasswordStep2').style.display = 'none';
                        document.getElementById('forgotPasswordStep1').style.display = 'block';

                        // Close modal and show sign in
                        setTimeout(() => {
                            $('#forgotPasswordModal').modal('hide');
                            setTimeout(() => {
                                messageDiv.style.display = 'none';
                                $('#signInModal').modal('show');
                            }, 500);
                        }, 2000);
                    } else {
                        messageDiv.className = 'auth-message error';
                        messageDiv.innerHTML = '<i class="fas fa-exclamation-circle"></i> ' + data.message;
                    }
                })
                .catch(error => {
                    messageDiv.style.display = 'flex';
                    messageDiv.className = 'auth-message error';
                    messageDiv.innerHTML = '<i class="fas fa-exclamation-circle"></i> Error: ' + error.message;
                });
        });

        // Resend Reset OTP
        document.getElementById('resendResetOTP').addEventListener('click', function(e) {
            e.preventDefault();
            const email = document.getElementById('forgotEmail').value;
            const messageDiv = document.getElementById('forgotPasswordMessage');

            const formData = {
                action: 'resend_otp',
                email: email,
                purpose: 'reset'
            };

            messageDiv.style.display = 'flex';
            messageDiv.className = 'auth-message';
            messageDiv.innerHTML = '<i class="fas fa-spinner fa-spin"></i> Resending OTP...';

            fetch('backend/send_otp.php', {
                    method: 'POST',
                    headers: {
                        'Content-Type': 'application/json'
                    },
                    body: JSON.stringify(formData)
                })
                .then(response => response.json())
                .then(data => {
                    messageDiv.style.display = 'flex';
                    if (data.success) {
                        messageDiv.className = 'auth-message success';
                        messageDiv.innerHTML = '<i class="fas fa-check-circle"></i> ' + data.message;
                    } else {
                        messageDiv.className = 'auth-message error';
                        messageDiv.innerHTML = '<i class="fas fa-exclamation-circle"></i> ' + data.message;
                    }
                })
                .catch(error => {
                    messageDiv.style.display = 'flex';
                    messageDiv.className = 'auth-message error';
                    messageDiv.innerHTML = '<i class="fas fa-exclamation-circle"></i> Error: ' + error.message;
                });
        });

        // Sign In Handler
        document.getElementById('signInForm').addEventListener('submit', function(e) {
            e.preventDefault();

            const formData = {
                email: document.getElementById('signinEmail').value,
                password: document.getElementById('signinPassword').value,
                rememberMe: document.getElementById('rememberMe').checked
            };

            const messageDiv = document.getElementById('signinMessage');

            fetch('backend/signin.php', {
                    method: 'POST',
                    headers: {
                        'Content-Type': 'application/json'
                    },
                    body: JSON.stringify(formData)
                })
                .then(response => response.json())
                .then(data => {
                    messageDiv.style.display = 'flex';
                    if (data.success) {
                        messageDiv.className = 'auth-message success';
                        messageDiv.innerHTML = '<i class="fas fa-check-circle"></i> ' + data.message;

                        // Clear form
                        document.getElementById('signInForm').reset();

                        // Store user data in localStorage
                        localStorage.setItem('user', JSON.stringify(data.data));

                        // Update cartManager login status
                        if (window.cartManager) {
                            window.cartManager.updateLoginStatus();
                        }

                        // Close modal
                        setTimeout(() => {
                            $('#signInModal').modal('hide');
                            messageDiv.style.display = 'none';
                            // Update header with user profile
                            updateHeaderWithUserProfile(data.data);
                            // Refresh page after successful sign-in
                            setTimeout(() => {
                                window.location.reload();
                            }, 500);
                        }, 2000);
                    } else {
                        messageDiv.className = 'auth-message error';
                        messageDiv.innerHTML = '<i class="fas fa-exclamation-circle"></i> ' + data.message;
                    }
                })
                .catch(error => {
                    messageDiv.style.display = 'flex';
                    messageDiv.className = 'auth-message error';
                    messageDiv.innerHTML = '<i class="fas fa-exclamation-circle"></i> Error: ' + error.message;
                    console.error('Error:', error);
                });
        });

        // Booking Handler
        document.getElementById('professionalBookingForm').addEventListener('submit', function(e) {
            e.preventDefault();

            const formData = {
                booking_name: document.getElementById('bookingName')?.value || '',
                booking_email: document.getElementById('bookingEmail')?.value || '',
                booking_phone: document.getElementById('bookingPhone')?.value || '',
                booking_date: document.getElementById('bookingDate')?.value || '',
                booking_time: document.getElementById('bookingTime')?.value || '',
                booking_guests: document.getElementById('bookingGuests')?.value || '',
                booking_occasion: document.getElementById('bookingOccasion')?.value || '',
                booking_table_type: document.getElementById('bookingTableType')?.value || '',
                booking_dietary: document.getElementById('bookingDietaryNeeds')?.value || '',
                booking_special_requests: document.getElementById('bookingSpecialRequests')?.value || ''
            };

            const successMessage = document.querySelector('.booking-success-message');
            const errorMessage = document.querySelector('.booking-error-message');

            console.log('Sending booking data:', formData);

            // Validate required fields
            if (!formData.booking_name || !formData.booking_email || !formData.booking_phone || !formData.booking_date || !formData.booking_time || !formData.booking_guests) {
                errorMessage.style.display = 'flex';
                errorMessage.querySelector('.error-message').textContent = 'Please fill in all required fields';
                successMessage.style.display = 'none';
                console.error('Validation failed: Missing required fields');
                return;
            }

            fetch('backend/booking.php', {
                    method: 'POST',
                    headers: {
                        'Content-Type': 'application/json'
                    },
                    body: JSON.stringify(formData)
                })
                .then(response => {
                    console.log('Response status:', response.status);
                    return response.json();
                })
                .then(data => {
                    console.log('Booking response:', data);
                    if (data.success) {
                        successMessage.style.display = 'flex';
                        errorMessage.style.display = 'none';

                        // Update confirmation message with booking details
                        const confirmationDiv = document.getElementById('bookingConfirmation');
                        if (confirmationDiv && data.data) {
                            confirmationDiv.innerHTML = `
                            <strong>Booking ID:</strong> #${data.data.booking_id}<br>
                            <strong>Date:</strong> ${data.data.booking_date} at ${data.data.booking_time}<br>
                            <strong>Guests:</strong> ${data.data.guests} person(s)
                        `;
                        }

                        // Store booking data
                        localStorage.setItem('lastBooking', JSON.stringify(data.data));
                        console.log('Booking saved to localStorage:', data.data);

                        // Reset and close
                        setTimeout(() => {
                            document.getElementById('professionalBookingForm').reset();
                            $('#reservationPopup').modal('hide');
                            successMessage.style.display = 'none';
                            confirmationDiv.innerHTML = '';
                        }, 3500);
                    } else {
                        errorMessage.style.display = 'flex';
                        errorMessage.querySelector('.error-message').textContent = data.message;
                        successMessage.style.display = 'none';
                        console.error('Booking error:', data.message);
                    }
                })
                .catch(error => {
                    errorMessage.style.display = 'flex';
                    errorMessage.querySelector('.error-message').textContent = 'Error: ' + error.message;
                    successMessage.style.display = 'none';
                    console.error('Fetch error:', error);
                });
        });

        // Load blogs from database for home page carousel
        function loadHomePageBlogs() {
            fetch('backend/blog_api.php?action=get_blogs')
                .then(response => response.json())
                .then(data => {
                    if (data.success && data.data && data.data.length > 0) {
                        renderHomePageBlogs(data.data);
                    }
                })
                .catch(error => {
                    console.error('Error loading blogs:', error);
                });
        }

        // Render blogs in carousel
        function renderHomePageBlogs(blogs) {
            const wrapper = document.getElementById('blogSwiperWrapper');
            if (!wrapper) return;

            wrapper.innerHTML = '';

            blogs.forEach(blog => {
                const date = new Date(blog.created_at).toLocaleDateString('en-US', {
                    year: 'numeric',
                    month: 'short',
                    day: 'numeric'
                });

                const blogSlide = `
                    <div class="swiper-slide">
                        <div class="blog-entry">
                            <div class="entry--img">
                                <a href="javascript:void(0);">
                                    <img src="${blog.featured_image || 'assets/images/default-blog.jpg'}" alt="${escapeHtml(blog.title)}">
                                </a>
                            </div>
                            <div class="entry--content">
                                <div class="entry--meta">
                                    <span>${blog.category ? escapeHtml(blog.category) : 'Blog'}</span>
                                </div>
                                <div class="entry--title">
                                    <h4><a href="javascript:void(0);" class="blog-link">${escapeHtml(blog.title)}</a></h4>
                                </div>
                                <div class="entry--bio">
                                    ${escapeHtml(blog.excerpt || 'No description available')}
                                </div>
                                <div class="entry--footer">
                                    <div class="entry--date">${date}</div>
                                </div>
                            </div>
                        </div>
                    </div>
                `;

                wrapper.insertAdjacentHTML('beforeend', blogSlide);
            });

            // Reinitialize swiper after adding slides
            if (window.blogSwiperInstance) {
                window.blogSwiperInstance.destroy();
            }

            // Recreate swiper with new slides
            setTimeout(() => {
                window.blogSwiperInstance = new Swiper('.blog-slider', {
                    slidesPerView: 1,
                    spaceBetween: 30,
                    speed: 800,
                    effect: 'slide',
                    pagination: {
                        el: '.blog-slider .swiper-pagination',
                        clickable: true,
                        dynamicBullets: true,
                        dynamicMainBullets: 3
                    },
                    autoplay: {
                        delay: 6000,
                        disableOnInteraction: false,
                        pauseOnMouseEnter: true
                    },
                    easing: 'cubic-bezier(0.25, 0.46, 0.45, 0.94)',
                    breakpoints: {
                        640: {
                            slidesPerView: 1,
                        },
                        768: {
                            slidesPerView: 2,
                            spaceBetween: 30
                        },
                        1024: {
                            slidesPerView: 3,
                            spaceBetween: 30
                        }
                    }
                });
            }, 100);
        }

        // Initialize user session on page load
        document.addEventListener('DOMContentLoaded', function() {
            const user = localStorage.getItem('user');
            if (user) {
                const userData = JSON.parse(user);
                console.log('User logged in:', userData);
                // Header is already updated by the earlier DOMContentLoaded event
            }

            // Load chefs for home page
            loadHomePageChefs();

            // Load blogs for home page
            loadHomePageBlogs();
        });

        // Load chefs from database (maximum 4 for home page)
        function loadHomePageChefs() {
            fetch('backend/chefs_api.php?action=get_all_chefs')
                .then(response => response.json())
                .then(data => {
                    if (data.success && data.data && data.data.length > 0) {
                        // Limit to 4 chefs
                        const chefs = data.data.slice(0, 4);
                        renderHomePageChefs(chefs);
                    }
                })
                .catch(error => {
                    console.error('Error loading chefs:', error);
                });
        }

        // Render chefs in home page
        function renderHomePageChefs(chefs) {
            const container = document.getElementById('chefsContainer');
            if (!container) return;

            container.innerHTML = '';

            chefs.forEach(chef => {
                const chefHtml = `
                    <div class="col-xs-12 col-sm-6 col-md-3">
                        <div class="member">
                            <div class="member-img">
                                <img src="${chef.image_path || 'assets/images/default-chef.jpg'}" alt="${escapeHtml(chef.name)}">
                                <div class="member-overlay">
                                    <div class="member-hover">
                                        <div class="pos-vertical-center">
                                            <div class="member-social">
                                                ${chef.social_media && chef.social_media.length > 0 ? 
                                                    chef.social_media.map(social => 
                                                        `<a href="${social.url}" target="_blank"><i class="${social.icon_class}"></i></a>`
                                                    ).join('') 
                                                    : '<a href="#"><i class="fa fa-facebook"></i></a><a href="#"><i class="fa fa-twitter"></i></a><a href="#"><i class="fa fa-instagram"></i></a>'
                                                }
                                            </div>
                                            <!-- .memebr-social end -->
                                            <div class="member-desc">
                                                <p>${chef.description || 'Passion for cooking is in his genes. He grew up appreciating outstanding food and service at an early age.'}</p>
                                            </div>
                                            <!-- .memebr-desc end -->
                                        </div>
                                        <!-- .pos-vertical-center end -->
                                    </div>
                                    <!-- .memebr-hover end -->
                                </div>
                                <!-- .memebr-ovelay end -->
                            </div>
                            <!-- .member-img end -->
                            <div class="member-info">
                                <h5>${escapeHtml(chef.name)}</h5>
                                <h6>${escapeHtml(chef.position)}</h6>
                            </div>
                            <!-- .member-info end -->
                        </div>
                        <!-- .member end -->
                    </div>
                    <!-- .col-md-3 end -->
                `;

                container.insertAdjacentHTML('beforeend', chefHtml);
            });
        }

        // Escape HTML to prevent XSS
        function escapeHtml(text) {
            if (!text) return '';
            const div = document.createElement('div');
            div.textContent = text;
            return div.innerHTML;
        }
    </script>

</body>

</html>