<?php
session_start();

// Check if user is logged in (via session or cookie)
$isLoggedIn = false;

// Check session first
if (isset($_SESSION['user_id']) && isset($_SESSION['user_email'])) {
    $isLoggedIn = true;
} 
// Check cookies (for remember me functionality)
else if (isset($_COOKIE['user_id']) && isset($_COOKIE['user_email'])) {
    // Restore session from cookies
    $_SESSION['user_id'] = $_COOKIE['user_id'];
    $_SESSION['user_email'] = $_COOKIE['user_email'];
    $isLoggedIn = true;
}

// If still not logged in, redirect to index page
if (!$isLoggedIn) {
    header('Location: index.php');
    exit();
}
?>
<!DOCTYPE html>
<html dir="ltr" lang="en-US">

<head>
    <!-- Document Meta
    ============================================= -->
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <!--IE Compatibility Meta-->
    <meta name="author" content="zytheme">
    <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1">
    <meta name="description" content="Elegant Restaurant & Cafe Html5 Template">
    <link href="assets/images/favicon/favicon.png" rel="icon">

    <!-- Fonts
    ============================================= -->
    <link
        href="../css?family=Great+Vibes%7CKaushan+Script%7CRaleway:100,100i,200,200i,300,300i,400,400i,500,500i,600,600i,700,700i,800,800i,900,900i"
        rel="stylesheet" type="text/css">

    <!-- Font Awesome Icons
    ============================================= -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">

    <!-- Swiper CSS -->
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/swiper@11/swiper-bundle.min.css">

    <!-- Stylesheets
    ============================================= -->
    <link href="assets/css/external.css" rel="stylesheet">
    <link href="assets/css/bootstrap.min.css" rel="stylesheet">
    <link href="assets/css/style.css" rel="stylesheet">
    <link href="assets/css/custom-sections.css" rel="stylesheet">
    <link href="assets/css/menu-showcase.css" rel="stylesheet">
    <link href="assets/css/testimonial-new.css" rel="stylesheet">
    <link href="assets/css/blog-section.css" rel="stylesheet">
    <link href="assets/css/cart.css" rel="stylesheet">

    <!-- RS5.0 Main Stylesheet -->
    <link rel="stylesheet" type="text/css" href="assets/revolution/css/settings.css">
    <link rel="stylesheet" type="text/css" href="assets/revolution/css/layers.css">
    <link rel="stylesheet" type="text/css" href="assets/revolution/css/navigation.css">

    <!-- SweetAlert2 CSS -->
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/sweetalert2@11/dist/sweetalert2.min.css">

    <!-- HTML5 shim, for IE6-8 support of HTML5 elements. All other JS at the end of file. -->
    <!--[if lt IE 9]>
      <script src="assets/js/html5shiv.js"></script>
      <script src="assets/js/respond.min.js"></script>
    <![endif]-->

    <!-- Document Title
    ============================================= -->
    <title>Home Page</title>
</head>

<body>
    <div class="preloader">
        <div class="spinner">
            <div class="bounce1"></div>
            <div class="bounce2"></div>
            <div class="bounce3"></div>
        </div>
    </div>
    <!-- Document Wrapper
	============================================= -->
    <div id="wrapper" class="wrapper clearfix">
        <!-- New Header -->
        <!-- Top Announcement Bar -->
        <div class="header-top-bar">
            <div class="container">
                <div class="header-top-bar-text">Welcome to Granny Restaurant & Catering Services</div>
                <div class="header-social-icons">
                    <a href="#" title="Facebook"><i class="fab fa-facebook-f"></i></a>
                    <a href="#" title="Twitter"><i class="fab fa-twitter"></i></a>
                    <a href="#" title="Instagram"><i class="fab fa-instagram"></i></a>
                    <a href="#" title="WhatsApp"><i class="fab fa-whatsapp"></i></a>
                    <a href="#" title="YouTube"><i class="fab fa-youtube"></i></a>
                </div>
            </div>
        </div>
        <!-- Main Header -->
        <header class="header-main">
            <div class="container">
                <div class="header-logo">
                    <a href="index.php"><img src="assets/images/logo/logo-dark.png" alt="Granny Logo"></a>
                </div>

                <div style="display: flex; align-items: center; gap: 20px; flex: 1;">
                    <div class="header-contact-info">
                        <a href="tel:+919876543210" class="header-contact-item">
                            <i class="fas fa-phone"></i>
                            <div class="header-contact-text">
                                <span class="header-contact-label">Call Us:</span>
                                <span class="header-contact-value">+91 98765 43210</span>
                            </div>
                        </a>
                        <a href="mailto:info@granny.com" class="header-contact-item">
                            <i class="fas fa-envelope"></i>
                            <div class="header-contact-text">
                                <span class="header-contact-label">Mail Us:</span>
                                <span class="header-contact-value">info@granny.com</span>
                            </div>
                        </a>
                        <a href="#" class="header-contact-item">
                            <i class="fas fa-map-marker-alt"></i>
                            <div class="header-contact-text">
                                <span class="header-contact-label">Location:</span>
                                <span class="header-contact-value">Egypt</span>
                            </div>
                        </a>
                    </div>
                    <div class="header-booking-section" id="bookingSection">
                        <button class="header-booking-btn" data-toggle="modal" data-target="#reservationPopup">Table Booking</button>
                    </div>
                    <div class="user-profile-dropdown" id="userProfileDropdown" style="display: none;">
                        <button class="user-profile-btn" id="userProfileBtn">
                            <i class="fas fa-user-circle"></i>
                            <span class="user-name" id="userName"></span>
                        </button>
                        <div class="user-dropdown-menu" id="userDropdownMenu">
                            <a href="#" class="dropdown-item user-profile-link">
                                <i class="fas fa-user"></i> My Profile
                            </a>
                            <a href="#" class="dropdown-item user-settings-link">
                                <i class="fas fa-cog"></i> Settings
                            </a>
                            <div class="dropdown-divider"></div>
                            <a href="#" class="dropdown-item user-logout-link" id="logoutBtn">
                                <i class="fas fa-sign-out-alt"></i> Logout
                            </a>
                        </div>
                    </div>
                </div>
                </div>
        </header>
        <!-- Navigation Bar -->
        <nav class="header-nav-bar">
            <div class="container"
                style="display: flex; justify-content: space-between; align-items: center; padding: 0;">
                <div class="header-navbar-logo">
                    <a href="index.php"><img src="assets/images/logo/logo-light.png" alt="Granny Logo"></a>
                </div>
                <ul class="header-nav-menu" id="headerNavMenu">
                    <li><a href="index.php">Home</a></li>
                    <li>
                        <a href="about.php">About Us</a>

                    </li>
                    <li>
                        <a href="menu.php">Menu</a>

                    </li>
                    <li><a href="chefs.php">Our Chefs</a></li>
                    <li><a href="blog.php">Blog</a></li>
                    <!-- <li><a href="shop-4cols.html">Shop</a></li> -->
                    <li><a href="gallery.php">Gallery</a></li>
                    <li><a href="contacts.php">Contact Us</a></li>
                    <!-- Mobile Only Cart Icon -->
                    <li class="mobile-cart-item"
                        style="border-top: 2px solid #c59d5f; margin: 10px 0; padding: 10px 15px;">
                        <a href="cart.php" class="header-cart-icon"
                            style="display: flex; align-items: center; gap: 10px; color: #ffffff; text-decoration: none; padding: 0; font-size: 16px;">
                            <i class="fas fa-shopping-cart"></i>
                            <span>Cart</span>
                            <span class="header-cart-count">0</span>
                        </a>
                    </li>
                    <!-- Mobile Only Booking Button -->
                    <li class="mobile-booking-item">
                        <button class="header-booking-btn" data-toggle="modal" data-target="#reservationPopup"
                            style="width: 100%; display: block; padding: 12px 15px; background-color: #c59d5f; color: #ffffff; border: none; border-radius: 4px; font-size: 14px; font-weight: 700; text-transform: uppercase; cursor: pointer; transition: all 0.3s ease;">Booking</button>
                    </li>
                    <!-- Mobile Only Auth Section -->
                    <li class="mobile-auth-divider" id="mobileAuthSection"
                        style="border-top: 2px solid #c59d5f; margin: 10px 0; padding: 10px 0;">
                        <a href="#" class="header-auth-btn header-signin-btn" data-toggle="modal"
                            data-target="#signInModal"
                            style="display: block; padding: 12px 15px; text-align: center; width: 100%; box-sizing: border-box; margin-bottom: 10px; border: 2px solid #c59d5f; background-color: transparent; color: #c59d5f; border-radius: 4px; font-size: 14px; font-weight: 600;">Sign
                            In</a>
                        <a href="#" class="header-auth-btn header-signup-btn" data-toggle="modal"
                            data-target="#signUpModal"
                            style="display: block; padding: 12px 15px; text-align: center; width: 100%; box-sizing: border-box; background-color: #c59d5f; color: #ffffff; border: 2px solid #c59d5f; border-radius: 4px; font-size: 14px; font-weight: 600;">Sign
                            Up</a>
                    </li>
        
                </ul>
                <div class="header-nav-right">
                    <a href="cart.php" class="header-cart-icon">
                        <i class="fas fa-shopping-cart"></i>
                        <span class="header-cart-count">0</span>
                    </a>
                    <div class="header-auth-section" id="navAuthSection">
                        <a href="#" class="header-auth-btn header-signin-btn" data-toggle="modal"
                            data-target="#signInModal">Sign In</a>
                        <a href="#" class="header-auth-btn header-signup-btn" data-toggle="modal"
                            data-target="#signUpModal">Sign Up</a>
                    </div>
                    <div class="nav-user-profile-dropdown" id="navUserProfileDropdown" style="display: none;">
                        <button class="nav-user-profile-btn" id="navUserProfileBtn">
                            <i class="fas fa-user-circle"></i>
                            <span class="nav-user-name" id="navUserName"></span>
                        </button>
                        <div class="nav-user-dropdown-menu" id="navUserDropdownMenu">
                            <a href="dashboard.php" class="dropdown-item user-profile-link">
                                <i class="fa-solid fa-gauge"></i> Dashboard
                            </a>
                            <!-- <a href="#" class="dropdown-item user-settings-link">
                                <i class="fas fa-cog"></i> Settings
                            </a> -->
                            <!-- <div class="dropdown-divider"></div> -->
                            <a href="#" class="dropdown-item user-logout-link" id="navLogoutBtn">
                                <i class="fas fa-sign-out-alt"></i> Logout
                            </a>
                        </div>
                    </div>
                </div>
                <!-- Mobile Profile Icon (shown when logged in) -->
                <div class="mobile-profile-icon-container" id="mobileProfileIconContainer" style="display: none;">
                    <button class="mobile-profile-icon-btn" id="mobileProfileIconBtn">
                        <i class="fas fa-user-circle"></i>
                        <span class="mobile-user-name" id="mobileUserName"></span>
                    </button>
                    <div class="mobile-profile-dropdown-menu" id="mobileProfileDropdownMenu">
                        <a href="dashboard.php" class="dropdown-item user-profile-link">
                            <i class="fa-solid fa-gauge"></i> Dashboard
                        </a>
                        <!-- <a href="#" class="dropdown-item user-settings-link">
                            <i class="fas fa-cog"></i> Settings
                        </a> -->
                        <!-- <div class="dropdown-divider"></div> -->
                        <a href="#" class="dropdown-item user-logout-link" id="mobileProfileLogoutBtn">
                            <i class="fas fa-sign-out-alt"></i> Logout
                        </a>
                    </div>
                </div>
                <button class="header-mobile-toggle" id="headerMenuToggle">
                    <i class="fas fa-bars"></i>
                    <span class="hamburger-cart-badge header-cart-count">0</span>
                </button>
            </div>
        </nav>

        <!-- Dashboard Content Section -->
        <div class="dashboard-section" style="min-height: 100vh; padding: 60px 20px; background: #f8f8f8;">
            <div class="container" style="max-width: 1200px;">
                
                <!-- Welcome Banner -->
                <div class="dashboard-welcome-banner" style="background: linear-gradient(135deg, #c59d5f 0%, #d4a574 100%); padding: 40px 50px; border-radius: 15px; margin-bottom: 50px; box-shadow: 0 4px 15px rgba(197, 157, 95, 0.25);">
                    <h2 style="color: white; margin: 0 0 10px 0; font-size: 32px; font-weight: 600;">Welcome, <span id="dashboardUserNameBanner">User</span> 👋</h2>
                    <p style="color: rgba(255,255,255,0.95); margin: 0; font-size: 16px;" id="dashboardUserEmailBanner">user@email.com</p>
                </div>

                <!-- Dashboard Cards Grid -->
                <div style="display: grid; grid-template-columns: repeat(auto-fit, minmax(260px, 1fr)); gap: 30px; margin-bottom: 30px;">
                    
                    <!-- My Profile Card -->
                    <div class="dashboard-card-item" style="background: white; padding: 30px; border-radius: 12px; box-shadow: 0 2px 8px rgba(0,0,0,0.08); transition: transform 0.3s ease, box-shadow 0.3s ease; cursor: pointer; text-align: center;" onmouseover="this.style.transform='translateY(-5px)'; this.style.boxShadow='0 8px 20px rgba(0,0,0,0.12)';" onmouseout="this.style.transform='translateY(0)'; this.style.boxShadow='0 2px 8px rgba(0,0,0,0.08)';">
                        <i class="fas fa-user" style="font-size: 40px; color: #c59d5f; margin-bottom: 20px; display: block;"></i>
                        <h3 style="color: #333; font-size: 18px; margin: 0 0 10px 0; font-weight: 600;">My Profile</h3>
                        <p style="color: #777; font-size: 14px; margin: 0 0 20px 0; line-height: 1.5;">View and update your personal information.</p>
                        <a href="profile.php" style="display: inline-block; background: #c59d5f; color: white; padding: 10px 30px; border-radius: 6px; text-decoration: none; font-weight: 600; font-size: 14px; transition: background 0.3s ease;" onmouseover="this.style.background='#b8855a';" onmouseout="this.style.background='#c59d5f';">Go to Profile</a>
                    </div>

                    <!-- My Cart Card -->
                    <div class="dashboard-card-item" style="background: white; padding: 30px; border-radius: 12px; box-shadow: 0 2px 8px rgba(0,0,0,0.08); transition: transform 0.3s ease, box-shadow 0.3s ease; cursor: pointer; text-align: center;" onmouseover="this.style.transform='translateY(-5px)'; this.style.boxShadow='0 8px 20px rgba(0,0,0,0.12)';" onmouseout="this.style.transform='translateY(0)'; this.style.boxShadow='0 2px 8px rgba(0,0,0,0.08)';">
                        <i class="fas fa-shopping-cart" style="font-size: 40px; color: #c59d5f; margin-bottom: 20px; display: block;"></i>
                        <h3 style="color: #333; font-size: 18px; margin: 0 0 10px 0; font-weight: 600;">My Cart</h3>
                        <p style="color: #777; font-size: 14px; margin: 0 0 20px 0; line-height: 1.5;">View and manage your cart items.</p>
                        <a href="cart.php" style="display: inline-block; background: #c59d5f; color: white; padding: 10px 30px; border-radius: 6px; text-decoration: none; font-weight: 600; font-size: 14px; transition: background 0.3s ease;" onmouseover="this.style.background='#b8855a';" onmouseout="this.style.background='#c59d5f';">View Cart</a>
                    </div>

                    <!-- My Appointments Card -->
                    <div class="dashboard-card-item" style="background: white; padding: 30px; border-radius: 12px; box-shadow: 0 2px 8px rgba(0,0,0,0.08); transition: transform 0.3s ease, box-shadow 0.3s ease; cursor: pointer; text-align: center;" onmouseover="this.style.transform='translateY(-5px)'; this.style.boxShadow='0 8px 20px rgba(0,0,0,0.12)';" onmouseout="this.style.transform='translateY(0)'; this.style.boxShadow='0 2px 8px rgba(0,0,0,0.08)';">
                        <i class="fas fa-calendar-alt" style="font-size: 40px; color: #c59d5f; margin-bottom: 20px; display: block;"></i>
                        <h3 style="color: #333; font-size: 18px; margin: 0 0 10px 0; font-weight: 600;">My Table Bookings</h3>
                        <p style="color: #777; font-size: 14px; margin: 0 0 20px 0; line-height: 1.5;">View, reschedule, or cancel table bookings.</p>
                        <a href="table_booking.php" style="display: inline-block; background: #c59d5f; color: white; padding: 10px 30px; border-radius: 6px; text-decoration: none; font-weight: 600; font-size: 14px; transition: background 0.3s ease;" onmouseover="this.style.background='#b8855a';" onmouseout="this.style.background='#c59d5f';">View Bookings</a>
                    </div>

                    <!-- Change Password Card -->
                    <div class="dashboard-card-item" style="background: white; padding: 30px; border-radius: 12px; box-shadow: 0 2px 8px rgba(0,0,0,0.08); transition: transform 0.3s ease, box-shadow 0.3s ease; cursor: pointer; text-align: center;" onmouseover="this.style.transform='translateY(-5px)'; this.style.boxShadow='0 8px 20px rgba(0,0,0,0.12)';" onmouseout="this.style.transform='translateY(0)'; this.style.boxShadow='0 2px 8px rgba(0,0,0,0.08)';">
                        <i class="fas fa-lock" style="font-size: 40px; color: #c59d5f; margin-bottom: 20px; display: block;"></i>
                        <h3 style="color: #333; font-size: 18px; margin: 0 0 10px 0; font-weight: 600;">Change Password</h3>
                        <p style="color: #777; font-size: 14px; margin: 0 0 20px 0; line-height: 1.5;">Update your account password securely.</p>
                        <a href="changepassword.php" style="display: inline-block; background: #c59d5f; color: white; padding: 10px 30px; border-radius: 6px; text-decoration: none; font-weight: 600; font-size: 14px; transition: background 0.3s ease;" onmouseover="this.style.background='#b8855a';" onmouseout="this.style.background='#c59d5f';">Change Password</a>
                    </div>

                    <!-- Feedback Card -->
                    <div class="dashboard-card-item" style="background: white; padding: 30px; border-radius: 12px; box-shadow: 0 2px 8px rgba(0,0,0,0.08); transition: transform 0.3s ease, box-shadow 0.3s ease; cursor: pointer; text-align: center;" onmouseover="this.style.transform='translateY(-5px)'; this.style.boxShadow='0 8px 20px rgba(0,0,0,0.12)';" onmouseout="this.style.transform='translateY(0)'; this.style.boxShadow='0 2px 8px rgba(0,0,0,0.08)';">
                        <i class="fas fa-comments" style="font-size: 40px; color: #c59d5f; margin-bottom: 20px; display: block;"></i>
                        <h3 style="color: #333; font-size: 18px; margin: 0 0 10px 0; font-weight: 600;">FeedBack</h3>
                        <p style="color: #777; font-size: 14px; margin: 0 0 20px 0; line-height: 1.5;">Provide feedback about our services.</p>
                        <a href="feedback.php" style="display: inline-block; background: #c59d5f; color: white; padding: 10px 30px; border-radius: 6px; text-decoration: none; font-weight: 600; font-size: 14px; transition: background 0.3s ease;" onmouseover="this.style.background='#b8855a';" onmouseout="this.style.background='#c59d5f';">Give Feedback</a>
                    </div>

                    <!-- My Orders Card -->
                    <div class="dashboard-card-item" style="background: white; padding: 30px; border-radius: 12px; box-shadow: 0 2px 8px rgba(0,0,0,0.08); transition: transform 0.3s ease, box-shadow 0.3s ease; cursor: pointer; text-align: center;" onmouseover="this.style.transform='translateY(-5px)'; this.style.boxShadow='0 8px 20px rgba(0,0,0,0.12)';" onmouseout="this.style.transform='translateY(0)'; this.style.boxShadow='0 2px 8px rgba(0,0,0,0.08)';">
                        <i class="fas fa-shopping-bag" style="font-size: 40px; color: #c59d5f; margin-bottom: 20px; display: block;"></i>
                        <h3 style="color: #333; font-size: 18px; margin: 0 0 10px 0; font-weight: 600;">My Orders</h3>
                        <p style="color: #777; font-size: 14px; margin: 0 0 20px 0; line-height: 1.5;">View and manage your orders.</p>
                        <a href="myorders.php" style="display: inline-block; background: #c59d5f; color: white; padding: 10px 30px; border-radius: 6px; text-decoration: none; font-weight: 600; font-size: 14px; transition: background 0.3s ease;" onmouseover="this.style.background='#b8855a';" onmouseout="this.style.background='#c59d5f';">View Orders</a>
                    </div>

                </div>

                <!-- Table Availability Calendar Section -->
                <div style="margin-top: 60px; padding: 40px; background: white; border-radius: 15px; box-shadow: 0 4px 15px rgba(0,0,0,0.08);">
                    <div style="margin-bottom: 40px;">
                        <h2 style="color: #333; font-size: 28px; margin: 0 0 5px 0; font-weight: 700;">Table Availability Calendar</h2>
                        <p style="color: #777; font-size: 14px; margin: 0;">Check table availability for the next 30 days and plan your dining experience</p>
                    </div>

                    <!-- Filter Options -->
                    <!-- <div style="display: flex; gap: 20px; margin-bottom: 30px; flex-wrap: wrap; align-items: center;">
                        <div style="display: flex; align-items: center; gap: 10px;">
                            <label for="guestCount" style="font-weight: 600; color: #333;">Guests:</label>
                            <select id="guestCount" style="padding: 8px 15px; border: 1px solid #ddd; border-radius: 6px; font-size: 14px; cursor: pointer; background-color: white;">
                                <option value="1">1 Guest</option>
                                <option value="2" selected>2 Guests</option>
                                <option value="3">3 Guests</option>
                                <option value="4">4 Guests</option>
                                <option value="5">5 Guests</option>
                                <option value="6">6 Guests</option>
                                <option value="8">8 Guests</option>
                                <option value="10">10+ Guests</option>
                            </select>
                        </div>
                        <button id="refreshCalendar" style="padding: 10px 25px; background: #c59d5f; color: white; border: none; border-radius: 6px; font-weight: 600; cursor: pointer; transition: background 0.3s ease;" onmouseover="this.style.background='#b8855a';" onmouseout="this.style.background='#c59d5f';">
                            <i class="fas fa-sync"></i> Refresh
                        </button>
                    </div> -->

                    <!-- Legend -->
                    <div style="display: grid; grid-template-columns: repeat(auto-fit, minmax(200px, 1fr)); gap: 15px; margin-bottom: 30px; padding-bottom: 30px; border-bottom: 1px solid #eee;">
                        <div style="display: flex; align-items: center; gap: 10px;">
                            <div style="width: 20px; height: 20px; background: #27ae60; border-radius: 4px;"></div>
                            <span style="color: #333; font-size: 14px;"><strong>Available</strong> (75%+ tables free)</span>
                        </div>
                        <div style="display: flex; align-items: center; gap: 10px;">
                            <div style="width: 20px; height: 20px; background: #f39c12; border-radius: 4px;"></div>
                            <span style="color: #333; font-size: 14px;"><strong>Limited</strong> (25-75% tables)</span>
                        </div>
                        <div style="display: flex; align-items: center; gap: 10px;">
                            <div style="width: 20px; height: 20px; background: #e74c3c; border-radius: 4px;"></div>
                            <span style="color: #333; font-size: 14px;"><strong>Booked</strong> (Less than 25%)</span>
                        </div>
                        <div style="display: flex; align-items: center; gap: 10px;">
                            <div style="width: 20px; height: 20px; background: #bdc3c7; border-radius: 4px;"></div>
                            <span style="color: #333; font-size: 14px;"><strong>Closed</strong> (Sunday)</span>
                        </div>
                    </div>

                    <!-- Month Navigation and Calendar Grid -->
                    <div id="calendarContainer" style="display: none;">
                        <!-- Month Header with Navigation -->
                        <div style="display: flex; justify-content: space-between; align-items: center; margin-bottom: 30px; padding-bottom: 20px; border-bottom: 2px solid #eee;">
                            <button id="prevMonthBtn" style="padding: 10px 20px; background: #c59d5f; color: white; border: none; border-radius: 6px; font-weight: 600; cursor: pointer; font-size: 14px; transition: background 0.3s ease; display: flex; align-items: center; gap: 8px;" onmouseover="this.style.background='#b8855a';" onmouseout="this.style.background='#c59d5f';">
                                <i class="fas fa-chevron-left"></i> Previous
                            </button>
                            <h3 id="currentMonthYear" style="color: #333; font-size: 22px; margin: 0; font-weight: 700; min-width: 250px; text-align: center;">January 2026</h3>
                            <button id="nextMonthBtn" style="padding: 10px 20px; background: #c59d5f; color: white; border: none; border-radius: 6px; font-weight: 600; cursor: pointer; font-size: 14px; transition: background 0.3s ease; display: flex; align-items: center; gap: 8px;" onmouseover="this.style.background='#b8855a';" onmouseout="this.style.background='#c59d5f';">
                                Next <i class="fas fa-chevron-right"></i>
                            </button>
                        </div>

                        <!-- Day Headers (Sun, Mon, Tue, etc.) -->
                        <div id="dayHeadersContainer" style="display: grid; grid-template-columns: repeat(7, 1fr); gap: 12px; margin-bottom: 15px;">
                            <div style="text-align: center; font-weight: 700; color: #666; font-size: 14px; padding: 10px 0;">Sun</div>
                            <div style="text-align: center; font-weight: 700; color: #666; font-size: 14px; padding: 10px 0;">Mon</div>
                            <div style="text-align: center; font-weight: 700; color: #666; font-size: 14px; padding: 10px 0;">Tue</div>
                            <div style="text-align: center; font-weight: 700; color: #666; font-size: 14px; padding: 10px 0;">Wed</div>
                            <div style="text-align: center; font-weight: 700; color: #666; font-size: 14px; padding: 10px 0;">Thu</div>
                            <div style="text-align: center; font-weight: 700; color: #666; font-size: 14px; padding: 10px 0;">Fri</div>
                            <div style="text-align: center; font-weight: 700; color: #666; font-size: 14px; padding: 10px 0;">Sat</div>
                        </div>

                        <!-- Calendar Grid (7 columns for days of week) -->
                        <div id="calendarGrid" style="display: grid; grid-template-columns: repeat(7, 1fr); gap: 12px; margin-bottom: 30px;">
                            <!-- Calendar days will be populated by JavaScript -->
                        </div>
                    </div>

                    <!-- Loading State -->
                    <div id="calendarLoading" style="text-align: center; padding: 60px 20px;">
                        <div style="display: inline-block;">
                            <div class="spinner" style="border: 4px solid #f3f3f3; border-top: 4px solid #c59d5f; border-radius: 50%; width: 40px; height: 40px; animation: spin 1s linear infinite;"></div>
                        </div>
                        <p style="color: #777; margin-top: 20px; font-size: 16px;">Loading calendar availability...</p>
                    </div>

                    <!-- Error State -->
                    <div id="calendarError" style="display: none; text-align: center; padding: 40px; color: #e74c3c; background: #fadbd8; border-radius: 8px;">
                        <i class="fas fa-exclamation-triangle" style="font-size: 32px; margin-bottom: 15px; display: block;"></i>
                        <p id="calendarErrorMsg" style="font-size: 16px; margin: 0;">Unable to load calendar. Please try again.</p>
                    </div>

                    <!-- Selected Date Details -->
                    <div id="selectedDateDetails" style="display: none; padding: 30px; background: #f9f9f9; border-radius: 10px; border-left: 4px solid #c59d5f;">
                        <div style="display: flex; justify-content: space-between; align-items: start; margin-bottom: 20px;">
                            <div>
                                <h3 style="color: #333; margin: 0 0 5px 0; font-size: 20px;" id="selectedDateTitle">Date Details</h3>
                                <p style="color: #777; margin: 0; font-size: 14px;" id="selectedDateDayOfWeek">Loading...</p>
                            </div>
                            <button onclick="document.getElementById('selectedDateDetails').style.display='none';" style="background: none; border: none; font-size: 20px; color: #ccc; cursor: pointer;">✕</button>
                        </div>
                        <div style="display: grid; grid-template-columns: repeat(auto-fit, minmax(200px, 1fr)); gap: 20px;">
                            <div style="padding: 15px; background: white; border-radius: 8px; border-left: 3px solid #27ae60;">
                                <p style="color: #777; margin: 0 0 8px 0; font-size: 13px; font-weight: 600; text-transform: uppercase;">Total Tables</p>
                                <p style="color: #333; margin: 0; font-size: 24px; font-weight: 700;" id="detailTotalTables">-</p>
                            </div>
                            <div style="padding: 15px; background: white; border-radius: 8px; border-left: 3px solid #27ae60;">
                                <p style="color: #777; margin: 0 0 8px 0; font-size: 13px; font-weight: 600; text-transform: uppercase;">Available Tables</p>
                                <p style="color: #27ae60; margin: 0; font-size: 24px; font-weight: 700;" id="detailAvailableTables">-</p>
                            </div>
                            <div style="padding: 15px; background: white; border-radius: 8px; border-left: 3px solid #3498db;">
                                <p style="color: #777; margin: 0 0 8px 0; font-size: 13px; font-weight: 600; text-transform: uppercase;">Booked Tables</p>
                                <p style="color: #3498db; margin: 0; font-size: 24px; font-weight: 700;" id="detailBookedTables">-</p>
                            </div>
                            <div style="padding: 15px; background: white; border-radius: 8px; border-left: 3px solid #c59d5f;">
                                <p style="color: #777; margin: 0 0 8px 0; font-size: 13px; font-weight: 600; text-transform: uppercase;">Availability %</p>
                                <p style="color: #c59d5f; margin: 0; font-size: 24px; font-weight: 700;" id="detailPercentage">-</p>
                            </div>
                        </div>
                        <div style="margin-top: 25px;">
                            <button onclick="openBookingModal()" style="display: inline-block; background: #c59d5f; color: white; padding: 12px 35px; border-radius: 6px; text-decoration: none; font-weight: 600; font-size: 14px; transition: background 0.3s ease; border: none; cursor: pointer;" onmouseover="this.style.background='#b8855a';" onmouseout="this.style.background='#c59d5f';">
                                <i class="fas fa-calendar-check"></i> Book a Table for this Date
                            </button>
                        </div>
                    </div>
                </div>

                <!-- Booking Modal with Existing Form -->
                <div id="bookingModalContainer" style="display: none; position: fixed; top: 0; left: 0; width: 100%; height: 100%; background: rgba(0,0,0,0.5); z-index: 9999; overflow-y: auto;">
                    <div class="modal-dialog modal-lg" style="margin: 30px auto; max-width: 700px;">
                        <div class="modal-content professional-booking-modal" style="border: none; border-radius: 12px; box-shadow: 0 10px 50px rgba(0, 0, 0, 0.2);">
                            <!-- Header -->
                            <div class="modal-header professional-booking-header" style="background: linear-gradient(135deg, #d4a574 0%, #8b6f47 100%); border: none; color: white; padding: 30px; position: relative;">
                                <h5 class="modal-title" style="font-size: 28px; font-weight: 600; margin: 0; font-family: 'Raleway', sans-serif;">Reserve Your Table</h5>
                                <button type="button" class="close" onclick="closeBookingModal()" style="position: absolute; right: 20px; top: 20px; color: white; opacity: 0.8; font-size: 24px; background: none; border: none; cursor: pointer;">&times;</button>
                            </div>

                            <!-- Body with Booking Form -->
                            <div class="modal-body professional-booking-body" style="padding: 40px; background: #f9f7f4;">
                                <form id="dashboardBookingForm" class="professional-booking-form" style="background: white; padding: 30px; border-radius: 8px; box-shadow: 0 2px 10px rgba(0, 0, 0, 0.05);">
                                    <!-- Section 1: Guest Details -->
                                    <div class="booking-section" style="margin-bottom: 30px;">
                                        <h4 class="booking-section-title" style="font-size: 16px; font-weight: 600; color: #333; margin-bottom: 20px; padding-bottom: 12px; border-bottom: 2px solid #d4a574;"><i class="fa fa-user-circle"></i> Guest Details</h4>
                                        <div class="row">
                                            <div class="col-md-6">
                                                <div class="form-group">
                                                    <label for="modalBookingName">Full Name *</label>
                                                    <input type="text" class="form-control" id="modalBookingName" name="booking_name" placeholder="Enter your full name" required>
                                                    <small class="form-text text-muted">We'll use this to identify your reservation</small>
                                                </div>
                                            </div>
                                            <div class="col-md-6">
                                                <div class="form-group">
                                                    <label for="modalBookingEmail">Email Address *</label>
                                                    <input type="email" class="form-control" id="modalBookingEmail" name="booking_email" placeholder="your.email@example.com" required>
                                                    <small class="form-text text-muted">Confirmation will be sent here</small>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="row">
                                            <div class="col-md-6">
                                                <div class="form-group">
                                                    <label for="modalBookingPhone">Phone Number *</label>
                                                    <input type="tel" class="form-control" id="modalBookingPhone" name="booking_phone" placeholder="+1 (555) 000-0000" required>
                                                    <small class="form-text text-muted">Contact number for reservation</small>
                                                </div>
                                            </div>
                                            <div class="col-md-6">
                                                <div class="form-group">
                                                    <label for="modalBookingOccasion">Occasion (Optional)</label>
                                                    <select class="form-control" id="modalBookingOccasion" name="booking_occasion">
                                                        <option value="">Select an occasion</option>
                                                        <option value="birthday">Birthday Celebration</option>
                                                        <option value="anniversary">Anniversary</option>
                                                        <option value="business">Business Meeting</option>
                                                        <option value="family">Family Gathering</option>
                                                        <option value="date">Date Night</option>
                                                        <option value="other">Other</option>
                                                    </select>
                                                </div>
                                            </div>
                                        </div>
                                    </div>

                                    <hr class="booking-divider" style="margin: 30px 0; border: none; border-top: 2px solid #e8e8e8;">

                                    <!-- Section 2: Reservation Details -->
                                    <div class="booking-section" style="margin-bottom: 30px;">
                                        <h4 class="booking-section-title" style="font-size: 16px; font-weight: 600; color: #333; margin-bottom: 20px; padding-bottom: 12px; border-bottom: 2px solid #d4a574;"><i class="fa fa-calendar-alt"></i> Reservation Details</h4>
                                        <div class="row">
                                            <div class="col-md-4">
                                                <div class="form-group">
                                                    <label for="modalBookingDate">Date *</label>
                                                    <input type="date" class="form-control" id="modalBookingDate" name="booking_date" required>
                                                    <small class="form-text text-muted">Select your preferred date</small>
                                                </div>
                                            </div>
                                            <div class="col-md-4">
                                                <div class="form-group">
                                                    <label for="modalBookingTime">Time *</label>
                                                    <input type="time" class="form-control" id="modalBookingTime" name="booking_time" required>
                                                    <small class="form-text text-muted">Select your preferred time</small>
                                                </div>
                                            </div>
                                            <div class="col-md-4">
                                                <div class="form-group">
                                                    <label for="modalBookingGuests">Number of Guests *</label>
                                                    <select class="form-control" id="modalBookingGuests" name="booking_guests" required>
                                                        <option value="">Select number</option>
                                                        <option value="1">1 Person</option>
                                                        <option value="2">2 People</option>
                                                        <option value="3">3 People</option>
                                                        <option value="4">4 People</option>
                                                        <option value="5">5 People</option>
                                                        <option value="6">6 People</option>
                                                        <option value="7">7 People</option>
                                                        <option value="8">8 People</option>
                                                        <option value="10">10 People</option>
                                                        <option value="12">12 People</option>
                                                        <option value="15">15+ People</option>
                                                    </select>
                                                </div>
                                            </div>
                                        </div>
                                    </div>

                                    <!-- Form Actions -->
                                    <div class="booking-actions" style="display: flex; gap: 10px; margin-top: 30px;">
                                        <button type="button" class="btn btn-outline-secondary" onclick="closeBookingModal()" style="flex: 1; padding: 12px;">Cancel</button>
                                        <button type="submit" class="btn btn--secondary" style="flex: 1; padding: 12px; background: #d4a574; color: white; border: none; border-radius: 6px; font-weight: 600;">Complete Booking</button>
                                    </div>

                                    <!-- Booking Status Message -->
                                    <div class="alert alert-success booking-success-message" style="display: none; margin-top: 20px;">
                                        <div style="display: flex; align-items: flex-start; gap: 15px;">
                                            <div style="font-size: 24px; color: #28a745;">
                                                <i class="fa fa-check-circle"></i>
                                            </div>
                                            <div style="flex: 1;">
                                                <h5 style="margin: 0 0 10px 0; color: #155724;">Booking Confirmed!</h5>
                                                <p style="margin: 5px 0; font-size: 14px;" id="bookingConfirmation"></p>
                                                <p style="margin: 5px 0; font-size: 12px; color: #666;">Confirmation email has been sent to your email address.</p>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="alert alert-danger booking-error-message" style="display: none; margin-top: 20px;">
                                        <i class="fa fa-exclamation-circle"></i> <span class="error-message"></span>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
                <style>
                    @keyframes spin {
                        0% { transform: rotate(0deg); }
                        100% { transform: rotate(360deg); }
                    }
                </style>

                <!-- Logout Button -->
                <div style="text-align: center; margin-top: 50px;">
                    <a href="#" id="dashboardLogoutBtn" style="display: inline-block; background: #e74c3c; color: white; padding: 14px 50px; border-radius: 30px; text-decoration: none; font-weight: 600; font-size: 16px; transition: background 0.3s ease, transform 0.2s ease; cursor: pointer; border: none;" onmouseover="this.style.background='#c0392b'; this.style.transform='scale(1.05)';" onmouseout="this.style.background='#e74c3c'; this.style.transform='scale(1)';">Logout</a>
                </div>

            </div>
        </div>

        <!-- Responsive CSS for Mobile Devices -->
        <style>
            /* Calendar Grid Layout - 7 columns for days of week */
            #calendarGrid {
                grid-template-columns: repeat(7, 1fr) !important;
                gap: 12px;
                grid-auto-rows: auto;
            }

            /* Day headers - also 7 columns */
            #dayHeadersContainer {
                grid-template-columns: repeat(7, 1fr) !important;
            }

            @media (max-width: 768px) {
                .dashboard-welcome-banner {
                    padding: 30px 25px !important;
                    margin-bottom: 30px !important;
                }
                .dashboard-welcome-banner h2 {
                    font-size: 24px !important;
                }
                .dashboard-section {
                    padding: 30px 15px !important;
                }

                /* Calendar Responsive Styles */
                #calendarGrid {
                    gap: 8px !important;
                }

                #dayHeadersContainer {
                    gap: 8px !important;
                }

                /* Month navigation buttons */
                #prevMonthBtn, #nextMonthBtn {
                    padding: 8px 15px !important;
                    font-size: 13px !important;
                }

                #currentMonthYear {
                    font-size: 18px !important;
                }

                /* Calendar day cells */
                #calendarGrid > div {
                    min-height: 80px !important;
                    padding: 8px !important;
                }

                #calendarGrid > div > div:first-child {
                    font-size: 16px !important;
                }

                #calendarGrid > div > div:nth-child(2) {
                    font-size: 10px !important;
                }

                #calendarGrid > div > div:nth-child(3) {
                    font-size: 10px !important;
                }
            }

            @media (max-width: 480px) {
                .dashboard-welcome-banner {
                    padding: 25px 15px !important;
                    border-radius: 10px !important;
                }
                .dashboard-welcome-banner h2 {
                    font-size: 20px !important;
                }
                .dashboard-welcome-banner p {
                    font-size: 14px !important;
                }
                .dashboard-card-item {
                    padding: 20px !important;
                }
                .dashboard-card-item h3 {
                    font-size: 16px !important;
                }
                .dashboard-card-item p {
                    font-size: 13px !important;
                }
                .dashboard-card-item a {
                    font-size: 12px !important;
                    padding: 8px 20px !important;
                }

                /* Calendar Responsive Styles for Mobile */
                #calendarGrid {
                    gap: 6px !important;
                }

                #dayHeadersContainer {
                    gap: 6px !important;
                    margin-bottom: 12px !important;
                }

                #dayHeadersContainer > div {
                    font-size: 12px !important;
                    padding: 8px 0 !important;
                }

                /* Calendar day cells - even smaller for mobile */
                #calendarGrid > div {
                    min-height: 75px !important;
                    padding: 6px !important;
                    border-radius: 6px !important;
                }

                #calendarGrid > div > div:first-child {
                    font-size: 14px !important;
                    margin-bottom: 2px !important;
                }

                #calendarGrid > div > div:nth-child(2) {
                    font-size: 9px !important;
                    margin-bottom: 3px !important;
                }

                #calendarGrid > div > div:nth-child(3) {
                    font-size: 9px !important;
                }

                /* Month navigation - stacked on very small screens */
                #prevMonthBtn, #nextMonthBtn {
                    padding: 8px 12px !important;
                    font-size: 12px !important;
                }

                #prevMonthBtn i, #nextMonthBtn i {
                    display: none;
                }

                #currentMonthYear {
                    font-size: 16px !important;
                    min-width: 150px !important;
                }
            }

            /* Grid responsive behavior */
            @media (max-width: 1024px) {
                .dashboard-section .container {
                    max-width: 100%;
                }
            }

            /* Calendar Styles */
            #calendarGrid > div:hover {
                box-shadow: 0 8px 20px rgba(0,0,0,0.2) !important;
            }

            /* Detail Cards Grid */
            #selectedDateDetails > div:last-child {
                display: grid;
                grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
                gap: 20px;
            }

            @media (max-width: 600px) {
                #selectedDateDetails > div:last-child {
                    grid-template-columns: 1fr;
                }
            }
        </style>

        <footer id="footer" class="footer footer-premium">
            <!-- Premium Footer Widget Section -->
            <div class="footer--widget-premium">
                <div class="container">
                    <div class="row">
                        <!-- Footer Logo & Description -->
                        <div class="col-xs-12 col-sm-12 col-md-3 footer--col-about">
                            <div class="footer--logo-section">
                                <img src="assets/images/logo/logo-light.png" alt="Granny Logo" class="footer--logo">
                                <p class="footer--tagline">Crafted with passion and served with love since 2015</p>
                                <div class="footer--description">
                                    <p>Experience culinary excellence at Granny. Our award-winning chefs blend
                                        traditional flavors with modern techniques to create unforgettable dining
                                        moments.</p>
                                </div>
                            </div>
                            <!-- Follow Us Section -->
                            <div class="footer--social-icons-widget">
                                <p
                                    style="font-size: 14px; margin-top: 20px; margin-bottom: 10px; color: #c59d5f; font-weight: 600;">
                                    Follow Us</p>
                                <div class="social-icons-list">
                                    <a href="#" class="social-icon-widget" title="Facebook"><i
                                            class="fa fa-facebook"></i></a>
                                    <a href="#" class="social-icon-widget" title="Instagram"><i
                                            class="fa fa-instagram"></i></a>
                                    <a href="#" class="social-icon-widget" title="Twitter"><i
                                            class="fa fa-twitter"></i></a>
                                    <a href="#" class="social-icon-widget" title="Pinterest"><i
                                            class="fa fa-pinterest"></i></a>
                                    <a href="#" class="social-icon-widget" title="TripAdvisor"><i
                                            class="fa fa-tripadvisor"></i></a>
                                </div>
                            </div>
                        </div>
                        <!-- .col-md-3 end -->

                        <!-- Quick Links -->
                        <div class="col-xs-12 col-sm-6 col-md-3 footer--col-links">
                            <h4 class="footer--title">Quick Links</h4>
                            <ul class="footer--menu">
                                <li><a href="index.html">Home</a></li>
                                <li><a href="menu-board.html">Our Menu</a></li>
                                <li><a href="page-about.html">About Us</a></li>
                                <li><a href="page-gallery.html">Gallery</a></li>
                                <li><a href="page-contacts.html">Contact</a></li>
                                <li><a href="blog-carousel.html">Blog</a></li>
                            </ul>
                        </div>
                        <!-- .col-md-3 end -->

                        <!-- Location & Hours -->
                        <div class="col-xs-12 col-sm-6 col-md-3 footer--col-info">
                            <h4 class="footer--title">Visit Us</h4>
                            <div class="footer--info-item">
                                <i class="fa fa-map-marker"></i>
                                <div class="footer--info-content">
                                    <p><strong>Address</strong><br>22 Alnahas Building, 2 AlBahr St<br>Tanta,
                                        Al-Gharbia, Egypt</p>
                                </div>
                            </div>
                            <div class="footer--info-item">
                                <i class="fa fa-clock-o"></i>
                                <div class="footer--info-content">
                                    <p><strong>Hours</strong><br>Mon-Fri: 9:00 AM � 12:00 AM<br>Sat: 8:00 AM � 3:00
                                        AM<br>Sun: Closed</p>
                                </div>
                            </div>
                        </div>
                        <!-- .col-md-3 end -->

                        <!-- Contact -->
                        <div class="col-xs-12 col-sm-12 col-md-3 footer--col-contact">
                            <h4 class="footer--title">Connect</h4>
                            <div class="footer--contact-info">
                                <p><i class="fa fa-phone"></i> <a href="tel:+201065370701">(+20) 106-537-0701</a></p>
                                <p><i class="fa fa-envelope"></i> <a href="mailto:info@granny.com">info@granny.com</a>
                                </p>
                            </div>

                        </div>
                    </div>
                    <!-- .col-md-3 end -->
                </div>
                <!-- .row end -->
            </div>
            <!-- .container end -->
    </div>
    <!-- .footer-widget-premium end -->

    <!-- Divider -->
    <div class="footer--divider"></div>

    <!-- Premium Copyright Section -->
    <div class="footer--copyright-premium">
        <div class="container">
            <div class="row">
                <div class="col-xs-12 col-sm-12 col-md-12">
                    <div class="footer--copyright-wrapper">
                        <p class="footer--copyright-text">&copy; 2026 <strong>Granny Restaurant & Cafe</strong>. All
                            rights reserved. | Crafted with <i class="fa fa-heart"></i> for food lovers.</p>
                        <div class="footer--links-legal">
                            <a href="#">Privacy Policy</a>
                            <span class="separator">�</span>
                            <a href="#">Terms of Service</a>
                            <span class="separator">�</span>
                            <a href="#">Cookies</a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- .container end -->
    </div>
    <!-- .footer-copyright-premium end -->
    </footer>
    </div>
    <!-- #wrapper end -->

    <!-- Footer Scripts
============================================= -->
    <script data-cfasync="false" src="/cdn-cgi/scripts/5c5dd728/cloudflare-static/email-decode.min.js"></script>
    <script src="assets/js/jquery-2.2.4.min.js"></script>
    <script src="assets/js/plugins.js"></script>
    <script src="assets/js/functions.js"></script>
    <script src="assets/js/cart-manager.js"></script>
    <!-- SweetAlert2 -->
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11/dist/sweetalert2.all.min.js"></script>
    <!-- Swiper JS -->
    <script src="https://cdn.jsdelivr.net/npm/swiper@11/swiper-bundle.min.js"></script>
    <!-- Slider Init -->
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            const testimonialSlider = new Swiper('.testimonial-slider', {
                slidesPerView: 1,
                spaceBetween: 30,
                speed: 800,
                effect: 'slide',
                pagination: {
                    el: '.testimonial-slider .swiper-pagination',
                    clickable: true,
                    dynamicBullets: true,
                    dynamicMainBullets: 3
                },
                autoplay: {
                    delay: 5000,
                    disableOnInteraction: false,
                    pauseOnMouseEnter: true
                },
                easing: 'cubic-bezier(0.25, 0.46, 0.45, 0.94)',
                breakpoints: {
                    768: {
                        slidesPerView: 2,
                        spaceBetween: 25
                    },
                    1024: {
                        slidesPerView: 3,
                        spaceBetween: 30
                    }
                }
            });

            const blogSlider = new Swiper('.blog-slider', {
                slidesPerView: 1,
                spaceBetween: 30,
                speed: 800,
                effect: 'slide',
                pagination: {
                    el: '.blog-slider .swiper-pagination',
                    clickable: true,
                    dynamicBullets: true,
                    dynamicMainBullets: 3
                },
                autoplay: {
                    delay: 6000,
                    disableOnInteraction: false,
                    pauseOnMouseEnter: true
                },
                easing: 'cubic-bezier(0.25, 0.46, 0.45, 0.94)',
                breakpoints: {
                    768: {
                        slidesPerView: 2,
                        spaceBetween: 25
                    },
                    1024: {
                        slidesPerView: 3,
                        spaceBetween: 30
                    }
                }
            });
        });
    </script>
    <!-- RS5.0 Core JS Files -->
    <script src="assets/revolution/js/jquery.themepunch.tools.min.js?rev=5.0"></script>
    <script src="assets/revolution/js/jquery.themepunch.revolution.min.js?rev=5.0"></script>
    <script src="assets/revolution/js/extensions/revolution.extension.video.min.js"></script>
    <script src="assets/revolution/js/extensions/revolution.extension.slideanims.min.js"></script>
    <script src="assets/revolution/js/extensions/revolution.extension.actions.min.js"></script>
    <script src="assets/revolution/js/extensions/revolution.extension.layeranimation.min.js"></script>
    <script src="assets/revolution/js/extensions/revolution.extension.kenburn.min.js"></script>
    <script src="assets/revolution/js/extensions/revolution.extension.navigation.min.js"></script>
    <script src="assets/revolution/js/extensions/revolution.extension.migration.min.js"></script>
    <script src="assets/revolution/js/extensions/revolution.extension.parallax.min.js"></script>
    <!-- RS Configration JS Files -->
    <script src="assets/js/rsconfig.js"></script>

    <!-- Professional Table Booking Modal -->
    <div class="modal fade reservation-popup" tabindex="-1" role="dialog" id="reservationPopup">
        <div class="modal-dialog modal-lg" role="document">
            <div class="modal-content professional-booking-modal">
                <div class="modal-header professional-booking-header">
                    <div class="booking-header-content">
                        <h2 class="modal-title">Reserve Your Table</h2>
                    </div>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <i class="fa fa-times"></i>
                    </button>
                </div>
                <div class="modal-body professional-booking-body">
                    <form id="professionalBookingForm" class="professional-booking-form" method="POST" action="#">
                        <!-- Section 1: Guest Details -->
                        <div class="booking-section">
                            <h4 class="booking-section-title"><i class="fa fa-user-circle"></i> Guest Details</h4>
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="bookingName">Full Name *</label>
                                        <input type="text" class="form-control" id="bookingName"
                                            name="booking_name" placeholder="Enter your full name" required>
                                        <small class="form-text text-muted">We'll use this to identify your reservation</small>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="bookingEmail">Email Address *</label>
                                        <input type="email" class="form-control" id="bookingEmail"
                                            name="booking_email" placeholder="your.email@example.com" required>
                                        <small class="form-text text-muted">Confirmation will be sent here</small>
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="bookingPhone">Phone Number *</label>
                                        <input type="tel" class="form-control" id="bookingPhone"
                                            name="booking_phone" placeholder="+1 (555) 000-0000" required>
                                        <small class="form-text text-muted">Contact number for reservation</small>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="bookingOccasion">Occasion (Optional)</label>
                                        <select class="form-control" id="bookingOccasion" name="booking_occasion">
                                            <option value="">Select an occasion</option>
                                            <option value="birthday">Birthday Celebration</option>
                                            <option value="anniversary">Anniversary</option>
                                            <option value="business">Business Meeting</option>
                                            <option value="family">Family Gathering</option>
                                            <option value="date">Date Night</option>
                                            <option value="other">Other</option>
                                        </select>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <hr class="booking-divider">

                        <!-- Section 2: Reservation Details -->
                        <div class="booking-section">
                            <h4 class="booking-section-title"><i class="fa fa-calendar-alt"></i> Reservation Details</h4>
                            <div class="row">
                                <div class="col-md-4">
                                    <div class="form-group">
                                        <label for="bookingDate">Date *</label>
                                        <input type="date" class="form-control" id="bookingDate"
                                            name="booking_date" required>
                                        <small class="form-text text-muted">Select your preferred date</small>
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="form-group">
                                        <label for="bookingTime">Time *</label>
                                        <input type="time" class="form-control" id="bookingTime"
                                            name="booking_time" required>
                                        <small class="form-text text-muted">Select your preferred time</small>
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="form-group">
                                        <label for="bookingGuests">Number of Guests *</label>
                                        <select class="form-control" id="bookingGuests" name="booking_guests" required>
                                            <option value="">Select number</option>
                                            <option value="1">1 Person</option>
                                            <option value="2">2 People</option>
                                            <option value="3">3 People</option>
                                            <option value="4">4 People</option>
                                            <option value="5">5 People</option>
                                            <option value="6">6 People</option>
                                            <option value="7">7 People</option>
                                            <option value="8">8 People</option>
                                            <option value="10">10 People</option>
                                            <option value="12">12 People</option>
                                            <option value="15">15+ People</option>
                                        </select>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <hr class="booking-divider">

                        <!-- Section 3: Preferences & Special Requests -->
                      

                        <!-- Form Actions -->
                        <div class="booking-actions">
                            <button type="reset" class="btn btn-outline-secondary">Clear Form</button>
                            <button type="submit" class="btn btn--secondary">Complete Booking</button>
                        </div>

                        <!-- Booking Status Message -->
                        <div class="alert alert-success booking-success-message" style="display: none; margin-top: 20px;">
                            <div style="display: flex; align-items: flex-start; gap: 15px;">
                                <div style="font-size: 24px; color: #28a745;">
                                    <i class="fa fa-check-circle"></i>
                                </div>
                                <div style="flex: 1;">
                                    <h5 style="margin: 0 0 10px 0; color: #155724;">Booking Confirmed!</h5>
                                    <p style="margin: 5px 0; font-size: 14px;" id="bookingConfirmation"></p>
                                    <p style="margin: 5px 0; font-size: 12px; color: #666;">Confirmation email has been sent to your email address.</p>
                                </div>
                            </div>
                        </div>
                        <div class="alert alert-danger booking-error-message" style="display: none; margin-top: 20px;">
                            <i class="fa fa-exclamation-circle"></i> <span class="error-message"></span>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>

    <!-- Professional Booking Modal Styles -->
    <style>
        .professional-booking-modal {
            border: none;
            border-radius: 12px;
            box-shadow: 0 10px 50px rgba(0, 0, 0, 0.2);
            overflow: hidden;
        }

        .professional-booking-header {
            background: linear-gradient(135deg, #d4a574 0%, #8b6f47 100%);
            border: none;
            color: white;
            padding: 30px;
            position: relative;
        }

        .booking-header-content h2 {
            font-size: 28px;
            font-weight: 600;
            margin: 0;
            margin-bottom: 8px;
            font-family: 'Raleway', sans-serif;
        }

        .booking-subtitle {
            font-size: 14px;
            margin: 0;
            opacity: 0.95;
            font-weight: 300;
        }

        .professional-booking-header .close {
            position: absolute;
            right: 20px;
            top: 20px;
            color: white;
            opacity: 0.8;
            font-size: 24px;
        }

        .professional-booking-header .close:hover {
            opacity: 1;
        }

        .professional-booking-body {
            padding: 40px;
            background: #f9f7f4;
        }

        .professional-booking-form {
            background: white;
            padding: 30px;
            border-radius: 8px;
            box-shadow: 0 2px 10px rgba(0, 0, 0, 0.05);
        }

        .booking-section {
            margin-bottom: 30px;
        }

        .booking-section-title {
            font-size: 16px;
            font-weight: 600;
            color: #333;
            margin-bottom: 20px;
            padding-bottom: 12px;
            border-bottom: 2px solid #d4a574;
            display: flex;
            align-items: center;
            gap: 10px;
        }

        .booking-section-title i {
            color: #d4a574;
            font-size: 18px;
        }

        .booking-divider {
            margin: 30px 0;
            border: none;
            border-top: 2px solid #e8e8e8;
        }

        .professional-booking-form .form-group {
            margin-bottom: 20px;
        }

        .professional-booking-form .form-group label {
            font-weight: 600;
            color: #333;
            margin-bottom: 8px;
            font-size: 13px;
            text-transform: uppercase;
            letter-spacing: 0.5px;
        }

        .professional-booking-form .form-control {
            border: 2px solid #e8e8e8;
            border-radius: 6px;
            padding: 12px 15px;
            font-size: 14px;
            transition: all 0.3s ease;
            background: #fafafa;
        }

        .professional-booking-form .form-control:focus {
            border-color: #d4a574;
            background: white;
            box-shadow: 0 0 0 3px rgba(212, 165, 116, 0.1);
            outline: none;
        }

        .professional-booking-form .form-control::placeholder {
            color: #999;
        }

        .professional-booking-form textarea.form-control {
            resize: vertical;
            min-height: 100px;
            font-family: 'Raleway', sans-serif;
        }

        .form-text {
            font-size: 12px;
            color: #999;
            margin-top: 5px;
        }

        .booking-actions {
            display: flex !important;
            gap: 15px !important;
            margin-top: 30px !important;
            justify-content: center !important;
            flex-wrap: wrap !important;
        }

        .professional-booking-form .booking-actions button {
            padding: 14px 35px !important;
            font-weight: 700 !important;
            border-radius: 8px !important;
            font-size: 15px !important;
            transition: all 0.3s cubic-bezier(0.25, 0.46, 0.45, 0.94) !important;
            min-width: 140px !important;
            line-height: 1.6 !important;
            display: inline-flex !important;
            align-items: center !important;
            justify-content: center !important;
            text-align: center !important;
            vertical-align: middle !important;
            cursor: pointer !important;
            letter-spacing: 0.5px !important;
            text-transform: uppercase !important;
            box-shadow: 0 4px 15px rgba(0, 0, 0, 0.1) !important;
        }

        .professional-booking-form .booking-actions .btn-outline-secondary {
            border: 2px solid #d4a574 !important;
            color: #d4a574 !important;
            background: white !important;
            box-shadow: 0 2px 10px rgba(212, 165, 116, 0.15) !important;
        }

        .professional-booking-form .booking-actions .btn-outline-secondary:hover,
        .professional-booking-form .booking-actions .btn-outline-secondary:active,
        .professional-booking-form .booking-actions .btn-outline-secondary:focus {
            border-color: #8b6f47 !important;
            color: white !important;
            background: linear-gradient(135deg, #d4a574 0%, #8b6f47 100%) !important;
            box-shadow: 0 6px 20px rgba(212, 165, 116, 0.35) !important;
            transform: translateY(-3px) !important;
        }

        .professional-booking-form .booking-actions .btn--secondary {
            background: linear-gradient(135deg, #d4a574 0%, #8b6f47 100%) !important;
            color: white !important;
            border: none !important;
            box-shadow: 0 4px 15px rgba(212, 165, 116, 0.25) !important;
            position: relative !important;
            overflow: hidden !important;
        }

        .professional-booking-form .booking-actions .btn--secondary::before {
            content: '' !important;
            position: absolute !important;
            top: 0 !important;
            left: -100% !important;
            width: 100% !important;
            height: 100% !important;
            background: rgba(255, 255, 255, 0.1) !important;
            transition: left 0.3s ease !important;
            z-index: 0 !important;
        }

        .professional-booking-form .booking-actions .btn--secondary:hover::before,
        .professional-booking-form .booking-actions .btn--secondary:active::before,
        .professional-booking-form .booking-actions .btn--secondary:focus::before {
            left: 100% !important;
        }

        .professional-booking-form .booking-actions .btn--secondary:hover,
        .professional-booking-form .booking-actions .btn--secondary:active,
        .professional-booking-form .booking-actions .btn--secondary:focus {
            transform: translateY(-3px) !important;
            box-shadow: 0 8px 25px rgba(212, 165, 116, 0.4) !important;
            background: linear-gradient(135deg, #8b6f47 0%, #d4a574 100%) !important;
            color: white !important;
            border: none !important;
        }

        .professional-booking-form .booking-actions button:active {
            transform: translateY(-1px) !important;
        }

        /* Mobile Responsiveness */
        @media (max-width: 576px) {
            .booking-actions {
                flex-direction: column !important;
                gap: 12px !important;
            }

            .professional-booking-form .booking-actions button {
                width: 100% !important;
                padding: 12px 20px !important;
                font-size: 14px !important;
                min-width: unset !important;
            }
        }

        @media (max-width: 768px) {
            .professional-booking-form .booking-actions button {
                padding: 12px 28px !important;
                font-size: 14px !important;
                min-width: 130px !important;
            }
        }

        @media (min-width: 769px) and (max-width: 992px) {
            .professional-booking-form .booking-actions button {
                padding: 13px 32px !important;
                font-size: 14px !important;
                min-width: 135px !important;
            }
        }

        .alert {
            border-radius: 6px;
            border: none;
            padding: 15px 20px;
            display: flex;
            align-items: center;
            gap: 12px;
        }

        .alert-success {
            background-color: #d4edda;
            color: #155724;
        }

        .alert-danger {
            background-color: #f8d7da;
            color: #721c24;
        }

        @media (max-width: 768px) {
            .professional-booking-body {
                padding: 20px;
            }

            .professional-booking-form {
                padding: 20px;
            }

            .booking-header-content h2 {
                font-size: 22px;
            }

            .booking-actions {
                flex-direction: column;
            }

            .booking-actions button {
                width: 100%;
            }
        }
    </style>

    <!-- Professional Booking Modal Scripts -->
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            const bookingForm = document.getElementById('professionalBookingForm');
            const successMessage = document.querySelector('.booking-success-message');
            const errorMessage = document.querySelector('.booking-error-message');

            // Set minimum date to today
            const today = new Date().toISOString().split('T')[0];
            document.getElementById('bookingDate').setAttribute('min', today);

            // Form submission
            if (bookingForm) {
                bookingForm.addEventListener('submit', function(e) {
                    e.preventDefault();

                    // Reset messages
                    successMessage.style.display = 'none';
                    errorMessage.style.display = 'none';

                    // Collect form data
                    const formData = new FormData(bookingForm);
                    const data = Object.fromEntries(formData);

                    // Validate data
                    if (!data.booking_name || !data.booking_email || !data.booking_phone ||
                        !data.booking_date || !data.booking_time || !data.booking_guests) {
                        errorMessage.querySelector('.error-message').textContent = 'Please fill in all required fields.';
                        errorMessage.style.display = 'flex';
                        return;
                    }

                    // Send booking data (you can modify this to your backend API)
                    console.log('Booking Data:', data);

                    // Show success message
                    successMessage.style.display = 'flex';

                    // Optional: Reset form and close modal after delay
                    setTimeout(function() {
                        bookingForm.reset();
                        $('#reservationPopup').modal('hide');
                    }, 2000);
                });
            }

            // Clear messages when modal is closed
            $('#reservationPopup').on('hidden.bs.modal', function() {
                successMessage.style.display = 'none';
                errorMessage.style.display = 'none';
            });
        });
    </script>
    <!-- End Professional Table Booking Modal -->

    <!-- Sign In Modal -->
    <div class="modal fade" tabindex="-1" role="dialog" id="signInModal">
        <div class="modal-dialog modal-lg" role="document">
            <div class="modal-content auth-modal-content">
                <button type="button" class="close auth-close-btn" data-dismiss="modal" aria-label="Close"><i
                        class="fa fa-times"></i></button>
                <div class="auth-modal-body">
                    <div class="auth-header">
                        <h2>Welcome Back</h2>
                        <p class="auth-subtitle">Sign in to your account</p>
                    </div>
                    <div id="signinMessage" class="auth-message" style="display: none;"></div>
                    <form class="auth-form" id="signInForm">
                        <div class="auth-form-group">
                            <label for="signinEmail" class="auth-label">Email Address</label>
                            <div class="auth-input-wrapper">
                                <i class="fas fa-envelope auth-input-icon"></i>
                                <input type="email" class="auth-input" id="signinEmail" name="email" placeholder="your@email.com"
                                    required>
                            </div>
                        </div>
                        <div class="auth-form-group">
                            <label for="signinPassword" class="auth-label">Password</label>
                            <div class="auth-input-wrapper">
                                <i class="fas fa-lock auth-input-icon"></i>
                                <input type="password" class="auth-input" id="signinPassword" name="password" placeholder="*********"
                                    required>
                            </div>
                        </div>
                        <div class="auth-form-group auth-remember">
                            <input type="checkbox" id="rememberMe" name="rememberMe">
                            <label for="rememberMe" class="auth-checkbox-label">Remember me</label>
                        </div>
                        <button type="submit" class="auth-btn">Sign In</button>
                    </form>
                    <div class="auth-divider">
                        <span>Don't have an account?</span>
                    </div>
                    <p class="auth-footer">
                        <a href="#" data-toggle="modal" data-dismiss="modal" data-target="#signUpModal"
                            class="auth-link">Create a new account</a>
                    </p>
                </div>
            </div>
        </div>
    </div>
    <!-- End Sign In Modal -->

    <!-- Sign Up Modal -->
    <div class="modal fade" tabindex="-1" role="dialog" id="signUpModal">
        <div class="modal-dialog modal-lg" role="document">
            <div class="modal-content auth-modal-content">
                <button type="button" class="close auth-close-btn" data-dismiss="modal" aria-label="Close"><i
                        class="fa fa-times"></i></button>
                <div class="auth-modal-body">
                    <div class="auth-header">
                        <h2>Create Account</h2>
                        <p class="auth-subtitle">Join us today</p>
                    </div>
                    <div id="signupMessage" class="auth-message" style="display: none;"></div>
                    <form class="auth-form" id="signUpForm">
                        <div class="auth-form-group">
                            <label for="signupName" class="auth-label">Full Name</label>
                            <div class="auth-input-wrapper">
                                <i class="fas fa-user auth-input-icon"></i>
                                <input type="text" class="auth-input" id="signupName" name="name" placeholder="John Doe" required>
                            </div>
                        </div>
                        <div class="auth-form-group">
                            <label for="signupEmail" class="auth-label">Email Address</label>
                            <div class="auth-input-wrapper">
                                <i class="fas fa-envelope auth-input-icon"></i>
                                <input type="email" class="auth-input" id="signupEmail" name="email" placeholder="your@email.com"
                                    required>
                            </div>
                        </div>
                        <div class="auth-form-group">
                            <label for="signupPassword" class="auth-label">Password</label>
                            <div class="auth-input-wrapper">
                                <i class="fas fa-lock auth-input-icon"></i>
                                <input type="password" class="auth-input" id="signupPassword" name="password" placeholder="*********"
                                    required>
                            </div>
                        </div>
                        <div class="auth-form-group">
                            <label for="signupConfirmPassword" class="auth-label">Confirm Password</label>
                            <div class="auth-input-wrapper">
                                <i class="fas fa-check-circle auth-input-icon"></i>
                                <input type="password" class="auth-input" id="signupConfirmPassword" name="confirmPassword"
                                    placeholder="*********" required>
                            </div>
                        </div>
                        <div class="auth-form-group auth-checkbox">
                            <input type="checkbox" id="agreeTerms" required>
                            <label for="agreeTerms" class="auth-checkbox-label">I agree to the <a href="#"
                                    class="auth-link-inline">Terms & Conditions</a></label>
                        </div>
                        <button type="submit" class="auth-btn">Create Account</button>
                    </form>
                    <div class="auth-divider">
                        <span>Already have an account?</span>
                    </div>
                    <p class="auth-footer">
                        <a href="#" data-toggle="modal" data-dismiss="modal" data-target="#signInModal"
                            class="auth-link">Sign In here</a>
                    </p>
                </div>
            </div>
        </div>
    </div>
    <!-- End Sign Up Modal -->

    <!-- Backend Integration Scripts -->
    <style>
        .auth-message {
            padding: 12px;
            border-radius: 6px;
            margin-bottom: 20px;
            font-weight: 500;
            display: flex;
            align-items: center;
            gap: 10px;
        }

        .auth-message.success {
            background: #d4edda;
            color: #155724;
            border: 1px solid #c3e6cb;
        }

        .auth-message.error {
            background: #f8d7da;
            color: #721c24;
            border: 1px solid #f5c6cb;
        }
    </style>
   

    <script>
        // Update header with user profile
        function updateHeaderWithUserProfile(userData) {
            // Desktop header auth section
            const navAuthSection = document.getElementById('navAuthSection');
            const navUserProfileDropdown = document.getElementById('navUserProfileDropdown');
            const navUserName = document.getElementById('navUserName');
            
            // Mobile auth section (inside menu)
            const mobileAuthSection = document.getElementById('mobileAuthSection');
            const mobileUserProfileSection = document.getElementById('mobileUserProfileSection');
            
            // Mobile profile icon (next to hamburger)
            const mobileProfileIconContainer = document.getElementById('mobileProfileIconContainer');
            const mobileUserName = document.getElementById('mobileUserName');
            
            // Hide sign in/sign up buttons (desktop)
            if (navAuthSection) {
                navAuthSection.style.display = 'none';
            }
            
            // Show user profile dropdown with username (desktop)
            if (navUserProfileDropdown) {
                navUserProfileDropdown.style.display = 'inline-block';
                navUserName.textContent = userData.name || userData.email;
            }
            
            // Hide mobile auth buttons inside hamburger menu and show mobile user profile
            if (mobileAuthSection) {
                mobileAuthSection.classList.add('hide-auth');
            }
            if (mobileUserProfileSection) {
                mobileUserProfileSection.style.display = 'block';
            }
            
            // Show mobile profile icon next to hamburger
            if (mobileProfileIconContainer) {
                mobileProfileIconContainer.classList.add('show');
                // Remove inline style to let CSS handle it
                mobileProfileIconContainer.style.display = '';
            }
            
            // Set mobile username
            if (mobileUserName) {
                mobileUserName.textContent = userData.name || userData.email;
            }
            
            console.log('Header updated for user:', userData.name);
        }


        // Check if user is already logged in on page load
        document.addEventListener('DOMContentLoaded', function() {
            const user = localStorage.getItem('user');
            if (user) {
                try {
                    const userData = JSON.parse(user);
                    updateHeaderWithUserProfile(userData);
                    console.log('User already logged in:', userData.name);
                } catch (e) {
                    console.error('Error parsing user data:', e);
                }
            }
        });

        // Reset header to show auth buttons (used on logout)
        function resetHeaderAuthSection() {
            // Desktop header auth section
            const navAuthSection = document.getElementById('navAuthSection');
            const navUserProfileDropdown = document.getElementById('navUserProfileDropdown');
            
            // Mobile auth section
            const mobileAuthSection = document.getElementById('mobileAuthSection');
            const mobileUserProfileSection = document.getElementById('mobileUserProfileSection');
            
            // Mobile profile icon (next to hamburger)
            const mobileProfileIconContainer = document.getElementById('mobileProfileIconContainer');
            
            // Show sign in/sign up buttons (desktop)
            if (navAuthSection) {
                navAuthSection.style.display = 'flex';
            }
            
            // Hide user profile dropdown (desktop)
            if (navUserProfileDropdown) {
                navUserProfileDropdown.style.display = 'none';
            }
            
            // Show mobile auth buttons and hide mobile user profile
            if (mobileAuthSection) {
                mobileAuthSection.classList.remove('hide-auth');
            }
            if (mobileUserProfileSection) {
                mobileUserProfileSection.style.display = 'none';
            }
            
            // Hide mobile profile icon
            if (mobileProfileIconContainer) {
                mobileProfileIconContainer.classList.remove('show');
                mobileProfileIconContainer.style.display = 'none';
            }
            
            console.log('Header reset to show auth buttons');
        }

        // Logout function
        function logout() {
            console.log('Logout function called');
            // Remove user data from localStorage first
            localStorage.removeItem('user');
            // Clear cart from localStorage on logout
            localStorage.removeItem('granny_cart');
            
            fetch('backend/logout.php')
            .then(response => response.json())
            .then(data => {
                console.log('Logout response:', data);
                if (data.success) {
                    // Redirect to index page after logout is complete
                    setTimeout(() => {
                        window.location.href = 'index.php';
                    }, 500);
                }
            })
            .catch(error => {
                console.error('Logout error:', error);
                // Still logout on client side even if server fails
                setTimeout(() => {
                    window.location.href = 'index.php';
                }, 500);
            });
        }

        // Logout button click handler
        document.addEventListener('DOMContentLoaded', function() {
            const logoutBtn = document.getElementById('navLogoutBtn');
            const mobileLogoutBtn = document.getElementById('mobileLogoutBtn');
            const mobileProfileLogoutBtn = document.getElementById('mobileProfileLogoutBtn');
            
            if (logoutBtn) {
                logoutBtn.addEventListener('click', function(e) {
                    e.preventDefault();
                    logout();
                });
            }
            
            if (mobileLogoutBtn) {
                mobileLogoutBtn.addEventListener('click', function(e) {
                    e.preventDefault();
                    logout();
                });
            }
            
            if (mobileProfileLogoutBtn) {
                mobileProfileLogoutBtn.addEventListener('click', function(e) {
                    e.preventDefault();
                    logout();
                });
            }
        });

        // Sign Up Handler
        document.getElementById('signUpForm').addEventListener('submit', function(e) {
            e.preventDefault();

            const formData = {
                name: document.getElementById('signupName').value,
                email: document.getElementById('signupEmail').value,
                password: document.getElementById('signupPassword').value,
                confirmPassword: document.getElementById('signupConfirmPassword').value
            };

            const messageDiv = document.getElementById('signupMessage');

            fetch('backend/signup.php', {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json'
                },
                body: JSON.stringify(formData)
            })
            .then(response => response.json())
            .then(data => {
                messageDiv.style.display = 'flex';
                if (data.success) {
                    messageDiv.className = 'auth-message success';
                    messageDiv.innerHTML = '<i class="fas fa-check-circle"></i> ' + data.message + ' Please sign in to continue.';
                    
                    // Clear form
                    document.getElementById('signUpForm').reset();
                    
                    // Do NOT store user data in localStorage - user must sign in first
                    
                    // Close sign up modal and open sign in modal
                    setTimeout(() => {
                        $('#signUpModal').modal('hide');
                        messageDiv.style.display = 'none';
                        // Show sign in modal after a short delay
                        setTimeout(() => {
                            $('#signInModal').modal('show');
                        }, 500);
                    }, 2000);
                } else {
                    messageDiv.className = 'auth-message error';
                    messageDiv.innerHTML = '<i class="fas fa-exclamation-circle"></i> ' + data.message;
                }
            })
            .catch(error => {
                messageDiv.style.display = 'flex';
                messageDiv.className = 'auth-message error';
                messageDiv.innerHTML = '<i class="fas fa-exclamation-circle"></i> Error: ' + error.message;
                console.error('Error:', error);
            });
        });

        // Sign In Handler
        document.getElementById('signInForm').addEventListener('submit', function(e) {
            e.preventDefault();

            const formData = {
                email: document.getElementById('signinEmail').value,
                password: document.getElementById('signinPassword').value,
                rememberMe: document.getElementById('rememberMe').checked
            };

            const messageDiv = document.getElementById('signinMessage');

            fetch('backend/signin.php', {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json'
                },
                body: JSON.stringify(formData)
            })
            .then(response => response.json())
            .then(data => {
                messageDiv.style.display = 'flex';
                if (data.success) {
                    messageDiv.className = 'auth-message success';
                    messageDiv.innerHTML = '<i class="fas fa-check-circle"></i> ' + data.message;
                    
                    // Clear form
                    document.getElementById('signInForm').reset();
                    
                    // Store user data in localStorage
                    localStorage.setItem('user', JSON.stringify(data.data));
                    
                    // Close modal
                    setTimeout(() => {
                        $('#signInModal').modal('hide');
                        messageDiv.style.display = 'none';
                        // Update header with user profile
                        updateHeaderWithUserProfile(data.data);
                        // Refresh page after successful sign-in
                        setTimeout(() => {
                            window.location.reload();
                        }, 500);
                    }, 2000);
                } else {
                    messageDiv.className = 'auth-message error';
                    messageDiv.innerHTML = '<i class="fas fa-exclamation-circle"></i> ' + data.message;
                }
            })
            .catch(error => {
                messageDiv.style.display = 'flex';
                messageDiv.className = 'auth-message error';
                messageDiv.innerHTML = '<i class="fas fa-exclamation-circle"></i> Error: ' + error.message;
                console.error('Error:', error);
            });
        });

        // Booking Handler
        document.getElementById('professionalBookingForm').addEventListener('submit', function(e) {
            e.preventDefault();

            const formData = {
                booking_name: document.getElementById('bookingName')?.value || '',
                booking_email: document.getElementById('bookingEmail')?.value || '',
                booking_phone: document.getElementById('bookingPhone')?.value || '',
                booking_date: document.getElementById('bookingDate')?.value || '',
                booking_time: document.getElementById('bookingTime')?.value || '',
                booking_guests: document.getElementById('bookingGuests')?.value || '',
                booking_occasion: document.getElementById('bookingOccasion')?.value || '',
                booking_table_type: document.getElementById('bookingTableType')?.value || '',
                booking_dietary: document.getElementById('bookingDietaryNeeds')?.value || '',
                booking_special_requests: document.getElementById('bookingSpecialRequests')?.value || ''
            };

            const successMessage = document.querySelector('.booking-success-message');
            const errorMessage = document.querySelector('.booking-error-message');

            console.log('Sending booking data:', formData);
            
            // Validate required fields
            if (!formData.booking_name || !formData.booking_email || !formData.booking_phone || !formData.booking_date || !formData.booking_time || !formData.booking_guests) {
                errorMessage.style.display = 'flex';
                errorMessage.querySelector('.error-message').textContent = 'Please fill in all required fields';
                successMessage.style.display = 'none';
                console.error('Validation failed: Missing required fields');
                return;
            }

            fetch('backend/booking.php', {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json'
                },
                body: JSON.stringify(formData)
            })
            .then(response => {
                console.log('Response status:', response.status);
                return response.json();
            })
            .then(data => {
                console.log('Booking response:', data);
                if (data.success) {
                    successMessage.style.display = 'flex';
                    errorMessage.style.display = 'none';
                    
                    // Update confirmation message with booking details
                    const confirmationDiv = document.getElementById('bookingConfirmation');
                    if (confirmationDiv && data.data) {
                        confirmationDiv.innerHTML = `
                            <strong>Booking ID:</strong> #${data.data.booking_id}<br>
                            <strong>Date:</strong> ${data.data.booking_date} at ${data.data.booking_time}<br>
                            <strong>Guests:</strong> ${data.data.guests} person(s)
                        `;
                    }
                    
                    // Store booking data
                    localStorage.setItem('lastBooking', JSON.stringify(data.data));
                    console.log('Booking saved to localStorage:', data.data);
                    
                    // Reset and close
                    setTimeout(() => {
                        document.getElementById('professionalBookingForm').reset();
                        $('#reservationPopup').modal('hide');
                        successMessage.style.display = 'none';
                        confirmationDiv.innerHTML = '';
                    }, 3500);
                } else {
                    errorMessage.style.display = 'flex';
                    errorMessage.querySelector('.error-message').textContent = data.message;
                    successMessage.style.display = 'none';
                    console.error('Booking error:', data.message);
                }
            })
            .catch(error => {
                errorMessage.style.display = 'flex';
                errorMessage.querySelector('.error-message').textContent = 'Error: ' + error.message;
                successMessage.style.display = 'none';
                console.error('Fetch error:', error);
            });
        });

        // Initialize user session on page load
        document.addEventListener('DOMContentLoaded', function() {
            const user = localStorage.getItem('user');
            if (user) {
                const userData = JSON.parse(user);
                console.log('User logged in:', userData);
                
                // Update dashboard banner with user information
                const dashboardUserNameBanner = document.getElementById('dashboardUserNameBanner');
                const dashboardUserEmailBanner = document.getElementById('dashboardUserEmailBanner');
                
                if (dashboardUserNameBanner) {
                    dashboardUserNameBanner.textContent = userData.name || userData.email || 'User';
                }
                if (dashboardUserEmailBanner) {
                    dashboardUserEmailBanner.textContent = userData.email || 'user@email.com';
                }
                
                // Header is already updated by the earlier DOMContentLoaded event
            }

            // Add dashboard logout button handler
            const dashboardLogoutBtn = document.getElementById('dashboardLogoutBtn');
            if (dashboardLogoutBtn) {
                dashboardLogoutBtn.addEventListener('click', function(e) {
                    e.preventDefault();
                    logout();
                });
            }

            // Load Calendar Availability
            loadTableAvailabilityCalendar();
        });

        // Calendar Functions
        // Calendar state
        let calendarData = {};
        let currentDisplayMonth = new Date();

        function loadTableAvailabilityCalendar() {
            const guestCount = document.getElementById('guestCount')?.value || '2';
            
            // Show loading state
            document.getElementById('calendarLoading').style.display = 'block';
            document.getElementById('calendarContainer').style.display = 'none';
            document.getElementById('calendarError').style.display = 'none';

            fetch('backend/get_calendar_availability.php?guests=' + guestCount)
                .then(response => response.json())
                .then(data => {
                    if (data.success && data.data) {
                        document.getElementById('calendarLoading').style.display = 'none';
                        document.getElementById('calendarContainer').style.display = 'block';
                        calendarData = data.data;
                        currentDisplayMonth = new Date();
                        renderMonthCalendar();
                        setupMonthNavigation();
                    } else {
                        throw new Error(data.message || 'Failed to load calendar');
                    }
                })
                .catch(error => {
                    console.error('Error loading calendar:', error);
                    document.getElementById('calendarLoading').style.display = 'none';
                    document.getElementById('calendarError').style.display = 'block';
                    document.getElementById('calendarErrorMsg').textContent = 'Unable to load calendar: ' + error.message;
                });
        }

        function renderMonthCalendar() {
            const year = currentDisplayMonth.getFullYear();
            const month = currentDisplayMonth.getMonth();

            // Update month/year header
            const monthYearStr = currentDisplayMonth.toLocaleDateString('en-US', { month: 'long', year: 'numeric' });
            document.getElementById('currentMonthYear').textContent = monthYearStr;

            // Get first day of month and number of days in month
            const firstDay = new Date(year, month, 1).getDay();
            const daysInMonth = new Date(year, month + 1, 0).getDate();

            const calendarGrid = document.getElementById('calendarGrid');
            calendarGrid.innerHTML = ''; // Clear existing content

            // Create date cells for all positions in the calendar (including empty cells for days before month starts)
            const totalCells = 42; // 6 rows × 7 columns

            for (let i = 0; i < totalCells; i++) {
                const dayNumber = i - firstDay + 1;
                const dayElement = document.createElement('div');

                if (dayNumber < 1 || dayNumber > daysInMonth) {
                    // Empty cell for days outside the current month
                    dayElement.style.cssText = `
                        background: #f5f5f5;
                        border-radius: 8px;
                        min-height: 90px;
                    `;
                } else {
                    // Create date string for this day (without UTC conversion)
                    const pad = (num) => String(num).padStart(2, '0');
                    const dateStr = `${year}-${pad(month + 1)}-${pad(dayNumber)}`;
                    const dateData = calendarData[dateStr];

                    if (dateData) {
                        // Determine color based on status
                        let backgroundColor = '#bdc3c7'; // closed (gray)
                        let borderColor = '#95a5a6';
                        let textColor = '#fff';

                        if (dateData.status === 'available') {
                            backgroundColor = '#27ae60'; // green
                            borderColor = '#229954';
                        } else if (dateData.status === 'limited') {
                            backgroundColor = '#f39c12'; // orange
                            borderColor = '#d68910';
                        } else if (dateData.status === 'booked') {
                            backgroundColor = '#e74c3c'; // red
                            borderColor = '#c0392b';
                        }

                        dayElement.style.cssText = `
                            background: ${backgroundColor};
                            border: 2px solid ${borderColor};
                            border-radius: 8px;
                            padding: 12px;
                            text-align: center;
                            cursor: ${dateData.status === 'closed' ? 'not-allowed' : 'pointer'};
                            transition: all 0.3s ease;
                            position: relative;
                            min-height: 90px;
                            display: flex;
                            flex-direction: column;
                            justify-content: center;
                            opacity: ${dateData.status === 'closed' ? '0.6' : '1'};
                        `;

                        dayElement.innerHTML = `
                            <div style="color: ${textColor}; font-weight: 700; font-size: 20px; margin-bottom: 4px;">${dayNumber}</div>
                            <div style="color: ${textColor}; font-size: 12px; font-weight: 600; margin-bottom: 6px;">
                                ${dateData.status === 'closed' ? 'CLOSED' : (dateData.available_tables + '/' + dateData.total_tables)}
                            </div>
                            <div style="color: ${textColor}; font-size: 11px; opacity: 0.9;">
                                ${dateData.status === 'closed' ? '' : dateData.percentage.toFixed(0) + '% Free'}
                            </div>
                        `;

                        if (dateData.status !== 'closed') {
                            dayElement.addEventListener('mouseenter', function() {
                                this.style.transform = 'translateY(-5px)';
                                this.style.boxShadow = '0 8px 20px rgba(0,0,0,0.15)';
                            });

                            dayElement.addEventListener('mouseleave', function() {
                                this.style.transform = 'translateY(0)';
                                this.style.boxShadow = 'none';
                            });

                            dayElement.addEventListener('click', function() {
                                showDateDetails(dateStr, dateData);
                            });
                        }
                    } else {
                        // Date not in data (outside 30-day range)
                        dayElement.style.cssText = `
                            background: #f5f5f5;
                            border: 2px dashed #ddd;
                            border-radius: 8px;
                            padding: 12px;
                            text-align: center;
                            min-height: 90px;
                            display: flex;
                            flex-direction: column;
                            justify-content: center;
                            opacity: 0.5;
                        `;

                        dayElement.innerHTML = `
                            <div style="color: #999; font-weight: 700; font-size: 20px; margin-bottom: 4px;">${dayNumber}</div>
                            <div style="color: #aaa; font-size: 11px;">No Data</div>
                        `;
                    }
                }

                calendarGrid.appendChild(dayElement);
            }
        }

        function setupMonthNavigation() {
            const prevBtn = document.getElementById('prevMonthBtn');
            const nextBtn = document.getElementById('nextMonthBtn');

            if (prevBtn) {
                prevBtn.onclick = function() {
                    currentDisplayMonth.setMonth(currentDisplayMonth.getMonth() - 1);
                    renderMonthCalendar();
                };
            }

            if (nextBtn) {
                nextBtn.onclick = function() {
                    currentDisplayMonth.setMonth(currentDisplayMonth.getMonth() + 1);
                    renderMonthCalendar();
                };
            }
        }

        function showDateDetails(dateStr, data) {
            // Parse date string (YYYY-MM-DD) without UTC conversion
            const [year, month, day] = dateStr.split('-').map(Number);
            // Create a date object for local timezone (midnight)
            const date = new Date(year, month - 1, day);
            const dayOfWeek = date.toLocaleDateString('en-US', { weekday: 'long', year: 'numeric', month: 'long', day: 'numeric' });

            document.getElementById('selectedDateTitle').textContent = dayOfWeek;
            document.getElementById('selectedDateDayOfWeek').textContent = `Table availability for ${data.total_tables} tables`;
            document.getElementById('detailTotalTables').textContent = data.total_tables;
            document.getElementById('detailAvailableTables').textContent = data.available_tables;
            document.getElementById('detailBookedTables').textContent = (data.total_tables - data.available_tables);
            document.getElementById('detailPercentage').textContent = data.percentage.toFixed(1) + '%';

            document.getElementById('selectedDateDetails').style.display = 'block';
            // Scroll to details
            setTimeout(() => {
                document.getElementById('selectedDateDetails').scrollIntoView({ behavior: 'smooth', block: 'center' });
            }, 100);
        }

        // Store selected date globally for booking form
        let selectedBookingDate = null;

        // Function to open booking modal
        function openBookingModal() {
            const dateTitle = document.getElementById('selectedDateTitle').textContent;
            
            // Pre-fill form with user data
            const user = localStorage.getItem('user');
            if (user) {
                try {
                    const userData = JSON.parse(user);
                    document.getElementById('modalBookingName').value = userData.name || '';
                    document.getElementById('modalBookingEmail').value = userData.email || '';
                    document.getElementById('modalBookingPhone').value = userData.phone || '';
                } catch (e) {
                    console.error('Error parsing user data:', e);
                }
            }

            // Extract date from selectedDateTitle if in format "Monday, February 26, 2026"
            if (dateTitle && dateTitle.includes(',')) {
                const dateObj = new Date(dateTitle);
                if (!isNaN(dateObj)) {
                    const year = dateObj.getFullYear();
                    const month = String(dateObj.getMonth() + 1).padStart(2, '0');
                    const day = String(dateObj.getDate()).padStart(2, '0');
                    document.getElementById('modalBookingDate').value = `${year}-${month}-${day}`;
                }
            }

            // Set a default time (e.g., 7:00 PM)
            if (!document.getElementById('modalBookingTime').value) {
                document.getElementById('modalBookingTime').value = '19:00';
            }

            // Clear previous messages
            document.querySelector('.booking-success-message').style.display = 'none';
            document.querySelector('.booking-error-message').style.display = 'none';

            // Show modal
            document.getElementById('bookingModalContainer').style.display = 'block';
            document.body.style.overflow = 'hidden';
        }

        // Function to close booking modal
        function closeBookingModal() {
            document.getElementById('bookingModalContainer').style.display = 'none';
            document.body.style.overflow = 'auto';
            document.getElementById('dashboardBookingForm').reset();
        }

        // Close modal when clicking outside
        document.addEventListener('DOMContentLoaded', function() {
            const modal = document.getElementById('bookingModalContainer');
            if (modal) {
                window.addEventListener('click', function(event) {
                    if (event.target === modal) {
                        closeBookingModal();
                    }
                });
            }
        });

        // Handle booking form submission
        document.addEventListener('DOMContentLoaded', function() {
            const bookingForm = document.getElementById('dashboardBookingForm');
            if (bookingForm) {
                bookingForm.addEventListener('submit', async function(e) {
                    e.preventDefault();

                    const bookingData = {
                        booking_name: document.getElementById('modalBookingName').value.trim(),
                        booking_email: document.getElementById('modalBookingEmail').value.trim(),
                        booking_phone: document.getElementById('modalBookingPhone').value.trim(),
                        booking_date: document.getElementById('modalBookingDate').value,
                        booking_time: document.getElementById('modalBookingTime').value,
                        booking_guests: parseInt(document.getElementById('modalBookingGuests').value),
                        booking_occasion: document.getElementById('modalBookingOccasion').value || null
                    };

                    const successMsg = document.querySelector('.booking-success-message');
                    const errorMsg = document.querySelector('.booking-error-message');
                    const submitBtn = bookingForm.querySelector('button[type="submit"]');
                    
                    try {
                        submitBtn.disabled = true;
                        submitBtn.style.opacity = '0.6';
                        submitBtn.textContent = 'Processing...';

                        const response = await fetch('backend/booking.php', {
                            method: 'POST',
                            headers: {
                                'Content-Type': 'application/json'
                            },
                            body: JSON.stringify(bookingData)
                        });

                        const data = await response.json();

                        if (data.success) {
                            successMsg.style.display = 'block';
                            errorMsg.style.display = 'none';
                            document.getElementById('bookingConfirmation').textContent = data.data.confirmation_message;

                            // Show success alert
                            Swal.fire({
                                icon: 'success',
                                title: 'Booking Confirmed!',
                                text: data.data.confirmation_message,
                                confirmButtonColor: '#c59d5f'
                            }).then(() => {
                                closeBookingModal();
                                // Reload calendar to refresh availability
                                loadTableAvailabilityCalendar();
                            });

                            // Reset form
                            bookingForm.reset();
                        } else {
                            errorMsg.style.display = 'block';
                            successMsg.style.display = 'none';
                            errorMsg.querySelector('.error-message').textContent = data.message;
                        }
                    } catch (error) {
                        errorMsg.style.display = 'block';
                        successMsg.style.display = 'none';
                        errorMsg.querySelector('.error-message').textContent = 'Error: ' + error.message;
                        console.error('Booking error:', error);
                    } finally {
                        submitBtn.disabled = false;
                        submitBtn.style.opacity = '1';
                        submitBtn.textContent = 'Complete Booking';
                    }
                });
            }
        });

        // Add event listeners for filter controls
        document.getElementById('guestCount')?.addEventListener('change', function() {
            loadTableAvailabilityCalendar();
        });

        document.getElementById('refreshCalendar')?.addEventListener('click', function() {
            loadTableAvailabilityCalendar();
        });
    </script>

</body>

</html>
