﻿<?php session_start(); ?>
<!DOCTYPE html>
<html dir="ltr" lang="en-US">

<head>
    <!-- Document Meta
    ============================================= -->
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <!--IE Compatibility Meta-->
    <meta name="author" content="zytheme">
    <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1">
    <meta name="description" content="Elegant Restaurant & Cafe Html5 Template">
    <link href="assets/images/favicon/favicon.png" rel="icon">

    <!-- Fonts
    ============================================= -->
    <link
        href="../css?family=Great+Vibes%7CKaushan+Script%7CRaleway:100,100i,200,200i,300,300i,400,400i,500,500i,600,600i,700,700i,800,800i,900,900i"
        rel="stylesheet" type="text/css">

    <!-- Font Awesome Icons -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">

    <!-- SweetAlert2 CSS -->
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/sweetalert2@11/dist/sweetalert2.min.css">

    <!-- Stylesheets
    ============================================= -->
    <link href="assets/css/external.css" rel="stylesheet">
    <link href="assets/css/bootstrap.min.css" rel="stylesheet">
    <link href="assets/css/style.css" rel="stylesheet">
    <!-- HTML5 shim, for IE6-8 support of HTML5 elements. All other JS at the end of file. -->
    <!--[if lt IE 9]>
      <script src="assets/js/html5shiv.js"></script>
      <script src="assets/js/respond.min.js"></script>
    <![endif]-->

    <!-- Document Title
    ============================================= -->
    <title>Contact Us</title>

    <!-- Contact Page Styles
    ============================================= -->
    <style>
        /* Contact Hero Section */

        .contact-hero-simple {
            position: relative;
            height: 400px;
            display: flex;
            align-items: center;
            justify-content: flex-start;
            overflow: hidden;
            min-height: 350px;
        }

        .hero-bg-wrapper {
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            z-index: 1;
        }

        .hero-bg-image {
            width: 100%;
            height: 100%;
            object-fit: cover;
            filter: brightness(0.5) saturate(1.2) contrast(1.1);
        }

        .hero-bg-overlay {
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background: linear-gradient(135deg, rgba(44, 24, 16, 0.6) 0%, rgba(44, 24, 16, 0.4) 100%);
            z-index: 2;
        }

        .hero-content-wrapper {
            position: relative;
            z-index: 3;
            text-align: left;
            width: 100%;
            max-width: 100%;
            padding: 0 40px;
            display: flex;
            flex-direction: column;
            justify-content: center;
            height: 100%;
        }

        .hero-simple-title {
            font-size: 72px;
            font-weight: 700;
            color: #ffffff;
            margin: 0 0 25px 0;
            font-family: 'Raleway', sans-serif;
            text-shadow: 0 3px 15px rgba(0, 0, 0, 0.4);
            letter-spacing: 1px;
            animation: fadeInLeft 0.8s ease-out;
            line-height: 1.1;
            word-wrap: break-word;
        }

        .hero-breadcrumb {
            display: flex;
            align-items: center;
            gap: 15px;
            animation: fadeInLeft 0.8s ease-out 0.2s both;
            flex-wrap: wrap;
        }

        .breadcrumb-link {
            color: #d4a574;
            text-decoration: none;
            font-size: 14px;
            font-weight: 600;
            display: flex;
            align-items: center;
            gap: 8px;
            transition: all 0.3s ease;
            letter-spacing: 0.5px;
            white-space: nowrap;
        }

        .breadcrumb-link:hover {
            color: #e8c9a0;
            transform: translateX(5px);
        }

        .breadcrumb-link i {
            font-size: 16px;
        }

        .breadcrumb-separator {
            color: rgba(232, 201, 160, 0.6);
            font-size: 14px;
            font-weight: 600;
            white-space: nowrap;
        }

        .breadcrumb-current {
            color: rgba(255, 255, 255, 0.8);
            font-size: 14px;
            font-weight: 500;
            letter-spacing: 0.5px;
            white-space: nowrap;
        }

        @keyframes fadeInLeft {
            from {
                opacity: 0;
                transform: translateX(-30px);
            }

            to {
                opacity: 1;
                transform: translateX(0);
            }
        }


        /* Contact Section */
        .contact-section {
            padding: 80px 0;
            background-color: #ffffff;
        }

        .contact-header {
            text-align: center;
            margin-bottom: 60px;
        }

        .contact-header h2 {
            font-family: 'Great Vibes', cursive;
            font-size: 48px;
            font-weight: 400;
            color: #c59d5f;
            margin: 0 0 15px 0;
            letter-spacing: 0.5px;
        }

        .contact-header p {
            font-size: 16px;
            color: #666666;
            margin: 0;
            font-weight: 300;
        }

        /* Contact Content */
        .contact-content {
            width: 100%;
        }

        /* Contact Info Cards */
        .contact-info-card {
            background: #f9f7f4;
            padding: 40px 30px;
            border-radius: 8px;
            text-align: center;
            transition: all 0.3s ease;
            height: 100%;
            display: flex;
            flex-direction: column;
            margin-bottom: 30px;
        }

        .contact-info-card:hover {
            background: #f0ede9;
            transform: translateY(-5px);
            box-shadow: 0 8px 20px rgba(0, 0, 0, 0.1);
        }

        .contact-info-icon {
            font-size: 48px;
            color: #c59d5f;
            margin-bottom: 20px;
            animation: float 3s ease-in-out infinite;
        }

        @keyframes float {

            0%,
            100% {
                transform: translateY(0px);
            }

            50% {
                transform: translateY(-10px);
            }
        }

        .contact-info-title {
            font-size: 22px;
            font-weight: 600;
            color: #333333;
            margin: 0 0 15px 0;
        }

        .contact-info-text {
            font-size: 14px;
            color: #666666;
            line-height: 1.8;
            margin-bottom: 20px;
            flex-grow: 1;
        }

        .contact-info-link {
            font-size: 14px;
            color: #c59d5f;
            font-weight: 600;
            text-decoration: none;
            display: inline-flex;
            align-items: center;
            gap: 8px;
            transition: gap 0.3s ease;
        }

        .contact-info-link:hover {
            gap: 12px;
        }

        .contact-info-link i {
            font-size: 12px;
        }

        /* Contact Form Wrapper */
        .contact-form-wrapper {
            background: #f9f7f4;
            padding: 40px;
            border-radius: 8px;
            height: 100%;
        }

        .contact-form-title {
            font-size: 24px;
            font-weight: 600;
            color: #333333;
            margin: 0 0 30px 0;
        }

        .contact-form {
            width: 100%;
        }

        .contact-form .form-group {
            margin-bottom: 20px;
        }

        .contact-form .form-control {
            width: 100%;
            padding: 12px 15px;
            border: 1px solid #e0dbd5;
            border-radius: 4px;
            font-size: 14px;
            font-family: 'Raleway', sans-serif;
            background-color: #ffffff;
            color: #333333;
            transition: all 0.3s ease;
        }

        .contact-form .form-control:focus {
            border-color: #c59d5f;
            background-color: #ffffff;
            box-shadow: 0 0 5px rgba(197, 157, 95, 0.2);
        }

        .contact-form .form-control::placeholder {
            color: #999999;
        }

        .contact-form textarea.form-control {
            resize: vertical;
            min-height: 120px;
        }

        .btn-submit {
            background-color: #c59d5f;
            color: #ffffff;
            border: none;
            padding: 12px 35px;
            font-size: 14px;
            font-weight: 600;
            text-transform: uppercase;
            letter-spacing: 1px;
            border-radius: 4px;
            cursor: pointer;
            transition: all 0.3s ease;
            width: 100%;
            overflow: hidden;
            text-indent: -9999px;
            position: relative;
        }

        .btn-submit::before {
            content: "Send Message";
            position: absolute;
            left: 50%;
            top: 50%;
            transform: translate(-50%, -50%);
            text-indent: 0;
            white-space: nowrap;
        }

        .btn-submit:hover {
            background-color: #b18540;
            box-shadow: 0 4px 10px rgba(197, 157, 95, 0.3);
            transform: translateY(-2px);
        }

        .contact-result {
            margin-top: 15px;
            font-size: 14px;
            text-align: center;
            min-height: 20px;
        }

        .contact-result.success {
            color: #28a745;
        }

        .contact-result.error {
            color: #dc3545;
        }

        /* Hours & Social Section */
        .contact-hours-wrapper,
        .contact-social-wrapper {
            margin-bottom: 40px;
        }

        .contact-section-title {
            font-size: 20px;
            font-weight: 600;
            color: #333333;
            margin: 0 0 20px 0;
        }

        .hours-list {
            background: #f9f7f4;
            padding: 25px;
            border-radius: 8px;
        }

        .hours-item {
            display: flex;
            justify-content: space-between;
            padding: 12px 0;
            border-bottom: 1px solid #e0dbd5;
            font-size: 14px;
        }

        .hours-item:last-child {
            border-bottom: none;
        }

        .hours-day {
            font-weight: 600;
            color: #333333;
        }

        .hours-time {
            color: #c59d5f;
            font-weight: 500;
        }

        .social-links {
            display: flex;
            gap: 15px;
            flex-wrap: wrap;
        }

        .social-link {
            display: inline-flex;
            align-items: center;
            justify-content: center;
            width: 45px;
            height: 45px;
            border-radius: 50%;
            background-color: #f0ede9;
            color: #c59d5f;
            font-size: 18px;
            transition: all 0.3s ease;
            border: 2px solid transparent;
        }

        .social-link:hover {
            background-color: #c59d5f;
            color: #ffffff;
            transform: translateY(-3px);
            box-shadow: 0 4px 12px rgba(197, 157, 95, 0.3);
        }

        /* Map Section */
        .map-section {
            padding: 60px 0;
            background-color: #f9f7f4;
        }

        .map-section-title {
            text-align: center;
            font-family: 'Great Vibes', cursive;
            font-size: 48px;
            font-weight: 400;
            color: #c59d5f;
            margin: 0 0 40px 0;
            letter-spacing: 0.5px;
        }

        .map-section iframe {
            width: 100%;
            max-height: 450px;
            border-radius: 8px;
            box-shadow: 0 4px 15px rgba(0, 0, 0, 0.1);
        }

        /* Utility Classes */
        .mt-60 {
            margin-top: 60px;
        }

        .pt-0 {
            padding-top: 0;
        }

        /* Animations */
        @keyframes fadeInUp {
            from {
                opacity: 0;
                transform: translateY(30px);
            }

            to {
                opacity: 1;
                transform: translateY(0);
            }
        }

        /* Responsive Design */
        /* Large Desktop (1200px and above) */
        @media (min-width: 1200px) {
            .contact-hero-simple {
                height: 450px;
            }

            .hero-content-wrapper {
                padding: 0 60px;
            }

            .hero-simple-title {
                font-size: 72px;
                margin-bottom: 25px;
            }

            .hero-breadcrumb {
                gap: 15px;
                font-size: 14px;
            }

            .btn-submit {
                padding: 12px 35px;
                font-size: 14px;
            }

            .btn-submit::before {
                content: "Send Message";
            }
        }

        /* Desktop (1025px - 1199px) */
        @media (min-width: 1025px) and (max-width: 1199px) {
            .contact-hero-simple {
                height: 420px;
            }

            .hero-content-wrapper {
                padding: 0 50px;
            }

            .hero-simple-title {
                font-size: 64px;
                margin-bottom: 25px;
            }

            .btn-submit {
                padding: 12px 30px;
                font-size: 14px;
            }

            .btn-submit::before {
                content: "Send Message";
            }
        }

        /* Tablets (768px - 1024px) */
        @media (max-width: 1024px) {
            .contact-hero-simple {
                height: 380px;
            }

            .hero-content-wrapper {
                padding: 0 40px;
            }

            .hero-simple-title {
                font-size: 52px;
                margin-bottom: 20px;
            }

            .hero-breadcrumb {
                gap: 12px;
                font-size: 13px;
            }

            .breadcrumb-link {
                font-size: 13px;
            }

            .breadcrumb-separator {
                font-size: 13px;
            }

            .breadcrumb-current {
                font-size: 13px;
            }

            .contact-header h2 {
                font-size: 40px;
            }

            .btn-submit {
                padding: 11px 28px;
                font-size: 13px;
            }

            .btn-submit::before {
                content: "Send Message";
            }

            .map-section-title {
                font-size: 40px;
            }

            .contact-section {
                padding: 60px 0;
            }
        }

        /* Small Tablets (481px - 767px) */
        @media (max-width: 767px) {
            .contact-hero-simple {
                height: 340px;
                min-height: 340px;
            }

            .hero-content-wrapper {
                padding: 0 30px;
                justify-content: flex-end;
                padding-bottom: 30px;
            }

            .hero-simple-title {
                font-size: 42px;
                margin-bottom: 18px;
            }

            .hero-breadcrumb {
                font-size: 12px;
                gap: 10px;
                flex-wrap: wrap;
            }

            .breadcrumb-link {
                font-size: 12px;
                gap: 6px;
            }

            .breadcrumb-link i {
                font-size: 14px;
            }

            .breadcrumb-separator {
                font-size: 12px;
                margin: 0 3px;
            }

            .breadcrumb-current {
                font-size: 12px;
            }

            .contact-header {
                margin-bottom: 40px;
            }

            .contact-header h2 {
                font-size: 32px;
                margin-bottom: 10px;
            }

            .contact-header p {
                font-size: 14px;
            }

            .contact-info-card {
                padding: 30px 20px;
                margin-bottom: 25px;
            }

            .contact-info-icon {
                font-size: 36px;
                margin-bottom: 15px;
            }

            .contact-info-title {
                font-size: 18px;
                margin-bottom: 12px;
            }

            .contact-info-text {
                font-size: 13px;
                margin-bottom: 15px;
            }

            .contact-form-wrapper {
                padding: 30px 20px;
                margin-bottom: 30px;
            }

            .contact-form-title {
                font-size: 20px;
                margin-bottom: 20px;
            }

            .contact-form .form-control {
                padding: 10px 12px;
                font-size: 13px;
            }

            .btn-submit {
                padding: 10px 22px;
                font-size: 12px;
            }

            .btn-submit::before {
                content: "Send";
            }

            .contact-section-title {
                font-size: 18px;
                margin-bottom: 15px;
            }

            .hours-list {
                padding: 20px;
            }

            .hours-item {
                padding: 10px 0;
            }

            .contact-hours-wrapper,
            .contact-social-wrapper {
                margin-bottom: 30px;
            }

            .social-links {
                gap: 12px;
            }

            .social-link {
                width: 40px;
                height: 40px;
                font-size: 16px;
            }

            .map-section {
                padding: 40px 0;
            }

            .map-section-title {
                font-size: 32px;
                margin-bottom: 30px;
            }

            .map-section iframe {
                min-height: 300px;
            }

            .contact-section {
                padding: 40px 0;
            }

            .mt-60 {
                margin-top: 40px;
            }
        }

        /* Mobile Phones (321px - 480px) */
        @media (max-width: 480px) {
            .contact-hero-simple {
                height: 300px;
                min-height: 300px;
            }

            .hero-content-wrapper {
                padding: 0 20px;
                justify-content: flex-end;
                padding-bottom: 20px;
            }

            .hero-simple-title {
                font-size: 32px;
                margin-bottom: 14px;
                line-height: 1.2;
            }

            .hero-breadcrumb {
                font-size: 11px;
                gap: 6px;
                flex-direction: column;
                align-items: flex-start;
            }

            .breadcrumb-link {
                font-size: 11px;
                gap: 5px;
            }

            .breadcrumb-link i {
                font-size: 12px;
            }

            .breadcrumb-separator {
                display: none;
            }

            .breadcrumb-current {
                font-size: 11px;
                color: #ffffff;
            }

            .contact-header {
                margin-bottom: 30px;
            }

            .contact-header h2 {
                font-size: 26px;
                margin-bottom: 8px;
            }

            .contact-header p {
                font-size: 13px;
            }

            .contact-info-card {
                padding: 20px 15px;
                margin-bottom: 20px;
            }

            .contact-info-icon {
                font-size: 32px;
                margin-bottom: 12px;
            }

            .contact-info-title {
                font-size: 16px;
                margin-bottom: 10px;
            }

            .contact-info-text {
                font-size: 12px;
                line-height: 1.6;
                margin-bottom: 12px;
            }

            .contact-info-link {
                font-size: 12px;
            }

            .contact-form-wrapper {
                padding: 20px 15px;
                margin-bottom: 25px;
            }

            .contact-form-title {
                font-size: 18px;
                margin-bottom: 15px;
            }

            .contact-form .form-control {
                padding: 10px 10px;
                font-size: 12px;
            }

            .contact-form .form-group {
                margin-bottom: 15px;
            }

            .btn-submit {
                padding: 10px 18px;
                font-size: 11px;
                letter-spacing: 0.5px;
            }

            .btn-submit::before {
                content: "Send";
            }

            .contact-section-title {
                font-size: 16px;
                margin-bottom: 12px;
            }

            .hours-list {
                padding: 15px;
            }

            .hours-item {
                padding: 8px 0;
                font-size: 12px;
                flex-direction: column;
                gap: 4px;
            }

            .hours-day {
                font-size: 12px;
                font-weight: 600;
            }

            .hours-time {
                font-size: 11px;
            }

            .contact-hours-wrapper,
            .contact-social-wrapper {
                margin-bottom: 25px;
            }

            .social-links {
                gap: 10px;
            }

            .social-link {
                width: 38px;
                height: 38px;
                font-size: 14px;
            }

            .map-section {
                padding: 30px 0;
            }

            .map-section-title {
                font-size: 24px;
                margin-bottom: 20px;
            }

            .map-section iframe {
                min-height: 250px;
            }

            .contact-section {
                padding: 30px 0;
            }

            .mt-60 {
                margin-top: 30px;
            }
        }

        /* Extra Small Devices (below 320px) */
        @media (max-width: 319px) {
            .contact-hero-simple {
                height: 280px;
            }

            .hero-content-wrapper {
                padding: 0 15px;
                padding-bottom: 15px;
            }

            .hero-simple-title {
                font-size: 24px;
                margin-bottom: 10px;
            }

            .hero-breadcrumb {
                font-size: 10px;
                gap: 5px;
            }

            .contact-header h2 {
                font-size: 20px;
            }

            .map-section-title {
                font-size: 20px;
            }

            .contact-info-icon {
                font-size: 28px;
            }

            .btn-submit {
                padding: 8px 15px;
                font-size: 10px;
            }

            .btn-submit::before {
                content: "Send";
            }
        }
    </style>

</head>

<body>
    <div class="preloader">
        <div class="spinner">
            <div class="bounce1"></div>
            <div class="bounce2"></div>
            <div class="bounce3"></div>
        </div>
    </div>
    <!-- Document Wrapper
	============================================= -->
    <div id="wrapper" class="wrapper clearfix">

        <!-- New Header -->
        <!-- Top Announcement Bar -->
        <div class="header-top-bar">
            <div class="container">
                <div class="header-top-bar-text">Welcome to Granny Restaurant & Catering Services</div>
                <div class="header-social-icons">
                    <a href="#" title="Facebook"><i class="fab fa-facebook-f"></i></a>
                    <a href="#" title="Twitter"><i class="fab fa-twitter"></i></a>
                    <a href="#" title="Instagram"><i class="fab fa-instagram"></i></a>
                    <a href="#" title="WhatsApp"><i class="fab fa-whatsapp"></i></a>
                    <a href="#" title="YouTube"><i class="fab fa-youtube"></i></a>
                </div>
            </div>
        </div>
        <!-- Main Header -->
        <header class="header-main">
            <div class="container">
                <div class="header-logo">
                    <a href="index.php"><img src="assets/images/logo/logo-dark.png" alt="Granny Logo"></a>
                </div>

                <div style="display: flex; align-items: center; gap: 20px; flex: 1;">
                    <div class="header-contact-info">
                        <a href="tel:+919876543210" class="header-contact-item">
                            <i class="fas fa-phone"></i>
                            <div class="header-contact-text">
                                <span class="header-contact-label">Call Us:</span>
                                <span class="header-contact-value">+91 98765 43210</span>
                            </div>
                        </a>
                        <a href="mailto:info@granny.com" class="header-contact-item">
                            <i class="fas fa-envelope"></i>
                            <div class="header-contact-text">
                                <span class="header-contact-label">Mail Us:</span>
                                <span class="header-contact-value">info@granny.com</span>
                            </div>
                        </a>
                        <a href="#" class="header-contact-item">
                            <i class="fas fa-map-marker-alt"></i>
                            <div class="header-contact-text">
                                <span class="header-contact-label">Location:</span>
                                <span class="header-contact-value">Egypt</span>
                            </div>
                        </a>
                    </div>
                    <div class="header-booking-section" id="bookingSection">
                        <button class="header-booking-btn" data-toggle="modal" data-target="#reservationPopup">Table Booking</button>
                    </div>
                    <div class="user-profile-dropdown" id="userProfileDropdown" style="display: none;">
                        <button class="user-profile-btn" id="userProfileBtn">
                            <i class="fas fa-user-circle"></i>
                            <span class="user-name" id="userName"></span>
                        </button>
                        <div class="user-dropdown-menu" id="userDropdownMenu">
                            <a href="#" class="dropdown-item user-profile-link">
                                <i class="fas fa-user"></i> My Profile
                            </a>
                            <a href="#" class="dropdown-item user-settings-link">
                                <i class="fas fa-cog"></i> Settings
                            </a>
                            <div class="dropdown-divider"></div>
                            <a href="#" class="dropdown-item user-logout-link" id="logoutBtn">
                                <i class="fas fa-sign-out-alt"></i> Logout
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </header>
        <!-- Navigation Bar -->
        <nav class="header-nav-bar">
            <div class="container"
                style="display: flex; justify-content: space-between; align-items: center; padding: 0;">
                <div class="header-navbar-logo">
                    <a href="index.php"><img src="assets/images/logo/logo-light.png" alt="Granny Logo"></a>
                </div>
                <ul class="header-nav-menu" id="headerNavMenu">
                    <li><a href="index.php">Home</a></li>
                    <li>
                        <a href="about.php">About Us</a>

                    </li>
                    <li>
                        <a href="menu.php">Menu</a>

                    </li>
                    <li><a href="chefs.php">Our Chefs</a></li>
                    <li><a href="blog.php">Blog</a></li>
                    <!-- <li><a href="shop-4cols.html">Shop</a></li> -->
                    <li><a href="gallery.php">Gallery</a></li>
                    <li><a href="contacts.php">Contact Us</a></li>
                    <!-- Mobile Only Cart Icon -->
                    <li class="mobile-cart-item"
                        style="border-top: 2px solid #c59d5f; margin: 10px 0; padding: 10px 15px;">
                        <a href="cart.php" class="header-cart-icon"
                            style="display: flex; align-items: center; gap: 10px; color: #ffffff; text-decoration: none; padding: 0; font-size: 16px;">
                            <i class="fas fa-shopping-cart"></i>
                            <span>Cart</span>
                            <span class="header-cart-count">0</span>
                        </a>
                    </li>
                    <!-- Mobile Only Booking Button -->
                    <li class="mobile-booking-item">
                        <button class="header-booking-btn" data-toggle="modal" data-target="#reservationPopup"
                            style="width: 100%; display: block; padding: 12px 15px; background-color: #c59d5f; color: #ffffff; border: none; border-radius: 4px; font-size: 14px; font-weight: 700; text-transform: uppercase; cursor: pointer; transition: all 0.3s ease;">Booking</button>
                    </li>
                    <!-- Mobile Only Auth Section -->
                    <li class="mobile-auth-divider" id="mobileAuthSection"
                        style="border-top: 2px solid #c59d5f; margin: 10px 0; padding: 10px 0;">
                        <a href="#" class="header-auth-btn header-signin-btn" data-toggle="modal"
                            data-target="#signInModal"
                            style="display: block; padding: 12px 15px; text-align: center; width: 100%; box-sizing: border-box; margin-bottom: 10px; border: 2px solid #c59d5f; background-color: transparent; color: #c59d5f; border-radius: 4px; font-size: 14px; font-weight: 600;">Sign
                            In</a>
                        <a href="#" class="header-auth-btn header-signup-btn" data-toggle="modal"
                            data-target="#signUpModal"
                            style="display: block; padding: 12px 15px; text-align: center; width: 100%; box-sizing: border-box; background-color: #c59d5f; color: #ffffff; border: 2px solid #c59d5f; border-radius: 4px; font-size: 14px; font-weight: 600;">Sign
                            Up</a>
                    </li>

                </ul>
                <div class="header-nav-right">
                    <a href="cart.php" class="header-cart-icon">
                        <i class="fas fa-shopping-cart"></i>
                        <span class="header-cart-count">0</span>
                    </a>
                    <div class="header-auth-section" id="navAuthSection">
                        <a href="#" class="header-auth-btn header-signin-btn" data-toggle="modal"
                            data-target="#signInModal">Sign In</a>
                        <a href="#" class="header-auth-btn header-signup-btn" data-toggle="modal"
                            data-target="#signUpModal">Sign Up</a>
                    </div>
                    <div class="nav-user-profile-dropdown" id="navUserProfileDropdown" style="display: none;">
                        <button class="nav-user-profile-btn" id="navUserProfileBtn">
                            <i class="fas fa-user-circle"></i>
                            <span class="nav-user-name" id="navUserName"></span>
                        </button>
                        <div class="nav-user-dropdown-menu" id="navUserDropdownMenu">
                            <a href="dashboard.php" class="dropdown-item user-profile-link">
                                <i class="fa-solid fa-gauge"></i> Dashboard
                            </a>
                            <!-- <a href="#" class="dropdown-item user-settings-link">
                                <i class="fas fa-cog"></i> Settings
                            </a> -->
                            <!-- <div class="dropdown-divider"></div> -->
                            <a href="#" class="dropdown-item user-logout-link" id="navLogoutBtn">
                                <i class="fas fa-sign-out-alt"></i> Logout
                            </a>
                        </div>
                    </div>
                </div>
                <!-- Mobile Profile Icon (shown when logged in) -->
                <div class="mobile-profile-icon-container" id="mobileProfileIconContainer" style="display: none;">
                    <button class="mobile-profile-icon-btn" id="mobileProfileIconBtn">
                        <i class="fas fa-user-circle"></i>
                        <span class="mobile-user-name" id="mobileUserName"></span>
                    </button>
                    <div class="mobile-profile-dropdown-menu" id="mobileProfileDropdownMenu">
                        <a href="dashboard.php" class="dropdown-item user-profile-link">
                            <i class="fa-solid fa-gauge"></i> Dashboard
                        </a>
                        <!-- <a href="#" class="dropdown-item user-settings-link">
                            <i class="fas fa-cog"></i> Settings
                        </a> -->
                        <!-- <div class="dropdown-divider"></div> -->
                        <a href="#" class="dropdown-item user-logout-link" id="mobileProfileLogoutBtn">
                            <i class="fas fa-sign-out-alt"></i> Logout
                        </a>
                    </div>
                </div>
                <button class="header-mobile-toggle" id="headerMenuToggle">
                    <i class="fas fa-bars"></i>
                    <span class="hamburger-cart-badge header-cart-count">0</span>
                </button>
            </div>
        </nav>
        <!-- End Header -->

        <!-- Simple Elegant Hero Section
        ============================================= -->
        <section id="contact-hero" class="contact-hero-simple">
            <div class="hero-bg-wrapper">
                <img src="assets/images/page-title/12.jpg" alt="Contact Background" class="hero-bg-image">
                <div class="hero-bg-overlay"></div>
            </div>

            <div class="hero-content-wrapper">
                <h1 class="hero-simple-title">Contact Us</h1>

                <!-- Breadcrumb Navigation -->
                <nav class="hero-breadcrumb">
                    <a href="index.php" class="breadcrumb-link">
                        <i class="fas fa-home"></i> Home
                    </a>
                    <span class="breadcrumb-separator">/</span>
                    <span class="breadcrumb-current">Contact Us</span>
                </nav>
            </div>
        </section>
        <!-- #contact-hero-simple end -->

        <!-- Contact Section - Modern Design
        ============================================= -->
        <section id="contact-section" class="contact-section">
            <div class="container">
                <!-- Section Header -->
                <div class="contact-header pt-0">
                    <h2>Get In Touch With Us</h2>
                    <p>We're here to answer your questions and take your reservation</p>
                </div>

                <!-- Contact Content Grid -->
                <div class="contact-content">
                    <div class="row">
                        <!-- Contact Information Cards -->
                        <div class="col-xs-12 col-sm-12 col-md-4">
                            <!-- Address Card -->
                            <div class="contact-info-card">
                                <div class="contact-info-icon">
                                    <i class="fas fa-map-marker-alt"></i>
                                </div>
                                <h3 class="contact-info-title">Visit Us</h3>
                                <p class="contact-info-text">22 Alnahas Building<br>2 AlBahr St<br>Tanta, Al-Gharbia, Egypt</p>
                                <a href="#" class="contact-info-link">Get Directions <i class="fas fa-arrow-right"></i></a>
                            </div>
                        </div>

                        <!-- Phone Card -->
                        <div class="col-xs-12 col-sm-12 col-md-4">
                            <div class="contact-info-card">
                                <div class="contact-info-icon">
                                    <i class="fas fa-phone"></i>
                                </div>
                                <h3 class="contact-info-title">Call Us</h3>
                                <p class="contact-info-text">Office: +20 106-537-0701<br>Mobile: +20 106-537-0701<br>Available 9 AM - 11 PM</p>
                                <a href="tel:+201065370701" class="contact-info-link">Call Now <i class="fas fa-arrow-right"></i></a>
                            </div>
                        </div>

                        <!-- Email Card -->
                        <div class="col-xs-12 col-sm-12 col-md-4">
                            <div class="contact-info-card">
                                <div class="contact-info-icon">
                                    <i class="fas fa-envelope"></i>
                                </div>
                                <h3 class="contact-info-title">Email Us</h3>
                                <p class="contact-info-text">Main: info@granny.com<br>Inquiries: reservations@granny.com<br>We reply within 24 hours</p>
                                <a href="mailto:info@granny.com" class="contact-info-link">Send Email <i class="fas fa-arrow-right"></i></a>
                            </div>
                        </div>
                    </div>

                    <!-- Contact Form & Social -->
                    <div class="row mt-60">
                        <!-- Contact Form -->
                        <div class="col-xs-12 col-sm-12 col-md-6">
                            <div class="contact-form-wrapper">
                                <h3 class="contact-form-title">Send us a Message</h3>
                                <form id="contactForm" method="post" class="contact-form">
                                    <div class="form-group">
                                        <input type="text" class="form-control" name="contact-name" placeholder="Your Name" required>
                                    </div>
                                    <div class="form-group">
                                        <input type="email" class="form-control" name="contact-email" placeholder="Your Email" required>
                                    </div>
                                    <div class="form-group">
                                        <input type="text" class="form-control" name="contact-phone" placeholder="Your Phone" required>
                                    </div>
                                    <div class="form-group">
                                        <input type="text" class="form-control" name="contact-subject" placeholder="Subject" required>
                                    </div>
                                    <div class="form-group">
                                        <textarea class="form-control" name="contact-message" rows="4" placeholder="Your Message" required></textarea>
                                    </div>
                                    <button type="submit" class="btn btn-primary btn-submit">Connect</button>
                                    <div class="contact-result"></div>
                                </form>
                            </div>
                        </div>

                        <!-- Hours & Social -->
                        <div class="col-xs-12 col-sm-12 col-md-6">
                            <!-- Hours -->
                            <div class="contact-hours-wrapper">
                                <h3 class="contact-section-title">Opening Hours</h3>
                                <div class="hours-list">
                                    <div class="hours-item">
                                        <span class="hours-day">Monday - Friday</span>
                                        <span class="hours-time">9:00 AM – 12:00 AM</span>
                                    </div>
                                    <div class="hours-item">
                                        <span class="hours-day">Saturday</span>
                                        <span class="hours-time">8:00 AM – 3:00 AM</span>
                                    </div>
                                    <div class="hours-item">
                                        <span class="hours-day">Sunday</span>
                                        <span class="hours-time">Closed</span>
                                    </div>
                                </div>
                            </div>

                            <!-- Social Media -->
                            <div class="contact-social-wrapper">
                                <h3 class="contact-section-title">Follow Us</h3>
                                <div class="social-links">
                                    <a href="#" class="social-link" title="Facebook"><i class="fab fa-facebook-f"></i></a>
                                    <a href="#" class="social-link" title="Twitter"><i class="fab fa-twitter"></i></a>
                                    <a href="#" class="social-link" title="Instagram"><i class="fab fa-instagram"></i></a>
                                    <a href="#" class="social-link" title="WhatsApp"><i class="fab fa-whatsapp"></i></a>
                                    <a href="#" class="social-link" title="YouTube"><i class="fab fa-youtube"></i></a>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
        <!-- #contact-section end -->

        <!-- Map Section
        ============================================= -->
        <section class="map-section">
            <div class="container-fluid">
                <h2 class="map-section-title">Find Us On The Map</h2>

                <iframe
                    src="https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d3914.8978320783895!2d77.02594187437836!3d11.120986589049476!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x3ba8f9862f7b4587%3A0xcc2d23d7532052ef!2sZEMARAIM%20TECHNOLOGY%20PVT.%20LTD!5e0!3m2!1sen!2sin!4v1769062762313!5m2!1sen!2sin"
                    width="100%"
                    height="450"
                    style="border:0; border-radius:8px;"
                    allowfullscreen=""
                    loading="lazy"
                    referrerpolicy="no-referrer-when-downgrade">
                </iframe>
            </div>
        </section>
        <!-- #map-section end -->

        <!-- footer#2
        ============================================= -->
        <footer id="footer" class="footer footer-premium">
            <!-- Premium Footer Widget Section -->
            <div class="footer--widget-premium">
                <div class="container">
                    <div class="row">
                        <!-- Footer Logo & Description -->
                        <div class="col-xs-12 col-sm-12 col-md-3 footer--col-about">
                            <div class="footer--logo-section">
                                <img src="assets/images/logo/logo-light.png" alt="Granny Logo" class="footer--logo">
                                <p class="footer--tagline">Crafted with passion and served with love since 2015</p>
                                <div class="footer--description">
                                    <p>Experience culinary excellence at Granny. Our award-winning chefs blend
                                        traditional flavors with modern techniques to create unforgettable dining
                                        moments.</p>
                                </div>
                            </div>
                            <!-- Follow Us Section -->
                            <div class="footer--social-icons-widget">
                                <p
                                    style="font-size: 14px; margin-top: 20px; margin-bottom: 10px; color: #c59d5f; font-weight: 600;">
                                    Follow Us</p>
                                <div class="social-icons-list">
                                    <a href="#" class="social-icon-widget" title="Facebook"><i
                                            class="fa fa-facebook"></i></a>
                                    <a href="#" class="social-icon-widget" title="Instagram"><i
                                            class="fa fa-instagram"></i></a>
                                    <a href="#" class="social-icon-widget" title="Twitter"><i class="fa fa-twitter"></i></a>
                                    <a href="#" class="social-icon-widget" title="Pinterest"><i
                                            class="fa fa-pinterest"></i></a>
                                    <a href="#" class="social-icon-widget" title="TripAdvisor"><i
                                            class="fa fa-tripadvisor"></i></a>
                                </div>
                            </div>
                        </div>
                        <!-- .col-md-3 end -->

                        <!-- Quick Links -->
                        <div class="col-xs-12 col-sm-6 col-md-3 footer--col-links">
                            <h4 class="footer--title">Quick Links</h4>
                            <ul class="footer--menu">
                                <li><a href="index.html">Home</a></li>
                                <li><a href="menu-board.html">Our Menu</a></li>
                                <li><a href="page-about.html">About Us</a></li>
                                <li><a href="page-gallery.html">Gallery</a></li>
                                <li><a href="page-contacts.html">Contact</a></li>
                                <li><a href="blog-carousel.html">Blog</a></li>
                            </ul>
                        </div>
                        <!-- .col-md-3 end -->

                        <!-- Location & Hours -->
                        <div class="col-xs-12 col-sm-6 col-md-3 footer--col-info">
                            <h4 class="footer--title">Visit Us</h4>
                            <div class="footer--info-item">
                                <i class="fa fa-map-marker"></i>
                                <div class="footer--info-content">
                                    <p><strong>Address</strong><br>22 Alnahas Building, 2 AlBahr St<br>Tanta,
                                        Al-Gharbia, Egypt</p>
                                </div>
                            </div>
                            <div class="footer--info-item">
                                <i class="fa fa-clock-o"></i>
                                <div class="footer--info-content">
                                    <p><strong>Hours</strong><br>Mon-Fri: 9:00 AM – 12:00 AM<br>Sat: 8:00 AM – 3:00
                                        AM<br>Sun: Closed</p>
                                </div>
                            </div>
                        </div>
                        <!-- .col-md-3 end -->

                        <!-- Contact -->
                        <div class="col-xs-12 col-sm-12 col-md-3 footer--col-contact">
                            <h4 class="footer--title">Connect</h4>
                            <div class="footer--contact-info">
                                <p><i class="fa fa-phone"></i> <a href="tel:+201065370701">(+20) 106-537-0701</a></p>
                                <p><i class="fa fa-envelope"></i> <a href="mailto:info@granny.com">info@granny.com</a>
                                </p>
                            </div>

                        </div>
                    </div>
                    <!-- .col-md-3 end -->
                </div>
                <!-- .row end -->
            </div>
            <!-- .container end -->
    </div>
    <!-- .footer-widget-premium end -->

    <!-- Divider -->
    <div class="footer--divider"></div>

    <!-- Premium Copyright Section -->
    <div class="footer--copyright-premium">
        <div class="container">
            <div class="row">
                <div class="col-xs-12 col-sm-12 col-md-12">
                    <div class="footer--copyright-wrapper">
                        <p class="footer--copyright-text">&copy; 2026 <strong>Granny Restaurant & Cafe</strong>. All
                            rights reserved. | Crafted with <i class="fa fa-heart"></i> for food lovers.</p>
                        <div class="footer--links-legal">
                            <a href="#">Privacy Policy</a>
                            <span class="separator">•</span>
                            <a href="#">Terms of Service</a>
                            <span class="separator">•</span>
                            <a href="#">Cookies</a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- .container end -->
    </div>
    <!-- .footer-copyright-premium end -->
    </footer>
    </div>
    <!-- #wrapper end -->

    <!-- Footer Scripts
    ============================================= -->
    <script data-cfasync="false" src="/cdn-cgi/scripts/5c5dd728/cloudflare-static/email-decode.min.js"></script>

    <!-- SweetAlert2 JS -->
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11/dist/sweetalert2.all.min.js"></script>

    <script src="assets/js/jquery-2.2.4.min.js"></script>
    <script src="assets/js/plugins.js"></script>
    <script src="assets/js/cart-manager.js"></script>
    <script src="assets/js/functions.js"></script>
    <script src="assets/js/rsconfig.js"></script>

    <!-- Professional Table Booking Modal -->
    <div class="modal fade reservation-popup" tabindex="-1" role="dialog" id="reservationPopup">
        <div class="modal-dialog modal-lg" role="document">
            <div class="modal-content professional-booking-modal">
                <div class="modal-header professional-booking-header">
                    <div class="booking-header-content">
                        <h2 class="modal-title">Reserve Your Table</h2>
                    </div>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <i class="fa fa-times"></i>
                    </button>
                </div>
                <div class="modal-body professional-booking-body">
                    <form id="professionalBookingForm" class="professional-booking-form" method="POST" action="#">
                        <!-- Section 1: Guest Details -->
                        <div class="booking-section">
                            <h4 class="booking-section-title"><i class="fa fa-user-circle"></i> Guest Details</h4>
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="bookingName">Full Name *</label>
                                        <input type="text" class="form-control" id="bookingName"
                                            name="booking_name" placeholder="Enter your full name" required>
                                        <small class="form-text text-muted">We'll use this to identify your reservation</small>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="bookingEmail">Email Address *</label>
                                        <input type="email" class="form-control" id="bookingEmail"
                                            name="booking_email" placeholder="your.email@example.com" required>
                                        <small class="form-text text-muted">Confirmation will be sent here</small>
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="bookingPhone">Phone Number *</label>
                                        <input type="tel" class="form-control" id="bookingPhone"
                                            name="booking_phone" placeholder="+1 (555) 000-0000" required>
                                        <small class="form-text text-muted">Contact number for reservation</small>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="bookingOccasion">Occasion (Optional)</label>
                                        <select class="form-control" id="bookingOccasion" name="booking_occasion">
                                            <option value="">Select an occasion</option>
                                            <option value="birthday">Birthday Celebration</option>
                                            <option value="anniversary">Anniversary</option>
                                            <option value="business">Business Meeting</option>
                                            <option value="family">Family Gathering</option>
                                            <option value="date">Date Night</option>
                                            <option value="other">Other</option>
                                        </select>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <hr class="booking-divider">

                        <!-- Section 2: Reservation Details -->
                        <div class="booking-section">
                            <h4 class="booking-section-title"><i class="fa fa-calendar-alt"></i> Reservation Details</h4>
                            <div class="row">
                                <div class="col-md-4">
                                    <div class="form-group">
                                        <label for="bookingDate">Date *</label>
                                        <input type="date" class="form-control" id="bookingDate"
                                            name="booking_date" required>
                                        <small class="form-text text-muted">Select your preferred date</small>
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="form-group">
                                        <label for="bookingTime">Time *</label>
                                        <input type="time" class="form-control" id="bookingTime"
                                            name="booking_time" required>
                                        <small class="form-text text-muted">Select your preferred time</small>
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="form-group">
                                        <label for="bookingGuests">Number of Guests *</label>
                                        <select class="form-control" id="bookingGuests" name="booking_guests" required>
                                            <option value="">Select number</option>
                                            <option value="1">1 Person</option>
                                            <option value="2">2 People</option>
                                            <option value="3">3 People</option>
                                            <option value="4">4 People</option>
                                            <option value="5">5 People</option>
                                            <option value="6">6 People</option>
                                            <option value="7">7 People</option>
                                            <option value="8">8 People</option>
                                            <option value="10">10 People</option>
                                            <option value="12">12 People</option>
                                            <option value="15">15+ People</option>
                                        </select>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <hr class="booking-divider">

                        <!-- Section 3: Preferences & Special Requests -->


                        <!-- Form Actions -->
                        <div class="booking-actions">
                            <button type="reset" class="btn btn-outline-secondary">Clear Form</button>
                            <button type="submit" class="btn btn--secondary">Complete Booking</button>
                        </div>

                        <!-- Booking Status Message -->
                        <div class="alert alert-success booking-success-message" style="display: none; margin-top: 20px;">
                            <div style="display: flex; align-items: flex-start; gap: 15px;">
                                <div style="font-size: 24px; color: #28a745;">
                                    <i class="fa fa-check-circle"></i>
                                </div>
                                <div style="flex: 1;">
                                    <h5 style="margin: 0 0 10px 0; color: #155724;">Booking Confirmed!</h5>
                                    <p style="margin: 5px 0; font-size: 14px;" id="bookingConfirmation"></p>
                                    <p style="margin: 5px 0; font-size: 12px; color: #666;">Confirmation email has been sent to your email address.</p>
                                </div>
                            </div>
                        </div>
                        <div class="alert alert-danger booking-error-message" style="display: none; margin-top: 20px;">
                            <i class="fa fa-exclamation-circle"></i> <span class="error-message"></span>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>

    <!-- Professional Booking Modal Styles -->
    <style>
        .professional-booking-modal {
            border: none;
            border-radius: 12px;
            box-shadow: 0 10px 50px rgba(0, 0, 0, 0.2);
            overflow: hidden;
        }

        .professional-booking-header {
            background: linear-gradient(135deg, #d4a574 0%, #8b6f47 100%);
            border: none;
            color: white;
            padding: 30px;
            position: relative;
        }

        .booking-header-content h2 {
            font-size: 28px;
            font-weight: 600;
            margin: 0;
            margin-bottom: 8px;
            font-family: 'Raleway', sans-serif;
        }

        .booking-subtitle {
            font-size: 14px;
            margin: 0;
            opacity: 0.95;
            font-weight: 300;
        }

        .professional-booking-header .close {
            position: absolute;
            right: 20px;
            top: 20px;
            color: white;
            opacity: 0.8;
            font-size: 24px;
        }

        .professional-booking-header .close:hover {
            opacity: 1;
        }

        .professional-booking-body {
            padding: 40px;
            background: #f9f7f4;
        }

        .professional-booking-form {
            background: white;
            padding: 30px;
            border-radius: 8px;
            box-shadow: 0 2px 10px rgba(0, 0, 0, 0.05);
        }

        .booking-section {
            margin-bottom: 30px;
        }

        .booking-section-title {
            font-size: 16px;
            font-weight: 600;
            color: #333;
            margin-bottom: 20px;
            padding-bottom: 12px;
            border-bottom: 2px solid #d4a574;
            display: flex;
            align-items: center;
            gap: 10px;
        }

        .booking-section-title i {
            color: #d4a574;
            font-size: 18px;
        }

        .booking-divider {
            margin: 30px 0;
            border: none;
            border-top: 2px solid #e8e8e8;
        }

        .professional-booking-form .form-group {
            margin-bottom: 20px;
        }

        .professional-booking-form .form-group label {
            font-weight: 600;
            color: #333;
            margin-bottom: 8px;
            font-size: 13px;
            text-transform: uppercase;
            letter-spacing: 0.5px;
        }

        .professional-booking-form .form-control {
            border: 2px solid #e8e8e8;
            border-radius: 6px;
            padding: 12px 15px;
            font-size: 14px;
            transition: all 0.3s ease;
            background: #fafafa;
        }

        .professional-booking-form .form-control:focus {
            border-color: #d4a574;
            background: white;
            box-shadow: 0 0 0 3px rgba(212, 165, 116, 0.1);
            outline: none;
        }

        .professional-booking-form .form-control::placeholder {
            color: #999;
        }

        .professional-booking-form textarea.form-control {
            resize: vertical;
            min-height: 100px;
            font-family: 'Raleway', sans-serif;
        }

        .form-text {
            font-size: 12px;
            color: #999;
            margin-top: 5px;
        }

        .booking-actions {
            display: flex !important;
            gap: 15px !important;
            margin-top: 30px !important;
            justify-content: center !important;
            flex-wrap: wrap !important;
        }

        .professional-booking-form .booking-actions button {
            padding: 14px 35px !important;
            font-weight: 700 !important;
            border-radius: 8px !important;
            font-size: 15px !important;
            transition: all 0.3s cubic-bezier(0.25, 0.46, 0.45, 0.94) !important;
            min-width: 140px !important;
            line-height: 1.6 !important;
            display: inline-flex !important;
            align-items: center !important;
            justify-content: center !important;
            text-align: center !important;
            vertical-align: middle !important;
            cursor: pointer !important;
            letter-spacing: 0.5px !important;
            text-transform: uppercase !important;
            box-shadow: 0 4px 15px rgba(0, 0, 0, 0.1) !important;
        }

        .professional-booking-form .booking-actions .btn-outline-secondary {
            border: 2px solid #d4a574 !important;
            color: #d4a574 !important;
            background: white !important;
            box-shadow: 0 2px 10px rgba(212, 165, 116, 0.15) !important;
        }

        .professional-booking-form .booking-actions .btn-outline-secondary:hover,
        .professional-booking-form .booking-actions .btn-outline-secondary:active,
        .professional-booking-form .booking-actions .btn-outline-secondary:focus {
            border-color: #8b6f47 !important;
            color: white !important;
            background: linear-gradient(135deg, #d4a574 0%, #8b6f47 100%) !important;
            box-shadow: 0 6px 20px rgba(212, 165, 116, 0.35) !important;
            transform: translateY(-3px) !important;
        }

        .professional-booking-form .booking-actions .btn--secondary {
            background: linear-gradient(135deg, #d4a574 0%, #8b6f47 100%) !important;
            color: white !important;
            border: none !important;
            box-shadow: 0 4px 15px rgba(212, 165, 116, 0.25) !important;
            position: relative !important;
            overflow: hidden !important;
        }

        .professional-booking-form .booking-actions .btn--secondary::before {
            content: '' !important;
            position: absolute !important;
            top: 0 !important;
            left: -100% !important;
            width: 100% !important;
            height: 100% !important;
            background: rgba(255, 255, 255, 0.1) !important;
            transition: left 0.3s ease !important;
            z-index: 0 !important;
        }

        .professional-booking-form .booking-actions .btn--secondary:hover::before,
        .professional-booking-form .booking-actions .btn--secondary:active::before,
        .professional-booking-form .booking-actions .btn--secondary:focus::before {
            left: 100% !important;
        }

        .professional-booking-form .booking-actions .btn--secondary:hover,
        .professional-booking-form .booking-actions .btn--secondary:active,
        .professional-booking-form .booking-actions .btn--secondary:focus {
            transform: translateY(-3px) !important;
            box-shadow: 0 8px 25px rgba(212, 165, 116, 0.4) !important;
            background: linear-gradient(135deg, #8b6f47 0%, #d4a574 100%) !important;
            color: white !important;
            border: none !important;
        }

        .professional-booking-form .booking-actions button:active {
            transform: translateY(-1px) !important;
        }

        /* Mobile Responsiveness */
        @media (max-width: 576px) {
            .booking-actions {
                flex-direction: column !important;
                gap: 12px !important;
            }

            .professional-booking-form .booking-actions button {
                width: 100% !important;
                padding: 12px 20px !important;
                font-size: 14px !important;
                min-width: unset !important;
            }
        }

        @media (max-width: 768px) {
            .professional-booking-form .booking-actions button {
                padding: 12px 28px !important;
                font-size: 14px !important;
                min-width: 130px !important;
            }
        }

        @media (min-width: 769px) and (max-width: 992px) {
            .professional-booking-form .booking-actions button {
                padding: 13px 32px !important;
                font-size: 14px !important;
                min-width: 135px !important;
            }
        }

        .alert {
            border-radius: 6px;
            border: none;
            padding: 15px 20px;
            display: flex;
            align-items: center;
            gap: 12px;
        }

        .alert-success {
            background-color: #d4edda;
            color: #155724;
        }

        .alert-danger {
            background-color: #f8d7da;
            color: #721c24;
        }

        @media (max-width: 768px) {
            .professional-booking-body {
                padding: 20px;
            }

            .professional-booking-form {
                padding: 20px;
            }

            .booking-header-content h2 {
                font-size: 22px;
            }

            .booking-actions {
                flex-direction: column;
            }

            .booking-actions button {
                width: 100%;
            }
        }
    </style>

    <!-- Professional Booking Modal Scripts -->
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            const bookingForm = document.getElementById('professionalBookingForm');
            const successMessage = document.querySelector('.booking-success-message');
            const errorMessage = document.querySelector('.booking-error-message');

            // Set minimum date to today
            const today = new Date().toISOString().split('T')[0];
            document.getElementById('bookingDate').setAttribute('min', today);

            // Form submission
            if (bookingForm) {
                bookingForm.addEventListener('submit', function(e) {
                    e.preventDefault();

                    // Reset messages
                    successMessage.style.display = 'none';
                    errorMessage.style.display = 'none';

                    // Collect form data
                    const formData = new FormData(bookingForm);
                    const data = Object.fromEntries(formData);

                    // Validate data
                    if (!data.booking_name || !data.booking_email || !data.booking_phone ||
                        !data.booking_date || !data.booking_time || !data.booking_guests) {
                        errorMessage.querySelector('.error-message').textContent = 'Please fill in all required fields.';
                        errorMessage.style.display = 'flex';
                        return;
                    }

                    // Send booking data (you can modify this to your backend API)
                    console.log('Booking Data:', data);

                    // Show success message
                    successMessage.style.display = 'flex';

                    // Optional: Reset form and close modal after delay
                    setTimeout(function() {
                        bookingForm.reset();
                        $('#reservationPopup').modal('hide');
                    }, 2000);
                });
            }

            // Clear messages when modal is closed
            $('#reservationPopup').on('hidden.bs.modal', function() {
                successMessage.style.display = 'none';
                errorMessage.style.display = 'none';
            });
        });
    </script>
    <!-- End Professional Table Booking Modal -->

    <!-- Sign In Modal -->
    <div class="modal fade" tabindex="-1" role="dialog" id="signInModal">
        <div class="modal-dialog modal-lg" role="document">
            <div class="modal-content auth-modal-content">
                <button type="button" class="close auth-close-btn" data-dismiss="modal" aria-label="Close"><i
                        class="fa fa-times"></i></button>
                <div class="auth-modal-body">
                    <div class="auth-header">
                        <h2>Welcome Back</h2>
                        <p class="auth-subtitle">Sign in to your account</p>
                    </div>
                    <div id="signinMessage" class="auth-message" style="display: none;"></div>
                    <form class="auth-form" id="signInForm">
                        <div class="auth-form-group">
                            <label for="signinEmail" class="auth-label">Email Address</label>
                            <div class="auth-input-wrapper">
                                <i class="fas fa-envelope auth-input-icon"></i>
                                <input type="email" class="auth-input" id="signinEmail" name="email" placeholder="your@email.com"
                                    required>
                            </div>
                        </div>
                        <div class="auth-form-group">
                            <label for="signinPassword" class="auth-label">Password</label>
                            <div class="auth-input-wrapper">
                                <i class="fas fa-lock auth-input-icon"></i>
                                <input type="password" class="auth-input" id="signinPassword" name="password" placeholder="*********"
                                    required>
                            </div>
                        </div>
                        <div class="auth-form-group auth-remember">
                            <input type="checkbox" id="rememberMe" name="rememberMe">
                            <label for="rememberMe" class="auth-checkbox-label">Remember me</label>
                        </div>
                                                    <a href="#" data-toggle="modal" data-dismiss="modal" data-target="#forgotPasswordModal" class="auth-forgot-password" style="float: right; margin-top: 5px;">Forgot Password?</a>

                        <button type="submit" class="auth-btn">Sign In</button>
                    </form>
                    <div class="auth-divider">
                        <span>Don't have an account?</span>
                    </div>
                    <p class="auth-footer">
                        <a href="#" data-toggle="modal" data-dismiss="modal" data-target="#signUpModal"
                            class="auth-link">Create a new account</a>
                    </p>
                </div>
            </div>
        </div>
    </div>
    <!-- End Sign In Modal -->

    <!-- Sign Up Modal -->
    <div class="modal fade" tabindex="-1" role="dialog" id="signUpModal">
        <div class="modal-dialog modal-lg" role="document">
            <div class="modal-content auth-modal-content">
                <button type="button" class="close auth-close-btn" data-dismiss="modal" aria-label="Close"><i
                        class="fa fa-times"></i></button>
                <div class="auth-modal-body">
                    <div class="auth-header">
                        <h2>Create Account</h2>
                        <p class="auth-subtitle">Join us today</p>
                    </div>
                    <div id="signupMessage" class="auth-message" style="display: none;"></div>
                    <form class="auth-form" id="signUpForm">
                        <div class="auth-form-group">
                            <label for="signupName" class="auth-label">Full Name</label>
                            <div class="auth-input-wrapper">
                                <i class="fas fa-user auth-input-icon"></i>
                                <input type="text" class="auth-input" id="signupName" name="name" placeholder="John Doe" required>
                            </div>
                        </div>
                        <div class="auth-form-group">
                            <label for="signupEmail" class="auth-label">Email Address</label>
                            <div class="auth-input-wrapper">
                                <i class="fas fa-envelope auth-input-icon"></i>
                                <input type="email" class="auth-input" id="signupEmail" name="email" placeholder="your@email.com"
                                    required>
                            </div>
                        </div>
                        <div class="auth-form-group">
                            <label for="signupPhone" class="auth-label">Phone Number</label>
                            <div class="auth-input-wrapper">
                                <i class="fas fa-phone auth-input-icon"></i>
                                <input type="tel" class="auth-input" id="signupPhone" name="phone"
                                    placeholder="9876543210" required>
                            </div>
                        </div>
                        <div class="auth-form-group">
                            <label for="signupPassword" class="auth-label">Password</label>
                            <div class="auth-input-wrapper">
                                <i class="fas fa-lock auth-input-icon"></i>
                                <input type="password" class="auth-input" id="signupPassword" name="password" placeholder="*********"
                                    required>
                            </div>
                        </div>
                        <div class="auth-form-group">
                            <label for="signupConfirmPassword" class="auth-label">Confirm Password</label>
                            <div class="auth-input-wrapper">
                                <i class="fas fa-check-circle auth-input-icon"></i>
                                <input type="password" class="auth-input" id="signupConfirmPassword" name="confirmPassword"
                                    placeholder="*********" required>
                            </div>
                        </div>
                        <div class="auth-form-group auth-checkbox">
                            <input type="checkbox" id="agreeTerms" required>
                            <label for="agreeTerms" class="auth-checkbox-label">I agree to the <a href="#"
                                    class="auth-link-inline">Terms & Conditions</a></label>
                        </div>
                        <button type="submit" class="auth-btn">Create Account</button>
                    </form>
                    <div class="auth-divider">
                        <span>Already have an account?</span>
                    </div>
                    <p class="auth-footer">
                        <a href="#" data-toggle="modal" data-dismiss="modal" data-target="#signInModal"
                            class="auth-link">Sign In here</a>
                    </p>
                </div>
            </div>
        </div>
    </div>
    <!-- End Sign Up Modal -->
      
<!-- Email Verification Modal -->
<div class="modal fade" tabindex="-1" role="dialog" id="emailVerificationModal">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content auth-modal-content">
            <button type="button" class="close auth-close-btn" data-dismiss="modal"><i class="fa fa-times"></i></button>
            <div class="auth-modal-body">
                <div class="auth-header">
                    <h2>Verify Email</h2>
                    <p class="auth-subtitle">Enter the OTP sent to your email</p>
                </div>
                <div id="verifyEmailMessage" class="auth-message" style="display: none;"></div>
                <form class="auth-form" id="emailVerificationForm">
                    <input type="hidden" id="verifyEmailAddress" value="">
                    <div class="auth-form-group">
                        <label for="emailOTP" class="auth-label">One-Time Password (OTP)</label>
                        <div class="auth-input-wrapper">
                            <i class="fas fa-key auth-input-icon"></i>
                            <input type="text" class="auth-input" id="emailOTP" name="otp" 
                                   placeholder="000000" maxlength="6" required>
                        </div>
                        <small style="color: #666; margin-top: 5px;">Check your email for the 6-digit code</small>
                    </div>
                    <button type="submit" class="auth-btn">Verify Email</button>
                    <div style="text-align: center; margin-top: 15px;">
                        <p style="color: #666; font-size: 14px;">Didn't receive the code? 
                            <a href="#" id="resendEmailOTP" class="auth-link" style="text-decoration: underline;">Resend OTP</a>
                        </p>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
<!-- End Email Verification Modal -->

<!-- Forgot Password Modal -->
<div class="modal fade" tabindex="-1" role="dialog" id="forgotPasswordModal">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content auth-modal-content">
            <button type="button" class="close auth-close-btn" data-dismiss="modal"><i class="fa fa-times"></i></button>
            <div class="auth-modal-body">
                <div class="auth-header">
                    <h2>Reset Password</h2>
                    <p class="auth-subtitle">We'll send you an OTP to reset your password</p>
                </div>
                <div id="forgotPasswordMessage" class="auth-message" style="display: none;"></div>
                <form class="auth-form" id="forgotPasswordForm" name="step">
                    <!-- Step 1: Enter Email -->
                    <div id="forgotPasswordStep1">
                        <div class="auth-form-group">
                            <label for="forgotEmail" class="auth-label">Email Address</label>
                            <div class="auth-input-wrapper">
                                <i class="fas fa-envelope auth-input-icon"></i>
                                <input type="email" class="auth-input" id="forgotEmail" name="email" 
                                       placeholder="your@email.com" required>
                            </div>
                        </div>
                        <button type="button" class="auth-btn" id="sendResetOTPBtn">Send OTP</button>
                    </div>

                    <!-- Step 2: Enter OTP -->
                    <div id="forgotPasswordStep2" style="display: none;">
                        <input type="hidden" id="resetToken" value="">
                        <div class="auth-form-group">
                            <label for="resetOTP" class="auth-label">One-Time Password (OTP)</label>
                            <div class="auth-input-wrapper">
                                <i class="fas fa-key auth-input-icon"></i>
                                <input type="text" class="auth-input" id="resetOTP" name="otp" 
                                       placeholder="000000" maxlength="6">
                            </div>
                            <small style="color: #666; margin-top: 5px;">Check your email for the 6-digit code</small>
                        </div>
                        <div class="auth-form-group">
                            <label for="newPassword" class="auth-label">New Password</label>
                            <div class="auth-input-wrapper">
                                <i class="fas fa-lock auth-input-icon"></i>
                                <input type="password" class="auth-input" id="newPassword" name="password" placeholder="*********">
                            </div>
                        </div>
                        <div class="auth-form-group">
                            <label for="confirmNewPassword" class="auth-label">Confirm Password</label>
                            <div class="auth-input-wrapper">
                                <i class="fas fa-check-circle auth-input-icon"></i>
                                <input type="password" class="auth-input" id="confirmNewPassword" name="confirmPassword" placeholder="*********">
                            </div>
                        </div>
                        <button type="button" class="auth-btn" id="resetPasswordBtn">Reset Password</button>
                        <button type="button" class="auth-btn" style="background-color: #6c757d; margin-top: 10px;" id="backToEmailBtn">Back</button>
                        <div style="text-align: center; margin-top: 15px;">
                            <p style="color: #666; font-size: 14px;">
                                <a href="#" id="resendResetOTP" class="auth-link" style="text-decoration: underline;">Resend OTP</a>
                            </p>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
<!-- End Forgot Password Modal -->


    <!-- Backend Integration Scripts -->
    <style>
        .auth-message {
            padding: 12px;
            border-radius: 6px;
            margin-bottom: 20px;
            font-weight: 500;
            display: flex;
            align-items: center;
            gap: 10px;
        }

        .auth-message.success {
            background: #d4edda;
            color: #155724;
            border: 1px solid #c3e6cb;
        }

        .auth-message.error {
            background: #f8d7da;
            color: #721c24;
            border: 1px solid #f5c6cb;
        }
    </style>


    <script>
        // Update header with user profile
        function updateHeaderWithUserProfile(userData) {
            // Desktop header auth section
            const navAuthSection = document.getElementById('navAuthSection');
            const navUserProfileDropdown = document.getElementById('navUserProfileDropdown');
            const navUserName = document.getElementById('navUserName');

            // Mobile auth section (inside menu)
            const mobileAuthSection = document.getElementById('mobileAuthSection');
            const mobileUserProfileSection = document.getElementById('mobileUserProfileSection');

            // Mobile profile icon (next to hamburger)
            const mobileProfileIconContainer = document.getElementById('mobileProfileIconContainer');
            const mobileUserName = document.getElementById('mobileUserName');

            // Hide sign in/sign up buttons (desktop)
            if (navAuthSection) {
                navAuthSection.style.display = 'none';
            }

            // Show user profile dropdown with username (desktop)
            if (navUserProfileDropdown) {
                navUserProfileDropdown.style.display = 'inline-block';
                navUserName.textContent = userData.name || userData.email;
            }

            // Hide mobile auth buttons inside hamburger menu and show mobile user profile
            if (mobileAuthSection) {
                mobileAuthSection.classList.add('hide-auth');
            }
            if (mobileUserProfileSection) {
                mobileUserProfileSection.style.display = 'block';
            }

            // Show mobile profile icon next to hamburger
            if (mobileProfileIconContainer) {
                mobileProfileIconContainer.classList.add('show');
                // Remove inline style to let CSS handle it
                mobileProfileIconContainer.style.display = '';
            }

            // Set mobile username
            if (mobileUserName) {
                mobileUserName.textContent = userData.name || userData.email;
            }

            console.log('Header updated for user:', userData.name);
        }


        // Check if user is already logged in on page load
        document.addEventListener('DOMContentLoaded', function() {
            const user = localStorage.getItem('user');
            if (user) {
                try {
                    const userData = JSON.parse(user);
                    updateHeaderWithUserProfile(userData);
                    console.log('User already logged in:', userData.name);
                } catch (e) {
                    console.error('Error parsing user data:', e);
                }
            }
        });

        // Reset header to show auth buttons (used on logout)
        function resetHeaderAuthSection() {
            // Desktop header auth section
            const navAuthSection = document.getElementById('navAuthSection');
            const navUserProfileDropdown = document.getElementById('navUserProfileDropdown');

            // Mobile auth section
            const mobileAuthSection = document.getElementById('mobileAuthSection');
            const mobileUserProfileSection = document.getElementById('mobileUserProfileSection');

            // Mobile profile icon (next to hamburger)
            const mobileProfileIconContainer = document.getElementById('mobileProfileIconContainer');

            // Show sign in/sign up buttons (desktop)
            if (navAuthSection) {
                navAuthSection.style.display = 'flex';
            }

            // Hide user profile dropdown (desktop)
            if (navUserProfileDropdown) {
                navUserProfileDropdown.style.display = 'none';
            }

            // Show mobile auth buttons and hide mobile user profile
            if (mobileAuthSection) {
                mobileAuthSection.classList.remove('hide-auth');
            }
            if (mobileUserProfileSection) {
                mobileUserProfileSection.style.display = 'none';
            }

            // Hide mobile profile icon
            if (mobileProfileIconContainer) {
                mobileProfileIconContainer.classList.remove('show');
                mobileProfileIconContainer.style.display = 'none';
            }

            console.log('Header reset to show auth buttons');
        }

        // Logout function
        function logout() {
            console.log('Logout function called');
            // Remove user data from localStorage first
            localStorage.removeItem('user');
            // Clear cart from localStorage on logout
            localStorage.removeItem('granny_cart');

            fetch('backend/logout.php')
                .then(response => response.json())
                .then(data => {
                    console.log('Logout response:', data);
                    if (data.success) {
                        // Reload after logout is complete
                        setTimeout(() => {
                            window.location.reload();
                        }, 500);
                    }
                })
                .catch(error => {
                    console.error('Logout error:', error);
                    // Still logout on client side even if server fails
                    setTimeout(() => {
                        window.location.reload();
                    }, 500);
                });
        }

        // Logout button click handler
        document.addEventListener('DOMContentLoaded', function() {
            const logoutBtn = document.getElementById('navLogoutBtn');
            const mobileLogoutBtn = document.getElementById('mobileLogoutBtn');
            const mobileProfileLogoutBtn = document.getElementById('mobileProfileLogoutBtn');

            if (logoutBtn) {
                logoutBtn.addEventListener('click', function(e) {
                    e.preventDefault();
                    logout();
                });
            }

            if (mobileLogoutBtn) {
                mobileLogoutBtn.addEventListener('click', function(e) {
                    e.preventDefault();
                    logout();
                });
            }

            if (mobileProfileLogoutBtn) {
                mobileProfileLogoutBtn.addEventListener('click', function(e) {
                    e.preventDefault();
                    logout();
                });
            }
        });

        // Sign Up Handler
        document.getElementById('signUpForm').addEventListener('submit', function(e) {
            e.preventDefault();

            const formData = {
                name: document.getElementById('signupName').value,
                email: document.getElementById('signupEmail').value,
                password: document.getElementById('signupPassword').value,
                confirmPassword: document.getElementById('signupConfirmPassword').value
            };

            const messageDiv = document.getElementById('signupMessage');

            fetch('backend/signup.php', {
                    method: 'POST',
                    headers: {
                        'Content-Type': 'application/json'
                    },
                    body: JSON.stringify(formData)
                })
                .then(response => response.json())
                .then(data => {
                    messageDiv.style.display = 'flex';
                    if (data.success) {
                        messageDiv.className = 'auth-message success';
                        messageDiv.innerHTML = '<i class="fas fa-check-circle"></i> ' + data.message + ' Please sign in to continue.';

                        // Clear form
                        document.getElementById('signUpForm').reset();

                        // Do NOT store user data in localStorage - user must sign in first

                        // Close sign up modal and open sign in modal
                        setTimeout(() => {
                            $('#signUpModal').modal('hide');
                            messageDiv.style.display = 'none';
                            // Show sign in modal after a short delay
                            setTimeout(() => {
                                $('#signInModal').modal('show');
                            }, 500);
                        }, 2000);
                    } else {
                        messageDiv.className = 'auth-message error';
                        messageDiv.innerHTML = '<i class="fas fa-exclamation-circle"></i> ' + data.message;
                    }
                })
                .catch(error => {
                    messageDiv.style.display = 'flex';
                    messageDiv.className = 'auth-message error';
                    messageDiv.innerHTML = '<i class="fas fa-exclamation-circle"></i> Error: ' + error.message;
                    console.error('Error:', error);
                });
        });

        // Sign In Handler
        document.getElementById('signInForm').addEventListener('submit', function(e) {
            e.preventDefault();

            const formData = {
                email: document.getElementById('signinEmail').value,
                password: document.getElementById('signinPassword').value,
                rememberMe: document.getElementById('rememberMe').checked
            };

            const messageDiv = document.getElementById('signinMessage');

            fetch('backend/signin.php', {
                    method: 'POST',
                    headers: {
                        'Content-Type': 'application/json'
                    },
                    body: JSON.stringify(formData)
                })
                .then(response => response.json())
                .then(data => {
                    messageDiv.style.display = 'flex';
                    if (data.success) {
                        messageDiv.className = 'auth-message success';
                        messageDiv.innerHTML = '<i class="fas fa-check-circle"></i> ' + data.message;

                        // Clear form
                        document.getElementById('signInForm').reset();

                        // Store user data in localStorage
                        localStorage.setItem('user', JSON.stringify(data.data));

                        // Close modal
                        setTimeout(() => {
                            $('#signInModal').modal('hide');
                            messageDiv.style.display = 'none';
                            // Update header with user profile
                            updateHeaderWithUserProfile(data.data);
                            // Refresh page after successful sign-in
                            setTimeout(() => {
                                window.location.reload();
                            }, 500);
                        }, 2000);
                    } else {
                        messageDiv.className = 'auth-message error';
                        messageDiv.innerHTML = '<i class="fas fa-exclamation-circle"></i> ' + data.message;
                    }
                })
                .catch(error => {
                    messageDiv.style.display = 'flex';
                    messageDiv.className = 'auth-message error';
                    messageDiv.innerHTML = '<i class="fas fa-exclamation-circle"></i> Error: ' + error.message;
                    console.error('Error:', error);
                });
        });

        // Booking Handler
        document.getElementById('professionalBookingForm').addEventListener('submit', function(e) {
            e.preventDefault();

            const formData = {
                booking_name: document.getElementById('bookingName')?.value || '',
                booking_email: document.getElementById('bookingEmail')?.value || '',
                booking_phone: document.getElementById('bookingPhone')?.value || '',
                booking_date: document.getElementById('bookingDate')?.value || '',
                booking_time: document.getElementById('bookingTime')?.value || '',
                booking_guests: document.getElementById('bookingGuests')?.value || '',
                booking_occasion: document.getElementById('bookingOccasion')?.value || '',
                booking_table_type: document.getElementById('bookingTableType')?.value || '',
                booking_dietary: document.getElementById('bookingDietaryNeeds')?.value || '',
                booking_special_requests: document.getElementById('bookingSpecialRequests')?.value || ''
            };

            const successMessage = document.querySelector('.booking-success-message');
            const errorMessage = document.querySelector('.booking-error-message');

            console.log('Sending booking data:', formData);

            // Validate required fields
            if (!formData.booking_name || !formData.booking_email || !formData.booking_phone || !formData.booking_date || !formData.booking_time || !formData.booking_guests) {
                errorMessage.style.display = 'flex';
                errorMessage.querySelector('.error-message').textContent = 'Please fill in all required fields';
                successMessage.style.display = 'none';
                console.error('Validation failed: Missing required fields');
                return;
            }

            fetch('backend/booking.php', {
                    method: 'POST',
                    headers: {
                        'Content-Type': 'application/json'
                    },
                    body: JSON.stringify(formData)
                })
                .then(response => {
                    console.log('Response status:', response.status);
                    return response.json();
                })
                .then(data => {
                    console.log('Booking response:', data);
                    if (data.success) {
                        successMessage.style.display = 'flex';
                        errorMessage.style.display = 'none';

                        // Update confirmation message with booking details
                        const confirmationDiv = document.getElementById('bookingConfirmation');
                        if (confirmationDiv && data.data) {
                            confirmationDiv.innerHTML = `
                            <strong>Booking ID:</strong> #${data.data.booking_id}<br>
                            <strong>Date:</strong> ${data.data.booking_date} at ${data.data.booking_time}<br>
                            <strong>Guests:</strong> ${data.data.guests} person(s)
                        `;
                        }

                        // Store booking data
                        localStorage.setItem('lastBooking', JSON.stringify(data.data));
                        console.log('Booking saved to localStorage:', data.data);

                        // Reset and close
                        setTimeout(() => {
                            document.getElementById('professionalBookingForm').reset();
                            $('#reservationPopup').modal('hide');
                            successMessage.style.display = 'none';
                            confirmationDiv.innerHTML = '';
                        }, 3500);
                    } else {
                        errorMessage.style.display = 'flex';
                        errorMessage.querySelector('.error-message').textContent = data.message;
                        successMessage.style.display = 'none';
                        console.error('Booking error:', data.message);
                    }
                })
                .catch(error => {
                    errorMessage.style.display = 'flex';
                    errorMessage.querySelector('.error-message').textContent = 'Error: ' + error.message;
                    successMessage.style.display = 'none';
                    console.error('Fetch error:', error);
                });
        });

        // Initialize user session on page load
        document.addEventListener('DOMContentLoaded', function() {
            const user = localStorage.getItem('user');
            if (user) {
                const userData = JSON.parse(user);
                console.log('User logged in:', userData);
                // Header is already updated by the earlier DOMContentLoaded event
            }

            // Contact Form Handler with SweetAlert
            const contactForm = document.getElementById('contactForm');
            if (contactForm) {
                contactForm.addEventListener('submit', function(e) {
                    e.preventDefault();

                    const formData = new FormData(this);

                    // Show loading state
                    const submitBtn = this.querySelector('button[type="submit"]');
                    const originalText = submitBtn.textContent;
                    submitBtn.disabled = true;
                    submitBtn.textContent = 'Sending...';

                    fetch('backend/contact.php', {
                            method: 'POST',
                            body: formData
                        })
                        .then(response => response.json())
                        .then(data => {
                            submitBtn.disabled = false;
                            submitBtn.textContent = originalText;

                            if (data.success) {
                                // Show success alert
                                Swal.fire({
                                    icon: 'success',
                                    title: 'Message Sent!',
                                    text: data.message,
                                    confirmButtonColor: '#d4a574',
                                    confirmButtonText: 'OK',
                                    didClose: function() {
                                        // Reset form after alert is closed
                                        contactForm.reset();
                                    }
                                });
                                console.log('Contact message sent successfully:', data);
                            } else {
                                // Show error alert
                                Swal.fire({
                                    icon: 'error',
                                    title: 'Oops!',
                                    text: data.message || 'Error sending message',
                                    confirmButtonColor: '#d4a574',
                                    confirmButtonText: 'Try Again'
                                });
                                console.error('Contact error:', data.message);
                            }
                        })
                        .catch(error => {
                            submitBtn.disabled = false;
                            submitBtn.textContent = originalText;

                            // Show error alert
                            Swal.fire({
                                icon: 'error',
                                title: 'Error!',
                                text: 'Error sending message: ' + error.message,
                                confirmButtonColor: '#d4a574',
                                confirmButtonText: 'Try Again'
                            });
                            console.error('Fetch error:', error);
                        });
                });
            }
        });
    </script>
    <script src="assets/js/auth-handler.js"></script>
</body>

</html>