<?php session_start(); ?>
<!DOCTYPE html>
<html dir="ltr" lang="en-US">
<head>
    <!-- Document Meta
    ============================================= -->
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <!--IE Compatibility Meta-->
    <meta name="author" content="zytheme">
    <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1">
    <meta name="description" content="Elegant Restaurant & Cafe Html5 Template">
    <link href="assets/images/favicon/favicon.png" rel="icon">

    <!-- Fonts
    ============================================= -->
    <link
        href="../css?family=Great+Vibes%7CKaushan+Script%7CRaleway:100,100i,200,200i,300,300i,400,400i,500,500i,600,600i,700,700i,800,800i,900,900i"
        rel="stylesheet" type="text/css">

    <!-- Font Awesome Icons -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">

    <!-- Stylesheets
    ============================================= -->
    <link href="assets/css/external.css" rel="stylesheet">
    <link href="assets/css/bootstrap.min.css" rel="stylesheet">
    <link href="assets/css/style.css" rel="stylesheet">
    <link href="assets/css/cart.css" rel="stylesheet">

    <!-- Document Title
    ============================================= -->
    <title>Checkout | Granny Restaurant</title>

    <style>
        /* Checkout Page Styles */
        .checkout-hero-section {
            position: relative;
            height: 300px;
            display: flex;
            align-items: center;
            justify-content: center;
            background: linear-gradient(135deg, rgba(212, 165, 116, 0.9) 0%, rgba(139, 111, 71, 0.9) 100%);
            margin-bottom: 50px;
        }

        .checkout-hero-title {
            font-size: 48px;
            font-weight: 700;
            color: #ffffff;
            text-align: center;
            font-family: 'Raleway', sans-serif;
            letter-spacing: 1px;
        }

        .checkout-container {
            max-width: 1200px;
            margin: 0 auto;
            padding: 0 20px;
        }

        .checkout-wrapper {
            display: grid;
            grid-template-columns: 2fr 1fr;
            gap: 40px;
            margin-bottom: 60px;
        }

        .checkout-form-section {
            background: white;
            padding: 40px;
            border-radius: 12px;
            box-shadow: 0 5px 20px rgba(0, 0, 0, 0.08);
        }

        .checkout-order-summary {
            background: white;
            padding: 40px;
            border-radius: 12px;
            box-shadow: 0 5px 20px rgba(0, 0, 0, 0.08);
            height: fit-content;
            position: sticky;
            top: 20px;
        }

        .section-title {
            font-size: 22px;
            font-weight: 700;
            color: #333;
            margin-bottom: 25px;
            padding-bottom: 15px;
            border-bottom: 3px solid #d4a574;
            display: flex;
            align-items: center;
            gap: 12px;
        }

        .section-title i {
            color: #d4a574;
            font-size: 24px;
        }

        .form-row {
            display: grid;
            grid-template-columns: 1fr 1fr;
            gap: 20px;
            margin-bottom: 25px;
        }

        .form-row.full {
            grid-template-columns: 1fr;
        }

        .form-group {
            display: flex;
            flex-direction: column;
        }

        .form-group label {
            font-weight: 600;
            color: #333;
            margin-bottom: 8px;
            font-size: 13px;
            text-transform: uppercase;
            letter-spacing: 0.5px;
        }

        .form-group input,
        .form-group select,
        .form-group textarea {
            padding: 12px 15px;
            border: 2px solid #e8e8e8;
            border-radius: 6px;
            font-size: 14px;
            font-family: 'Raleway', sans-serif;
            transition: all 0.3s ease;
            background: #fafafa;
        }

        .form-group input:focus,
        .form-group select:focus,
        .form-group textarea:focus {
            border-color: #d4a574;
            background: white;
            box-shadow: 0 0 0 3px rgba(212, 165, 116, 0.1);
            outline: none;
        }

        .form-group textarea {
            resize: vertical;
            min-height: 80px;
        }

        .payment-methods {
            display: grid;
            grid-template-columns: repeat(2, 1fr);
            gap: 15px;
            margin-bottom: 25px;
        }

        .payment-option {
            position: relative;
        }

        .payment-option input[type="radio"] {
            display: none;
        }

        .payment-option label {
            display: flex;
            align-items: center;
            justify-content: center;
            gap: 10px;
            padding: 18px;
            border: 2px solid #e8e8e8;
            border-radius: 8px;
            cursor: pointer;
            transition: all 0.3s ease;
            background: white;
            font-weight: 600;
            margin: 0;
            text-transform: none;
            text-align: center;
            font-size: 14px;
        }

        .payment-option input[type="radio"]:checked + label {
            border-color: #d4a574;
            background: #fef5e7;
            color: #d4a574;
            box-shadow: 0 4px 12px rgba(212, 165, 116, 0.2);
        }

        .payment-option label i {
            font-size: 24px;
        }

        .order-item {
            display: flex;
            justify-content: space-between;
            align-items: flex-start;
            padding: 15px 0;
            border-bottom: 1px solid #e8e8e8;
            gap: 15px;
        }

        .order-item:last-child {
            border-bottom: none;
        }

        .item-image {
            width: 70px;
            height: 70px;
            border-radius: 6px;
            object-fit: cover;
            flex-shrink: 0;
        }

        .item-details {
            flex: 1;
        }

        .item-name {
            font-weight: 600;
            color: #333;
            margin-bottom: 5px;
            font-size: 14px;
        }

        .item-qty {
            font-size: 12px;
            color: #999;
        }

        .item-price {
            font-weight: 700;
            color: #d4a574;
            font-size: 16px;
            white-space: nowrap;
            text-align: right;
        }

        .summary-divider {
            height: 2px;
            background: #e8e8e8;
            margin: 20px 0;
        }

        .summary-row {
            display: flex;
            justify-content: space-between;
            margin-bottom: 15px;
            font-size: 14px;
        }

        .summary-row.total {
            font-size: 18px;
            font-weight: 700;
            color: #333;
            padding-top: 15px;
            border-top: 2px solid #d4a574;
        }

        .summary-row.total span:last-child {
            color: #d4a574;
        }

        .checkout-actions {
            display: flex;
            gap: 15px;
            margin-top: 30px;
        }

        .btn-place-order {
            width: 100%;
            padding: 16px 30px;
            background: linear-gradient(135deg, #d4a574 0%, #8b6f47 100%);
            color: white;
            border: none;
            border-radius: 6px;
            font-weight: 700;
            font-size: 16px;
            cursor: pointer;
            transition: all 0.3s cubic-bezier(0.25, 0.46, 0.45, 0.94);
            text-transform: uppercase;
            letter-spacing: 0.5px;
            box-shadow: 0 4px 15px rgba(212, 165, 116, 0.25);
        }

        .btn-place-order:hover {
            transform: translateY(-3px);
            box-shadow: 0 8px 25px rgba(212, 165, 116, 0.4);
            background: linear-gradient(135deg, #8b6f47 0%, #d4a574 100%);
        }

        .btn-checkout-back {
            flex: 1;
            padding: 16px 30px;
            background: white;
            color: #d4a574;
            border: 2px solid #d4a574;
            border-radius: 8px;
            font-weight: 700;
            font-size: 15px;
            cursor: pointer;
            transition: all 0.3s ease;
            text-transform: uppercase;
            letter-spacing: 0.5px;
        }

        .btn-checkout-back:hover {
            background: linear-gradient(135deg, #d4a574 0%, #8b6f47 100%);
            color: white;
            transform: translateY(-3px);
            box-shadow: 0 4px 15px rgba(212, 165, 116, 0.25);
        }

        .success-message {
            display: none;
            background: #d4edda;
            color: #155724;
            padding: 20px;
            border-radius: 8px;
            margin-bottom: 30px;
            text-align: center;
            font-weight: 600;
        }

        .error-message {
            display: none;
            background: #f8d7da;
            color: #721c24;
            padding: 20px;
            border-radius: 8px;
            margin-bottom: 30px;
            text-align: center;
            font-weight: 600;
        }

        .promo-section {
            background: #f9f7f4;
            padding: 15px;
            border-radius: 8px;
            margin-bottom: 25px;
        }

        .promo-input-wrapper {
            display: flex;
            gap: 10px;
        }

        .promo-input-wrapper input {
            flex: 1;
            padding: 10px 15px;
            border: 2px solid #e8e8e8;
            border-radius: 6px;
            font-size: 14px;
        }

        .promo-input-wrapper button {
            padding: 10px 20px;
            background: #d4a574;
            color: white;
            border: none;
            border-radius: 6px;
            font-weight: 600;
            cursor: pointer;
            transition: all 0.3s ease;
        }

        .promo-input-wrapper button:hover {
            background: #8b6f47;
        }

        .progress-steps {
            display: flex;
            justify-content: space-between;
            margin-bottom: 50px;
            position: relative;
        }

        .progress-step {
            display: flex;
            flex-direction: column;
            align-items: center;
            gap: 10px;
            flex: 1;
            position: relative;
            z-index: 2;
        }

        .step-number {
            width: 50px;
            height: 50px;
            background: white;
            border: 3px solid #e8e8e8;
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            font-weight: 700;
            color: #999;
            font-size: 20px;
            transition: all 0.3s ease;
        }

        .progress-step.active .step-number {
            background: linear-gradient(135deg, #d4a574 0%, #8b6f47 100%);
            color: white;
            border-color: #d4a574;
        }

        .step-label {
            font-weight: 600;
            color: #999;
            font-size: 13px;
            text-align: center;
        }

        .progress-step.active .step-label {
            color: #d4a574;
        }

        .progress-line {
            position: absolute;
            top: 25px;
            left: 0;
            right: 0;
            height: 3px;
            background: #e8e8e8;
            z-index: 1;
        }

        @media (max-width: 768px) {
            .checkout-wrapper {
                grid-template-columns: 1fr;
                gap: 30px;
            }

            .checkout-order-summary {
                position: static;
            }

            .checkout-form-section,
            .checkout-order-summary {
                padding: 30px 20px;
            }

            .form-row {
                grid-template-columns: 1fr;
            }

            .payment-methods {
                grid-template-columns: 1fr;
            }

            .checkout-actions {
                flex-direction: column;
            }

            .hero-simple-title {
                font-size: 32px;
            }

            .progress-steps {
                flex-wrap: wrap;
            }

            .progress-line {
                display: none;
            }

            .progress-step {
                flex: 1 1 33.33%;
            }
        }
    </style>
</head>

<body>
    <div class="preloader">
        <div class="spinner">
            <div class="bounce1"></div>
            <div class="bounce2"></div>
            <div class="bounce3"></div>
        </div>
    </div>

    <!-- Document Wrapper -->
    <div id="wrapper" class="wrapper clearfix">
        <!-- New Header -->
        <!-- New Header -->
        <!-- Top Announcement Bar -->
        <div class="header-top-bar">
            <div class="container">
                <div class="header-top-bar-text">Welcome to Granny Restaurant & Catering Services</div>
                <div class="header-social-icons">
                    <a href="#" title="Facebook"><i class="fab fa-facebook-f"></i></a>
                    <a href="#" title="Twitter"><i class="fab fa-twitter"></i></a>
                    <a href="#" title="Instagram"><i class="fab fa-instagram"></i></a>
                    <a href="#" title="WhatsApp"><i class="fab fa-whatsapp"></i></a>
                    <a href="#" title="YouTube"><i class="fab fa-youtube"></i></a>
                </div>
            </div>
        </div>

        <header class="header-main">
            <div class="container">
                <div class="header-logo">
                    <a href="index.php"><img src="assets/images/logo/logo-dark.png" alt="Granny Logo"></a>
                </div>

                <div style="display: flex; align-items: center; gap: 20px; flex: 1;">
                    <div class="header-contact-info">
                        <a href="tel:+919876543210" class="header-contact-item">
                            <i class="fas fa-phone"></i>
                            <div class="header-contact-text">
                                <span class="header-contact-label">Call Us:</span>
                                <span class="header-contact-value">+91 98765 43210</span>
                            </div>
                        </a>
                        <a href="mailto:info@granny.com" class="header-contact-item">
                            <i class="fas fa-envelope"></i>
                            <div class="header-contact-text">
                                <span class="header-contact-label">Mail Us:</span>
                                <span class="header-contact-value">info@granny.com</span>
                            </div>
                        </a>
                        <a href="#" class="header-contact-item">
                            <i class="fas fa-map-marker-alt"></i>
                            <div class="header-contact-text">
                                <span class="header-contact-label">Location:</span>
                                <span class="header-contact-value">Egypt</span>
                            </div>
                        </a>
                    </div>
                    <div class="header-booking-section" id="bookingSection">
                        <button class="header-booking-btn" data-toggle="modal" data-target="#reservationPopup">Table Booking</button>
                    </div>
                    <div class="user-profile-dropdown" id="userProfileDropdown" style="display: none;">
                        <button class="user-profile-btn" id="userProfileBtn">
                            <i class="fas fa-user-circle"></i>
                            <span class="user-name" id="userName"></span>
                        </button>
                        <div class="user-dropdown-menu" id="userDropdownMenu">
                            <a href="#" class="dropdown-item user-profile-link">
                                <i class="fas fa-user"></i> My Profile
                            </a>
                            <a href="#" class="dropdown-item user-settings-link">
                                <i class="fas fa-cog"></i> Settings
                            </a>
                            <div class="dropdown-divider"></div>
                            <a href="#" class="dropdown-item user-logout-link" id="logoutBtn">
                                <i class="fas fa-sign-out-alt"></i> Logout
                            </a>
                        </div>
                    </div>
                </div>
                </div>
        </header>
        <!-- Navigation Bar -->
        <nav class="header-nav-bar">
            <div class="container"
                style="display: flex; justify-content: space-between; align-items: center; padding: 0;">
                <div class="header-navbar-logo">
                    <a href="index.php"><img src="assets/images/logo/logo-light.png" alt="Granny Logo"></a>
                </div>
                <ul class="header-nav-menu" id="headerNavMenu">
                    <li><a href="index.php">Home</a></li>
                    <li>
                        <a href="about.php">About Us</a>

                    </li>
                    <li>
                        <a href="menu.php">Menu</a>

                    </li>
                    <li><a href="chefs.php">Our Chefs</a></li>
                    <li><a href="blog.php">Blog</a></li>
                    <!-- <li><a href="shop-4cols.html">Shop</a></li> -->
                    <li><a href="gallery.php">Gallery</a></li>
                    <li><a href="contacts.php">Contact Us</a></li>
                    <!-- Mobile Only Cart Icon -->
                    <li class="mobile-cart-item"
                        style="border-top: 2px solid #c59d5f; margin: 10px 0; padding: 10px 15px;">
                        <a href="cart.php" class="header-cart-icon"
                            style="display: flex; align-items: center; gap: 10px; color: #ffffff; text-decoration: none; padding: 0; font-size: 16px;">
                            <i class="fas fa-shopping-cart"></i>
                            <span>Cart</span>
                            <span class="header-cart-count">0</span>
                        </a>
                    </li>
                    <!-- Mobile Only Booking Button -->
                    <li class="mobile-booking-item">
                        <button class="header-booking-btn" data-toggle="modal" data-target="#reservationPopup"
                            style="width: 100%; display: block; padding: 12px 15px; background-color: #c59d5f; color: #ffffff; border: none; border-radius: 4px; font-size: 14px; font-weight: 700; text-transform: uppercase; cursor: pointer; transition: all 0.3s ease;">Booking</button>
                    </li>
                    <!-- Mobile Only Auth Section -->
                    <li class="mobile-auth-divider" id="mobileAuthSection"
                        style="border-top: 2px solid #c59d5f; margin: 10px 0; padding: 10px 0;">
                        <a href="#" class="header-auth-btn header-signin-btn" data-toggle="modal"
                            data-target="#signInModal"
                            style="display: block; padding: 12px 15px; text-align: center; width: 100%; box-sizing: border-box; margin-bottom: 10px; border: 2px solid #c59d5f; background-color: transparent; color: #c59d5f; border-radius: 4px; font-size: 14px; font-weight: 600;">Sign
                            In</a>
                        <a href="#" class="header-auth-btn header-signup-btn" data-toggle="modal"
                            data-target="#signUpModal"
                            style="display: block; padding: 12px 15px; text-align: center; width: 100%; box-sizing: border-box; background-color: #c59d5f; color: #ffffff; border: 2px solid #c59d5f; border-radius: 4px; font-size: 14px; font-weight: 600;">Sign
                            Up</a>
                    </li>
        
                </ul>
                <div class="header-nav-right">
                    <a href="cart.php" class="header-cart-icon">
                        <i class="fas fa-shopping-cart"></i>
                        <span class="header-cart-count">0</span>
                    </a>
                    <div class="header-auth-section" id="navAuthSection">
                        <a href="#" class="header-auth-btn header-signin-btn" data-toggle="modal"
                            data-target="#signInModal">Sign In</a>
                        <a href="#" class="header-auth-btn header-signup-btn" data-toggle="modal"
                            data-target="#signUpModal">Sign Up</a>
                    </div>
                    <div class="nav-user-profile-dropdown" id="navUserProfileDropdown" style="display: none;">
                        <button class="nav-user-profile-btn" id="navUserProfileBtn">
                            <i class="fas fa-user-circle"></i>
                            <span class="nav-user-name" id="navUserName"></span>
                        </button>
                        <div class="nav-user-dropdown-menu" id="navUserDropdownMenu">
                            <a href="dashboard.php" class="dropdown-item user-profile-link">
                                <i class="fa-solid fa-gauge"></i> Dashboard
                            </a>
                            <!-- <a href="#" class="dropdown-item user-settings-link">
                                <i class="fas fa-cog"></i> Settings
                            </a> -->
                            <!-- <div class="dropdown-divider"></div> -->
                            <a href="#" class="dropdown-item user-logout-link" id="navLogoutBtn">
                                <i class="fas fa-sign-out-alt"></i> Logout
                            </a>
                        </div>
                    </div>
                </div>
                <!-- Mobile Profile Icon (shown when logged in) -->
                <div class="mobile-profile-icon-container" id="mobileProfileIconContainer" style="display: none;">
                    <button class="mobile-profile-icon-btn" id="mobileProfileIconBtn">
                        <i class="fas fa-user-circle"></i>
                        <span class="mobile-user-name" id="mobileUserName"></span>
                    </button>
                    <div class="mobile-profile-dropdown-menu" id="mobileProfileDropdownMenu">
                        <a href="dashboard.php" class="dropdown-item user-profile-link">
                            <i class="fa-solid fa-gauge"></i> Dashboard
                        </a>
                        <!-- <a href="#" class="dropdown-item user-settings-link">
                            <i class="fas fa-cog"></i> Settings
                        </a> -->
                        <!-- <div class="dropdown-divider"></div> -->
                        <a href="#" class="dropdown-item user-logout-link" id="mobileProfileLogoutBtn">
                            <i class="fas fa-sign-out-alt"></i> Logout
                        </a>
                    </div>
                </div>
                <button class="header-mobile-toggle" id="headerMenuToggle">
                    <i class="fas fa-bars"></i>
                    <span class="hamburger-cart-badge header-cart-count">0</span>
                </button>
            </div>
        </nav>
       

        <!-- Checkout Hero Section -->
        <!-- <div class="checkout-hero-section">
            <h1 class="checkout-hero-title">Secure Checkout</h1>
        </div> -->

        <!-- Progress Steps -->
        <!-- <div class="checkout-container">
            <div class="progress-steps">
                <div class="progress-line"></div>
                <div class="progress-step active">
                    <div class="step-number">1</div>
                    <div class="step-label">Shipping</div>
                </div>
                <div class="progress-step active">
                    <div class="step-number">2</div>
                    <div class="step-label">Payment</div>
                </div>
                <div class="progress-step">
                    <div class="step-number">3</div>
                    <div class="step-label">Confirmation</div>
                </div>
            </div>
        </div> -->

        <!-- Checkout Main Content -->
        <div class="checkout-container">
            <div id="successMessage" class="success-message">
                <i class="fas fa-check-circle"></i> Order placed successfully! Redirecting...
            </div>
            <div id="errorMessage" class="error-message"></div>

            <div class="checkout-wrapper">
                <!-- Checkout Form -->
                <div class="checkout-form-section">
                    <form id="checkoutForm">
                        <!-- Billing Details -->
                        <div class="section-title">
                            <i class="fas fa-credit-card"></i>
                            Billing Details
                        </div>

                        <div class="form-row full">
                            <div class="form-group">
                                <label for="fullName">Full Name *</label>
                                <input type="text" id="fullName" name="fullName" placeholder="Enter your full name" required>
                            </div>
                        </div>

                        <div class="form-row">
                            <div class="form-group">
                                <label for="phone">Phone *</label>
                                <input type="tel" id="phone" name="phone" placeholder="9988776655" required>
                            </div>
                            <div class="form-group">
                                <label for="email">Email *</label>
                                <input type="email" id="email" name="email" placeholder="your@email.com" required>
                            </div>
                        </div>

                        <div class="form-row full">
                            <div class="form-group">
                                <label for="address">Shipping Address *</label>
                                <textarea id="address" name="address" placeholder="Enter your complete address" rows="4" required></textarea>
                            </div>
                        </div>

                        <!-- Payment Method -->
                        <div class="section-title" style="margin-top: 40px;">
                            <i class="fas fa-wallet"></i>
                            Payment Method
                        </div>

                        <div class="payment-methods">
                            <div class="payment-option">
                                <input type="radio" id="cod" name="paymentMethod" value="cash-on-delivery" checked>
                                <label for="cod">
                                    <i class="fas fa-money-bill-wave"></i>
                                    Cash on Delivery
                                </label>
                            </div>
                            <div class="payment-option">
                                <input type="radio" id="upi" name="paymentMethod" value="upi">
                                <label for="upi">
                                    <i class="fas fa-mobile-alt"></i>
                                    UPI / QR Scan
                                </label>
                            </div>
                            <div class="payment-option">
                                <input type="radio" id="card" name="paymentMethod" value="credit-debit-card">
                                <label for="card">
                                    <i class="fas fa-credit-card"></i>
                                    Credit/Debit Card
                                </label>
                            </div>
                            <div class="payment-option">
                                <input type="radio" id="netbanking" name="paymentMethod" value="net-banking">
                                <label for="netbanking">
                                    <i class="fas fa-university"></i>
                                    Net Banking
                                </label>
                            </div>
                        </div>

                        <!-- Terms and Conditions -->
                        <div class="form-row full" style="margin-top: 30px;">
                            <div class="form-group">
                                <input type="checkbox" id="terms" name="terms" required>
                                <label for="terms" style="display: inline; text-transform: none; text-align: left;">
                                    I agree to the <a href="#" style="color: #d4a574; text-decoration: underline;">Terms & Conditions</a>
                                </label>
                            </div>
                        </div>

                        <!-- Action Button -->
                        <div class="checkout-actions" style="margin-top: 30px;">
                            <button type="submit" class="btn-place-order">
                                Place Order
                            </button>
                        </div>
                    </form>
                </div>

                <!-- Order Summary Sidebar -->
                <div class="checkout-order-summary">
                    <div class="section-title">
                        <i class="fas fa-box"></i>
                        Order Summary
                    </div>

                    <div id="orderItems"></div>

                    <!-- Promo Code -->
                    <div class="promo-section">
                        <div style="font-weight: 600; margin-bottom: 10px; color: #333;">Have a Promo Code?</div>
                        <div class="promo-input-wrapper">
                            <input type="text" id="promoCode" placeholder="Enter code" name="promoCode">
                            <button type="button" onclick="applyPromo()">Apply</button>
                        </div>
                    </div>

                    <div class="summary-divider"></div>

                    <div class="summary-row">
                        <span>Subtotal:</span>
                        <span id="subtotal">₹0.00</span>
                    </div>

                    <div class="summary-row">
                        <span>Shipping:</span>
                        <span id="shipping">Free</span>
                    </div>

                    <div class="summary-row">
                        <span>Tax (10%):</span>
                        <span id="tax">₹0.00</span>
                    </div>

                    <div class="summary-row">
                        <span>Discount:</span>
                        <span id="discount" style="color: #27ae60;">-₹0.00</span>
                    </div>

                    <div class="summary-row total">
                        <span>Total:</span>
                        <span id="total">₹0.00</span>
                    </div>

                    <div style="background: #e8f5e9; border-left: 4px solid #27ae60; padding: 12px; border-radius: 4px; font-size: 12px; color: #155724; margin-top: 20px;">
                        <i class="fas fa-lock"></i> Your payment information is secure and encrypted.
                    </div>
                </div>
            </div>
        </div>

        <!-- Footer -->
         <footer id="footer" class="footer footer-premium">
        <!-- Premium Footer Widget Section -->
        <div class="footer--widget-premium">
            <div class="container">
                <div class="row">
                    <!-- Footer Logo & Description -->
                    <div class="col-xs-12 col-sm-12 col-md-3 footer--col-about">
                        <div class="footer--logo-section">
                            <img src="assets/images/logo/logo-light.png" alt="Granny Logo" class="footer--logo">
                            <p class="footer--tagline">Crafted with passion and served with love since 2015</p>
                            <div class="footer--description">
                                <p>Experience culinary excellence at Granny. Our award-winning chefs blend
                                    traditional flavors with modern techniques to create unforgettable dining
                                    moments.</p>
                            </div>
                        </div>
                        <!-- Follow Us Section -->
                        <div class="footer--social-icons-widget">
                            <p
                                style="font-size: 14px; margin-top: 20px; margin-bottom: 10px; color: #c59d5f; font-weight: 600;">
                                Follow Us</p>
                            <div class="social-icons-list">
                                <a href="#" class="social-icon-widget" title="Facebook"><i
                                        class="fa fa-facebook"></i></a>
                                <a href="#" class="social-icon-widget" title="Instagram"><i
                                        class="fa fa-instagram"></i></a>
                                <a href="#" class="social-icon-widget" title="Twitter"><i class="fa fa-twitter"></i></a>
                                <a href="#" class="social-icon-widget" title="Pinterest"><i
                                        class="fa fa-pinterest"></i></a>
                                <a href="#" class="social-icon-widget" title="TripAdvisor"><i
                                        class="fa fa-tripadvisor"></i></a>
                            </div>
                        </div>
                    </div>
                    <!-- .col-md-3 end -->

                    <!-- Quick Links -->
                    <div class="col-xs-12 col-sm-6 col-md-3 footer--col-links">
                        <h4 class="footer--title">Quick Links</h4>
                        <ul class="footer--menu">
                            <li><a href="index.html">Home</a></li>
                            <li><a href="menu-board.html">Our Menu</a></li>
                            <li><a href="page-about.html">About Us</a></li>
                            <li><a href="page-gallery.html">Gallery</a></li>
                            <li><a href="page-contacts.html">Contact</a></li>
                            <li><a href="blog-carousel.html">Blog</a></li>
                        </ul>
                    </div>
                    <!-- .col-md-3 end -->

                    <!-- Location & Hours -->
                    <div class="col-xs-12 col-sm-6 col-md-3 footer--col-info">
                        <h4 class="footer--title">Visit Us</h4>
                        <div class="footer--info-item">
                            <i class="fa fa-map-marker"></i>
                            <div class="footer--info-content">
                                <p><strong>Address</strong><br>22 Alnahas Building, 2 AlBahr St<br>Tanta,
                                    Al-Gharbia, Egypt</p>
                            </div>
                        </div>
                        <div class="footer--info-item">
                            <i class="fa fa-clock-o"></i>
                            <div class="footer--info-content">
                                <p><strong>Hours</strong><br>Mon-Fri: 9:00 AM – 12:00 AM<br>Sat: 8:00 AM – 3:00
                                    AM<br>Sun: Closed</p>
                            </div>
                        </div>
                    </div>
                    <!-- .col-md-3 end -->

                    <!-- Contact -->
                    <div class="col-xs-12 col-sm-12 col-md-3 footer--col-contact">
                        <h4 class="footer--title">Connect</h4>
                        <div class="footer--contact-info">
                            <p><i class="fa fa-phone"></i> <a href="tel:+201065370701">(+20) 106-537-0701</a></p>
                            <p><i class="fa fa-envelope"></i> <a href="mailto:info@granny.com">info@granny.com</a>
                            </p>
                        </div>
                        <a class="btn btn--secondary btn--sm" data-toggle="modal"
                            data-target="#reservationPopup">Reserve Table</a>
                    </div>
                </div>
                <!-- .col-md-3 end -->
            </div>
            <!-- .row end -->
        </div>
        <!-- .container end -->
        </div>
        <!-- .footer-widget-premium end -->

        <!-- Divider -->
        <div class="footer--divider"></div>

        <!-- Premium Copyright Section -->
        <div class="footer--copyright-premium">
            <div class="container">
                <div class="row">
                    <div class="col-xs-12 col-sm-12 col-md-12">
                        <div class="footer--copyright-wrapper">
                            <p class="footer--copyright-text">&copy; 2026 <strong>Granny Restaurant & Cafe</strong>. All
                                rights reserved. | Crafted with <i class="fa fa-heart"></i> for food lovers.</p>
                            <div class="footer--links-legal">
                                <a href="#">Privacy Policy</a>
                                <span class="separator">•</span>
                                <a href="#">Terms of Service</a>
                                <span class="separator">•</span>
                                <a href="#">Cookies</a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <!-- .container end -->
        </div>
        <!-- .footer-copyright-premium end -->
    </footer>
    </div>

    <!-- Scripts -->
    <script src="assets/js/jquery-2.2.4.min.js"></script>
    <script src="assets/js/plugins.js"></script>
    <script src="assets/js/functions.js"></script>
    <script src="assets/js/cart-manager.js"></script>

    <script>
        // Load cart and populate order summary
        function loadOrderSummary() {
            const cart = window.cartManager ? window.cartManager.getCart() : [];
            const orderItemsDiv = document.getElementById('orderItems');
            let subtotal = 0;

            orderItemsDiv.innerHTML = '';

            if (cart && cart.length > 0) {
                cart.forEach(item => {
                    const itemTotal = (item.price * item.quantity);
                    subtotal += itemTotal;

                    // Use item image if available, otherwise use placeholder
                    const itemImage = item.image || 'assets/images/placeholder.jpg';

                    const orderItemHTML = `
                        <div class="order-item">
                            <img src="${itemImage}" alt="${item.name}" class="item-image" onerror="this.src='assets/images/menu/default.jpg'">
                            <div class="item-details">
                                <div class="item-name">${item.name}</div>
                                <div class="item-qty">Qty: ${item.quantity} • ₹${item.price.toFixed(2)}</div>
                            </div>
                            <div class="item-price">₹${itemTotal.toFixed(2)}</div>
                        </div>
                    `;
                    orderItemsDiv.innerHTML += orderItemHTML;
                });
            }

            // Calculate totals
            const tax = subtotal * 0.10;
            const total = subtotal + tax;

            document.getElementById('subtotal').textContent = `₹${subtotal.toFixed(2)}`;
            document.getElementById('tax').textContent = `₹${tax.toFixed(2)}`;
            document.getElementById('total').textContent = `₹${total.toFixed(2)}`;
        }

        // Apply promo code
        function applyPromo() {
            const promoCode = document.getElementById('promoCode').value.toUpperCase();
            const discountEl = document.getElementById('discount');
            const totalEl = document.getElementById('total');

            if (promoCode === 'SAVE10') {
                const subtotal = parseFloat(document.getElementById('subtotal').textContent.replace('₹', ''));
                const discount = subtotal * 0.10;
                const tax = subtotal * 0.10;
                const total = subtotal + tax - discount;

                discountEl.textContent = `-₹${discount.toFixed(2)}`;
                totalEl.textContent = `₹${total.toFixed(2)}`;

                alert('Promo code applied successfully!');
            } else if (promoCode === '') {
                alert('Please enter a promo code');
            } else {
                alert('Invalid promo code');
            }
        }

        // Form submission
        document.getElementById('checkoutForm').addEventListener('submit', function(e) {
            e.preventDefault();

            const formData = new FormData(this);
            const data = Object.fromEntries(formData);

            // Validate required fields
            if (!data.fullName || !data.phone || !data.email || !data.address) {
                document.getElementById('errorMessage').textContent = 'Please fill in all required fields';
                document.getElementById('errorMessage').style.display = 'block';
                return;
            }

            if (!data.terms) {
                document.getElementById('errorMessage').textContent = 'Please agree to the Terms & Conditions';
                document.getElementById('errorMessage').style.display = 'block';
                return;
            }

            // Get cart items and totals
            const cart = window.cartManager.getCart() || [];
            if (cart.length === 0) {
                document.getElementById('errorMessage').textContent = 'Your cart is empty. Please add items before checkout';
                document.getElementById('errorMessage').style.display = 'block';
                return;
            }

            // Get user ID if logged in
            const user = localStorage.getItem('user');
            let userId = null;
            
            if (user) {
                try {
                    const userData = JSON.parse(user);
                    userId = userData.id || null;
                    console.log('✓ User logged in - ID:', userId, 'Data:', userData);
                } catch (e) {
                    console.error('Error parsing user data:', e);
                }
            } else {
                console.log('⚠ No user logged in (checkout as guest)');
            }

            // Get totals from the page
            const subtotalText = document.getElementById('subtotal').textContent.replace('₹', '').replace('$', '').trim();
            const taxText = document.getElementById('tax').textContent.replace('₹', '').replace('$', '').trim();
            const totalText = document.getElementById('total').textContent.replace('₹', '').replace('$', '').trim();

            const checkoutData = {
                fullName: data.fullName,
                email: data.email,
                phone: data.phone,
                address: data.address,
                paymentMethod: data.paymentMethod,
                userId: userId,
                items: cart,
                subtotal: parseFloat(subtotalText) || 0,
                tax: parseFloat(taxText) || 0,
                total: parseFloat(totalText) || 0
            };
            
            console.log('Sending checkout data to backend:', checkoutData);

            // Show loading state
            const submitBtn = document.querySelector('.btn-place-order');
            const originalText = submitBtn.textContent;
            submitBtn.disabled = true;
            submitBtn.textContent = 'Processing...';

            // Send to backend
            fetch('backend/checkout.php', {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json'
                },
                body: JSON.stringify(checkoutData)
            })
            .then(response => response.json())
            .then(data => {
                console.log('Checkout response:', data);
                
                if (data.success) {
                    document.getElementById('successMessage').style.display = 'block';
                    document.getElementById('errorMessage').style.display = 'none';

                    // Store order details
                    if (data.data) {
                        localStorage.setItem('lastOrder', JSON.stringify(data.data));
                    }

                    // Clear cart and redirect
                    setTimeout(() => {
                        if (window.cartManager) {
                            window.cartManager.clearCart();
                        }
                        window.location.href = 'index.php';
                    }, 2500);
                } else {
                    document.getElementById('errorMessage').textContent = data.message || 'Failed to place order';
                    document.getElementById('errorMessage').style.display = 'block';
                    
                    // Reset button
                    submitBtn.disabled = false;
                    submitBtn.textContent = originalText;
                }
            })
            .catch(error => {
                console.error('Checkout error:', error);
                document.getElementById('errorMessage').textContent = 'Error: ' + error.message;
                document.getElementById('errorMessage').style.display = 'block';
                
                // Reset button
                submitBtn.disabled = false;
                submitBtn.textContent = originalText;
            });
        });

        // Load summary on page load and pre-fill user data
        document.addEventListener('DOMContentLoaded', function() {
            loadOrderSummary();
            
            // Check if user is logged in and pre-fill form
            const user = localStorage.getItem('user');
            if (user) {
                try {
                    const userData = JSON.parse(user);
                    
                    // Pre-fill form fields
                    if (userData.name) {
                        document.getElementById('fullName').value = userData.name;
                    }
                    if (userData.email) {
                        document.getElementById('email').value = userData.email;
                    }
                    if (userData.phone) {
                        document.getElementById('phone').value = userData.phone;
                    }
                    
                    console.log('Form pre-filled with user data');
                } catch (e) {
                    console.error('Error parsing user data:', e);
                }
            }
        });
    </script>
        <style>
        .professional-booking-modal {
            border: none;
            border-radius: 12px;
            box-shadow: 0 10px 50px rgba(0, 0, 0, 0.2);
            overflow: hidden;
        }

        .professional-booking-header {
            background: linear-gradient(135deg, #d4a574 0%, #8b6f47 100%);
            border: none;
            color: white;
            padding: 30px;
            position: relative;
        }

        .booking-header-content h2 {
            font-size: 28px;
            font-weight: 600;
            margin: 0;
            margin-bottom: 8px;
            font-family: 'Raleway', sans-serif;
        }

        .booking-subtitle {
            font-size: 14px;
            margin: 0;
            opacity: 0.95;
            font-weight: 300;
        }

        .professional-booking-header .close {
            position: absolute;
            right: 20px;
            top: 20px;
            color: white;
            opacity: 0.8;
            font-size: 24px;
        }

        .professional-booking-header .close:hover {
            opacity: 1;
        }

        .professional-booking-body {
            padding: 40px;
            background: #f9f7f4;
        }

        .professional-booking-form {
            background: white;
            padding: 30px;
            border-radius: 8px;
            box-shadow: 0 2px 10px rgba(0, 0, 0, 0.05);
        }

        .booking-section {
            margin-bottom: 30px;
        }

        .booking-section-title {
            font-size: 16px;
            font-weight: 600;
            color: #333;
            margin-bottom: 20px;
            padding-bottom: 12px;
            border-bottom: 2px solid #d4a574;
            display: flex;
            align-items: center;
            gap: 10px;
        }

        .booking-section-title i {
            color: #d4a574;
            font-size: 18px;
        }

        .booking-divider {
            margin: 30px 0;
            border: none;
            border-top: 2px solid #e8e8e8;
        }

        .professional-booking-form .form-group {
            margin-bottom: 20px;
        }

        .professional-booking-form .form-group label {
            font-weight: 600;
            color: #333;
            margin-bottom: 8px;
            font-size: 13px;
            text-transform: uppercase;
            letter-spacing: 0.5px;
        }

        .professional-booking-form .form-control {
            border: 2px solid #e8e8e8;
            border-radius: 6px;
            padding: 12px 15px;
            font-size: 14px;
            transition: all 0.3s ease;
            background: #fafafa;
        }

        .professional-booking-form .form-control:focus {
            border-color: #d4a574;
            background: white;
            box-shadow: 0 0 0 3px rgba(212, 165, 116, 0.1);
            outline: none;
        }

        .professional-booking-form .form-control::placeholder {
            color: #999;
        }

        .professional-booking-form textarea.form-control {
            resize: vertical;
            min-height: 100px;
            font-family: 'Raleway', sans-serif;
        }

        .form-text {
            font-size: 12px;
            color: #999;
            margin-top: 5px;
        }

        .booking-actions {
            display: flex !important;
            gap: 15px !important;
            margin-top: 30px !important;
            justify-content: center !important;
            flex-wrap: wrap !important;
        }

        .professional-booking-form .booking-actions button {
            padding: 14px 35px !important;
            font-weight: 700 !important;
            border-radius: 8px !important;
            font-size: 15px !important;
            transition: all 0.3s cubic-bezier(0.25, 0.46, 0.45, 0.94) !important;
            min-width: 140px !important;
            line-height: 1.6 !important;
            display: inline-flex !important;
            align-items: center !important;
            justify-content: center !important;
            text-align: center !important;
            vertical-align: middle !important;
            cursor: pointer !important;
            letter-spacing: 0.5px !important;
            text-transform: uppercase !important;
            box-shadow: 0 4px 15px rgba(0, 0, 0, 0.1) !important;
        }

        .professional-booking-form .booking-actions .btn-outline-secondary {
            border: 2px solid #d4a574 !important;
            color: #d4a574 !important;
            background: white !important;
            box-shadow: 0 2px 10px rgba(212, 165, 116, 0.15) !important;
        }

        .professional-booking-form .booking-actions .btn-outline-secondary:hover,
        .professional-booking-form .booking-actions .btn-outline-secondary:active,
        .professional-booking-form .booking-actions .btn-outline-secondary:focus {
            border-color: #8b6f47 !important;
            color: white !important;
            background: linear-gradient(135deg, #d4a574 0%, #8b6f47 100%) !important;
            box-shadow: 0 6px 20px rgba(212, 165, 116, 0.35) !important;
            transform: translateY(-3px) !important;
        }

        .professional-booking-form .booking-actions .btn--secondary {
            background: linear-gradient(135deg, #d4a574 0%, #8b6f47 100%) !important;
            color: white !important;
            border: none !important;
            box-shadow: 0 4px 15px rgba(212, 165, 116, 0.25) !important;
            position: relative !important;
            overflow: hidden !important;
        }

        .professional-booking-form .booking-actions .btn--secondary::before {
            content: '' !important;
            position: absolute !important;
            top: 0 !important;
            left: -100% !important;
            width: 100% !important;
            height: 100% !important;
            background: rgba(255, 255, 255, 0.1) !important;
            transition: left 0.3s ease !important;
            z-index: 0 !important;
        }

        .professional-booking-form .booking-actions .btn--secondary:hover::before,
        .professional-booking-form .booking-actions .btn--secondary:active::before,
        .professional-booking-form .booking-actions .btn--secondary:focus::before {
            left: 100% !important;
        }

        .professional-booking-form .booking-actions .btn--secondary:hover,
        .professional-booking-form .booking-actions .btn--secondary:active,
        .professional-booking-form .booking-actions .btn--secondary:focus {
            transform: translateY(-3px) !important;
            box-shadow: 0 8px 25px rgba(212, 165, 116, 0.4) !important;
            background: linear-gradient(135deg, #8b6f47 0%, #d4a574 100%) !important;
            color: white !important;
            border: none !important;
        }

        .professional-booking-form .booking-actions button:active {
            transform: translateY(-1px) !important;
        }

        /* Mobile Responsiveness */
        @media (max-width: 576px) {
            .booking-actions {
                flex-direction: column !important;
                gap: 12px !important;
            }

            .professional-booking-form .booking-actions button {
                width: 100% !important;
                padding: 12px 20px !important;
                font-size: 14px !important;
                min-width: unset !important;
            }
        }

        @media (max-width: 768px) {
            .professional-booking-form .booking-actions button {
                padding: 12px 28px !important;
                font-size: 14px !important;
                min-width: 130px !important;
            }
        }

        @media (min-width: 769px) and (max-width: 992px) {
            .professional-booking-form .booking-actions button {
                padding: 13px 32px !important;
                font-size: 14px !important;
                min-width: 135px !important;
            }
        }

        .alert {
            border-radius: 6px;
            border: none;
            padding: 15px 20px;
            display: flex;
            align-items: center;
            gap: 12px;
        }

        .alert-success {
            background-color: #d4edda;
            color: #155724;
        }

        .alert-danger {
            background-color: #f8d7da;
            color: #721c24;
        }

        @media (max-width: 768px) {
            .professional-booking-body {
                padding: 20px;
            }

            .professional-booking-form {
                padding: 20px;
            }

            .booking-header-content h2 {
                font-size: 22px;
            }

            .booking-actions {
                flex-direction: column;
            }

            .booking-actions button {
                width: 100%;
            }
        }
    </style>

    <!-- Professional Booking Modal Scripts -->
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            const bookingForm = document.getElementById('professionalBookingForm');
            const successMessage = document.querySelector('.booking-success-message');
            const errorMessage = document.querySelector('.booking-error-message');

            // Set minimum date to today
            const today = new Date().toISOString().split('T')[0];
            document.getElementById('bookingDate').setAttribute('min', today);

            // Form submission
            if (bookingForm) {
                bookingForm.addEventListener('submit', function(e) {
                    e.preventDefault();

                    // Reset messages
                    successMessage.style.display = 'none';
                    errorMessage.style.display = 'none';

                    // Collect form data
                    const formData = new FormData(bookingForm);
                    const data = Object.fromEntries(formData);

                    // Validate data
                    if (!data.booking_name || !data.booking_email || !data.booking_phone ||
                        !data.booking_date || !data.booking_time || !data.booking_guests) {
                        errorMessage.querySelector('.error-message').textContent = 'Please fill in all required fields.';
                        errorMessage.style.display = 'flex';
                        return;
                    }

                    // Send booking data (you can modify this to your backend API)
                    console.log('Booking Data:', data);

                    // Show success message
                    successMessage.style.display = 'flex';

                    // Optional: Reset form and close modal after delay
                    setTimeout(function() {
                        bookingForm.reset();
                        $('#reservationPopup').modal('hide');
                    }, 2000);
                });
            }

            // Clear messages when modal is closed
            $('#reservationPopup').on('hidden.bs.modal', function() {
                successMessage.style.display = 'none';
                errorMessage.style.display = 'none';
            });
        });
    </script>
    <!-- End Professional Table Booking Modal -->

    <!-- Sign In Modal -->
    <div class="modal fade" tabindex="-1" role="dialog" id="signInModal">
        <div class="modal-dialog modal-lg" role="document">
            <div class="modal-content auth-modal-content">
                <button type="button" class="close auth-close-btn" data-dismiss="modal" aria-label="Close"><i
                        class="fa fa-times"></i></button>
                <div class="auth-modal-body">
                    <div class="auth-header">
                        <h2>Welcome Back</h2>
                        <p class="auth-subtitle">Sign in to your account</p>
                    </div>
                    <div id="signinMessage" class="auth-message" style="display: none;"></div>
                    <form class="auth-form" id="signInForm">
                        <div class="auth-form-group">
                            <label for="signinEmail" class="auth-label">Email Address</label>
                            <div class="auth-input-wrapper">
                                <i class="fas fa-envelope auth-input-icon"></i>
                                <input type="email" class="auth-input" id="signinEmail" name="email" placeholder="your@email.com"
                                    required>
                            </div>
                        </div>
                        <div class="auth-form-group">
                            <label for="signinPassword" class="auth-label">Password</label>
                            <div class="auth-input-wrapper">
                                <i class="fas fa-lock auth-input-icon"></i>
                                <input type="password" class="auth-input" id="signinPassword" name="password" placeholder="*********"
                                    required>
                            </div>
                        </div>
                        <div class="auth-form-group auth-remember">
                            <input type="checkbox" id="rememberMe" name="rememberMe">
                            <label for="rememberMe" class="auth-checkbox-label">Remember me</label>
                        </div>
                        <button type="submit" class="auth-btn">Sign In</button>
                    </form>
                    <div class="auth-divider">
                        <span>Don't have an account?</span>
                    </div>
                    <p class="auth-footer">
                        <a href="#" data-toggle="modal" data-dismiss="modal" data-target="#signUpModal"
                            class="auth-link">Create a new account</a>
                    </p>
                </div>
            </div>
        </div>
    </div>
    <!-- End Sign In Modal -->

    <!-- Sign Up Modal -->
    <div class="modal fade" tabindex="-1" role="dialog" id="signUpModal">
        <div class="modal-dialog modal-lg" role="document">
            <div class="modal-content auth-modal-content">
                <button type="button" class="close auth-close-btn" data-dismiss="modal" aria-label="Close"><i
                        class="fa fa-times"></i></button>
                <div class="auth-modal-body">
                    <div class="auth-header">
                        <h2>Create Account</h2>
                        <p class="auth-subtitle">Join us today</p>
                    </div>
                    <div id="signupMessage" class="auth-message" style="display: none;"></div>
                    <form class="auth-form" id="signUpForm">
                        <div class="auth-form-group">
                            <label for="signupName" class="auth-label">Full Name</label>
                            <div class="auth-input-wrapper">
                                <i class="fas fa-user auth-input-icon"></i>
                                <input type="text" class="auth-input" id="signupName" name="name" placeholder="John Doe" required>
                            </div>
                        </div>
                        <div class="auth-form-group">
                            <label for="signupEmail" class="auth-label">Email Address</label>
                            <div class="auth-input-wrapper">
                                <i class="fas fa-envelope auth-input-icon"></i>
                                <input type="email" class="auth-input" id="signupEmail" name="email" placeholder="your@email.com"
                                    required>
                            </div>
                        </div>
                        <div class="auth-form-group">
                            <label for="signupPassword" class="auth-label">Password</label>
                            <div class="auth-input-wrapper">
                                <i class="fas fa-lock auth-input-icon"></i>
                                <input type="password" class="auth-input" id="signupPassword" name="password" placeholder="*********"
                                    required>
                            </div>
                        </div>
                        <div class="auth-form-group">
                            <label for="signupConfirmPassword" class="auth-label">Confirm Password</label>
                            <div class="auth-input-wrapper">
                                <i class="fas fa-check-circle auth-input-icon"></i>
                                <input type="password" class="auth-input" id="signupConfirmPassword" name="confirmPassword"
                                    placeholder="*********" required>
                            </div>
                        </div>
                        <div class="auth-form-group auth-checkbox">
                            <input type="checkbox" id="agreeTerms" required>
                            <label for="agreeTerms" class="auth-checkbox-label">I agree to the <a href="#"
                                    class="auth-link-inline">Terms & Conditions</a></label>
                        </div>
                        <button type="submit" class="auth-btn">Create Account</button>
                    </form>
                    <div class="auth-divider">
                        <span>Already have an account?</span>
                    </div>
                    <p class="auth-footer">
                        <a href="#" data-toggle="modal" data-dismiss="modal" data-target="#signInModal"
                            class="auth-link">Sign In here</a>
                    </p>
                </div>
            </div>
        </div>
    </div>
    <!-- End Sign Up Modal -->

    <!-- Backend Integration Scripts -->
    <style>
        .auth-message {
            padding: 12px;
            border-radius: 6px;
            margin-bottom: 20px;
            font-weight: 500;
            display: flex;
            align-items: center;
            gap: 10px;
        }

        .auth-message.success {
            background: #d4edda;
            color: #155724;
            border: 1px solid #c3e6cb;
        }

        .auth-message.error {
            background: #f8d7da;
            color: #721c24;
            border: 1px solid #f5c6cb;
        }
    </style>
   

    <script>
        // Update header with user profile
        function updateHeaderWithUserProfile(userData) {
            // Desktop header auth section
            const navAuthSection = document.getElementById('navAuthSection');
            const navUserProfileDropdown = document.getElementById('navUserProfileDropdown');
            const navUserName = document.getElementById('navUserName');
            
            // Mobile auth section (inside menu)
            const mobileAuthSection = document.getElementById('mobileAuthSection');
            const mobileUserProfileSection = document.getElementById('mobileUserProfileSection');
            
            // Mobile profile icon (next to hamburger)
            const mobileProfileIconContainer = document.getElementById('mobileProfileIconContainer');
            const mobileUserName = document.getElementById('mobileUserName');
            
            // Hide sign in/sign up buttons (desktop)
            if (navAuthSection) {
                navAuthSection.style.display = 'none';
            }
            
            // Show user profile dropdown with username (desktop)
            if (navUserProfileDropdown) {
                navUserProfileDropdown.style.display = 'inline-block';
                navUserName.textContent = userData.name || userData.email;
            }
            
            // Hide mobile auth buttons inside hamburger menu and show mobile user profile
            if (mobileAuthSection) {
                mobileAuthSection.classList.add('hide-auth');
            }
            if (mobileUserProfileSection) {
                mobileUserProfileSection.style.display = 'block';
            }
            
            // Show mobile profile icon next to hamburger
            if (mobileProfileIconContainer) {
                mobileProfileIconContainer.classList.add('show');
                // Remove inline style to let CSS handle it
                mobileProfileIconContainer.style.display = '';
            }
            
            // Set mobile username
            if (mobileUserName) {
                mobileUserName.textContent = userData.name || userData.email;
            }
            
            console.log('Header updated for user:', userData.name);
        }


        // Check if user is already logged in on page load
        document.addEventListener('DOMContentLoaded', function() {
            const user = localStorage.getItem('user');
            if (user) {
                try {
                    const userData = JSON.parse(user);
                    updateHeaderWithUserProfile(userData);
                    console.log('User already logged in:', userData.name);
                } catch (e) {
                    console.error('Error parsing user data:', e);
                }
            }
        });

        // Reset header to show auth buttons (used on logout)
        function resetHeaderAuthSection() {
            // Desktop header auth section
            const navAuthSection = document.getElementById('navAuthSection');
            const navUserProfileDropdown = document.getElementById('navUserProfileDropdown');
            
            // Mobile auth section
            const mobileAuthSection = document.getElementById('mobileAuthSection');
            const mobileUserProfileSection = document.getElementById('mobileUserProfileSection');
            
            // Mobile profile icon (next to hamburger)
            const mobileProfileIconContainer = document.getElementById('mobileProfileIconContainer');
            
            // Show sign in/sign up buttons (desktop)
            if (navAuthSection) {
                navAuthSection.style.display = 'flex';
            }
            
            // Hide user profile dropdown (desktop)
            if (navUserProfileDropdown) {
                navUserProfileDropdown.style.display = 'none';
            }
            
            // Show mobile auth buttons and hide mobile user profile
            if (mobileAuthSection) {
                mobileAuthSection.classList.remove('hide-auth');
            }
            if (mobileUserProfileSection) {
                mobileUserProfileSection.style.display = 'none';
            }
            
            // Hide mobile profile icon
            if (mobileProfileIconContainer) {
                mobileProfileIconContainer.classList.remove('show');
                mobileProfileIconContainer.style.display = 'none';
            }
            
            console.log('Header reset to show auth buttons');
        }

        // Logout function
        function logout() {
            console.log('Logout function called');
            // Remove user data from localStorage first
            localStorage.removeItem('user');
            // Clear cart from localStorage on logout
            localStorage.removeItem('granny_cart');
            
            fetch('backend/logout.php')
            .then(response => response.json())
            .then(data => {
                console.log('Logout response:', data);
                if (data.success) {
                    // Reload after logout is complete
                    setTimeout(() => {
                        window.location.reload();
                    }, 500);
                }
            })
            .catch(error => {
                console.error('Logout error:', error);
                // Still logout on client side even if server fails
                setTimeout(() => {
                    window.location.reload();
                }, 500);
            });
        }

        // Logout button click handler
        document.addEventListener('DOMContentLoaded', function() {
            const logoutBtn = document.getElementById('navLogoutBtn');
            const mobileLogoutBtn = document.getElementById('mobileLogoutBtn');
            const mobileProfileLogoutBtn = document.getElementById('mobileProfileLogoutBtn');
            
            if (logoutBtn) {
                logoutBtn.addEventListener('click', function(e) {
                    e.preventDefault();
                    logout();
                });
            }
            
            if (mobileLogoutBtn) {
                mobileLogoutBtn.addEventListener('click', function(e) {
                    e.preventDefault();
                    logout();
                });
            }
            
            if (mobileProfileLogoutBtn) {
                mobileProfileLogoutBtn.addEventListener('click', function(e) {
                    e.preventDefault();
                    logout();
                });
            }
        });

        // Sign Up Handler
        document.getElementById('signUpForm').addEventListener('submit', function(e) {
            e.preventDefault();

            const formData = {
                name: document.getElementById('signupName').value,
                email: document.getElementById('signupEmail').value,
                password: document.getElementById('signupPassword').value,
                confirmPassword: document.getElementById('signupConfirmPassword').value
            };

            const messageDiv = document.getElementById('signupMessage');

            fetch('backend/signup.php', {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json'
                },
                body: JSON.stringify(formData)
            })
            .then(response => response.json())
            .then(data => {
                messageDiv.style.display = 'flex';
                if (data.success) {
                    messageDiv.className = 'auth-message success';
                    messageDiv.innerHTML = '<i class="fas fa-check-circle"></i> ' + data.message + ' Please sign in to continue.';
                    
                    // Clear form
                    document.getElementById('signUpForm').reset();
                    
                    // Do NOT store user data in localStorage - user must sign in first
                    
                    // Close sign up modal and open sign in modal
                    setTimeout(() => {
                        $('#signUpModal').modal('hide');
                        messageDiv.style.display = 'none';
                        // Show sign in modal after a short delay
                        setTimeout(() => {
                            $('#signInModal').modal('show');
                        }, 500);
                    }, 2000);
                } else {
                    messageDiv.className = 'auth-message error';
                    messageDiv.innerHTML = '<i class="fas fa-exclamation-circle"></i> ' + data.message;
                }
            })
            .catch(error => {
                messageDiv.style.display = 'flex';
                messageDiv.className = 'auth-message error';
                messageDiv.innerHTML = '<i class="fas fa-exclamation-circle"></i> Error: ' + error.message;
                console.error('Error:', error);
            });
        });

        // Sign In Handler
        document.getElementById('signInForm').addEventListener('submit', function(e) {
            e.preventDefault();

            const formData = {
                email: document.getElementById('signinEmail').value,
                password: document.getElementById('signinPassword').value,
                rememberMe: document.getElementById('rememberMe').checked
            };

            const messageDiv = document.getElementById('signinMessage');

            fetch('backend/signin.php', {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json'
                },
                body: JSON.stringify(formData)
            })
            .then(response => response.json())
            .then(data => {
                messageDiv.style.display = 'flex';
                if (data.success) {
                    messageDiv.className = 'auth-message success';
                    messageDiv.innerHTML = '<i class="fas fa-check-circle"></i> ' + data.message;
                    
                    // Clear form
                    document.getElementById('signInForm').reset();
                    
                    // Store user data in localStorage
                    localStorage.setItem('user', JSON.stringify(data.data));
                    
                    // Close modal
                    setTimeout(() => {
                        $('#signInModal').modal('hide');
                        messageDiv.style.display = 'none';
                        // Update header with user profile
                        updateHeaderWithUserProfile(data.data);
                        // Refresh page after successful sign-in
                        setTimeout(() => {
                            window.location.reload();
                        }, 500);
                    }, 2000);
                } else {
                    messageDiv.className = 'auth-message error';
                    messageDiv.innerHTML = '<i class="fas fa-exclamation-circle"></i> ' + data.message;
                }
            })
            .catch(error => {
                messageDiv.style.display = 'flex';
                messageDiv.className = 'auth-message error';
                messageDiv.innerHTML = '<i class="fas fa-exclamation-circle"></i> Error: ' + error.message;
                console.error('Error:', error);
            });
        });

        // Booking Handler
        document.getElementById('professionalBookingForm').addEventListener('submit', function(e) {
            e.preventDefault();

            const formData = {
                booking_name: document.getElementById('bookingName')?.value || '',
                booking_email: document.getElementById('bookingEmail')?.value || '',
                booking_phone: document.getElementById('bookingPhone')?.value || '',
                booking_date: document.getElementById('bookingDate')?.value || '',
                booking_time: document.getElementById('bookingTime')?.value || '',
                booking_guests: document.getElementById('bookingGuests')?.value || '',
                booking_occasion: document.getElementById('bookingOccasion')?.value || '',
                booking_table_type: document.getElementById('bookingTableType')?.value || '',
                booking_dietary: document.getElementById('bookingDietaryNeeds')?.value || '',
                booking_special_requests: document.getElementById('bookingSpecialRequests')?.value || ''
            };

            const successMessage = document.querySelector('.booking-success-message');
            const errorMessage = document.querySelector('.booking-error-message');

            console.log('Sending booking data:', formData);
            
            // Validate required fields
            if (!formData.booking_name || !formData.booking_email || !formData.booking_phone || !formData.booking_date || !formData.booking_time || !formData.booking_guests) {
                errorMessage.style.display = 'flex';
                errorMessage.querySelector('.error-message').textContent = 'Please fill in all required fields';
                successMessage.style.display = 'none';
                console.error('Validation failed: Missing required fields');
                return;
            }

            fetch('backend/booking.php', {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json'
                },
                body: JSON.stringify(formData)
            })
            .then(response => {
                console.log('Response status:', response.status);
                return response.json();
            })
            .then(data => {
                console.log('Booking response:', data);
                if (data.success) {
                    successMessage.style.display = 'flex';
                    errorMessage.style.display = 'none';
                    
                    // Update confirmation message with booking details
                    const confirmationDiv = document.getElementById('bookingConfirmation');
                    if (confirmationDiv && data.data) {
                        confirmationDiv.innerHTML = `
                            <strong>Booking ID:</strong> #${data.data.booking_id}<br>
                            <strong>Date:</strong> ${data.data.booking_date} at ${data.data.booking_time}<br>
                            <strong>Guests:</strong> ${data.data.guests} person(s)
                        `;
                    }
                    
                    // Store booking data
                    localStorage.setItem('lastBooking', JSON.stringify(data.data));
                    console.log('Booking saved to localStorage:', data.data);
                    
                    // Reset and close
                    setTimeout(() => {
                        document.getElementById('professionalBookingForm').reset();
                        $('#reservationPopup').modal('hide');
                        successMessage.style.display = 'none';
                        confirmationDiv.innerHTML = '';
                    }, 3500);
                } else {
                    errorMessage.style.display = 'flex';
                    errorMessage.querySelector('.error-message').textContent = data.message;
                    successMessage.style.display = 'none';
                    console.error('Booking error:', data.message);
                }
            })
            .catch(error => {
                errorMessage.style.display = 'flex';
                errorMessage.querySelector('.error-message').textContent = 'Error: ' + error.message;
                successMessage.style.display = 'none';
                console.error('Fetch error:', error);
            });
        });

        // Initialize user session on page load
        document.addEventListener('DOMContentLoaded', function() {
            const user = localStorage.getItem('user');
            if (user) {
                const userData = JSON.parse(user);
                console.log('User logged in:', userData);
                // Header is already updated by the earlier DOMContentLoaded event
            }
        });
    </script>
</body>

</html>
