<?php session_start(); ?>
<!DOCTYPE html>
<html dir="ltr" lang="en-US">

<head>
    <!-- Document Meta
    ============================================= -->
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <!--IE Compatibility Meta-->
    <meta name="author" content="zytheme">
    <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1">
    <meta name="description" content="Elegant Restaurant & Cafe Html5 Template">
    <link href="assets/images/favicon/favicon.png" rel="icon">

    <!-- Fonts
    ============================================= -->
    <link
        href="../css?family=Great+Vibes%7CKaushan+Script%7CRaleway:100,100i,200,200i,300,300i,400,400i,500,500i,600,600i,700,700i,800,800i,900,900i"
        rel="stylesheet" type="text/css">

    <!-- Font Awesome Icons -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">

    <!-- Stylesheets
    ============================================= -->
    <link href="assets/css/external.css" rel="stylesheet">
    <link href="assets/css/bootstrap.min.css" rel="stylesheet">
    <link href="assets/css/style.css" rel="stylesheet">
    <link href="assets/css/menu-board.css" rel="stylesheet">
    <link href="assets/css/cart.css" rel="stylesheet">
    <!-- SweetAlert2 CSS -->
    <link href="https://cdn.jsdelivr.net/npm/sweetalert2@11.7.28/dist/sweetalert2.min.css" rel="stylesheet">
    <!-- HTML5 shim, for IE6-8 support of HTML5 elements. All other JS at the end of file. -->
    <!--[if lt IE 9]>
      <script src="assets/js/html5shiv.js"></script>
      <script src="assets/js/respond.min.js"></script>
    <![endif]-->

    <!-- Document Title
    ============================================= -->
    <title>Granny | Elegant Restaurant & Cafe Html5 Template</title>
    <style>
        .contact-hero-simple {
            position: relative;
            height: 350px;
            display: flex;
            align-items: center;
            justify-content: center;
            overflow: hidden;
        }

        .hero-bg-wrapper {
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            z-index: 1;
        }

        .hero-bg-image {
            width: 100%;
            height: 100%;
            object-fit: cover;
            filter: brightness(0.5) saturate(1.2) contrast(1.1);
        }

        .hero-bg-overlay {
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background: linear-gradient(135deg, rgba(44, 24, 16, 0.6) 0%, rgba(44, 24, 16, 0.4) 100%);
            z-index: 2;
        }

        .hero-content-wrapper {
            position: relative;
            z-index: 3;
            text-align: left;
            width: 100%;
            max-width: 100%;
        }

        .hero-simple-title {
            font-size: 72px;
            font-weight: 700;
            color: #ffffff;
            margin: 0 0 20px 0;
            font-family: 'Raleway', sans-serif;
            text-shadow: 0 3px 15px rgba(0, 0, 0, 0.4);
            letter-spacing: 1px;
            animation: fadeInLeft 0.8s ease-out;
            line-height: 1.1;
            padding-left: 40px;
        }

        .hero-breadcrumb {
            display: flex;
            align-items: center;
            gap: 15px;
            padding-left: 40px;
            animation: fadeInLeft 0.8s ease-out 0.2s both;
        }

        .breadcrumb-link {
            color: #d4a574;
            text-decoration: none;
            font-size: 14px;
            font-weight: 600;
            display: flex;
            align-items: center;
            gap: 8px;
            transition: all 0.3s ease;
            letter-spacing: 0.5px;
        }

        .breadcrumb-link:hover {
            color: #e8c9a0;
            transform: translateX(5px);
        }

        .breadcrumb-link i {
            font-size: 16px;
        }

        .breadcrumb-separator {
            color: rgba(232, 201, 160, 0.6);
            font-size: 14px;
            font-weight: 600;
        }

        .breadcrumb-current {
            color: rgba(255, 255, 255, 0.8);
            font-size: 14px;
            font-weight: 500;
            letter-spacing: 0.5px;
        }

        @keyframes fadeInLeft {
            from {
                opacity: 0;
                transform: translateX(-30px);
            }

            to {
                opacity: 1;
                transform: translateX(0);
            }
        }
    </style>
</head>

<body>
    <div class="preloader">
        <div class="spinner">
            <div class="bounce1"></div>
            <div class="bounce2"></div>
            <div class="bounce3"></div>
        </div>
    </div>
    <!-- Document Wrapper
	============================================= -->
    <div id="wrapper" class="wrapper clearfix">
        <!-- New Header -->
        <!-- Top Announcement Bar -->
        <div class="header-top-bar">
            <div class="container">
                <div class="header-top-bar-text">Welcome to Granny Restaurant & Catering Services</div>
                <div class="header-social-icons">
                    <a href="#" title="Facebook"><i class="fab fa-facebook-f"></i></a>
                    <a href="#" title="Twitter"><i class="fab fa-twitter"></i></a>
                    <a href="#" title="Instagram"><i class="fab fa-instagram"></i></a>
                    <a href="#" title="WhatsApp"><i class="fab fa-whatsapp"></i></a>
                    <a href="#" title="YouTube"><i class="fab fa-youtube"></i></a>
                </div>
            </div>
        </div>

        <!-- Main Header -->
        <header class="header-main">
            <div class="container">
                <div class="header-logo">
                    <a href="index.php"><img src="assets/images/logo/logo-dark.png" alt="Granny Logo"></a>
                </div>

                <div style="display: flex; align-items: center; gap: 20px; flex: 1;">
                    <div class="header-contact-info">
                        <a href="tel:+919876543210" class="header-contact-item">
                            <i class="fas fa-phone"></i>
                            <div class="header-contact-text">
                                <span class="header-contact-label">Call Us:</span>
                                <span class="header-contact-value">+91 98765 43210</span>
                            </div>
                        </a>
                        <a href="mailto:info@granny.com" class="header-contact-item">
                            <i class="fas fa-envelope"></i>
                            <div class="header-contact-text">
                                <span class="header-contact-label">Mail Us:</span>
                                <span class="header-contact-value">info@granny.com</span>
                            </div>
                        </a>
                        <a href="#" class="header-contact-item">
                            <i class="fas fa-map-marker-alt"></i>
                            <div class="header-contact-text">
                                <span class="header-contact-label">Location:</span>
                                <span class="header-contact-value">Egypt</span>
                            </div>
                        </a>
                    </div>
                    <div class="header-booking-section" id="bookingSection">
                        <button class="header-booking-btn" data-toggle="modal" data-target="#reservationPopup">Table Booking</button>
                    </div>
                    <div class="user-profile-dropdown" id="userProfileDropdown" style="display: none;">
                        <button class="user-profile-btn" id="userProfileBtn">
                            <i class="fas fa-user-circle"></i>
                            <span class="user-name" id="userName"></span>
                        </button>
                        <div class="user-dropdown-menu" id="userDropdownMenu">
                            <a href="#" class="dropdown-item user-profile-link">
                                <i class="fas fa-user"></i> My Profile
                            </a>
                            <a href="#" class="dropdown-item user-settings-link">
                                <i class="fas fa-cog"></i> Settings
                            </a>
                            <div class="dropdown-divider"></div>
                            <a href="#" class="dropdown-item user-logout-link" id="logoutBtn">
                                <i class="fas fa-sign-out-alt"></i> Logout
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </header>
        <!-- Navigation Bar -->
        <nav class="header-nav-bar">
            <div class="container"
                style="display: flex; justify-content: space-between; align-items: center; padding: 0;">
                <div class="header-navbar-logo">
                    <a href="index.php"><img src="assets/images/logo/logo-light.png" alt="Granny Logo"></a>
                </div>
                <ul class="header-nav-menu" id="headerNavMenu">
                    <li><a href="index.php">Home</a></li>
                    <li>
                        <a href="about.php">About Us</a>

                    </li>
                    <li>
                        <a href="menu.php">Menu</a>

                    </li>
                    <li><a href="chefs.php">Our Chefs</a></li>
                    <li><a href="blog.php">Blog</a></li>
                    <!-- <li><a href="shop-4cols.html">Shop</a></li> -->
                    <li><a href="gallery.php">Gallery</a></li>
                    <li><a href="contacts.php">Contact Us</a></li>
                    <!-- Mobile Only Cart Icon -->
                    <li class="mobile-cart-item"
                        style="border-top: 2px solid #c59d5f; margin: 10px 0; padding: 10px 15px;">
                        <a href="cart.php" class="header-cart-icon"
                            style="display: flex; align-items: center; gap: 10px; color: #ffffff; text-decoration: none; padding: 0; font-size: 16px;">
                            <i class="fas fa-shopping-cart"></i>
                            <span>Cart</span>
                            <span class="header-cart-count">0</span>
                        </a>
                    </li>
                    <!-- Mobile Only Booking Button -->
                    <li class="mobile-booking-item">
                        <button class="header-booking-btn" data-toggle="modal" data-target="#reservationPopup"
                            style="width: 100%; display: block; padding: 12px 15px; background-color: #c59d5f; color: #ffffff; border: none; border-radius: 4px; font-size: 14px; font-weight: 700; text-transform: uppercase; cursor: pointer; transition: all 0.3s ease;">Booking</button>
                    </li>
                    <!-- Mobile Only Auth Section -->
                    <li class="mobile-auth-divider" id="mobileAuthSection"
                        style="border-top: 2px solid #c59d5f; margin: 10px 0; padding: 10px 0;">
                        <a href="#" class="header-auth-btn header-signin-btn" data-toggle="modal"
                            data-target="#signInModal"
                            style="display: block; padding: 12px 15px; text-align: center; width: 100%; box-sizing: border-box; margin-bottom: 10px; border: 2px solid #c59d5f; background-color: transparent; color: #c59d5f; border-radius: 4px; font-size: 14px; font-weight: 600;">Sign
                            In</a>
                        <a href="#" class="header-auth-btn header-signup-btn" data-toggle="modal"
                            data-target="#signUpModal"
                            style="display: block; padding: 12px 15px; text-align: center; width: 100%; box-sizing: border-box; background-color: #c59d5f; color: #ffffff; border: 2px solid #c59d5f; border-radius: 4px; font-size: 14px; font-weight: 600;">Sign
                            Up</a>
                    </li>

                </ul>
                <div class="header-nav-right">
                    <a href="cart.php" class="header-cart-icon">
                        <i class="fas fa-shopping-cart"></i>
                        <span class="header-cart-count">0</span>
                    </a>
                    <div class="header-auth-section" id="navAuthSection">
                        <a href="#" class="header-auth-btn header-signin-btn" data-toggle="modal"
                            data-target="#signInModal">Sign In</a>
                        <a href="#" class="header-auth-btn header-signup-btn" data-toggle="modal"
                            data-target="#signUpModal">Sign Up</a>
                    </div>
                    <div class="nav-user-profile-dropdown" id="navUserProfileDropdown" style="display: none;">
                        <button class="nav-user-profile-btn" id="navUserProfileBtn">
                            <i class="fas fa-user-circle"></i>
                            <span class="nav-user-name" id="navUserName"></span>
                        </button>
                        <div class="nav-user-dropdown-menu" id="navUserDropdownMenu">
                            <a href="dashboard.php" class="dropdown-item user-profile-link">
                                <i class="fa-solid fa-gauge"></i> Dashboard
                            </a>
                            <!-- <a href="#" class="dropdown-item user-settings-link">
                                <i class="fas fa-cog"></i> Settings
                            </a> -->
                            <!-- <div class="dropdown-divider"></div> -->
                            <a href="#" class="dropdown-item user-logout-link" id="navLogoutBtn">
                                <i class="fas fa-sign-out-alt"></i> Logout
                            </a>
                        </div>
                    </div>
                </div>
                <!-- Mobile Profile Icon (shown when logged in) -->
                <div class="mobile-profile-icon-container" id="mobileProfileIconContainer" style="display: none;">
                    <button class="mobile-profile-icon-btn" id="mobileProfileIconBtn">
                        <i class="fas fa-user-circle"></i>
                        <span class="mobile-user-name" id="mobileUserName"></span>
                    </button>
                    <div class="mobile-profile-dropdown-menu" id="mobileProfileDropdownMenu">
                        <a href="dashboard.php" class="dropdown-item user-profile-link">
                            <i class="fa-solid fa-gauge"></i> Dashboard
                        </a>
                        <!-- <a href="#" class="dropdown-item user-settings-link">
                            <i class="fas fa-cog"></i> Settings
                        </a> -->
                        <!-- <div class="dropdown-divider"></div> -->
                        <a href="#" class="dropdown-item user-logout-link" id="mobileProfileLogoutBtn">
                            <i class="fas fa-sign-out-alt"></i> Logout
                        </a>
                    </div>
                </div>
                <button class="header-mobile-toggle" id="headerMenuToggle">
                    <i class="fas fa-bars"></i>
                    <span class="hamburger-cart-badge header-cart-count">0</span>
                </button>
            </div>
        </nav>
        <!-- End Header -->


        <!-- Page Title #4
============================================= -->
        <section id="contact-hero" class="contact-hero-simple">
            <div class="hero-bg-wrapper">
                <img src="assets/images/page-title/7.jpg" alt="Contact Background" class="hero-bg-image">
                <div class="hero-bg-overlay"></div>
            </div>

            <div class="hero-content-wrapper">
                <h1 class="hero-simple-title">Shopping Cart</h1>

                <!-- Breadcrumb Navigation -->
                <nav class="hero-breadcrumb">
                    <a href="index.html" class="breadcrumb-link">
                        <i class="fas fa-home"></i> Home
                    </a>
                    <span class="breadcrumb-separator">/</span>
                    <span class="breadcrumb-current">Cart</span>
                </nav>
            </div>
        </section>
        <!-- #page-title end -->

        <!-- Cart Section -->
        <section class="cart-container">
            <div class="container">
                <div class="row">
                    <div class="col-xs-12">
                        <div id="cart-content">
                            <!-- Cart content will be loaded here by JavaScript -->
                        </div>
                    </div>
                </div>
            </div>
        </section>
        <!-- End Cart Section -->


        <!-- footer#1
============================================= -->

        <footer id="footer" class="footer footer-premium">
            <!-- Premium Footer Widget Section -->
            <div class="footer--widget-premium">
                <div class="container">
                    <div class="row">
                        <!-- Footer Logo & Description -->
                        <div class="col-xs-12 col-sm-12 col-md-3 footer--col-about">
                            <div class="footer--logo-section">
                                <img src="assets/images/logo/logo-light.png" alt="Granny Logo" class="footer--logo">
                                <p class="footer--tagline">Crafted with passion and served with love since 2015</p>
                                <div class="footer--description">
                                    <p>Experience culinary excellence at Granny. Our award-winning chefs blend
                                        traditional flavors with modern techniques to create unforgettable dining
                                        moments.</p>
                                </div>
                            </div>
                            <!-- Follow Us Section -->
                            <div class="footer--social-icons-widget">
                                <p
                                    style="font-size: 14px; margin-top: 20px; margin-bottom: 10px; color: #c59d5f; font-weight: 600;">
                                    Follow Us</p>
                                <div class="social-icons-list">
                                    <a href="#" class="social-icon-widget" title="Facebook"><i
                                            class="fa fa-facebook"></i></a>
                                    <a href="#" class="social-icon-widget" title="Instagram"><i
                                            class="fa fa-instagram"></i></a>
                                    <a href="#" class="social-icon-widget" title="Twitter"><i class="fa fa-twitter"></i></a>
                                    <a href="#" class="social-icon-widget" title="Pinterest"><i
                                            class="fa fa-pinterest"></i></a>
                                    <a href="#" class="social-icon-widget" title="TripAdvisor"><i
                                            class="fa fa-tripadvisor"></i></a>
                                </div>
                            </div>
                        </div>
                        <!-- .col-md-3 end -->

                        <!-- Quick Links -->
                        <div class="col-xs-12 col-sm-6 col-md-3 footer--col-links">
                            <h4 class="footer--title">Quick Links</h4>
                            <ul class="footer--menu">
                                <li><a href="index.html">Home</a></li>
                                <li><a href="menu-board.html">Our Menu</a></li>
                                <li><a href="page-about.html">About Us</a></li>
                                <li><a href="page-gallery.html">Gallery</a></li>
                                <li><a href="page-contacts.html">Contact</a></li>
                                <li><a href="blog-carousel.html">Blog</a></li>
                            </ul>
                        </div>
                        <!-- .col-md-3 end -->

                        <!-- Location & Hours -->
                        <div class="col-xs-12 col-sm-6 col-md-3 footer--col-info">
                            <h4 class="footer--title">Visit Us</h4>
                            <div class="footer--info-item">
                                <i class="fa fa-map-marker"></i>
                                <div class="footer--info-content">
                                    <p><strong>Address</strong><br>22 Alnahas Building, 2 AlBahr St<br>Tanta,
                                        Al-Gharbia, Egypt</p>
                                </div>
                            </div>
                            <div class="footer--info-item">
                                <i class="fa fa-clock-o"></i>
                                <div class="footer--info-content">
                                    <p><strong>Hours</strong><br>Mon-Fri: 9:00 AM – 12:00 AM<br>Sat: 8:00 AM – 3:00
                                        AM<br>Sun: Closed</p>
                                </div>
                            </div>
                        </div>
                        <!-- .col-md-3 end -->

                        <!-- Contact -->
                        <div class="col-xs-12 col-sm-12 col-md-3 footer--col-contact">
                            <h4 class="footer--title">Connect</h4>
                            <div class="footer--contact-info">
                                <p><i class="fa fa-phone"></i> <a href="tel:+201065370701">(+20) 106-537-0701</a></p>
                                <p><i class="fa fa-envelope"></i> <a href="mailto:info@granny.com">info@granny.com</a>
                                </p>
                            </div>
                            <a class="btn btn--secondary btn--sm" data-toggle="modal"
                                data-target="#reservationPopup">Reserve Table</a>
                        </div>
                        <!-- .col-md-3 end -->
                    </div>
                    <!-- .row end -->
                </div>
                <!-- .container end -->
            </div>
            <!-- .footer-widget-premium end -->

            <!-- Divider -->
            <div class="footer--divider"></div>

            <!-- Premium Copyright Section -->
            <div class="footer--copyright-premium">
                <div class="container">
                    <div class="row">
                        <div class="col-xs-12 col-sm-12 col-md-12">
                            <div class="footer--copyright-wrapper">
                                <p class="footer--copyright-text">&copy; 2026 <strong>Granny Restaurant & Cafe</strong>.
                                    All rights reserved. | Crafted with <i class="fa fa-heart"></i> for food lovers.</p>
                                <div class="footer--links-legal">
                                    <a href="#">Privacy Policy</a>
                                    <span class="separator">•</span>
                                    <a href="#">Terms of Service</a>
                                    <span class="separator">•</span>
                                    <a href="#">Cookies</a>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <!-- .container end -->
            </div>
            <!-- .footer-copyright-premium end -->
        </footer>
        <!-- #wrapper end -->

        <!-- Footer Scripts
============================================= -->
        <script data-cfasync="false" src="/cdn-cgi/scripts/5c5dd728/cloudflare-static/email-decode.min.js"></script>
        <script src="assets/js/jquery-2.2.4.min.js"></script>
        <script src="assets/js/plugins.js"></script>
        <script src="assets/js/functions.js"></script>
        <!-- SweetAlert2 JS -->
        <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11.7.28/dist/sweetalert2.all.min.js"></script>
        <script src="assets/js/cart-manager.js"></script>

        <!-- Cart Display Script -->
        <script>
            // Debug: Log immediately when script loads
            console.log('=== CART.PHP SCRIPT LOADED ===');
            console.log('document.readyState:', document.readyState);
            console.log('window.cartManager at script load:', window.cartManager);

            // Immediate check - log cartManager state before any delays
            setTimeout(function() {
                console.log('=== Initial cartManager state (100ms) ===');
                console.log('window.cartManager:', window.cartManager);
                if (window.cartManager) {
                    console.log('cartManager type:', typeof window.cartManager);
                    console.log('cartManager keys:', Object.keys(window.cartManager));
                    console.log('isReady property:', window.cartManager.isReady);
                    console.log('isReady type:', typeof window.cartManager.isReady);
                    console.log('isLoggedIn:', window.cartManager.isLoggedIn);
                    console.log('storageKey:', window.cartManager.storageKey);
                } else {
                    console.error('ERROR: window.cartManager is not defined!');
                }
            }, 100);

            setTimeout(function() {
                console.log('=== Second check (500ms) ===');
                if (window.cartManager) {
                    console.log('isReady:', window.cartManager.isReady);
                }
            }, 500);

            setTimeout(function() {
                console.log('=== Third check (1000ms) ===');
                if (window.cartManager) {
                    console.log('isReady:', window.cartManager.isReady);
                }
            }, 1000);

            // Simple test to see if script is running at all
            console.log('Cart script loaded!');
            console.log('document.readyState:', document.readyState);

            // Flag to prevent multiple simultaneous updates
            var isUpdating = false;
            var cartEventListenerAttached = false;

            function displayCartItems() {
                console.log('displayCartItems called');

                // Get the cartManager
                console.log('window.cartManager:', window.cartManager);
                if (!window.cartManager) {
                    console.error('cartManager not available!');
                    setTimeout(displayCartItems, 100);
                    return;
                }

                console.log('cartManager.isReady:', window.cartManager.isReady);
                if (!window.cartManager.isReady) {
                    console.log('Waiting for cartManager to be ready...');
                    setTimeout(displayCartItems, 100);
                    return;
                }

                console.log('Getting cart data...');
                var cart = window.cartManager.getCart();
                console.log('Cart data:', cart);
                console.log('Cart items count:', cart ? cart.length : 0);

                var cartContent = document.getElementById('cart-content');
                console.log('cartContent element:', cartContent);

                if (!cartContent) {
                    console.error('cart-content element not found!');
                    // Add visible error message
                    var body = document.body;
                    var errorDiv = document.createElement('div');
                    errorDiv.style.color = 'red';
                    errorDiv.style.padding = '20px';
                    errorDiv.innerHTML = 'ERROR: cart-content element not found!';
                    body.appendChild(errorDiv);
                    return;
                }

                if (!cart || cart.length === 0) {
                    console.log('Cart is empty, showing empty message');
                    var emptyHtml = '<div class="empty-cart" style="text-align: center; padding: 40px 20px;">' +
                        '<div class="empty-cart-icon" style="font-size: 48px; margin-bottom: 20px;">' +
                        '<i class="fas fa-shopping-cart"></i>' +
                        '</div>' +
                        '<p class="empty-cart-text" style="font-size: 24px; margin: 10px 0;">Your cart is empty</p>' +
                        '<p class="empty-cart-desc" style="font-size: 14px; color: #666; margin: 10px 0;">Add some delicious items to your cart to continue shopping</p>' +
                        '<a href="menu.php" class="btn-continue-shopping-empty" style="display: inline-block; padding: 10px 20px; background: #d4a574; color: white; text-decoration: none; border-radius: 4px; margin-top: 20px;">Continue Shopping</a>' +
                        '</div>';
                    cartContent.innerHTML = emptyHtml;
                    return;
                }

                console.log('Building cart table with ' + cart.length + ' items');
                var html = '<table class="cart-table" style="width: 100%; border-collapse: collapse;"><thead><tr><th style="text-align: left; padding: 10px; border-bottom: 2px solid #ddd;">Image</th><th style="text-align: left; padding: 10px; border-bottom: 2px solid #ddd;">Item</th><th style="text-align: left; padding: 10px; border-bottom: 2px solid #ddd;">Price</th><th style="text-align: left; padding: 10px; border-bottom: 2px solid #ddd;">Quantity</th><th style="text-align: left; padding: 10px; border-bottom: 2px solid #ddd;">Total</th><th style="text-align: left; padding: 10px; border-bottom: 2px solid #ddd;"></th></tr></thead><tbody>';

                var grandTotal = 0;
                for (var i = 0; i < cart.length; i++) {
                    var item = cart[i];
                    console.log('Processing item:', item);
                    var itemTotal = parseFloat(item.price) * parseInt(item.quantity);
                    grandTotal += itemTotal;

                    html += '<tr style="border-bottom: 1px solid #eee;">' +
                        '<td data-label="Image" style="padding: 10px;">' +
                        '<img src="' + item.image + '" alt="' + item.name + '" class="cart-item-image" onerror="this.src=\'assets/images/no-image.png\'" style="max-width: 80px; height: auto; display: block;">' +
                        '</td>' +
                        '<td data-label="Item" style="padding: 10px;">' +
                        '<span class="cart-item-name">' + item.name + '</span>' +
                        '</td>' +
                        '<td data-label="Price" style="padding: 10px;">' +
                        '<span class="cart-item-price">₹' + parseFloat(item.price).toFixed(2) + '</span>' +
                        '</td>' +
                        '<td data-label="Quantity" style="padding: 10px;">' +
                        '<div class="quantity-control" style="display: flex; align-items: center; gap: 5px;">' +
                        '<button class="qty-minus" data-item-id="' + item.item_id + '" style="padding: 5px 10px; cursor: pointer;">−</button>' +
                        '<input type="number" class="qty-input" value="' + item.quantity + '" min="1" data-item-id="' + item.item_id + '" style="width: 50px; padding: 5px;">' +
                        '<button class="qty-plus" data-item-id="' + item.item_id + '" style="padding: 5px 10px; cursor: pointer;">+</button>' +
                        '</div>' +
                        '</td>' +
                        '<td data-label="Total" style="padding: 10px;">' +
                        '<span class="cart-item-price">₹' + itemTotal.toFixed(2) + '</span>' +
                        '</td>' +
                        '<td data-label="" style="padding: 10px;">' +
                        '<button class="remove-btn" data-item-id="' + item.item_id + '" style="padding: 5px 10px; background: #ff4444; color: white; border: none; border-radius: 3px; cursor: pointer;">' +
                        '<i class="fas fa-trash"></i>' +
                        '</button>' +
                        '</td>' +
                        '</tr>';
                }

                html += '</tbody></table>' +
                    '<div class="row" style="margin-top: 30px;">' +
                    '<div class="col-xs-12 col-sm-12 col-md-8"></div>' +
                    '<div class="col-xs-12 col-sm-12 col-md-4">' +
                    '<div class="cart-summary" style="background: #f5f5f5; padding: 20px; border-radius: 5px;">' +
                    '<div class="cart-summary-row" style="display: flex; justify-content: space-between; margin-bottom: 10px;">' +
                    '<span>Subtotal:</span>' +
                    '<span>₹' + grandTotal.toFixed(2) + '</span>' +
                    '</div>' +
                    '<div class="cart-summary-row" style="display: flex; justify-content: space-between; margin-bottom: 10px;">' +
                    '<span>Shipping:</span>' +
                    '<span>Free</span>' +
                    '</div>' +
                    '<div class="cart-summary-row" style="display: flex; justify-content: space-between; margin-bottom: 10px;">' +
                    '<span>Tax (10%):</span>' +
                    '<span>₹' + (grandTotal * 0.10).toFixed(2) + '</span>' +
                    '</div>' +
                    '<div class="cart-summary-row total" style="display: flex; justify-content: space-between; font-weight: bold; font-size: 16px; padding-top: 10px; border-top: 2px solid #ddd;">' +
                    '<span>Total:</span>' +
                    '<span>₹' + (grandTotal * 1.10).toFixed(2) + '</span>' +
                    '</div>' +
                    '<div class="cart-actions" style="margin-top: 20px; display: flex; flex-direction: column; gap: 10px;">' +
                    '<button class="btn-continue-shopping" onclick="window.location.href=\'menu.php\'" style="padding: 10px 20px; background: #666; color: white; border: none; border-radius: 4px; cursor: pointer; font-size: 14px;">Continue Shopping</button>' +
                    '<button class="btn-checkout" onclick="proceedToCheckout()" style="padding: 10px 20px; background: #d4a574; color: white; border: none; border-radius: 4px; cursor: pointer; font-size: 14px; font-weight: bold;">Proceed to Checkout</button>' +
                    '</div>' +
                    '</div>' +
                    '</div>' +
                    '</div>';

                console.log('Setting HTML, length:', html.length);
                cartContent.innerHTML = html;
                console.log('HTML set successfully');

                // Attach event handlers using event delegation for better cross-browser compatibility
                attachEventHandlers();
            }

            function attachEventHandlers() {
                var cartContent = document.getElementById('cart-content');
                if (!cartContent) {
                    console.error('cart-content element not found for event delegation');
                    return;
                }

                // Only attach listeners once
                if (cartEventListenerAttached) {
                    console.log('Event listeners already attached, skipping');
                    return;
                }

                cartEventListenerAttached = true;
                console.log('Attaching event listeners to cart-content');

                // Use event delegation - attach single listener to parent container
                cartContent.addEventListener('click', function(e) {
                    // Prevent multiple simultaneous updates
                    if (isUpdating) {
                        console.warn('Update already in progress, ignoring click');
                        return;
                    }

                    // Handle plus button
                    var plusBtn = e.target.closest('.qty-plus');
                    if (plusBtn) {
                        e.preventDefault();
                        e.stopPropagation();
                        isUpdating = true;

                        var itemId = plusBtn.getAttribute('data-item-id');
                        console.log('=== PLUS BUTTON CLICKED ===');
                        console.log('Item ID:', itemId);

                        // Get current quantity from cartManager (source of truth)
                        var cart = window.cartManager.getCart() || [];
                        console.log('Current cart length:', cart.length);

                        var item = null;
                        for (var j = 0; j < cart.length; j++) {
                            console.log('Checking item:', j, 'id=', cart[j].item_id, 'qty=', cart[j].quantity);
                            if (String(cart[j].item_id) === String(itemId)) {
                                item = cart[j];
                                break;
                            }
                        }

                        if (!item) {
                            console.error('Item not found in cart');
                            isUpdating = false;
                            return;
                        }

                        var currentQty = parseInt(item.quantity) || 1;
                        var newQty = currentQty + 1;

                        console.log('Current qty:', currentQty, 'New qty:', newQty);

                        // Max quantity limit of 10
                        if (newQty > 10) {
                            Swal.fire('Limit Reached', 'Maximum quantity is 10 per item', 'warning');
                            isUpdating = false;
                            return;
                        }

                        // Call update
                        window.cartManager.updateQuantity(itemId, newQty).then(function() {
                            console.log('Quantity update promise resolved');
                            // After update, verify the new quantity
                            var updatedCart = window.cartManager.getCart();
                            for (var k = 0; k < updatedCart.length; k++) {
                                if (String(updatedCart[k].item_id) === String(itemId)) {
                                    console.log('Verified new qty in cart:', updatedCart[k].quantity);
                                    break;
                                }
                            }
                            isUpdating = false;
                            setTimeout(function() {
                                displayCartItems();
                            }, 100);
                        }).catch(function(error) {
                            console.error('Error updating quantity:', error);
                            isUpdating = false;
                        });
                        return;
                    }

                    // Handle minus button
                    var minusBtn = e.target.closest('.qty-minus');
                    if (minusBtn) {
                        e.preventDefault();
                        e.stopPropagation();
                        isUpdating = true;

                        var itemId = minusBtn.getAttribute('data-item-id');
                        console.log('=== MINUS BUTTON CLICKED ===');
                        console.log('Item ID:', itemId);

                        // Get current quantity from cartManager (source of truth)
                        var cart = window.cartManager.getCart() || [];
                        console.log('Current cart length:', cart.length);

                        var item = null;
                        for (var j = 0; j < cart.length; j++) {
                            console.log('Checking item:', j, 'id=', cart[j].item_id, 'qty=', cart[j].quantity);
                            if (String(cart[j].item_id) === String(itemId)) {
                                item = cart[j];
                                break;
                            }
                        }

                        if (!item) {
                            console.error('Item not found in cart');
                            isUpdating = false;
                            return;
                        }

                        var currentQty = parseInt(item.quantity) || 1;
                        var newQty = currentQty - 1;

                        console.log('Current qty:', currentQty, 'New qty:', newQty);

                        // If quantity would go to 0 or below, remove the item
                        if (newQty <= 0) {
                            console.log('Qty would be ' + newQty + ', removing item instead');

                            window.cartManager.removeFromCart(itemId).then(function() {
                                console.log('Item removed successfully');
                                isUpdating = false;
                                setTimeout(function() {
                                    displayCartItems();
                                }, 100);
                            }).catch(function(error) {
                                console.error('Error removing item:', error);
                                isUpdating = false;
                            });
                            return;
                        }

                        // Otherwise update quantity
                        window.cartManager.updateQuantity(itemId, newQty).then(function() {
                            console.log('Quantity update promise resolved');
                            // After update, verify the new quantity
                            var updatedCart = window.cartManager.getCart();
                            for (var k = 0; k < updatedCart.length; k++) {
                                if (String(updatedCart[k].item_id) === String(itemId)) {
                                    console.log('Verified new qty in cart:', updatedCart[k].quantity);
                                    break;
                                }
                            }
                            isUpdating = false;
                            setTimeout(function() {
                                displayCartItems();
                            }, 100);
                        }).catch(function(error) {
                            console.error('Error updating quantity:', error);
                            isUpdating = false;
                        });
                        return;
                    }

                    // Handle remove button
                    var removeBtn = e.target.closest('.remove-btn');
                    if (removeBtn) {
                        e.preventDefault();
                        e.stopPropagation();
                        isUpdating = true;

                        var itemId = removeBtn.getAttribute('data-item-id');
                        console.log('Remove clicked for item:', itemId);

                        window.cartManager.removeFromCart(itemId).then(function() {
                            console.log('Item removed, re-rendering cart');
                            isUpdating = false;
                            setTimeout(function() {
                                displayCartItems();
                            }, 100);
                        }).catch(function(error) {
                            console.error('Error removing item:', error);
                            isUpdating = false;
                        });
                        return;
                    }
                });

                // Handle quantity input change event (manual entry)
                cartContent.addEventListener('change', function(e) {
                    if (e.target.classList.contains('qty-input')) {
                        if (isUpdating) {
                            console.warn('Update already in progress, ignoring change');
                            return;
                        }

                        isUpdating = true;
                        var itemId = e.target.getAttribute('data-item-id');
                        var newQty = parseInt(e.target.value);
                        var oldValue = e.target.value;

                        console.log('Qty input changed for item:', itemId, 'to:', newQty);

                        // Validate input
                        if (isNaN(newQty) || newQty < 1) {
                            Swal.fire('Invalid Quantity', 'Please enter a number greater than 0', 'warning');
                            e.target.value = oldValue;
                            isUpdating = false;
                            return;
                        }

                        if (newQty > 10) {
                            Swal.fire('Limit Exceeded', 'Maximum quantity is 10 per item', 'warning');
                            e.target.value = oldValue;
                            isUpdating = false;
                            return;
                        }

                        window.cartManager.updateQuantity(itemId, newQty).then(function() {
                            console.log('Quantity updated successfully');
                            isUpdating = false;
                            setTimeout(function() {
                                displayCartItems();
                            }, 100);
                        }).catch(function(error) {
                            console.error('Error updating quantity:', error);
                            e.target.value = oldValue; // Revert on error
                            isUpdating = false;
                        });
                    }
                });
            }

            // Display cart when DOM is ready
            if (document.readyState === 'loading') {
                document.addEventListener('DOMContentLoaded', function() {
                    setTimeout(displayCartItems, 500);
                });
            } else {
                // DOM is already ready
                console.log('DOM already ready, calling displayCartItems');
                setTimeout(displayCartItems, 500);
            }

            // Proceed to checkout function
            function proceedToCheckout() {
                var user = localStorage.getItem('user');
                if (!user) {
                    Swal.fire({
                        title: 'Login Required',
                        text: 'You must be logged in to proceed with checkout.',
                        icon: 'warning',
                        confirmButtonText: 'Login',
                        confirmButtonColor: '#d4a574'
                    }).then(function(result) {
                        if (result.isConfirmed) {
                            jQuery('#signInModal').modal('show');
                        }
                    });
                } else {
                    window.location.href = 'checkout.php';
                }
            }
        </script>
        </script>
        <script src="assets/revolution/js/jquery.themepunch.tools.min.js?rev=5.0"></script>
        <script src="assets/revolution/js/jquery.themepunch.revolution.min.js?rev=5.0"></script>
        <script src="assets/revolution/js/extensions/revolution.extension.video.min.js"></script>
        <script src="assets/revolution/js/extensions/revolution.extension.slideanims.min.js"></script>
        <script src="assets/revolution/js/extensions/revolution.extension.actions.min.js"></script>
        <script src="assets/revolution/js/extensions/revolution.extension.layeranimation.min.js"></script>
        <script src="assets/revolution/js/extensions/revolution.extension.kenburn.min.js"></script>
        <script src="assets/revolution/js/extensions/revolution.extension.navigation.min.js"></script>
        <script src="assets/revolution/js/extensions/revolution.extension.migration.min.js"></script>
        <script src="assets/revolution/js/extensions/revolution.extension.parallax.min.js"></script>
        <!-- RS Configration JS Files -->
        <script src="assets/js/rsconfig.js"></script>

        <!-- Professional Table Booking Modal -->
        <div class="modal fade reservation-popup" tabindex="-1" role="dialog" id="reservationPopup">
            <div class="modal-dialog modal-lg" role="document">
                <div class="modal-content professional-booking-modal">
                    <div class="modal-header professional-booking-header">
                        <div class="booking-header-content">
                            <h2 class="modal-title">Reserve Your Table</h2>
                        </div>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <i class="fa fa-times"></i>
                        </button>
                    </div>
                    <div class="modal-body professional-booking-body">
                        <form id="professionalBookingForm" class="professional-booking-form" method="POST" action="#">
                            <!-- Section 1: Guest Details -->
                            <div class="booking-section">
                                <h4 class="booking-section-title"><i class="fa fa-user-circle"></i> Guest Details</h4>
                                <div class="row">
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label for="bookingName">Full Name *</label>
                                            <input type="text" class="form-control" id="bookingName"
                                                name="booking_name" placeholder="Enter your full name" required>
                                            <small class="form-text text-muted">We'll use this to identify your reservation</small>
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label for="bookingEmail">Email Address *</label>
                                            <input type="email" class="form-control" id="bookingEmail"
                                                name="booking_email" placeholder="your.email@example.com" required>
                                            <small class="form-text text-muted">Confirmation will be sent here</small>
                                        </div>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label for="bookingPhone">Phone Number *</label>
                                            <input type="tel" class="form-control" id="bookingPhone"
                                                name="booking_phone" placeholder="+1 (555) 000-0000" required>
                                            <small class="form-text text-muted">Contact number for reservation</small>
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label for="bookingOccasion">Occasion (Optional)</label>
                                            <select class="form-control" id="bookingOccasion" name="booking_occasion">
                                                <option value="">Select an occasion</option>
                                                <option value="birthday">Birthday Celebration</option>
                                                <option value="anniversary">Anniversary</option>
                                                <option value="business">Business Meeting</option>
                                                <option value="family">Family Gathering</option>
                                                <option value="date">Date Night</option>
                                                <option value="other">Other</option>
                                            </select>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <hr class="booking-divider">

                            <!-- Section 2: Reservation Details -->
                            <div class="booking-section">
                                <h4 class="booking-section-title"><i class="fa fa-calendar-alt"></i> Reservation Details</h4>
                                <div class="row">
                                    <div class="col-md-4">
                                        <div class="form-group">
                                            <label for="bookingDate">Date *</label>
                                            <input type="date" class="form-control" id="bookingDate"
                                                name="booking_date" required>
                                            <small class="form-text text-muted">Select your preferred date</small>
                                        </div>
                                    </div>
                                    <div class="col-md-4">
                                        <div class="form-group">
                                            <label for="bookingTime">Time *</label>
                                            <input type="time" class="form-control" id="bookingTime"
                                                name="booking_time" required>
                                            <small class="form-text text-muted">Select your preferred time</small>
                                        </div>
                                    </div>
                                    <div class="col-md-4">
                                        <div class="form-group">
                                            <label for="bookingGuests">Number of Guests *</label>
                                            <select class="form-control" id="bookingGuests" name="booking_guests" required>
                                                <option value="">Select number</option>
                                                <option value="1">1 Person</option>
                                                <option value="2">2 People</option>
                                                <option value="3">3 People</option>
                                                <option value="4">4 People</option>
                                                <option value="5">5 People</option>
                                                <option value="6">6 People</option>
                                                <option value="7">7 People</option>
                                                <option value="8">8 People</option>
                                                <option value="10">10 People</option>
                                                <option value="12">12 People</option>
                                                <option value="15">15+ People</option>
                                            </select>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <hr class="booking-divider">

                            <!-- Section 3: Preferences & Special Requests -->


                            <!-- Form Actions -->
                            <div class="booking-actions">
                                <button type="reset" class="btn btn-outline-secondary">Clear Form</button>
                                <button type="submit" class="btn btn--secondary">Complete Booking</button>
                            </div>

                            <!-- Booking Status Message -->
                            <div class="alert alert-success booking-success-message" style="display: none; margin-top: 20px;">
                                <div style="display: flex; align-items: flex-start; gap: 15px;">
                                    <div style="font-size: 24px; color: #28a745;">
                                        <i class="fa fa-check-circle"></i>
                                    </div>
                                    <div style="flex: 1;">
                                        <h5 style="margin: 0 0 10px 0; color: #155724;">Booking Confirmed!</h5>
                                        <p style="margin: 5px 0; font-size: 14px;" id="bookingConfirmation"></p>
                                        <p style="margin: 5px 0; font-size: 12px; color: #666;">Confirmation email has been sent to your email address.</p>
                                    </div>
                                </div>
                            </div>
                            <div class="alert alert-danger booking-error-message" style="display: none; margin-top: 20px;">
                                <i class="fa fa-exclamation-circle"></i> <span class="error-message"></span>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>

        <!-- Professional Booking Modal Styles -->
        <style>
            .professional-booking-modal {
                border: none;
                border-radius: 12px;
                box-shadow: 0 10px 50px rgba(0, 0, 0, 0.2);
                overflow: hidden;
            }

            .professional-booking-header {
                background: linear-gradient(135deg, #d4a574 0%, #8b6f47 100%);
                border: none;
                color: white;
                padding: 30px;
                position: relative;
            }

            .booking-header-content h2 {
                font-size: 28px;
                font-weight: 600;
                margin: 0;
                margin-bottom: 8px;
                font-family: 'Raleway', sans-serif;
            }

            .booking-subtitle {
                font-size: 14px;
                margin: 0;
                opacity: 0.95;
                font-weight: 300;
            }

            .professional-booking-header .close {
                position: absolute;
                right: 20px;
                top: 20px;
                color: white;
                opacity: 0.8;
                font-size: 24px;
            }

            .professional-booking-header .close:hover {
                opacity: 1;
            }

            .professional-booking-body {
                padding: 40px;
                background: #f9f7f4;
            }

            .professional-booking-form {
                background: white;
                padding: 30px;
                border-radius: 8px;
                box-shadow: 0 2px 10px rgba(0, 0, 0, 0.05);
            }

            .booking-section {
                margin-bottom: 30px;
            }

            .booking-section-title {
                font-size: 16px;
                font-weight: 600;
                color: #333;
                margin-bottom: 20px;
                padding-bottom: 12px;
                border-bottom: 2px solid #d4a574;
                display: flex;
                align-items: center;
                gap: 10px;
            }

            .booking-section-title i {
                color: #d4a574;
                font-size: 18px;
            }

            .booking-divider {
                margin: 30px 0;
                border: none;
                border-top: 2px solid #e8e8e8;
            }

            .professional-booking-form .form-group {
                margin-bottom: 20px;
            }

            .professional-booking-form .form-group label {
                font-weight: 600;
                color: #333;
                margin-bottom: 8px;
                font-size: 13px;
                text-transform: uppercase;
                letter-spacing: 0.5px;
            }

            .professional-booking-form .form-control {
                border: 2px solid #e8e8e8;
                border-radius: 6px;
                padding: 12px 15px;
                font-size: 14px;
                transition: all 0.3s ease;
                background: #fafafa;
            }

            .professional-booking-form .form-control:focus {
                border-color: #d4a574;
                background: white;
                box-shadow: 0 0 0 3px rgba(212, 165, 116, 0.1);
                outline: none;
            }

            .professional-booking-form .form-control::placeholder {
                color: #999;
            }

            .professional-booking-form textarea.form-control {
                resize: vertical;
                min-height: 100px;
                font-family: 'Raleway', sans-serif;
            }

            .form-text {
                font-size: 12px;
                color: #999;
                margin-top: 5px;
            }

            .booking-actions {
                display: flex !important;
                gap: 15px !important;
                margin-top: 30px !important;
                justify-content: center !important;
                flex-wrap: wrap !important;
            }

            .professional-booking-form .booking-actions button {
                padding: 14px 35px !important;
                font-weight: 700 !important;
                border-radius: 8px !important;
                font-size: 15px !important;
                transition: all 0.3s cubic-bezier(0.25, 0.46, 0.45, 0.94) !important;
                min-width: 140px !important;
                line-height: 1.6 !important;
                display: inline-flex !important;
                align-items: center !important;
                justify-content: center !important;
                text-align: center !important;
                vertical-align: middle !important;
                cursor: pointer !important;
                letter-spacing: 0.5px !important;
                text-transform: uppercase !important;
                box-shadow: 0 4px 15px rgba(0, 0, 0, 0.1) !important;
            }

            .professional-booking-form .booking-actions .btn-outline-secondary {
                border: 2px solid #d4a574 !important;
                color: #d4a574 !important;
                background: white !important;
                box-shadow: 0 2px 10px rgba(212, 165, 116, 0.15) !important;
            }

            .professional-booking-form .booking-actions .btn-outline-secondary:hover,
            .professional-booking-form .booking-actions .btn-outline-secondary:active,
            .professional-booking-form .booking-actions .btn-outline-secondary:focus {
                border-color: #8b6f47 !important;
                color: white !important;
                background: linear-gradient(135deg, #d4a574 0%, #8b6f47 100%) !important;
                box-shadow: 0 6px 20px rgba(212, 165, 116, 0.35) !important;
                transform: translateY(-3px) !important;
            }

            .professional-booking-form .booking-actions .btn--secondary {
                background: linear-gradient(135deg, #d4a574 0%, #8b6f47 100%) !important;
                color: white !important;
                border: none !important;
                box-shadow: 0 4px 15px rgba(212, 165, 116, 0.25) !important;
                position: relative !important;
                overflow: hidden !important;
            }

            .professional-booking-form .booking-actions .btn--secondary::before {
                content: '' !important;
                position: absolute !important;
                top: 0 !important;
                left: -100% !important;
                width: 100% !important;
                height: 100% !important;
                background: rgba(255, 255, 255, 0.1) !important;
                transition: left 0.3s ease !important;
                z-index: 0 !important;
            }

            .professional-booking-form .booking-actions .btn--secondary:hover::before,
            .professional-booking-form .booking-actions .btn--secondary:active::before,
            .professional-booking-form .booking-actions .btn--secondary:focus::before {
                left: 100% !important;
            }

            .professional-booking-form .booking-actions .btn--secondary:hover,
            .professional-booking-form .booking-actions .btn--secondary:active,
            .professional-booking-form .booking-actions .btn--secondary:focus {
                transform: translateY(-3px) !important;
                box-shadow: 0 8px 25px rgba(212, 165, 116, 0.4) !important;
                background: linear-gradient(135deg, #8b6f47 0%, #d4a574 100%) !important;
                color: white !important;
                border: none !important;
            }

            .professional-booking-form .booking-actions button:active {
                transform: translateY(-1px) !important;
            }

            /* Mobile Responsiveness */
            @media (max-width: 576px) {
                .booking-actions {
                    flex-direction: column !important;
                    gap: 12px !important;
                }

                .professional-booking-form .booking-actions button {
                    width: 100% !important;
                    padding: 12px 20px !important;
                    font-size: 14px !important;
                    min-width: unset !important;
                }
            }

            @media (max-width: 768px) {
                .professional-booking-form .booking-actions button {
                    padding: 12px 28px !important;
                    font-size: 14px !important;
                    min-width: 130px !important;
                }
            }

            @media (min-width: 769px) and (max-width: 992px) {
                .professional-booking-form .booking-actions button {
                    padding: 13px 32px !important;
                    font-size: 14px !important;
                    min-width: 135px !important;
                }
            }

            .alert {
                border-radius: 6px;
                border: none;
                padding: 15px 20px;
                display: flex;
                align-items: center;
                gap: 12px;
            }

            .alert-success {
                background-color: #d4edda;
                color: #155724;
            }

            .alert-danger {
                background-color: #f8d7da;
                color: #721c24;
            }

            @media (max-width: 768px) {
                .professional-booking-body {
                    padding: 20px;
                }

                .professional-booking-form {
                    padding: 20px;
                }

                .booking-header-content h2 {
                    font-size: 22px;
                }

                .booking-actions {
                    flex-direction: column;
                }

                .booking-actions button {
                    width: 100%;
                }
            }
        </style>

        <!-- Professional Booking Modal Scripts -->
        <script>
            document.addEventListener('DOMContentLoaded', function() {
                const bookingForm = document.getElementById('professionalBookingForm');
                const successMessage = document.querySelector('.booking-success-message');
                const errorMessage = document.querySelector('.booking-error-message');

                // Set minimum date to today
                const today = new Date().toISOString().split('T')[0];
                document.getElementById('bookingDate').setAttribute('min', today);

                // Form submission
                if (bookingForm) {
                    bookingForm.addEventListener('submit', function(e) {
                        e.preventDefault();

                        // Reset messages
                        successMessage.style.display = 'none';
                        errorMessage.style.display = 'none';

                        // Collect form data
                        const formData = new FormData(bookingForm);
                        const data = Object.fromEntries(formData);

                        // Validate data
                        if (!data.booking_name || !data.booking_email || !data.booking_phone ||
                            !data.booking_date || !data.booking_time || !data.booking_guests) {
                            errorMessage.querySelector('.error-message').textContent = 'Please fill in all required fields.';
                            errorMessage.style.display = 'flex';
                            return;
                        }

                        // Send booking data (you can modify this to your backend API)
                        console.log('Booking Data:', data);

                        // Show success message
                        successMessage.style.display = 'flex';

                        // Optional: Reset form and close modal after delay
                        setTimeout(function() {
                            bookingForm.reset();
                            $('#reservationPopup').modal('hide');
                        }, 2000);
                    });
                }

                // Clear messages when modal is closed
                $('#reservationPopup').on('hidden.bs.modal', function() {
                    successMessage.style.display = 'none';
                    errorMessage.style.display = 'none';
                });
            });
        </script>
        <!-- End Professional Table Booking Modal -->

        <!-- Sign In Modal -->
        <div class="modal fade" tabindex="-1" role="dialog" id="signInModal">
            <div class="modal-dialog modal-lg" role="document">
                <div class="modal-content auth-modal-content">
                    <button type="button" class="close auth-close-btn" data-dismiss="modal" aria-label="Close"><i
                            class="fa fa-times"></i></button>
                    <div class="auth-modal-body">
                        <div class="auth-header">
                            <h2>Welcome Back</h2>
                            <p class="auth-subtitle">Sign in to your account</p>
                        </div>
                        <div id="signinMessage" class="auth-message" style="display: none;"></div>
                        <form class="auth-form" id="signInForm">
                            <div class="auth-form-group">
                                <label for="signinEmail" class="auth-label">Email Address</label>
                                <div class="auth-input-wrapper">
                                    <i class="fas fa-envelope auth-input-icon"></i>
                                    <input type="email" class="auth-input" id="signinEmail" name="email" placeholder="your@email.com"
                                        required>
                                </div>
                            </div>
                            <div class="auth-form-group">
                                <label for="signinPassword" class="auth-label">Password</label>
                                <div class="auth-input-wrapper">
                                    <i class="fas fa-lock auth-input-icon"></i>
                                    <input type="password" class="auth-input" id="signinPassword" name="password" placeholder="*********"
                                        required>
                                </div>
                            </div>
                            <div class="auth-form-group auth-remember">
                                <input type="checkbox" id="rememberMe" name="rememberMe">
                                <label for="rememberMe" class="auth-checkbox-label">Remember me</label>
                            </div>
                                                        <a href="#" data-toggle="modal" data-dismiss="modal" data-target="#forgotPasswordModal" class="auth-forgot-password" style="float: right; margin-top: 5px;">Forgot Password?</a>

                            <button type="submit" class="auth-btn">Sign In</button>
                        </form>
                        <div class="auth-divider">
                            <span>Don't have an account?</span>
                        </div>
                        <p class="auth-footer">
                            <a href="#" data-toggle="modal" data-dismiss="modal" data-target="#signUpModal"
                                class="auth-link">Create a new account</a>
                        </p>
                    </div>
                </div>
            </div>
        </div>
        <!-- End Sign In Modal -->

        <!-- Sign Up Modal -->
        <div class="modal fade" tabindex="-1" role="dialog" id="signUpModal">
            <div class="modal-dialog modal-lg" role="document">
                <div class="modal-content auth-modal-content">
                    <button type="button" class="close auth-close-btn" data-dismiss="modal" aria-label="Close"><i
                            class="fa fa-times"></i></button>
                    <div class="auth-modal-body">
                        <div class="auth-header">
                            <h2>Create Account</h2>
                            <p class="auth-subtitle">Join us today</p>
                        </div>
                        <div id="signupMessage" class="auth-message" style="display: none;"></div>
                        <form class="auth-form" id="signUpForm">
                            <div class="auth-form-group">
                                <label for="signupName" class="auth-label">Full Name</label>
                                <div class="auth-input-wrapper">
                                    <i class="fas fa-user auth-input-icon"></i>
                                    <input type="text" class="auth-input" id="signupName" name="name" placeholder="John Doe" required>
                                </div>
                            </div>
                            <div class="auth-form-group">
                                <label for="signupEmail" class="auth-label">Email Address</label>
                                <div class="auth-input-wrapper">
                                    <i class="fas fa-envelope auth-input-icon"></i>
                                    <input type="email" class="auth-input" id="signupEmail" name="email" placeholder="your@email.com"
                                        required>
                                </div>
                            </div>
                            <div class="auth-form-group">
                                <label for="signupPhone" class="auth-label">Phone Number</label>
                                <div class="auth-input-wrapper">
                                    <i class="fas fa-phone auth-input-icon"></i>
                                    <input type="tel" class="auth-input" id="signupPhone" name="phone"
                                        placeholder="9876543210" required>
                                </div>
                            </div>
                            <div class="auth-form-group">
                                <label for="signupPassword" class="auth-label">Password</label>
                                <div class="auth-input-wrapper">
                                    <i class="fas fa-lock auth-input-icon"></i>
                                    <input type="password" class="auth-input" id="signupPassword" name="password" placeholder="*********"
                                        required>
                                </div>
                            </div>
                            <div class="auth-form-group">
                                <label for="signupConfirmPassword" class="auth-label">Confirm Password</label>
                                <div class="auth-input-wrapper">
                                    <i class="fas fa-check-circle auth-input-icon"></i>
                                    <input type="password" class="auth-input" id="signupConfirmPassword" name="confirmPassword"
                                        placeholder="*********" required>
                                </div>
                            </div>
                            <div class="auth-form-group auth-checkbox">
                                <input type="checkbox" id="agreeTerms" required>
                                <label for="agreeTerms" class="auth-checkbox-label">I agree to the <a href="#"
                                        class="auth-link-inline">Terms & Conditions</a></label>
                            </div>
                            <button type="submit" class="auth-btn">Create Account</button>
                        </form>
                        <div class="auth-divider">
                            <span>Already have an account?</span>
                        </div>
                        <p class="auth-footer">
                            <a href="#" data-toggle="modal" data-dismiss="modal" data-target="#signInModal"
                                class="auth-link">Sign In here</a>
                        </p>
                    </div>
                </div>
            </div>
        </div>
        <!-- End Sign Up Modal -->
          
<!-- Email Verification Modal -->
<div class="modal fade" tabindex="-1" role="dialog" id="emailVerificationModal">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content auth-modal-content">
            <button type="button" class="close auth-close-btn" data-dismiss="modal"><i class="fa fa-times"></i></button>
            <div class="auth-modal-body">
                <div class="auth-header">
                    <h2>Verify Email</h2>
                    <p class="auth-subtitle">Enter the OTP sent to your email</p>
                </div>
                <div id="verifyEmailMessage" class="auth-message" style="display: none;"></div>
                <form class="auth-form" id="emailVerificationForm">
                    <input type="hidden" id="verifyEmailAddress" value="">
                    <div class="auth-form-group">
                        <label for="emailOTP" class="auth-label">One-Time Password (OTP)</label>
                        <div class="auth-input-wrapper">
                            <i class="fas fa-key auth-input-icon"></i>
                            <input type="text" class="auth-input" id="emailOTP" name="otp" 
                                   placeholder="000000" maxlength="6" required>
                        </div>
                        <small style="color: #666; margin-top: 5px;">Check your email for the 6-digit code</small>
                    </div>
                    <button type="submit" class="auth-btn">Verify Email</button>
                    <div style="text-align: center; margin-top: 15px;">
                        <p style="color: #666; font-size: 14px;">Didn't receive the code? 
                            <a href="#" id="resendEmailOTP" class="auth-link" style="text-decoration: underline;">Resend OTP</a>
                        </p>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
<!-- End Email Verification Modal -->

<!-- Forgot Password Modal -->
<div class="modal fade" tabindex="-1" role="dialog" id="forgotPasswordModal">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content auth-modal-content">
            <button type="button" class="close auth-close-btn" data-dismiss="modal"><i class="fa fa-times"></i></button>
            <div class="auth-modal-body">
                <div class="auth-header">
                    <h2>Reset Password</h2>
                    <p class="auth-subtitle">We'll send you an OTP to reset your password</p>
                </div>
                <div id="forgotPasswordMessage" class="auth-message" style="display: none;"></div>
                <form class="auth-form" id="forgotPasswordForm" name="step">
                    <!-- Step 1: Enter Email -->
                    <div id="forgotPasswordStep1">
                        <div class="auth-form-group">
                            <label for="forgotEmail" class="auth-label">Email Address</label>
                            <div class="auth-input-wrapper">
                                <i class="fas fa-envelope auth-input-icon"></i>
                                <input type="email" class="auth-input" id="forgotEmail" name="email" 
                                       placeholder="your@email.com" required>
                            </div>
                        </div>
                        <button type="button" class="auth-btn" id="sendResetOTPBtn">Send OTP</button>
                    </div>

                    <!-- Step 2: Enter OTP -->
                    <div id="forgotPasswordStep2" style="display: none;">
                        <input type="hidden" id="resetToken" value="">
                        <div class="auth-form-group">
                            <label for="resetOTP" class="auth-label">One-Time Password (OTP)</label>
                            <div class="auth-input-wrapper">
                                <i class="fas fa-key auth-input-icon"></i>
                                <input type="text" class="auth-input" id="resetOTP" name="otp" 
                                       placeholder="000000" maxlength="6">
                            </div>
                            <small style="color: #666; margin-top: 5px;">Check your email for the 6-digit code</small>
                        </div>
                        <div class="auth-form-group">
                            <label for="newPassword" class="auth-label">New Password</label>
                            <div class="auth-input-wrapper">
                                <i class="fas fa-lock auth-input-icon"></i>
                                <input type="password" class="auth-input" id="newPassword" name="password" placeholder="*********">
                            </div>
                        </div>
                        <div class="auth-form-group">
                            <label for="confirmNewPassword" class="auth-label">Confirm Password</label>
                            <div class="auth-input-wrapper">
                                <i class="fas fa-check-circle auth-input-icon"></i>
                                <input type="password" class="auth-input" id="confirmNewPassword" name="confirmPassword" placeholder="*********">
                            </div>
                        </div>
                        <button type="button" class="auth-btn" id="resetPasswordBtn">Reset Password</button>
                        <button type="button" class="auth-btn" style="background-color: #6c757d; margin-top: 10px;" id="backToEmailBtn">Back</button>
                        <div style="text-align: center; margin-top: 15px;">
                            <p style="color: #666; font-size: 14px;">
                                <a href="#" id="resendResetOTP" class="auth-link" style="text-decoration: underline;">Resend OTP</a>
                            </p>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
<!-- End Forgot Password Modal -->


        <!-- Backend Integration Scripts -->
        <style>
            .auth-message {
                padding: 12px;
                border-radius: 6px;
                margin-bottom: 20px;
                font-weight: 500;
                display: flex;
                align-items: center;
                gap: 10px;
            }

            .auth-message.success {
                background: #d4edda;
                color: #155724;
                border: 1px solid #c3e6cb;
            }

            .auth-message.error {
                background: #f8d7da;
                color: #721c24;
                border: 1px solid #f5c6cb;
            }
        </style>


        <script>
            // Update header with user profile
            function updateHeaderWithUserProfile(userData) {
                // Desktop header auth section
                const navAuthSection = document.getElementById('navAuthSection');
                const navUserProfileDropdown = document.getElementById('navUserProfileDropdown');
                const navUserName = document.getElementById('navUserName');

                // Mobile auth section (inside menu)
                const mobileAuthSection = document.getElementById('mobileAuthSection');
                const mobileUserProfileSection = document.getElementById('mobileUserProfileSection');

                // Mobile profile icon (next to hamburger)
                const mobileProfileIconContainer = document.getElementById('mobileProfileIconContainer');
                const mobileUserName = document.getElementById('mobileUserName');

                // Hide sign in/sign up buttons (desktop)
                if (navAuthSection) {
                    navAuthSection.style.display = 'none';
                }

                // Show user profile dropdown with username (desktop)
                if (navUserProfileDropdown) {
                    navUserProfileDropdown.style.display = 'inline-block';
                    navUserName.textContent = userData.name || userData.email;
                }

                // Hide mobile auth buttons inside hamburger menu and show mobile user profile
                if (mobileAuthSection) {
                    mobileAuthSection.classList.add('hide-auth');
                }
                if (mobileUserProfileSection) {
                    mobileUserProfileSection.style.display = 'block';
                }

                // Show mobile profile icon next to hamburger
                if (mobileProfileIconContainer) {
                    mobileProfileIconContainer.classList.add('show');
                    // Remove inline style to let CSS handle it
                    mobileProfileIconContainer.style.display = '';
                }

                // Set mobile username
                if (mobileUserName) {
                    mobileUserName.textContent = userData.name || userData.email;
                }

                console.log('Header updated for user:', userData.name);
            }


            // Check if user is already logged in on page load
            document.addEventListener('DOMContentLoaded', function() {
                const user = localStorage.getItem('user');
                if (user) {
                    try {
                        const userData = JSON.parse(user);
                        updateHeaderWithUserProfile(userData);
                        console.log('User already logged in:', userData.name);
                    } catch (e) {
                        console.error('Error parsing user data:', e);
                    }
                }
            });

            // Reset header to show auth buttons (used on logout)
            function resetHeaderAuthSection() {
                // Desktop header auth section
                const navAuthSection = document.getElementById('navAuthSection');
                const navUserProfileDropdown = document.getElementById('navUserProfileDropdown');

                // Mobile auth section
                const mobileAuthSection = document.getElementById('mobileAuthSection');
                const mobileUserProfileSection = document.getElementById('mobileUserProfileSection');

                // Mobile profile icon (next to hamburger)
                const mobileProfileIconContainer = document.getElementById('mobileProfileIconContainer');

                // Show sign in/sign up buttons (desktop)
                if (navAuthSection) {
                    navAuthSection.style.display = 'flex';
                }

                // Hide user profile dropdown (desktop)
                if (navUserProfileDropdown) {
                    navUserProfileDropdown.style.display = 'none';
                }

                // Show mobile auth buttons and hide mobile user profile
                if (mobileAuthSection) {
                    mobileAuthSection.classList.remove('hide-auth');
                }
                if (mobileUserProfileSection) {
                    mobileUserProfileSection.style.display = 'none';
                }

                // Hide mobile profile icon
                if (mobileProfileIconContainer) {
                    mobileProfileIconContainer.classList.remove('show');
                    mobileProfileIconContainer.style.display = 'none';
                }

                console.log('Header reset to show auth buttons');
            }

            // Logout function
            function logout() {
                console.log('Logout function called');
                // Remove user data from localStorage first
                localStorage.removeItem('user');
                // Clear cart from localStorage on logout
                localStorage.removeItem('granny_cart');

                fetch('backend/logout.php')
                    .then(response => response.json())
                    .then(data => {
                        console.log('Logout response:', data);
                        if (data.success) {
                            // Reload after logout is complete
                            setTimeout(() => {
                                window.location.reload();
                            }, 500);
                        }
                    })
                    .catch(error => {
                        console.error('Logout error:', error);
                        // Still logout on client side even if server fails
                        setTimeout(() => {
                            window.location.reload();
                        }, 500);
                    });
            }

            // Logout button click handler
            document.addEventListener('DOMContentLoaded', function() {
                const logoutBtn = document.getElementById('navLogoutBtn');
                const mobileLogoutBtn = document.getElementById('mobileLogoutBtn');
                const mobileProfileLogoutBtn = document.getElementById('mobileProfileLogoutBtn');

                if (logoutBtn) {
                    logoutBtn.addEventListener('click', function(e) {
                        e.preventDefault();
                        logout();
                    });
                }

                if (mobileLogoutBtn) {
                    mobileLogoutBtn.addEventListener('click', function(e) {
                        e.preventDefault();
                        logout();
                    });
                }

                if (mobileProfileLogoutBtn) {
                    mobileProfileLogoutBtn.addEventListener('click', function(e) {
                        e.preventDefault();
                        logout();
                    });
                }
            });

            // Sign Up Handler
            document.getElementById('signUpForm').addEventListener('submit', function(e) {
                e.preventDefault();

                const formData = {
                    name: document.getElementById('signupName').value,
                    email: document.getElementById('signupEmail').value,
                    password: document.getElementById('signupPassword').value,
                    confirmPassword: document.getElementById('signupConfirmPassword').value
                };

                const messageDiv = document.getElementById('signupMessage');

                fetch('backend/signup.php', {
                        method: 'POST',
                        headers: {
                            'Content-Type': 'application/json'
                        },
                        body: JSON.stringify(formData)
                    })
                    .then(response => response.json())
                    .then(data => {
                        messageDiv.style.display = 'flex';
                        if (data.success) {
                            messageDiv.className = 'auth-message success';
                            messageDiv.innerHTML = '<i class="fas fa-check-circle"></i> ' + data.message + ' Please sign in to continue.';

                            // Clear form
                            document.getElementById('signUpForm').reset();

                            // Do NOT store user data in localStorage - user must sign in first

                            // Close sign up modal and open sign in modal
                            setTimeout(() => {
                                $('#signUpModal').modal('hide');
                                messageDiv.style.display = 'none';
                                // Show sign in modal after a short delay
                                setTimeout(() => {
                                    $('#signInModal').modal('show');
                                }, 500);
                            }, 2000);
                        } else {
                            messageDiv.className = 'auth-message error';
                            messageDiv.innerHTML = '<i class="fas fa-exclamation-circle"></i> ' + data.message;
                        }
                    })
                    .catch(error => {
                        messageDiv.style.display = 'flex';
                        messageDiv.className = 'auth-message error';
                        messageDiv.innerHTML = '<i class="fas fa-exclamation-circle"></i> Error: ' + error.message;
                        console.error('Error:', error);
                    });
            });

            // Sign In Handler
            document.getElementById('signInForm').addEventListener('submit', function(e) {
                e.preventDefault();

                const formData = {
                    email: document.getElementById('signinEmail').value,
                    password: document.getElementById('signinPassword').value,
                    rememberMe: document.getElementById('rememberMe').checked
                };

                const messageDiv = document.getElementById('signinMessage');

                fetch('backend/signin.php', {
                        method: 'POST',
                        headers: {
                            'Content-Type': 'application/json'
                        },
                        body: JSON.stringify(formData)
                    })
                    .then(response => response.json())
                    .then(data => {
                        messageDiv.style.display = 'flex';
                        if (data.success) {
                            messageDiv.className = 'auth-message success';
                            messageDiv.innerHTML = '<i class="fas fa-check-circle"></i> ' + data.message;

                            // Clear form
                            document.getElementById('signInForm').reset();

                            // Store user data in localStorage
                            localStorage.setItem('user', JSON.stringify(data.data));

                            // Update cartManager login status
                            if (window.cartManager) {
                                window.cartManager.updateLoginStatus();
                            }

                            // Close modal
                            setTimeout(() => {
                                $('#signInModal').modal('hide');
                                messageDiv.style.display = 'none';
                                // Update header with user profile
                                updateHeaderWithUserProfile(data.data);
                                // Refresh page after successful sign-in
                                setTimeout(() => {
                                    window.location.reload();
                                }, 500);
                            }, 2000);
                        } else {
                            messageDiv.className = 'auth-message error';
                            messageDiv.innerHTML = '<i class="fas fa-exclamation-circle"></i> ' + data.message;
                        }
                    })
                    .catch(error => {
                        messageDiv.style.display = 'flex';
                        messageDiv.className = 'auth-message error';
                        messageDiv.innerHTML = '<i class="fas fa-exclamation-circle"></i> Error: ' + error.message;
                        console.error('Error:', error);
                    });
            });

            // Booking Handler
            document.getElementById('professionalBookingForm').addEventListener('submit', function(e) {
                e.preventDefault();

                const formData = {
                    booking_name: document.getElementById('bookingName')?.value || '',
                    booking_email: document.getElementById('bookingEmail')?.value || '',
                    booking_phone: document.getElementById('bookingPhone')?.value || '',
                    booking_date: document.getElementById('bookingDate')?.value || '',
                    booking_time: document.getElementById('bookingTime')?.value || '',
                    booking_guests: document.getElementById('bookingGuests')?.value || '',
                    booking_occasion: document.getElementById('bookingOccasion')?.value || '',
                    booking_table_type: document.getElementById('bookingTableType')?.value || '',
                    booking_dietary: document.getElementById('bookingDietaryNeeds')?.value || '',
                    booking_special_requests: document.getElementById('bookingSpecialRequests')?.value || ''
                };

                const successMessage = document.querySelector('.booking-success-message');
                const errorMessage = document.querySelector('.booking-error-message');

                console.log('Sending booking data:', formData);

                // Validate required fields
                if (!formData.booking_name || !formData.booking_email || !formData.booking_phone || !formData.booking_date || !formData.booking_time || !formData.booking_guests) {
                    errorMessage.style.display = 'flex';
                    errorMessage.querySelector('.error-message').textContent = 'Please fill in all required fields';
                    successMessage.style.display = 'none';
                    console.error('Validation failed: Missing required fields');
                    return;
                }

                fetch('backend/booking.php', {
                        method: 'POST',
                        headers: {
                            'Content-Type': 'application/json'
                        },
                        body: JSON.stringify(formData)
                    })
                    .then(response => {
                        console.log('Response status:', response.status);
                        return response.json();
                    })
                    .then(data => {
                        console.log('Booking response:', data);
                        if (data.success) {
                            successMessage.style.display = 'flex';
                            errorMessage.style.display = 'none';

                            // Update confirmation message with booking details
                            const confirmationDiv = document.getElementById('bookingConfirmation');
                            if (confirmationDiv && data.data) {
                                confirmationDiv.innerHTML = `
                            <strong>Booking ID:</strong> #${data.data.booking_id}<br>
                            <strong>Date:</strong> ${data.data.booking_date} at ${data.data.booking_time}<br>
                            <strong>Guests:</strong> ${data.data.guests} person(s)
                        `;
                            }

                            // Store booking data
                            localStorage.setItem('lastBooking', JSON.stringify(data.data));
                            console.log('Booking saved to localStorage:', data.data);

                            // Reset and close
                            setTimeout(() => {
                                document.getElementById('professionalBookingForm').reset();
                                $('#reservationPopup').modal('hide');
                                successMessage.style.display = 'none';
                                confirmationDiv.innerHTML = '';
                            }, 3500);
                        } else {
                            errorMessage.style.display = 'flex';
                            errorMessage.querySelector('.error-message').textContent = data.message;
                            successMessage.style.display = 'none';
                            console.error('Booking error:', data.message);
                        }
                    })
                    .catch(error => {
                        errorMessage.style.display = 'flex';
                        errorMessage.querySelector('.error-message').textContent = 'Error: ' + error.message;
                        successMessage.style.display = 'none';
                        console.error('Fetch error:', error);
                    });
            });

            // Initialize user session on page load
            document.addEventListener('DOMContentLoaded', function() {
                const user = localStorage.getItem('user');
                if (user) {
                    const userData = JSON.parse(user);
                    console.log('User logged in:', userData);
                    // Header is already updated by the earlier DOMContentLoaded event
                }
            });
        </script>
        <script src="assets/js/auth-handler.js"></script>
</body>

</html>