<?php
/**
 * Table Assignments Viewer
 * Shows all table assignments in the system for debugging
 */

define('DB_HOST', 'localhost');
define('DB_USER', 'root');
define('DB_PASS', '');
define('DB_NAME', 'granny_restaurant');

$conn = new mysqli(DB_HOST, DB_USER, DB_PASS, DB_NAME);

if ($conn->connect_error) {
    die('Connection failed: ' . $conn->connect_error);
}

// Get all table assignments with related data
$sql = "SELECT 
        ta.id,
        ta.table_id,
        ta.server_id,
        ta.status,
        ta.number_of_guests,
        ta.assigned_at,
        rt.table_number,
        rt.status as table_status,
        s.name as server_name,
        s.employee_id
        FROM table_assignments ta
        LEFT JOIN restaurant_tables rt ON ta.table_id = rt.id
        LEFT JOIN servers s ON ta.server_id = s.id
        ORDER BY ta.id DESC
        LIMIT 50";

$result = $conn->query($sql);

?>
<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <title>Table Assignments Debug</title>
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            font-family: Arial, sans-serif;
            background: #f5f5f5;
            padding: 20px;
        }

        .container {
            max-width: 1200px;
            margin: 0 auto;
            background: white;
            padding: 20px;
            border-radius: 8px;
            box-shadow: 0 2px 4px rgba(0,0,0,0.1);
        }

        h1 {
            color: #333;
            margin-bottom: 20px;
        }

        .stats {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
            gap: 15px;
            margin-bottom: 30px;
        }

        .stat-card {
            background: #f9f9f9;
            padding: 15px;
            border-radius: 5px;
            border-left: 4px solid #2196F3;
        }

        .stat-card h3 {
            color: #666;
            font-size: 12px;
            margin-bottom: 8px;
        }

        .stat-card .value {
            font-size: 24px;
            font-weight: bold;
            color: #2196F3;
        }

        table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 20px;
        }

        thead {
            background: #2196F3;
            color: white;
        }

        th {
            padding: 12px;
            text-align: left;
            font-weight: 600;
        }

        td {
            padding: 12px;
            border-bottom: 1px solid #ddd;
        }

        tbody tr:hover {
            background: #f5f5f5;
        }

        .assigned {
            background: #e8f5e9;
            color: #2e7d32;
            padding: 4px 8px;
            border-radius: 3px;
            font-weight: 600;
        }

        .active {
            background: #fff3e0;
            color: #f57c00;
            padding: 4px 8px;
            border-radius: 3px;
            font-weight: 600;
        }

        .null {
            color: #999;
            font-style: italic;
        }

        .info-box {
            background: #e3f2fd;
            border-left: 4px solid #2196F3;
            padding: 15px;
            margin-bottom: 20px;
            border-radius: 4px;
        }
    </style>
</head>
<body>
    <div class="container">
        <h1>📋 Table Assignments Debug Viewer</h1>

        <div class="info-box">
            <strong>ℹ️ Instructions:</strong>
            <p>This page shows all table assignments in the system. If a table doesn't appear here, the manager hasn't assigned a server to it yet.</p>
        </div>

        <div class="stats">
            <div class="stat-card">
                <h3>Total Assignments</h3>
                <div class="value"><?php echo $result->num_rows; ?></div>
            </div>
            <div class="stat-card">
                <h3>With Server Assigned</h3>
                <div class="value">
                    <?php 
                    $temp_result = $conn->query("SELECT COUNT(*) as count FROM table_assignments WHERE server_id IS NOT NULL");
                    $temp_row = $temp_result->fetch_assoc();
                    echo $temp_row['count'];
                    ?>
                </div>
            </div>
            <div class="stat-card">
                <h3>Active Assignments</h3>
                <div class="value">
                    <?php 
                    $temp_result = $conn->query("SELECT COUNT(*) as count FROM table_assignments WHERE status = 'assigned'");
                    $temp_row = $temp_result->fetch_assoc();
                    echo $temp_row['count'];
                    ?>
                </div>
            </div>
        </div>

        <table>
            <thead>
                <tr>
                    <th>ID</th>
                    <th>Table #</th>
                    <th>Server Name</th>
                    <th>Server ID</th>
                    <th>Guests</th>
                    <th>Status</th>
                    <th>Table Status</th>
                    <th>Assigned At</th>
                </tr>
            </thead>
            <tbody>
                <?php if ($result && $result->num_rows > 0): ?>
                    <?php while ($row = $result->fetch_assoc()): ?>
                    <tr>
                        <td><?php echo $row['id']; ?></td>
                        <td><?php echo $row['table_number'] ?? '-'; ?></td>
                        <td><?php echo $row['server_name'] ? htmlspecialchars($row['server_name']) : '<span class="null">No server</span>'; ?></td>
                        <td><?php echo $row['server_id'] ? htmlspecialchars($row['employee_id']) : '<span class="null">N/A</span>'; ?></td>
                        <td><?php echo $row['number_of_guests'] ?? '-'; ?></td>
                        <td>
                            <?php if ($row['status'] === 'assigned'): ?>
                                <span class="assigned">Assigned</span>
                            <?php elseif ($row['status'] === 'active'): ?>
                                <span class="active">Active</span>
                            <?php else: ?>
                                <?php echo htmlspecialchars($row['status']); ?>
                            <?php endif; ?>
                        </td>
                        <td><?php echo htmlspecialchars($row['table_status']) ?? '-'; ?></td>
                        <td><?php echo $row['assigned_at'] ?? '-'; ?></td>
                    </tr>
                    <?php endwhile; ?>
                <?php else: ?>
                    <tr>
                        <td colspan="8" style="text-align: center; padding: 30px; color: #999;">
                            No table assignments found. Manager needs to assign servers to tables first.
                        </td>
                    </tr>
                <?php endif; ?>
            </tbody>
        </table>

        <div style="margin-top: 20px; padding: 15px; background: #fff3cd; border-radius: 4px; border-left: 4px solid #ffc107;">
            <strong>🔍 Troubleshooting:</strong>
            <ul style="margin-left: 20px; margin-top: 10px;">
                <li>If <strong>"No table assignments found"</strong> appears, the manager hasn't assigned any tables to servers yet.</li>
                <li>If <strong>"No server" appears</strong> in the Server Name column, the table was allocated but not assigned to a server.</li>
                <li>If <strong>Status is not "Assigned"</strong>, the assignment might be in a different state (completed, cancelled, etc.).</li>
                <li>Go to Manager Dashboard → Tables → Assign Server to create new assignments.</li>
            </ul>
        </div>

        <div style="margin-top: 20px; text-align: center;">
            <a href="server_debug.php" style="background: #2196F3; color: white; padding: 10px 20px; text-decoration: none; border-radius: 4px; margin-right: 10px;">
                View Server Debug Info
            </a>
            <a href="javascript:location.reload()" style="background: #666; color: white; padding: 10px 20px; text-decoration: none; border-radius: 4px;">
                Refresh Page
            </a>
        </div>
    </div>
</body>
</html>

<?php
$conn->close();
?>
