<?php
/**
 * Verify Menu API and Create Sample Data
 */

require_once 'config.php';

try {
    // Check if tables exist
    $result = $conn->query("SELECT TABLE_NAME FROM INFORMATION_SCHEMA.TABLES WHERE TABLE_SCHEMA = DATABASE() AND TABLE_NAME LIKE 'menu%'");
    
    $tables = [];
    while ($row = $result->fetch_assoc()) {
        $tables[] = $row['TABLE_NAME'];
    }

    if (count($tables) < 3) {
        echo json_encode([
            'success' => false,
            'message' => 'Menu tables not found. Please run init_menu_db.php first',
            'tables_found' => $tables
        ]);
        exit;
    }

    // Create sample data
    // Insert filters
    $filters = ['Breakfast', 'Lunch', 'Dinner', 'Desserts', 'Drinks'];
    $filterIds = [];

    foreach ($filters as $i => $filter_name) {
        $stmt = $conn->prepare("INSERT INTO menu_filters (filter_name, description, display_order) VALUES (?, ?, ?)");
        $description = "Delicious " . $filter_name . " options";
        $stmt->bind_param("ssi", $filter_name, $description, $i);
        $stmt->execute();
        $filterIds[$filter_name] = $conn->insert_id;
    }

    // Subcategories - only 3 for each filter
    $subcategories = ['Vegetarian', 'Non-Vegetarian', 'Egg'];

    foreach ($filterIds as $filter_name => $filter_id) {
        foreach ($subcategories as $j => $sub_name) {
            $stmt = $conn->prepare("INSERT INTO menu_subcategories (filter_id, subcategory_name, display_order) VALUES (?, ?, ?)");
            $stmt->bind_param("isi", $filter_id, $sub_name, $j);
            $stmt->execute();
        }
    }

    // Sample menu items
    $sampleItems = [
        ['Paneer Tikka', 'Grilled paneer cheese with spices', 250],
        ['Mushroom Momo', 'Steamed mushroom dumplings', 180],
        ['Aloo Gobi', 'Potato and cauliflower curry', 220],
        ['Chilli Chicken', 'Spicy chicken with bell peppers', 320],
        ['Tandoori Chicken', 'Marinated chicken cooked in tandoor', 350],
        ['Mutton Kebab', 'Grilled mutton with herbs', 380],
        ['Egg Fried Rice', 'Rice with scrambled eggs', 280],
        ['Egg Curry', 'Boiled eggs in curry sauce', 240],
    ];

    // Insert sample items into first subcategory of first filter
    $result = $conn->query("SELECT id FROM menu_subcategories LIMIT 8");
    $subIds = [];
    while ($row = $result->fetch_assoc()) {
        $subIds[] = $row['id'];
    }

    foreach ($sampleItems as $i => $item) {
        if (!isset($subIds[$i])) break;

        $item_name = $item[0];
        $description = $item[1];
        $price = $item[2];
        $sub_id = $subIds[$i];
        $display_order = $i;

        $stmt = $conn->prepare("INSERT INTO menu_items (subcategory_id, item_name, description, price, display_order, is_available) VALUES (?, ?, ?, ?, ?, 1)");
        $stmt->bind_param("issdi", $sub_id, $item_name, $description, $price, $display_order);
        $stmt->execute();
    }

    echo json_encode([
        'success' => true,
        'message' => 'Sample menu data created successfully',
        'filters_created' => count($filters),
        'subcategories_created' => count($filters) * count($subcategories),
        'items_created' => count($sampleItems),
        'tables' => $tables
    ]);

} catch (Exception $e) {
    echo json_encode([
        'success' => false,
        'message' => 'Error: ' . $e->getMessage()
    ]);
}

$conn->close();
?>
