<?php
// Test OTP verification

$testEmail = 'testuser1770036560@example.com';
$testOtp = '734270';

$json = json_encode([
    'action' => 'verify_signup_otp',
    'email' => $testEmail,
    'otp' => $testOtp
]);

echo "Testing OTP verification\n";
echo "Email: {$testEmail}\n";
echo "OTP: {$testOtp}\n";
echo "Sending request...\n\n";

$ch = curl_init('http://localhost/rest_table/backend/verify_otp.php');
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_POST, true);
curl_setopt($ch, CURLOPT_POSTFIELDS, $json);
curl_setopt($ch, CURLOPT_HTTPHEADER, ['Content-Type: application/json']);

$response = curl_exec($ch);
$httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
curl_close($ch);

$data = json_decode($response, true);

echo "HTTP Code: {$httpCode}\n";
echo "Response: " . json_encode($data, JSON_PRETTY_PRINT) . "\n";

if ($data['success']) {
    echo "\n✓ Email verified successfully!\n";
    echo "Account created for: " . $data['data']['email'] . "\n";
}
?>
