<?php
$conn = new mysqli('localhost', 'root', '', 'granny_restaurant');

// Simulate the API request
$_POST['id'] = 1; // First recipe

// Test the query
$id = 1;
$sql = "
    SELECT r.*, m.item_name, m.description, m.price
    FROM recipes r
    LEFT JOIN menu_items m ON r.menu_item_id = m.id
    WHERE r.id = ?
";

$stmt = $conn->prepare($sql);
if (!$stmt) {
    die("Prepare failed: " . $conn->error);
}
$stmt->bind_param('i', $id);
$stmt->execute();
$result = $stmt->get_result();
$recipe = $result->fetch_assoc();
$stmt->close();

echo "=== RECIPE DATA ===\n";
echo "ID: " . $recipe['id'] . "\n";
echo "Name: " . $recipe['name'] . "\n";
echo "Menu Item Name: " . $recipe['item_name'] . "\n";
echo "Menu Item Description: " . $recipe['description'] . "\n";
echo "Menu Item Price: " . $recipe['price'] . "\n";
echo "Difficulty: " . $recipe['difficulty_level'] . "\n";
echo "Prep Time: " . $recipe['preparation_time'] . "\n";

echo "\n=== INGREDIENTS ===\n";
$ing_sql = "
    SELECT 
        ri.id,
        ri.ingredient_id,
        ri.quantity_required,
        ri.unit,
        ri.notes,
        i.name as ingredient_name,
        i.unit as ingredient_unit,
        i.unit_cost
    FROM recipe_ingredients ri
    JOIN ingredients i ON ri.ingredient_id = i.id
    WHERE ri.recipe_id = ?
";

$stmt = $conn->prepare($ing_sql);
$stmt->bind_param('i', $id);
$stmt->execute();
$ing_result = $stmt->get_result();

while ($ing = $ing_result->fetch_assoc()) {
    echo "- " . $ing['ingredient_name'] . ": " . $ing['quantity_required'] . " " . $ing['unit'] . "\n";
}
