<?php
// Direct test of the query
include 'config.php';

$server_id = 6;
$tables_sql = "SELECT 
                ta.id,
                ta.table_id,
                ta.server_id,
                ta.status,
                ta.number_of_guests,
                ta.assigned_at,
                rt.id as table_id_check,
                rt.table_number,
                rt.capacity,
                rt.floor,
                rt.section,
                rt.status as table_status
               FROM table_assignments ta
               INNER JOIN restaurant_tables rt ON ta.table_id = rt.id
               WHERE ta.server_id = " . intval($server_id) . " 
               AND ta.status = 'assigned'
               ORDER BY rt.table_number";

echo "<pre>";
echo "Testing Query for server " . $server_id . "\n";
echo "SQL: " . $tables_sql . "\n\n";

$result = $conn->query($tables_sql);
if (!$result) {
    echo "ERROR: " . $conn->error . "\n";
} else {
    echo "Rows returned: " . $result->num_rows . "\n";
    if ($result->num_rows > 0) {
        while ($row = $result->fetch_assoc()) {
            echo json_encode($row, JSON_PRETTY_PRINT) . "\n";
        }
    }
}
echo "</pre>";
?>
