<?php
/**
 * Test Server Order Taking Feature
 * Verifies menu API is working and data structure is correct
 */

session_start();
header('Content-Type: application/json');
require_once 'config.php';

// Test 1: Check menu API
echo "Testing Menu API...\n";
include 'menu_api.php';

// Test to see if we can fetch menu data
$sql = "SELECT 
            f.id as filter_id,
            f.filter_name,
            COUNT(DISTINCT sc.id) as subcategory_count,
            COUNT(DISTINCT mi.id) as item_count
        FROM menu_filters f
        LEFT JOIN menu_subcategories sc ON f.id = sc.filter_id
        LEFT JOIN menu_items mi ON sc.id = mi.subcategory_id AND mi.is_available = 1
        GROUP BY f.id, f.filter_name
        ORDER BY f.display_order ASC";

$result = $conn->query($sql);

if ($result && $result->num_rows > 0) {
    echo "✓ Menu filters found:\n";
    while ($row = $result->fetch_assoc()) {
        echo "  - {$row['filter_name']}: {$row['subcategory_count']} subcategories, {$row['item_count']} items\n";
    }
} else {
    echo "⚠ No menu filters found. Please create menu categories first.\n";
}

// Test 2: Check if orders table exists and is accessible
echo "\nTesting Orders Table...\n";
$sql = "SHOW COLUMNS FROM `orders`";
$result = $conn->query($sql);

if ($result) {
    echo "✓ Orders table structure:\n";
    while ($row = $result->fetch_assoc()) {
        echo "  - {$row['Field']} ({$row['Type']})\n";
    }
} else {
    echo "⚠ Orders table check failed: " . $conn->error . "\n";
}

// Test 3: Check servers table
echo "\nTesting Servers Table...\n";
$sql = "SHOW COLUMNS FROM `servers`";
$result = $conn->query($sql);

if ($result) {
    echo "✓ Servers table exists\n";
} else {
    echo "⚠ Servers table not found\n";
}

// Test 4: Check table_assignments
echo "\nTesting Table Assignments...\n";
$sql = "SELECT COUNT(*) as total FROM table_assignments WHERE status = 'assigned'";
$result = $conn->query($sql);

if ($result) {
    $row = $result->fetch_assoc();
    echo "✓ Table assignments: {$row['total']} active assignments\n";
} else {
    echo "⚠ Table assignments check failed\n";
}

echo "\n✓ All tests completed!\n";
?>
