<?php
// Test new signup with fresh email

$testEmail = 'testuser' . time() . '@example.com';

$json = json_encode([
    'action' => 'send_signup_otp',
    'email' => $testEmail,
    'name' => 'Test User',
    'phone' => '9876543210',
    'password' => 'password123',
    'confirmPassword' => 'password123'
]);

echo "Testing signup with email: {$testEmail}\n";
echo "Sending request...\n\n";

$ch = curl_init('http://localhost/rest_table/backend/send_otp.php');
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_POST, true);
curl_setopt($ch, CURLOPT_POSTFIELDS, $json);
curl_setopt($ch, CURLOPT_HTTPHEADER, ['Content-Type: application/json']);

$response = curl_exec($ch);
$httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
curl_close($ch);

$data = json_decode($response, true);

echo "HTTP Code: {$httpCode}\n";
echo "Response: " . json_encode($data, JSON_PRETTY_PRINT) . "\n";

if ($data['success']) {
    echo "\n✓ OTP sent successfully!\n";
    
    // Check if OTP is in the log
    $logFile = __DIR__ . '/../assets/uploads/otp_test_log.txt';
    if (file_exists($logFile)) {
        $logContent = file_get_contents($logFile);
        // Get last line
        $lines = explode("\n", trim($logContent));
        $lastLine = end($lines);
        echo "Latest OTP: {$lastLine}\n";
    }
}
?>
