<?php
$conn = new mysqli('localhost', 'root', '', 'granny_restaurant');

$sql = "
    SELECT 
        mi.id,
        mi.item_name,
        mi.price,
        CASE 
            WHEN r.id IS NOT NULL THEN 'Has Recipe'
            ELSE 'No Recipe'
        END as recipe_status
    FROM menu_items mi
    LEFT JOIN recipes r ON mi.id = r.menu_item_id
    ORDER BY mi.item_name ASC
";

$result = $conn->query($sql);
if (!$result) {
    die("Query failed: " . $conn->error);
}

echo json_encode([
    'success' => true,
    'message' => 'Menu items retrieved',
    'count' => $result->num_rows,
    'data' => $result->fetch_all(MYSQLI_ASSOC)
], JSON_PRETTY_PRINT);
