<?php
// Test duplicate signup

$testEmail = 'testuser1770036560@example.com';

$json = json_encode([
    'action' => 'send_signup_otp',
    'email' => $testEmail,
    'name' => 'Test User 2',
    'phone' => '9876543211',
    'password' => 'password456',
    'confirmPassword' => 'password456'
]);

echo "Testing signup with EXISTING email\n";
echo "Email: {$testEmail}\n";
echo "Expected: 'Email already registered'\n";
echo "Sending request...\n\n";

$ch = curl_init('http://localhost/rest_table/backend/send_otp.php');
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_POST, true);
curl_setopt($ch, CURLOPT_POSTFIELDS, $json);
curl_setopt($ch, CURLOPT_HTTPHEADER, ['Content-Type: application/json']);

$response = curl_exec($ch);
$httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
curl_close($ch);

$data = json_decode($response, true);

echo "HTTP Code: {$httpCode}\n";
echo "Response: " . json_encode($data, JSON_PRETTY_PRINT) . "\n";

if (!$data['success'] && strpos($data['message'], 'already') !== false) {
    echo "\n✓ Correctly rejected duplicate email!\n";
}
?>
