<?php
include 'config.php';

// Check if the pending registration exists
$email = 'test@example.com';
$stmt = $conn->prepare("SELECT * FROM pending_registrations WHERE email = ? ORDER BY id DESC LIMIT 1");
$stmt->bind_param("s", $email);
$stmt->execute();
$result = $stmt->get_result();

if ($row = $result->fetch_assoc()) {
    echo "Pending Registration Found:\n";
    echo "Name: " . $row['name'] . "\n";
    echo "Email: " . $row['email'] . "\n";
    echo "Phone: " . $row['phone'] . "\n";
    echo "OTP Code: " . $row['otp_code'] . "\n";
    echo "Is Verified: " . $row['is_verified'] . "\n";
    echo "Created At: " . $row['created_at'] . "\n";
    echo "Expires At: " . $row['expires_at'] . "\n";
} else {
    echo "No pending registration found for: " . $email . "\n";
}

$stmt->close();
?>
