<?php
// Complete test: Login as Priya Sharma (SRV002) and check assigned tables
session_start();

include 'config.php';

echo "<h2>Server Dashboard Data Test</h2>";
echo "<pre>";

// Step 1: Clear any previous session
session_destroy();
session_start();

// Step 2: Verify we can login
$employee_id = 'SRV002';
$password = 'Server@123';

echo "Step 1: Testing login with employee_id: " . $employee_id . "\n";
$stmt = $conn->prepare("SELECT id, name, phone, employee_id, password, status, is_online FROM servers WHERE employee_id = ?");
$stmt->bind_param("s", $employee_id);
$stmt->execute();
$login_result = $stmt->get_result();

if ($login_result->num_rows > 0) {
    $server = $login_result->fetch_assoc();
    echo "✓ Server found: " . $server['name'] . " (ID: " . $server['id'] . ")\n";
    
    // Verify password
    if (password_verify($password, $server['password'])) {
        echo "✓ Password verified\n\n";
        $_SESSION['server_id'] = $server['id'];
        $_SESSION['server_name'] = $server['name'];
        $_SESSION['employee_id'] = $server['employee_id'];
        $_SESSION['phone'] = $server['phone'];
        
        // Step 3: Get assigned tables
        $server_id = $server['id'];
        echo "Step 2: Getting assigned tables for server_id: " . $server_id . "\n\n";
        
        $tables_sql = "SELECT 
                        ta.id,
                        ta.table_id,
                        ta.server_id,
                        ta.status as assignment_status,
                        ta.number_of_guests,
                        ta.assigned_at,
                        rt.table_number,
                        rt.capacity,
                        rt.floor,
                        rt.section,
                        rt.status as table_status
                       FROM table_assignments ta
                       INNER JOIN restaurant_tables rt ON ta.table_id = rt.id
                       WHERE ta.server_id = " . intval($server_id) . " 
                       AND ta.status = 'assigned'
                       ORDER BY rt.table_number";
        
        echo "SQL Query:\n" . $tables_sql . "\n\n";
        
        $tables_result = $conn->query($tables_sql);
        if (!$tables_result) {
            echo "ERROR: " . $conn->error . "\n";
        } else {
            echo "Rows returned: " . $tables_result->num_rows . "\n\n";
            
            $assigned_tables = [];
            if ($tables_result->num_rows > 0) {
                while ($table = $tables_result->fetch_assoc()) {
                    echo "Raw row from DB:\n";
                    echo json_encode($table, JSON_PRETTY_PRINT) . "\n\n";
                    
                    $assigned_tables[] = [
                        'table_id' => $table['table_id'],
                        'table_number' => $table['table_number'],
                        'capacity' => $table['capacity'],
                        'floor' => $table['floor'],
                        'section' => $table['section'],
                        'status' => $table['assignment_status'],
                        'number_of_guests' => $table['number_of_guests'],
                        'assigned_at' => $table['assigned_at']
                    ];
                }
            }
            
            echo "\nStep 3: Final dashboard response structure:\n";
            $response_data = [
                'id' => $server['id'],
                'name' => $server['name'],
                'phone' => $server['phone'],
                'employee_id' => $server['employee_id'],
                'status' => $server['status'],
                'is_online' => (bool) $server['is_online'],
                'assigned_tables' => $assigned_tables,
                'assigned_tables_count' => count($assigned_tables)
            ];
            
            echo json_encode($response_data, JSON_PRETTY_PRINT);
        }
    } else {
        echo "✗ Password verification failed\n";
    }
} else {
    echo "✗ Server not found\n";
}

echo "</pre>";
?>
