<?php
// Database initialization for sliders
require_once 'config.php';

// Create sliders table
$createTableSQL = "CREATE TABLE IF NOT EXISTS sliders (
    id INT AUTO_INCREMENT PRIMARY KEY,
    image_path VARCHAR(255) NOT NULL,
    subheadline VARCHAR(255),
    headline VARCHAR(255) NOT NULL,
    description TEXT,
    button_text VARCHAR(100),
    button_link VARCHAR(255),
    button_style VARCHAR(50) DEFAULT 'btn--primary',
    display_order INT DEFAULT 0,
    is_active TINYINT(1) DEFAULT 1,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
    uploaded_by INT,
    FOREIGN KEY (uploaded_by) REFERENCES admins(id) ON DELETE SET NULL
)";

if ($conn->query($createTableSQL) === TRUE) {
    // Insert default sliders from hardcoded values if table was just created
    $checkSliders = $conn->query("SELECT COUNT(*) as count FROM sliders");
    $result = $checkSliders->fetch_assoc();
    
    if ($result['count'] == 0) {
        // Insert default sliders
        $defaultSliders = [
            [
                'image_path' => 'assets/images/sliders/slide-bg/11.jpg',
                'subheadline' => 'Granny Offers You',
                'headline' => 'The Best Tasting Experience!',
                'description' => 'Granny is a restaurant, bar and coffee roastery located on Egypt. We have awesome recipes and the most talented chefs in town!',
                'button_text' => 'Reservation Now',
                'button_link' => '#',
                'button_style' => 'btn--white btn--bordered btn--lg',
                'display_order' => 1
            ],
            [
                'image_path' => 'assets/images/sliders/slide-bg/3.jpg',
                'subheadline' => 'Hello, We Are Granny',
                'headline' => 'We Serve Quality Food',
                'description' => 'Granny is a restaurant, bar and coffee roastery located on Egypt. We have awesome recipes and the most talented chefs in town!',
                'button_text' => 'View Menu',
                'button_link' => '#',
                'button_style' => 'btn--primary',
                'display_order' => 2
            ],
            [
                'image_path' => 'assets/images/sliders/slide-bg/12.jpg',
                'subheadline' => 'Made With Love',
                'headline' => 'Hot and Ready to Serve',
                'description' => 'Granny is a restaurant, bar and coffee roastery located on Egypt. We have awesome recipes and the most talented chefs in town!',
                'button_text' => '',
                'button_link' => '#',
                'button_style' => 'btn--primary',
                'display_order' => 3
            ]
        ];
        
        foreach ($defaultSliders as $slider) {
            $stmt = $conn->prepare("INSERT INTO sliders (image_path, subheadline, headline, description, button_text, button_link, button_style, display_order) VALUES (?, ?, ?, ?, ?, ?, ?, ?)");
            $stmt->bind_param("sssssssi", $slider['image_path'], $slider['subheadline'], $slider['headline'], $slider['description'], $slider['button_text'], $slider['button_link'], $slider['button_style'], $slider['display_order']);
            $stmt->execute();
            $stmt->close();
        }
    }
    echo json_encode(['success' => true, 'message' => 'Sliders table created successfully']);
} else {
    echo json_encode(['success' => false, 'message' => 'Error creating table: ' . $conn->error]);
}
?>
