<?php
/**
 * Server Debug API
 * Helps diagnose why assigned tables aren't showing
 */

session_start();
require 'config.php';

header('Content-Type: application/json');

// Check if server is logged in
if (!isset($_SESSION['server_id'])) {
    http_response_code(401);
    sendResponse(false, 'Not authenticated', null);
}

$server_id = $_SESSION['server_id'];

// Get all table assignments for this server
$all_assignments = $conn->query("SELECT ta.*, rt.table_number, rt.status as table_status 
                                FROM table_assignments ta
                                LEFT JOIN restaurant_tables rt ON ta.table_id = rt.id
                                WHERE ta.server_id = " . intval($server_id));

$assigned = [];
if ($all_assignments && $all_assignments->num_rows > 0) {
    while ($row = $all_assignments->fetch_assoc()) {
        $assigned[] = $row;
    }
}

// Get server info
$server_result = $conn->query("SELECT * FROM servers WHERE id = " . intval($server_id));
$server = $server_result->fetch_assoc();

sendResponse(true, 'Debug data', [
    'server_id' => $server_id,
    'server_name' => $server['name'],
    'server_current_table_id' => $server['current_table_id'],
    'all_table_assignments' => $assigned,
    'count' => count($assigned),
    'total_assigned_status' => count(array_filter($assigned, function($a) { return $a['status'] === 'assigned'; }))
]);

?>
