<?php
/**
 * Seed Test Servers
 * Creates test server records with hashed passwords
 * Displays plain text passwords for testing purposes
 */

define('DB_HOST', 'localhost');
define('DB_USER', 'root');
define('DB_PASS', '');
define('DB_NAME', 'granny_restaurant');

$conn = new mysqli(DB_HOST, DB_USER, DB_PASS, DB_NAME);

if ($conn->connect_error) {
    die(json_encode(['success' => false, 'message' => 'Connection failed: ' . $conn->connect_error]));
}

// Test server data with plain text passwords
$test_servers = [
    [
        'name' => 'Rajesh Kumar',
        'employee_id' => 'SRV001',
        'password' => 'Server@123',
        'phone' => '9876543210',
        'status' => 'available'
    ],
    [
        'name' => 'Priya Sharma',
        'employee_id' => 'SRV002',
        'password' => 'Server@456',
        'phone' => '9876543211',
        'status' => 'available'
    ],
    [
        'name' => 'Arjun Singh',
        'employee_id' => 'SRV003',
        'password' => 'Server@789',
        'phone' => '9876543212',
        'status' => 'available'
    ],
    [
        'name' => 'Neha Patel',
        'employee_id' => 'SRV004',
        'password' => 'Server@234',
        'phone' => '9876543213',
        'status' => 'available'
    ],
    [
        'name' => 'Vikram Desai',
        'employee_id' => 'SRV005',
        'password' => 'Server@567',
        'phone' => '9876543214',
        'status' => 'available'
    ]
];

// Insert test servers
$inserted = 0;
$failed = 0;
$credentials = [];

foreach ($test_servers as $server) {
    // Hash password
    $hashed_password = password_hash($server['password'], PASSWORD_BCRYPT);
    
    // Insert into database
    $sql = "INSERT INTO servers (name, employee_id, password, phone, status, is_online, created_at)
            VALUES (
                '" . $conn->real_escape_string($server['name']) . "',
                '" . $conn->real_escape_string($server['employee_id']) . "',
                '" . $conn->real_escape_string($hashed_password) . "',
                '" . $conn->real_escape_string($server['phone']) . "',
                '" . $server['status'] . "',
                FALSE,
                NOW()
            )";
    
    if ($conn->query($sql) === TRUE) {
        $inserted++;
        $credentials[] = [
            'server_id' => $conn->insert_id,
            'name' => $server['name'],
            'employee_id' => $server['employee_id'],
            'plain_password' => $server['password']
        ];
    } else {
        $failed++;
        echo "Error inserting " . $server['name'] . ": " . $conn->error . "<br>";
    }
}

$conn->close();

// Display results
?>

<!DOCTYPE html>
<html dir="ltr" lang="en-US">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>Test Servers Created</title>
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            font-family: 'Raleway', sans-serif;
            background: linear-gradient(135deg, #d4a574 0%, #b8860b 100%);
            min-height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
            padding: 20px;
        }

        .container {
            background: white;
            padding: 40px;
            border-radius: 10px;
            box-shadow: 0 10px 40px rgba(0, 0, 0, 0.2);
            max-width: 900px;
            width: 100%;
        }

        h1 {
            color: #1e3c72;
            margin-bottom: 10px;
            display: flex;
            align-items: center;
            gap: 10px;
        }

        .status-message {
            margin-bottom: 30px;
            padding: 15px;
            background: #e8f5e9;
            border-left: 4px solid #4caf50;
            border-radius: 4px;
            color: #2e7d32;
        }

        .status-message.error {
            background: #ffebee;
            border-left-color: #f44336;
            color: #c62828;
        }

        .credentials-table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 20px;
        }

        .credentials-table thead {
            background: linear-gradient(135deg, #d4a574 0%, #b8860b 100%);
            color: white;
        }

        .credentials-table th {
            padding: 15px;
            text-align: left;
            font-weight: 600;
            border: 1px solid #ddd;
        }

        .credentials-table td {
            padding: 12px 15px;
            border: 1px solid #ddd;
        }

        .credentials-table tbody tr:nth-child(even) {
            background: #f8f9fa;
        }

        .credentials-table tbody tr:hover {
            background: #f0f0f0;
        }

        .employee-id {
            font-weight: 600;
            color: #1e3c72;
            font-family: 'Courier New', monospace;
        }

        .password {
            font-family: 'Courier New', monospace;
            background: #fff3cd;
            padding: 5px 10px;
            border-radius: 4px;
            font-weight: bold;
            color: #856404;
        }

        .copy-btn {
            background: #2196F3;
            color: white;
            border: none;
            padding: 6px 12px;
            border-radius: 4px;
            cursor: pointer;
            font-size: 12px;
            transition: background 0.3s;
        }

        .copy-btn:hover {
            background: #1976D2;
        }

        .info-box {
            background: #e3f2fd;
            border-left: 4px solid #2196F3;
            padding: 15px;
            margin-top: 20px;
            border-radius: 4px;
            color: #1565c0;
        }

        .login-url {
            background: white;
            padding: 10px 15px;
            border-radius: 4px;
            font-family: 'Courier New', monospace;
            margin-top: 10px;
            word-break: break-all;
            border: 1px solid #ddd;
        }

        .summary {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
            gap: 15px;
            margin-bottom: 30px;
        }

        .summary-card {
            padding: 20px;
            background: #f0f0f0;
            border-radius: 8px;
            text-align: center;
        }

        .summary-card h3 {
            color: #666;
            font-size: 14px;
            margin-bottom: 8px;
            text-transform: uppercase;
            font-weight: 600;
        }

        .summary-card .value {
            font-size: 32px;
            font-weight: 700;
            color: #1e3c72;
        }

        .warning-box {
            background: #fff3cd;
            border-left: 4px solid #ffc107;
            padding: 15px;
            margin-top: 20px;
            border-radius: 4px;
            color: #856404;
        }

        @media print {
            body {
                background: white;
            }
            .container {
                box-shadow: none;
            }
        }
    </style>
</head>
<body>
    <div class="container">
        <h1>
            <span>✓</span> Test Servers Created Successfully
        </h1>

        <div class="summary">
            <div class="summary-card">
                <h3>Inserted</h3>
                <div class="value"><?php echo $inserted; ?></div>
            </div>
            <div class="summary-card">
                <h3>Failed</h3>
                <div class="value" style="color: <?php echo $failed > 0 ? '#d32f2f' : '#2e7d32'; ?>">
                    <?php echo $failed; ?>
                </div>
            </div>
            <div class="summary-card">
                <h3>Total Servers</h3>
                <div class="value"><?php echo $inserted + $failed; ?></div>
            </div>
        </div>

        <div class="status-message">
            ✓ Created <?php echo $inserted; ?> test server records with hashed passwords
        </div>

        <?php if ($inserted > 0): ?>
        <h2 style="color: #1e3c72; margin-top: 30px; margin-bottom: 15px;">
            <i style="color: #d4a574;">📋</i> Test Server Credentials
        </h2>

        <table class="credentials-table">
            <thead>
                <tr>
                    <th>Server ID</th>
                    <th>Name</th>
                    <th>Employee ID</th>
                    <th>Password (Plain Text)</th>
                    <th>Action</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($credentials as $cred): ?>
                <tr>
                    <td><?php echo $cred['server_id']; ?></td>
                    <td><?php echo htmlspecialchars($cred['name']); ?></td>
                    <td class="employee-id"><?php echo htmlspecialchars($cred['employee_id']); ?></td>
                    <td class="password"><?php echo htmlspecialchars($cred['plain_password']); ?></td>
                    <td>
                        <button class="copy-btn" onclick="copyToClipboard('<?php echo htmlspecialchars($cred['plain_password']); ?>')">
                            Copy
                        </button>
                    </td>
                </tr>
                <?php endforeach; ?>
            </tbody>
        </table>

        <div class="info-box">
            <strong>🔗 Login URL:</strong>
            <div class="login-url">
                http://localhost/rest_table/server/login.php
            </div>
        </div>

        <div class="warning-box">
            <strong>⚠️ Important for Testing:</strong>
            <ul style="margin-left: 20px; margin-top: 10px;">
                <li>Use the <strong>Employee ID</strong> and <strong>Password</strong> to login</li>
                <li>Passwords are hashed in the database using BCRYPT</li>
                <li>These are test credentials - change them before production</li>
                <li>Keep the password list secure and never share it publicly</li>
                <li>You can assign table numbers to these servers using the Manager Dashboard</li>
            </ul>
        </div>

        <div style="margin-top: 30px; padding-top: 20px; border-top: 1px solid #ddd;">
            <a href="../server/login.php" style="display: inline-block; background: linear-gradient(135deg, #d4a574 0%, #b8860b 100%); color: white; padding: 12px 30px; text-decoration: none; border-radius: 6px; font-weight: 600;">
                Go to Server Login →
            </a>
            <a href="create_server_account.php" style="display: inline-block; background: #666; color: white; padding: 12px 30px; text-decoration: none; border-radius: 6px; font-weight: 600; margin-left: 10px;">
                ↻ Create More Accounts
            </a>
        </div>
        <?php endif; ?>
    </div>

    <script>
        function copyToClipboard(text) {
            navigator.clipboard.writeText(text).then(() => {
                alert('Password copied to clipboard!');
            }).catch(err => {
                console.error('Failed to copy:', err);
            });
        }
    </script>
</body>
</html>
