<?php
/**
 * Migration: Add password column to servers table
 * This migration adds authentication fields to the servers table
 */

define('DB_HOST', 'localhost');
define('DB_USER', 'root');
define('DB_PASS', '');
define('DB_NAME', 'granny_restaurant');

$conn = new mysqli(DB_HOST, DB_USER, DB_PASS, DB_NAME);

if ($conn->connect_error) {
    die(json_encode(['success' => false, 'message' => 'Connection failed: ' . $conn->connect_error]));
}

// Check if password column exists
$result = $conn->query("SHOW COLUMNS FROM servers LIKE 'password'");
if ($result && $result->num_rows === 0) {
    // Add password column
    $sql = "ALTER TABLE servers ADD COLUMN password VARCHAR(255) AFTER employee_id";
    if ($conn->query($sql) === TRUE) {
        echo json_encode(['success' => true, 'message' => 'Password column added to servers table']);
    } else {
        echo json_encode(['success' => false, 'message' => 'Error adding password column: ' . $conn->error]);
    }
} else {
    echo json_encode(['success' => true, 'message' => 'Password column already exists']);
}

// Check if is_online column exists
$result = $conn->query("SHOW COLUMNS FROM servers LIKE 'is_online'");
if ($result && $result->num_rows === 0) {
    // Add is_online column
    $sql = "ALTER TABLE servers ADD COLUMN is_online BOOLEAN DEFAULT FALSE AFTER status";
    if ($conn->query($sql) === TRUE) {
        echo json_encode(['success' => true, 'message' => 'is_online column added to servers table']);
    } else {
        echo json_encode(['success' => false, 'message' => 'Error adding is_online column: ' . $conn->error]);
    }
} else {
    echo json_encode(['success' => true, 'message' => 'is_online column already exists']);
}

$conn->close();
?>
