<?php
/**
 * Migration Script: Add number_of_guests column to table_assignments
 * Run this once to update the database schema
 */

require 'config.php';

// Add number_of_guests column if it doesn't exist
$sql = "ALTER TABLE table_assignments 
        ADD COLUMN number_of_guests INT DEFAULT 0 
        AFTER manager_id";

if ($conn->query($sql) === TRUE) {
    echo json_encode(['success' => true, 'message' => 'Successfully added number_of_guests column to table_assignments']);
} else {
    // Column might already exist, check if it's a duplicate column error
    if (strpos($conn->error, 'Duplicate column') !== false) {
        echo json_encode(['success' => true, 'message' => 'Column number_of_guests already exists']);
    } else {
        echo json_encode(['success' => false, 'message' => 'Error adding column: ' . $conn->error]);
    }
}

$conn->close();
?>
