<?php
/**
 * Manager Session Check
 * Validates manager session and returns manager info
 */

header('Content-Type: application/json');

if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

// Check if manager is logged in
if (!isset($_SESSION['manager_id']) || empty($_SESSION['manager_id'])) {
    http_response_code(401);
    echo json_encode([
        'authenticated' => false,
        'message' => 'No active session'
    ]);
    exit;
}

// Check for session timeout (30 minutes)
$timeout = 1800;
$_SESSION['last_activity'] = $_SESSION['last_activity'] ?? time();

if (time() - $_SESSION['last_activity'] > $timeout) {
    session_destroy();
    http_response_code(401);
    echo json_encode([
        'authenticated' => false,
        'message' => 'Session expired'
    ]);
    exit;
}

// Update last activity
$_SESSION['last_activity'] = time();

// Return manager information
$user = [
    'id' => $_SESSION['manager_id'],
    'name' => $_SESSION['manager_name'] ?? 'Manager',
    'email' => $_SESSION['manager_email'] ?? '',
    'phone' => $_SESSION['manager_phone'] ?? '',
    'shift_type' => $_SESSION['manager_shift'] ?? ''
];

echo json_encode([
    'authenticated' => true,
    'user' => $user,
    'message' => 'Manager authenticated via session'
]);
?>
