<?php
/**
 * Kitchen Staff Session Check API
 * Verifies if user is logged in as kitchen staff
 */

header('Content-Type: application/json');
require_once 'config.php';

session_start();

// Check if kitchen staff is logged in
if (!isset($_SESSION['kitchen_staff_id'])) {
    http_response_code(401);
    sendResponse(false, 'Not authenticated', null);
}

// Optional: Check session timeout (30 minutes of inactivity)
$timeout = 30 * 60; // 30 minutes
if (isset($_SESSION['kitchen_staff_login_time'])) {
    if (time() - $_SESSION['kitchen_staff_login_time'] > $timeout && !isset($_SESSION['kitchen_staff_remember_me'])) {
        session_destroy();
        http_response_code(401);
        sendResponse(false, 'Session expired', null);
    }
    // Update last activity time
    $_SESSION['kitchen_staff_login_time'] = time();
}

sendResponse(true, 'Session valid', [
    'chef_id' => $_SESSION['kitchen_staff_id'],
    'chef_name' => $_SESSION['kitchen_staff_name'],
    'chef_email' => $_SESSION['kitchen_staff_email'],
    'chef_role' => $_SESSION['kitchen_staff_role'],
    'chef_position' => $_SESSION['kitchen_staff_position'],
    'chef_image' => $_SESSION['kitchen_staff_image']
]);

$conn->close();
?>
