<?php
// Sample Table Data Initialization
define('DB_HOST', 'localhost');
define('DB_USER', 'root');
define('DB_PASS', '');
define('DB_NAME', 'granny_restaurant');

$conn = new mysqli(DB_HOST, DB_USER, DB_PASS, DB_NAME);

if ($conn->connect_error) {
    die("Connection failed: " . $conn->connect_error);
}

// Sample tables for Floor 1 - Dining Area
$tables = [
    // Floor 1 - Dining Area
    ['table_number' => 'T-01', 'capacity' => 4, 'floor' => 1, 'section' => 'Dining Area', 'notes' => 'Standard table near entrance'],
    ['table_number' => 'T-02', 'capacity' => 4, 'floor' => 1, 'section' => 'Dining Area', 'notes' => 'Standard table near window'],
    ['table_number' => 'T-03', 'capacity' => 4, 'floor' => 1, 'section' => 'Dining Area', 'notes' => 'Standard table center'],
    ['table_number' => 'T-04', 'capacity' => 4, 'floor' => 1, 'section' => 'Dining Area', 'notes' => 'Standard table near window'],
    ['table_number' => 'T-05', 'capacity' => 4, 'floor' => 1, 'section' => 'Dining Area', 'notes' => 'Standard table'],
    
    // Floor 1 - VIP Corner
    ['table_number' => 'VIP-01', 'capacity' => 6, 'floor' => 1, 'section' => 'VIP Corner', 'notes' => 'Premium corner table with garden view'],
    ['table_number' => 'VIP-02', 'capacity' => 6, 'floor' => 1, 'section' => 'VIP Corner', 'notes' => 'Premium table for special occasions'],
    ['table_number' => 'VIP-03', 'capacity' => 8, 'floor' => 1, 'section' => 'VIP Corner', 'notes' => 'Large conference table'],
    
    // Floor 1 - Bar Area
    ['table_number' => 'B-01', 'capacity' => 2, 'floor' => 1, 'section' => 'Bar Area', 'notes' => 'High table at bar'],
    ['table_number' => 'B-02', 'capacity' => 2, 'floor' => 1, 'section' => 'Bar Area', 'notes' => 'High table at bar'],
    
    // Floor 2 - Dining Area
    ['table_number' => 'T-06', 'capacity' => 4, 'floor' => 2, 'section' => 'Dining Area', 'notes' => 'Standard table'],
    ['table_number' => 'T-07', 'capacity' => 4, 'floor' => 2, 'section' => 'Dining Area', 'notes' => 'Standard table near window'],
    ['table_number' => 'T-08', 'capacity' => 4, 'floor' => 2, 'section' => 'Dining Area', 'notes' => 'Standard table'],
    ['table_number' => 'T-09', 'capacity' => 4, 'floor' => 2, 'section' => 'Dining Area', 'notes' => 'Standard table'],
    ['table_number' => 'T-10', 'capacity' => 4, 'floor' => 2, 'section' => 'Dining Area', 'notes' => 'Standard table'],
    
    // Floor 2 - VIP Corner
    ['table_number' => 'VIP-04', 'capacity' => 6, 'floor' => 2, 'section' => 'VIP Corner', 'notes' => 'Premium private room'],
    ['table_number' => 'VIP-05', 'capacity' => 8, 'floor' => 2, 'section' => 'VIP Corner', 'notes' => 'Large private dining'],
    
    // Floor 2 - Outdoor Patio
    ['table_number' => 'P-01', 'capacity' => 4, 'floor' => 2, 'section' => 'Outdoor Patio', 'notes' => 'Garden patio table'],
    ['table_number' => 'P-02', 'capacity' => 6, 'floor' => 2, 'section' => 'Outdoor Patio', 'notes' => 'Large patio table'],
    ['table_number' => 'P-03', 'capacity' => 4, 'floor' => 2, 'section' => 'Outdoor Patio', 'notes' => 'Garden patio table'],
];

$inserted = 0;
$skipped = 0;

foreach ($tables as $table) {
    // Check if table already exists
    $check = $conn->query("SELECT id FROM restaurant_tables WHERE table_number = '" . $conn->real_escape_string($table['table_number']) . "'");
    
    if ($check->num_rows > 0) {
        $skipped++;
        continue;
    }
    
    $sql = "INSERT INTO restaurant_tables (table_number, base_capacity, current_capacity, floor_level, section, notes, status) 
            VALUES ('" . $conn->real_escape_string($table['table_number']) . "', 
                    " . intval($table['capacity']) . ", 
                    " . intval($table['capacity']) . ", 
                    " . intval($table['floor']) . ", 
                    '" . $conn->real_escape_string($table['section']) . "', 
                    '" . $conn->real_escape_string($table['notes']) . "', 
                    'available')";
    
    if ($conn->query($sql) === TRUE) {
        $inserted++;
    } else {
        echo "Error inserting table " . $table['table_number'] . ": " . $conn->error . "<br>";
    }
}

$conn->close();

// HTML Response
?>
<!DOCTYPE html>
<html>
<head>
    <title>Sample Tables Initialization</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            padding: 20px;
            background: #f5f5f5;
        }
        .container {
            max-width: 600px;
            margin: 0 auto;
            background: white;
            padding: 30px;
            border-radius: 8px;
            box-shadow: 0 2px 10px rgba(0,0,0,0.1);
        }
        h1 {
            color: #2c3e50;
            border-bottom: 3px solid #d4a574;
            padding-bottom: 10px;
        }
        .success {
            background: #d4edda;
            color: #155724;
            padding: 15px;
            border-radius: 4px;
            margin-bottom: 20px;
        }
        .info {
            background: #d1ecf1;
            color: #0c5460;
            padding: 15px;
            border-radius: 4px;
            margin-bottom: 20px;
        }
        .stats {
            display: grid;
            grid-template-columns: 1fr 1fr;
            gap: 15px;
            margin-top: 20px;
        }
        .stat-box {
            background: #f9f9f9;
            padding: 15px;
            border-radius: 4px;
            border-left: 4px solid #d4a574;
        }
        .stat-value {
            font-size: 28px;
            font-weight: bold;
            color: #d4a574;
        }
        .stat-label {
            font-size: 12px;
            color: #666;
            text-transform: uppercase;
            margin-top: 5px;
        }
        .note {
            background: #fff3cd;
            color: #856404;
            padding: 15px;
            border-radius: 4px;
            margin-top: 20px;
            font-size: 14px;
        }
    </style>
</head>
<body>
    <div class="container">
        <h1>🍽️ Sample Tables Initialization</h1>
        
        <div class="success">
            <strong>✓ Initialization Complete!</strong>
        </div>

        <div class="stats">
            <div class="stat-box">
                <div class="stat-value"><?php echo $inserted; ?></div>
                <div class="stat-label">Tables Inserted</div>
            </div>
            <div class="stat-box">
                <div class="stat-value"><?php echo $skipped; ?></div>
                <div class="stat-label">Already Existing</div>
            </div>
        </div>

        <div class="info" style="margin-top: 20px;">
            <strong>📊 Sample Data Summary:</strong>
            <ul style="margin: 10px 0; padding-left: 20px;">
                <li><strong>Total Tables:</strong> <?php echo $inserted + $skipped; ?></li>
                <li><strong>Floors:</strong> 2 (Floor 1, Floor 2)</li>
                <li><strong>Sections:</strong> 5 (Dining Area, VIP Corner, Bar Area, Outdoor Patio)</li>
                <li><strong>Total Capacity:</strong> ~100 guests</li>
                <li><strong>Table Types:</strong> 2-seater (Bar), 4-seater (Standard), 6-seater (VIP), 8-seater (Conference)</li>
            </ul>
        </div>

        <div class="note">
            <strong>Next Steps:</strong><br>
            1. Log in to admin dashboard<br>
            2. Navigate to Tables section<br>
            3. View all created tables<br>
            4. Test merging, filtering, and availability features<br>
            5. Create additional tables as needed
        </div>
    </div>
</body>
</html>
