<?php
// Initialize Dine-In Orders Table
require_once 'config.php';

// Create dine_in_orders table for in-restaurant dining orders
$sql = "CREATE TABLE IF NOT EXISTS dine_in_orders (
    id INT PRIMARY KEY AUTO_INCREMENT,
    assignment_id INT NULL,
    server_id INT NOT NULL,
    table_id INT NOT NULL,
    order_number VARCHAR(50) UNIQUE,
    total_amount DECIMAL(10, 2) DEFAULT 0,
    status VARCHAR(50) DEFAULT 'pending' COMMENT 'pending, confirmed, preparing, ready, completed, cancelled',
    payment_status VARCHAR(50) DEFAULT 'unpaid' COMMENT 'unpaid, paid, partial',
    special_requests TEXT,
    notes TEXT,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
    FOREIGN KEY (assignment_id) REFERENCES table_assignments(id) ON DELETE SET NULL,
    FOREIGN KEY (server_id) REFERENCES servers(id) ON DELETE CASCADE,
    FOREIGN KEY (table_id) REFERENCES restaurant_tables(id) ON DELETE CASCADE
)";

if ($conn->query($sql) === TRUE) {
    echo json_encode(['success' => true, 'message' => 'dine_in_orders table created successfully']);
} else {
    echo json_encode(['success' => false, 'message' => 'Error creating table: ' . $conn->error]);
}

// Create dine_in_order_items table
$sql = "CREATE TABLE IF NOT EXISTS dine_in_order_items (
    id INT PRIMARY KEY AUTO_INCREMENT,
    dine_in_order_id INT NOT NULL,
    item_id INT NOT NULL,
    item_name VARCHAR(100) NOT NULL,
    quantity INT NOT NULL DEFAULT 1,
    unit_price DECIMAL(10, 2) NOT NULL,
    total_price DECIMAL(10, 2) NOT NULL,
    status VARCHAR(50) DEFAULT 'pending' COMMENT 'pending, preparing, ready, served',
    special_instructions TEXT,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    FOREIGN KEY (dine_in_order_id) REFERENCES dine_in_orders(id) ON DELETE CASCADE,
    FOREIGN KEY (item_id) REFERENCES menu_items(id) ON DELETE RESTRICT
)";

if ($conn->query($sql) === TRUE) {
    echo json_encode(['success' => true, 'message' => 'dine_in_order_items table created successfully']);
} else {
    echo json_encode(['success' => false, 'message' => 'Error creating table: ' . $conn->error]);
}

$conn->close();
?>
