<?php
// Initialize Chef Database Tables
header('Content-Type: application/json');

include 'config.php';

try {
    // Create chefs table
    $chefs_table = "CREATE TABLE IF NOT EXISTS chefs (
        id INT AUTO_INCREMENT PRIMARY KEY,
        name VARCHAR(255) NOT NULL,
        position VARCHAR(255) NOT NULL,
        description TEXT,
        image_path VARCHAR(500) NOT NULL,
        display_order INT DEFAULT 0,
        created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
        updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
        INDEX idx_name (name),
        INDEX idx_display_order (display_order)
    ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci";

    if (!$conn->query($chefs_table)) {
        throw new Exception('Error creating chefs table: ' . $conn->error);
    }

    // Create chef_skills table
    $skills_table = "CREATE TABLE IF NOT EXISTS chef_skills (
        id INT AUTO_INCREMENT PRIMARY KEY,
        chef_id INT NOT NULL,
        skill_name VARCHAR(100) NOT NULL,
        skill_level VARCHAR(50) DEFAULT 'Expert',
        created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
        FOREIGN KEY (chef_id) REFERENCES chefs(id) ON DELETE CASCADE,
        INDEX idx_chef (chef_id)
    ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci";

    if (!$conn->query($skills_table)) {
        throw new Exception('Error creating chef_skills table: ' . $conn->error);
    }

    // Create chef_social_media table
    $social_table = "CREATE TABLE IF NOT EXISTS chef_social_media (
        id INT AUTO_INCREMENT PRIMARY KEY,
        chef_id INT NOT NULL,
        platform VARCHAR(50) NOT NULL,
        url VARCHAR(500) NOT NULL,
        icon_class VARCHAR(50) DEFAULT 'fab fa-facebook',
        created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
        FOREIGN KEY (chef_id) REFERENCES chefs(id) ON DELETE CASCADE,
        INDEX idx_chef (chef_id),
        UNIQUE KEY unique_platform (chef_id, platform)
    ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci";

    if (!$conn->query($social_table)) {
        throw new Exception('Error creating chef_social_media table: ' . $conn->error);
    }

    echo json_encode([
        'success' => true,
        'message' => 'Chef tables created successfully'
    ]);

} catch (Exception $e) {
    echo json_encode([
        'success' => false,
        'message' => $e->getMessage()
    ]);
}

$conn->close();
?>
