<?php
/**
 * Blog Database Initialization
 * Creates the blog table with all necessary fields
 */

require_once 'config.php';

// Create blog table
$blog_table = "CREATE TABLE IF NOT EXISTS blog (
    id INT AUTO_INCREMENT PRIMARY KEY,
    title VARCHAR(255) NOT NULL,
    slug VARCHAR(255) NOT NULL UNIQUE,
    content LONGTEXT NOT NULL,
    excerpt VARCHAR(500),
    featured_image VARCHAR(255),
    category VARCHAR(100),
    author_id INT,
    status ENUM('draft', 'published') DEFAULT 'draft',
    featured BOOLEAN DEFAULT FALSE,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
    INDEX idx_status (status),
    INDEX idx_category (category),
    INDEX idx_created_at (created_at)
)";

if ($conn->query($blog_table) === TRUE) {
    echo "Blog table created successfully";
} else {
    echo "Error creating blog table: " . $conn->error;
}

// Create blog categories table (optional but useful)
$blog_categories_table = "CREATE TABLE IF NOT EXISTS blog_categories (
    id INT AUTO_INCREMENT PRIMARY KEY,
    name VARCHAR(100) NOT NULL,
    slug VARCHAR(100) NOT NULL UNIQUE,
    description TEXT,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
)";

if ($conn->query($blog_categories_table) === TRUE) {
    echo "<br>Blog categories table created successfully";
} else {
    echo "<br>Error creating blog categories table: " . $conn->error;
}

$conn->close();
?>
