<?php
header('Content-Type: application/json');
require_once 'config.php';

try {
    // Get total orders count
    $ordersResult = $conn->query("SELECT COUNT(*) as count FROM orders");
    $ordersData = $ordersResult->fetch_assoc();
    $totalOrders = $ordersData['count'];

    // Get total bookings count
    $bookingsResult = $conn->query("SELECT COUNT(*) as count FROM bookings");
    $bookingsData = $bookingsResult->fetch_assoc();
    $totalBookings = $bookingsData['count'];

    // Get total contacts count
    $contactsResult = $conn->query("SELECT COUNT(*) as count FROM contacts");
    $contactsData = $contactsResult->fetch_assoc();
    $totalContacts = $contactsData['count'];

    // Get total users count
    $usersResult = $conn->query("SELECT COUNT(*) as count FROM users");
    $usersData = $usersResult->fetch_assoc();
    $totalUsers = $usersData['count'];

    echo json_encode([
        'success' => true,
        'total_orders' => (int)$totalOrders,
        'total_bookings' => (int)$totalBookings,
        'total_contacts' => (int)$totalContacts,
        'total_users' => (int)$totalUsers
    ]);

} catch (Exception $e) {
    echo json_encode([
        'success' => false,
        'message' => 'Error fetching statistics: ' . $e->getMessage(),
        'total_orders' => 0,
        'total_bookings' => 0,
        'total_contacts' => 0,
        'total_users' => 0
    ]);
}

$conn->close();
?>
