<?php
/**
 * Schema Check - Verify table structures
 */

include 'config.php';

echo "<h2>Table Schema Verification</h2>";
echo "<pre>";

// Check table_assignments structure
echo "=== table_assignments schema ===\n";
$result = $conn->query("DESCRIBE table_assignments");
while ($row = $result->fetch_assoc()) {
    echo sprintf("%-20s %-20s %s\n", $row['Field'], $row['Type'], $row['Null']);
}

echo "\n=== restaurant_tables schema ===\n";
$result = $conn->query("DESCRIBE restaurant_tables");
while ($row = $result->fetch_assoc()) {
    echo sprintf("%-20s %-20s %s\n", $row['Field'], $row['Type'], $row['Null']);
}

echo "\n=== servers schema ===\n";
$result = $conn->query("DESCRIBE servers");
while ($row = $result->fetch_assoc()) {
    echo sprintf("%-20s %-20s %s\n", $row['Field'], $row['Type'], $row['Null']);
}

echo "\n=== Raw count - total assignments in DB ===\n";
$result = $conn->query("SELECT COUNT(*) as total FROM table_assignments");
$data = $result->fetch_assoc();
echo "Total assignments: " . $data['total'] . "\n";

echo "\n=== Assignments for server 6 (EXACT) ===\n";
$result = $conn->query("SELECT * FROM table_assignments WHERE server_id = 6");
echo "Rows found: " . $result->num_rows . "\n";
if ($result->num_rows > 0) {
    $row = $result->fetch_assoc();
    echo "Full row dump:\n";
    foreach ($row as $key => $value) {
        echo "  $key => " . ($value === null ? "NULL" : $value) . "\n";
    }
}

echo "\n=== All assignments (first 10) ===\n";
$result = $conn->query("SELECT id, server_id, table_id, status FROM table_assignments LIMIT 10");
while ($row = $result->fetch_assoc()) {
    echo "ID:" . $row['id'] . " Server:" . $row['server_id'] . " Table:" . $row['table_id'] . " Status:" . $row['status'] . "\n";
}

echo "</pre>";
?>
