<?php
require 'config.php';

echo "<h2>Database Tables</h2>";
echo "<pre>";

// Get all tables
$result = $conn->query("SHOW TABLES");
echo "Available Tables:\n";
while ($row = $result->fetch_row()) {
    echo "- " . $row[0] . "\n";
}

echo "\n\n<h2>Users Table Structure</h2>";
$result = $conn->query("DESCRIBE users");
echo "Users Table Columns:\n";
while ($row = $result->fetch_assoc()) {
    echo $row['Field'] . " (" . $row['Type'] . ")\n";
}

echo "\n\n<h2>Users Count</h2>";
$result = $conn->query("SELECT COUNT(*) as count FROM users");
$row = $result->fetch_assoc();
echo "Total Users: " . $row['count'] . "\n";

echo "\n\n<h2>Sample Users</h2>";
$result = $conn->query("SELECT * FROM users LIMIT 3");
while ($row = $result->fetch_assoc()) {
    echo json_encode($row, JSON_PRETTY_PRINT) . "\n\n";
}

echo "</pre>";
$conn->close();
?>
