<?php
/**
 * Comprehensive Server Assignment Check
 * Shows ALL data for debugging why tables aren't showing
 */

session_start();
require 'config.php';

header('Content-Type: application/json');

// Check if server is logged in
if (!isset($_SESSION['server_id'])) {
    http_response_code(401);
    sendResponse(false, 'Not authenticated', null);
}

$server_id = $_SESSION['server_id'];

// Get server info
$server_result = $conn->query("SELECT * FROM servers WHERE id = " . intval($server_id));
$server = $server_result->fetch_assoc();

// Check 1: All assignments for this server (any status)
$all_assignments = $conn->query("SELECT 
                                ta.id,
                                ta.table_id,
                                ta.server_id,
                                ta.status,
                                ta.number_of_guests,
                                ta.assigned_at,
                                rt.table_number,
                                rt.status as table_status
                                FROM table_assignments ta
                                LEFT JOIN restaurant_tables rt ON ta.table_id = rt.id
                                WHERE ta.server_id = " . intval($server_id));

$all_data = [];
while ($row = $all_assignments->fetch_assoc()) {
    $all_data[] = $row;
}

// Check 2: Assignments with status = 'assigned'
$assigned_status = $conn->query("SELECT 
                                ta.id,
                                ta.table_id,
                                ta.server_id,
                                ta.status,
                                ta.number_of_guests,
                                ta.assigned_at,
                                rt.table_number,
                                rt.status as table_status
                                FROM table_assignments ta
                                LEFT JOIN restaurant_tables rt ON ta.table_id = rt.id
                                WHERE ta.server_id = " . intval($server_id) . " AND ta.status = 'assigned'");

$assigned_data = [];
while ($row = $assigned_status->fetch_assoc()) {
    $assigned_data[] = $row;
}

// Check 3: All servers
$all_servers = $conn->query("SELECT id, name, employee_id, status, current_table_id FROM servers LIMIT 10");
$servers_data = [];
while ($row = $all_servers->fetch_assoc()) {
    $servers_data[] = $row;
}

// Check 4: All table assignments
$all_table_assignments = $conn->query("SELECT 
                                      ta.id,
                                      ta.table_id,
                                      ta.server_id,
                                      ta.status,
                                      s.name as server_name,
                                      rt.table_number
                                      FROM table_assignments ta
                                      LEFT JOIN servers s ON ta.server_id = s.id
                                      LEFT JOIN restaurant_tables rt ON ta.table_id = rt.id
                                      LIMIT 20");

$all_assignments_data = [];
while ($row = $all_table_assignments->fetch_assoc()) {
    $all_assignments_data[] = $row;
}

sendResponse(true, 'Debug info', [
    'current_server' => [
        'id' => $server['id'],
        'name' => $server['name'],
        'employee_id' => $server['employee_id'],
        'status' => $server['status'],
        'current_table_id' => $server['current_table_id']
    ],
    'assignments_for_this_server' => [
        'total' => count($all_data),
        'data' => $all_data
    ],
    'assignments_with_status_assigned' => [
        'total' => count($assigned_data),
        'data' => $assigned_data
    ],
    'all_servers' => $servers_data,
    'all_table_assignments_sample' => $all_assignments_data
]);

?>
