<?php
/**
 * Clear and reset menu data for testing
 */

require_once 'config.php';

try {
    // Disable foreign key checks
    $conn->query("SET FOREIGN_KEY_CHECKS=0");
    
    // Delete all data
    $conn->query("TRUNCATE TABLE menu_items");
    $conn->query("TRUNCATE TABLE menu_subcategories");
    $conn->query("TRUNCATE TABLE menu_filters");
    
    // Re-enable foreign key checks
    $conn->query("SET FOREIGN_KEY_CHECKS=1");

    echo json_encode([
        'success' => true,
        'message' => 'All menu data cleared successfully'
    ]);

} catch (Exception $e) {
    echo json_encode([
        'success' => false,
        'message' => 'Error: ' . $e->getMessage()
    ]);
}

$conn->close();
?>
