<?php
include 'config.php';

// Clean up verified pending registrations (keep only unverified ones)
$stmt = $conn->prepare("DELETE FROM pending_registrations WHERE is_verified = 1");
$stmt->execute();
$deletedCount = $stmt->affected_rows;
$stmt->close();

echo "Cleaned up {$deletedCount} verified pending registrations\n";

// Show current state
echo "\n=== CURRENT STATE ===\n";

echo "\nPending Registrations (should be empty or only unverified):\n";
$stmt = $conn->prepare("SELECT id, email, is_verified, created_at FROM pending_registrations ORDER BY created_at DESC");
$stmt->execute();
$result = $stmt->get_result();

if ($result->num_rows > 0) {
    while ($row = $result->fetch_assoc()) {
        echo "  Email: " . $row['email'] . " | Verified: " . $row['is_verified'] . "\n";
    }
} else {
    echo "  (empty)\n";
}
$stmt->close();

echo "\nRegistered Users:\n";
$stmt = $conn->prepare("SELECT id, email, is_email_verified, created_at FROM users ORDER BY created_at DESC LIMIT 5");
$stmt->execute();
$result = $stmt->get_result();

while ($row = $result->fetch_assoc()) {
    echo "  Email: " . $row['email'] . " | Verified: " . $row['is_email_verified'] . "\n";
}
$stmt->close();

echo "\n✓ Database cleaned!\n";
?>
