<?php
/**
 * Check restaurant_tables structure
 */

include 'config.php';

echo "<h2>Restaurant Tables Structure</h2>";
echo "<pre>";

// Show table structure
$result = $conn->query("DESCRIBE restaurant_tables");
echo "Columns in restaurant_tables:\n";
while ($row = $result->fetch_assoc()) {
    echo sprintf("%-20s %-20s %s\n", $row['Field'], $row['Type'], ($row['Null'] === 'YES' ? 'NULL' : 'NOT NULL'));
}

echo "\n\nSample row from restaurant_tables:\n";
$result = $conn->query("SELECT * FROM restaurant_tables LIMIT 1");
if ($result->num_rows > 0) {
    $row = $result->fetch_assoc();
    foreach ($row as $key => $value) {
        echo "  $key => " . ($value === null ? "NULL" : $value) . "\n";
    }
}

echo "\n\nAll restaurant_tables:\n";
$result = $conn->query("SELECT id, table_number, capacity, floor, section FROM restaurant_tables");
echo "Total: " . $result->num_rows . "\n";
while ($row = $result->fetch_assoc()) {
    echo "  ID:" . $row['id'] . " Number:" . $row['table_number'] . " Capacity:" . $row['capacity'] . " Floor:" . $row['floor'] . " Section:" . $row['section'] . "\n";
}

echo "</pre>";
?>
