<?php
/**
 * Check specific assignment ID that was shown earlier
 */

include 'config.php';

echo "<h2>Check Assignment ID 21</h2>";
echo "<pre>";

// Check assignment 21 specifically
$result = $conn->query("SELECT * FROM table_assignments WHERE id = 21");
echo "Query: SELECT * FROM table_assignments WHERE id = 21\n";
echo "Rows returned: " . $result->num_rows . "\n\n";

if ($result->num_rows > 0) {
    $row = $result->fetch_assoc();
    echo "Assignment 21 found:\n";
    foreach ($row as $key => $value) {
        echo "  $key => " . ($value === null ? "NULL" : $value) . "\n";
    }
} else {
    echo "Assignment 21 NOT FOUND\n";
    echo "\nChecking ALL assignments:\n";
    $result = $conn->query("SELECT id, server_id, table_id, status FROM table_assignments");
    echo "Total: " . $result->num_rows . " assignments\n\n";
    while ($row = $result->fetch_assoc()) {
        echo "ID:" . $row['id'] . " Server:" . $row['server_id'] . " Table:" . $row['table_id'] . " Status:" . $row['status'] . "\n";
    }
}

echo "\n=== Check server 6 ===\n";
$result = $conn->query("SELECT id, name, employee_id FROM servers WHERE id = 6");
if ($result->num_rows > 0) {
    $server = $result->fetch_assoc();
    echo "Server 6: " . $server['name'] . " (" . $server['employee_id'] . ")\n";
} else {
    echo "Server 6 not found!\n";
}

echo "\n=== Server 6 ALL assignments ===\n";
$result = $conn->query("SELECT id, table_id, status FROM table_assignments WHERE server_id = 6");
echo "Count: " . $result->num_rows . "\n";
if ($result->num_rows > 0) {
    while ($row = $result->fetch_assoc()) {
        echo "  Assignment ID:" . $row['id'] . " Table:" . $row['table_id'] . " Status:" . $row['status'] . "\n";
    }
}

echo "</pre>";
?>
