<?php
/**
 * Cart System Setup Verification
 * Check all components are in place
 */

header('Content-Type: application/json');
require_once 'config.php';

$checks = [];

// 1. Check if cart table exists
$result = $conn->query("SHOW TABLES LIKE 'cart'");
$checks['cart_table_exists'] = $result->num_rows > 0 ? true : false;

// 2. Check if cart_api.php exists
$checks['cart_api_exists'] = file_exists(__DIR__ . '/cart_api.php');

// 3. Check if menu table has items
$result = $conn->query("SELECT COUNT(*) as count FROM menu_items");
$row = $result->fetch_assoc();
$checks['menu_items_exist'] = $row['count'] > 0;

// 4. Check if users table exists
$result = $conn->query("SHOW TABLES LIKE 'users'");
$checks['users_table_exists'] = $result->num_rows > 0 ? true : false;

// 5. Try a test query
$checks['database_connection'] = true;

// Return results
echo json_encode([
    'success' => true,
    'message' => 'Cart system verification complete',
    'checks' => $checks,
    'all_good' => (
        $checks['cart_table_exists'] && 
        $checks['cart_api_exists'] && 
        $checks['menu_items_exist'] && 
        $checks['users_table_exists'] && 
        $checks['database_connection']
    ),
    'next_steps' => $checks['cart_table_exists'] ? [
        'Test the system: Go to /menu.php and try adding items to cart',
        'Log in with a test account',
        'Add items to cart and verify they persist after logout/login',
        'Go to /cart.php to view and manage cart items'
    ] : [
        'First: Visit /backend/cart_init.php to create the cart table'
    ]
]);
?>
