<?php
/**
 * Granny Restaurant Backend API Documentation
 * 
 * This file serves as reference documentation for all backend APIs
 */

?>
<!DOCTYPE html>
<html>
<head>
    <title>Backend API Documentation</title>
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        body {
            font-family: 'Raleway', sans-serif;
            line-height: 1.6;
            color: #333;
            background: #f9f7f4;
        }
        .container {
            max-width: 1000px;
            margin: 0 auto;
            padding: 40px 20px;
        }
        header {
            background: linear-gradient(135deg, #d4a574 0%, #8b6f47 100%);
            color: white;
            padding: 40px 20px;
            text-align: center;
            margin-bottom: 40px;
            border-radius: 8px;
        }
        header h1 {
            font-size: 36px;
            margin-bottom: 10px;
        }
        header p {
            font-size: 16px;
            opacity: 0.9;
        }
        .api-section {
            background: white;
            padding: 30px;
            margin-bottom: 30px;
            border-radius: 8px;
            box-shadow: 0 2px 10px rgba(0,0,0,0.1);
        }
        .api-section h2 {
            color: #d4a574;
            margin-bottom: 20px;
            padding-bottom: 10px;
            border-bottom: 2px solid #d4a574;
        }
        .endpoint {
            background: #f9f7f4;
            padding: 12px 16px;
            border-radius: 6px;
            margin-bottom: 15px;
            font-weight: 600;
            font-family: monospace;
            border-left: 4px solid #d4a574;
        }
        .endpoint .method {
            color: #27ae60;
            font-weight: 700;
        }
        .endpoint .path {
            color: #333;
        }
        code {
            background: #f0f0f0;
            padding: 2px 6px;
            border-radius: 3px;
            font-family: monospace;
        }
        pre {
            background: #1e1e1e;
            color: #d4d4d4;
            padding: 15px;
            border-radius: 6px;
            overflow-x: auto;
            margin-bottom: 15px;
        }
        .required {
            color: #c0392b;
            font-weight: 700;
        }
        table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 15px;
        }
        table th {
            background: #d4a574;
            color: white;
            padding: 12px;
            text-align: left;
            font-weight: 600;
        }
        table td {
            padding: 10px 12px;
            border-bottom: 1px solid #e8e8e8;
        }
        table tr:hover {
            background: #f9f7f4;
        }
        .status-success {
            background: #d4edda;
            padding: 15px;
            border-radius: 6px;
            border-left: 4px solid #27ae60;
            margin-bottom: 15px;
        }
        .status-error {
            background: #f8d7da;
            padding: 15px;
            border-radius: 6px;
            border-left: 4px solid #c0392b;
            margin-bottom: 15px;
        }
        .info-box {
            background: #e8f4f8;
            padding: 15px;
            border-radius: 6px;
            border-left: 4px solid #3498db;
            margin-bottom: 15px;
        }
        footer {
            text-align: center;
            padding: 20px;
            color: #999;
            border-top: 1px solid #e8e8e8;
        }
    </style>
</head>
<body>
    <header>
        <h1>Granny Restaurant Backend API</h1>
        <p>Complete API Documentation & Integration Guide</p>
    </header>

    <div class="container">
        <!-- Status Check -->
        <div class="api-section">
            <h2>System Status</h2>
            <div class="info-box">
                ✓ Backend API is ready for integration<br>
                ✓ Database initialized successfully<br>
                ✓ All endpoints are functional
            </div>
        </div>

        <!-- Sign Up API -->
        <div class="api-section">
            <h2>1. User Sign Up / Registration</h2>
            <div class="endpoint">
                <span class="method">POST</span>
                <span class="path">/backend/signup.php</span>
            </div>
            
            <h3>Description</h3>
            <p>Create a new user account with email and password.</p>

            <h3>Request Parameters <span class="required">*Required</span></h3>
            <table>
                <tr>
                    <th>Parameter</th>
                    <th>Type</th>
                    <th>Description</th>
                </tr>
                <tr>
                    <td><span class="required">name</span></td>
                    <td>string</td>
                    <td>User's full name (required)</td>
                </tr>
                <tr>
                    <td><span class="required">email</span></td>
                    <td>string</td>
                    <td>Valid email address (must be unique)</td>
                </tr>
                <tr>
                    <td><span class="required">password</span></td>
                    <td>string</td>
                    <td>Password (minimum 6 characters)</td>
                </tr>
                <tr>
                    <td><span class="required">confirmPassword</span></td>
                    <td>string</td>
                    <td>Must match password</td>
                </tr>
            </table>

            <h3>Request Example</h3>
            <pre>POST /backend/signup.php HTTP/1.1
Content-Type: application/json

{
  "name": "John Doe",
  "email": "john@example.com",
  "password": "secure_password_123",
  "confirmPassword": "secure_password_123"
}</pre>

            <h3>Success Response (200)</h3>
            <div class="status-success">
                <pre>{
  "success": true,
  "message": "Account created successfully",
  "data": {
    "user_id": 1,
    "name": "John Doe",
    "email": "john@example.com"
  }
}</pre>
            </div>

            <h3>Error Response</h3>
            <div class="status-error">
                <pre>{
  "success": false,
  "message": "Email already registered"
}</pre>
            </div>
        </div>

        <!-- Sign In API -->
        <div class="api-section">
            <h2>2. User Sign In / Login</h2>
            <div class="endpoint">
                <span class="method">POST</span>
                <span class="path">/backend/signin.php</span>
            </div>
            
            <h3>Description</h3>
            <p>Authenticate user with email and password. Supports "Remember Me" functionality.</p>

            <h3>Request Parameters <span class="required">*Required</span></h3>
            <table>
                <tr>
                    <th>Parameter</th>
                    <th>Type</th>
                    <th>Description</th>
                </tr>
                <tr>
                    <td><span class="required">email</span></td>
                    <td>string</td>
                    <td>User's registered email</td>
                </tr>
                <tr>
                    <td><span class="required">password</span></td>
                    <td>string</td>
                    <td>User's password</td>
                </tr>
                <tr>
                    <td>rememberMe</td>
                    <td>boolean</td>
                    <td>Keep user logged in (sets cookie for 30 days)</td>
                </tr>
            </table>

            <h3>Request Example</h3>
            <pre>POST /backend/signin.php HTTP/1.1
Content-Type: application/json

{
  "email": "john@example.com",
  "password": "secure_password_123",
  "rememberMe": true
}</pre>

            <h3>Success Response (200)</h3>
            <div class="status-success">
                <pre>{
  "success": true,
  "message": "Sign in successful",
  "data": {
    "user_id": 1,
    "name": "John Doe",
    "email": "john@example.com"
  }
}</pre>
            </div>
        </div>

        <!-- Booking API -->
        <div class="api-section">
            <h2>3. Table Booking</h2>
            <div class="endpoint">
                <span class="method">POST</span>
                <span class="path">/backend/booking.php</span>
            </div>
            
            <h3>Description</h3>
            <p>Create a new table reservation. Both registered users and guests can book.</p>

            <h3>Request Parameters <span class="required">*Required</span></h3>
            <table>
                <tr>
                    <th>Parameter</th>
                    <th>Type</th>
                    <th>Description</th>
                </tr>
                <tr>
                    <td><span class="required">booking_name</span></td>
                    <td>string</td>
                    <td>Name for the reservation</td>
                </tr>
                <tr>
                    <td><span class="required">booking_email</span></td>
                    <td>string</td>
                    <td>Contact email</td>
                </tr>
                <tr>
                    <td><span class="required">booking_phone</span></td>
                    <td>string</td>
                    <td>Contact phone number</td>
                </tr>
                <tr>
                    <td><span class="required">booking_date</span></td>
                    <td>date</td>
                    <td>Reservation date (YYYY-MM-DD)</td>
                </tr>
                <tr>
                    <td><span class="required">booking_time</span></td>
                    <td>time</td>
                    <td>Reservation time (HH:MM)</td>
                </tr>
                <tr>
                    <td><span class="required">booking_guests</span></td>
                    <td>integer</td>
                    <td>Number of guests (1-100)</td>
                </tr>
                <tr>
                    <td>booking_occasion</td>
                    <td>string</td>
                    <td>Occasion type (birthday, anniversary, etc.)</td>
                </tr>
                <tr>
                    <td>booking_table_type</td>
                    <td>string</td>
                    <td>Preferred table (window, corner, outdoor, etc.)</td>
                </tr>
                <tr>
                    <td>booking_dietary</td>
                    <td>string</td>
                    <td>Dietary requirements/restrictions</td>
                </tr>
                <tr>
                    <td>booking_special_requests</td>
                    <td>string</td>
                    <td>Special requests or notes</td>
                </tr>
            </table>

            <h3>Request Example</h3>
            <pre>POST /backend/booking.php HTTP/1.1
Content-Type: application/json

{
  "booking_name": "John Doe",
  "booking_email": "john@example.com",
  "booking_phone": "+1 (555) 000-0000",
  "booking_date": "2026-02-15",
  "booking_time": "19:00",
  "booking_guests": 4,
  "booking_occasion": "birthday",
  "booking_table_type": "window",
  "booking_dietary": "Vegetarian",
  "booking_special_requests": "High chair needed for baby"
}</pre>

            <h3>Success Response (200)</h3>
            <div class="status-success">
                <pre>{
  "success": true,
  "message": "Booking confirmed successfully",
  "data": {
    "booking_id": 1,
    "booking_date": "2026-02-15",
    "booking_time": "19:00",
    "guests": 4,
    "confirmation_message": "Your table for 4 guest(s) is booked for 2026-02-15 at 19:00..."
  }
}</pre>
            </div>
        </div>

        <!-- Logout API -->
        <div class="api-section">
            <h2>4. User Logout</h2>
            <div class="endpoint">
                <span class="method">POST</span>
                <span class="path">/backend/logout.php</span>
            </div>
            
            <h3>Description</h3>
            <p>Destroy user session and clear cookies.</p>

            <h3>Request Example</h3>
            <pre>POST /backend/logout.php HTTP/1.1</pre>

            <h3>Success Response (200)</h3>
            <div class="status-success">
                <pre>{
  "success": true,
  "message": "Logged out successfully"
}</pre>
            </div>
        </div>

        <!-- Integration Guide -->
        <div class="api-section">
            <h2>Frontend Integration Guide</h2>
            
            <h3>JavaScript Fetch Example</h3>
            <pre>// Sign Up Example
fetch('/rest_table/backend/signup.php', {
    method: 'POST',
    headers: {
        'Content-Type': 'application/json'
    },
    body: JSON.stringify({
        name: 'John Doe',
        email: 'john@example.com',
        password: 'password123',
        confirmPassword: 'password123'
    })
})
.then(response => response.json())
.then(data => {
    if (data.success) {
        console.log('Account created:', data.data);
        localStorage.setItem('user', JSON.stringify(data.data));
    } else {
        console.error('Error:', data.message);
    }
});</pre>

            <h3>Important Notes</h3>
            <div class="info-box">
                <strong>✓ All forms in index.php are already integrated</strong><br>
                ✓ User data is stored in localStorage<br>
                ✓ Sessions are managed server-side<br>
                ✓ Passwords are hashed with bcrypt<br>
                ✓ CORS headers are enabled<br>
                ✓ Input validation happens on both frontend and backend
            </div>
        </div>

        <!-- Testing -->
        <div class="api-section">
            <h2>Quick Testing Guide</h2>
            
            <h3>Test Sign Up</h3>
            <pre>curl -X POST http://localhost/rest_table/backend/signup.php \
  -H "Content-Type: application/json" \
  -d '{
    "name":"Test User",
    "email":"test@example.com",
    "password":"test123456",
    "confirmPassword":"test123456"
  }'</pre>

            <h3>Test Sign In</h3>
            <pre>curl -X POST http://localhost/rest_table/backend/signin.php \
  -H "Content-Type: application/json" \
  -d '{
    "email":"test@example.com",
    "password":"test123456",
    "rememberMe":true
  }'</pre>

            <h3>Test Booking</h3>
            <pre>curl -X POST http://localhost/rest_table/backend/booking.php \
  -H "Content-Type: application/json" \
  -d '{
    "booking_name":"John Doe",
    "booking_email":"john@example.com",
    "booking_phone":"+1234567890",
    "booking_date":"2026-02-20",
    "booking_time":"19:00",
    "booking_guests":4
  }'</pre>
        </div>

        <!-- Error Codes -->
        <div class="api-section">
            <h2>Common Error Messages</h2>
            <table>
                <tr>
                    <th>Error</th>
                    <th>Cause</th>
                    <th>Solution</th>
                </tr>
                <tr>
                    <td>"Email already registered"</td>
                    <td>Email exists in database</td>
                    <td>Use a different email or sign in</td>
                </tr>
                <tr>
                    <td>"Passwords do not match"</td>
                    <td>Password fields don't match</td>
                    <td>Ensure both passwords are identical</td>
                </tr>
                <tr>
                    <td>"Invalid email or password"</td>
                    <td>Wrong credentials</td>
                    <td>Check email and password</td>
                </tr>
                <tr>
                    <td>"Booking date must be in future"</td>
                    <td>Past date/time selected</td>
                    <td>Select today or future date</td>
                </tr>
                <tr>
                    <td>"Database connection failed"</td>
                    <td>MySQL not running or wrong credentials</td>
                    <td>Start XAMPP MySQL, check config.php</td>
                </tr>
            </table>
        </div>
    </div>

    <footer>
        <p>&copy; 2026 Granny Restaurant. Backend API v1.0</p>
        <p>For support, check the SETUP_GUIDE.md file</p>
    </footer>
</body>
</html>
