<?php
/**
 * Admin Session Validator
 * Ensures session is valid and not expired
 * Returns validation status
 */

header('Content-Type: application/json');

// Start session with proper configuration
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

// Check if admin is logged in
if (!isset($_SESSION['admin_id']) || empty($_SESSION['admin_id'])) {
    http_response_code(401);
    echo json_encode([
        'valid' => false,
        'message' => 'No active session'
    ]);
    exit;
}

// Optional: Check for session timeout (30 minutes)
$timeout = 1800; // 30 minutes
$_SESSION['last_activity'] = $_SESSION['last_activity'] ?? time();

if (time() - $_SESSION['last_activity'] > $timeout) {
    // Session expired
    session_destroy();
    http_response_code(401);
    echo json_encode([
        'valid' => false,
        'message' => 'Session expired. Please login again.'
    ]);
    exit;
}

// Update last activity
$_SESSION['last_activity'] = time();

// Session is valid
echo json_encode([
    'valid' => true,
    'admin_id' => $_SESSION['admin_id'],
    'admin_name' => $_SESSION['admin_name'] ?? 'Admin',
    'admin_email' => $_SESSION['admin_email'] ?? '',
    'message' => 'Session is valid'
]);
?>
