<?php
session_start();

// Log logout
if (isset($_SESSION['admin_id'])) {
    error_log("Admin logout - ID: " . $_SESSION['admin_id'] . ", Email: " . $_SESSION['admin_email']);
}

// Clear all admin session variables
unset($_SESSION['admin_id']);
unset($_SESSION['admin_email']);
unset($_SESSION['admin_name']);
unset($_SESSION['admin_position']);
unset($_SESSION['admin_permission']);
unset($_SESSION['admin_phone']);
unset($_SESSION['admin_user']);
unset($_SESSION['admin_token']);

// Destroy the entire session
session_destroy();

// Clear session cookie
if (ini_get("session.use_cookies")) {
    $params = session_get_cookie_params();
    setcookie(session_name(), '', time() - 42000,
        $params["path"], $params["domain"],
        $params["secure"], $params["httponly"]
    );
}

// Return success response
header('Content-Type: application/json');
echo json_encode([
    'success' => true,
    'message' => 'Logout successful'
]);
?>
