<?php
/**
 * Add Authentication Fields to Chef Table
 * Adds email, password, status, and employee_id fields for kitchen staff login
 */

header('Content-Type: application/json');
require_once 'config.php';

try {
    // Check if columns already exist
    $columns = ['email', 'password', 'status', 'employee_id', 'role'];
    $existing_columns = [];
    
    $result = $conn->query("DESCRIBE chefs");
    if ($result) {
        while ($col = $result->fetch_assoc()) {
            $existing_columns[] = $col['Field'];
        }
    }
    
    $added_columns = [];
    
    // Add email column if it doesn't exist
    if (!in_array('email', $existing_columns)) {
        $conn->query("ALTER TABLE chefs ADD COLUMN email VARCHAR(255) UNIQUE AFTER name");
        $added_columns[] = 'email';
    }
    
    // Add password column if it doesn't exist
    if (!in_array('password', $existing_columns)) {
        $conn->query("ALTER TABLE chefs ADD COLUMN password VARCHAR(255) AFTER email");
        $added_columns[] = 'password';
    }
    
    // Add employee_id column if it doesn't exist
    if (!in_array('employee_id', $existing_columns)) {
        $conn->query("ALTER TABLE chefs ADD COLUMN employee_id VARCHAR(50) UNIQUE AFTER password");
        $added_columns[] = 'employee_id';
    }
    
    // Add role column if it doesn't exist
    if (!in_array('role', $existing_columns)) {
        $conn->query("ALTER TABLE chefs ADD COLUMN role VARCHAR(50) DEFAULT 'Chef' AFTER position");
        $added_columns[] = 'role';
    }
    
    // Add status column if it doesn't exist
    if (!in_array('status', $existing_columns)) {
        $conn->query("ALTER TABLE chefs ADD COLUMN status VARCHAR(20) DEFAULT 'active' AFTER role");
        $added_columns[] = 'status';
    }
    
    if (count($added_columns) > 0) {
        sendResponse(true, 'Columns added successfully', [
            'added' => $added_columns,
            'message' => 'Chef table updated with authentication fields'
        ]);
    } else {
        sendResponse(true, 'Table already has all required columns', [
            'columns_present' => true
        ]);
    }
    
} catch (Exception $e) {
    http_response_code(500);
    sendResponse(false, 'Error: ' . $e->getMessage(), null);
}

$conn->close();
?>
