<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>Admin Setup - Granny Restaurant</title>
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            font-family: 'Raleway', sans-serif;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            min-height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
            padding: 20px;
        }

        .setup-container {
            background: white;
            border-radius: 15px;
            box-shadow: 0 20px 60px rgba(0, 0, 0, 0.3);
            max-width: 500px;
            width: 100%;
            padding: 50px;
        }

        .setup-header {
            text-align: center;
            margin-bottom: 30px;
        }

        .setup-header h1 {
            font-size: 28px;
            color: #333;
            margin-bottom: 10px;
        }

        .setup-header p {
            color: #999;
            font-size: 14px;
        }

        .setup-form {
            display: none;
        }

        .setup-form.active {
            display: block;
        }

        .form-group {
            margin-bottom: 20px;
        }

        .form-group label {
            display: block;
            font-weight: 600;
            color: #333;
            margin-bottom: 8px;
            font-size: 13px;
        }

        .form-group input {
            width: 100%;
            padding: 12px;
            border: 2px solid #e8e8e8;
            border-radius: 8px;
            font-size: 14px;
            font-family: 'Raleway', sans-serif;
            transition: all 0.3s ease;
        }

        .form-group input:focus {
            outline: none;
            border-color: #667eea;
            box-shadow: 0 0 0 3px rgba(102, 126, 234, 0.1);
        }

        .setup-btn {
            width: 100%;
            padding: 14px;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            border: none;
            border-radius: 8px;
            font-weight: 700;
            cursor: pointer;
            transition: all 0.3s ease;
            margin-top: 10px;
        }

        .setup-btn:hover {
            transform: translateY(-2px);
            box-shadow: 0 8px 20px rgba(102, 126, 234, 0.3);
        }

        .message {
            padding: 15px;
            border-radius: 8px;
            margin-bottom: 20px;
            display: none;
            text-align: center;
        }

        .message.success {
            background: #d4edda;
            color: #155724;
            border: 1px solid #c3e6cb;
            display: block;
        }

        .message.error {
            background: #f8d7da;
            color: #721c24;
            border: 1px solid #f5c6cb;
            display: block;
        }

        .status-box {
            padding: 20px;
            background: #f5f5f5;
            border-radius: 8px;
            margin-bottom: 20px;
            text-align: center;
        }

        .status-box h3 {
            color: #333;
            font-size: 16px;
            margin-bottom: 10px;
        }

        .status-box p {
            color: #666;
            font-size: 13px;
            line-height: 1.6;
        }

        .status-item {
            display: flex;
            align-items: center;
            gap: 10px;
            margin-bottom: 10px;
            font-size: 14px;
        }

        .status-item .icon {
            width: 24px;
            height: 24px;
            display: flex;
            align-items: center;
            justify-content: center;
            border-radius: 50%;
        }

        .status-item .icon.success {
            background: #d4edda;
            color: #155724;
            font-weight: bold;
        }

        .status-item .icon.pending {
            background: #fff3cd;
            color: #856404;
            font-weight: bold;
        }

        .info-box {
            background: #e7f3ff;
            border-left: 4px solid #2196F3;
            padding: 15px;
            border-radius: 4px;
            margin-top: 20px;
            font-size: 12px;
            color: #1565c0;
            line-height: 1.6;
        }

        .info-box strong {
            display: block;
            margin-bottom: 5px;
            color: #1976d2;
        }
    </style>
</head>
<body>
    <div class="setup-container">
        <div class="setup-header">
            <h1>🍽️ Admin Setup</h1>
            <p>Create your first admin account for Granny Restaurant</p>
        </div>

        <div id="checkMessage" class="message"></div>

        <div id="setupStatus" class="status-box">
            <h3>Checking Setup Status...</h3>
            <p>Verifying database and admin account...</p>
        </div>

        <form id="adminSetupForm" class="setup-form">
            <div class="message success" id="setupMessage" style="display: none;">
                Admin account created successfully! Redirecting...
            </div>

            <div class="form-group">
                <label for="adminName">Admin Name</label>
                <input type="text" id="adminName" name="name" placeholder="John Doe" required>
            </div>

            <div class="form-group">
                <label for="adminEmail">Admin Email</label>
                <input type="email" id="adminEmail" name="email" placeholder="admin@restaurant.com" required>
            </div>

            <div class="form-group">
                <label for="adminPosition">Position/Title</label>
                <input type="text" id="adminPosition" name="position" placeholder="General Manager" required>
            </div>

            <div class="form-group">
                <label for="adminPhone">Phone Number</label>
                <input type="tel" id="adminPhone" name="phone" placeholder="+1 (555) 000-0000" required>
            </div>

            <div class="form-group">
                <label for="adminPassword">Password</label>
                <input type="password" id="adminPassword" name="password" placeholder="Enter strong password" required>
            </div>

            <div class="form-group">
                <label for="adminConfirmPassword">Confirm Password</label>
                <input type="password" id="adminConfirmPassword" name="confirmPassword" placeholder="Confirm password" required>
            </div>

            <button type="submit" class="setup-btn" id="setupBtn">Create Admin Account</button>

            <div class="info-box">
                <strong>Security Reminder:</strong>
                Use a strong password with at least 8 characters. This account will have full access to the admin dashboard.
            </div>
        </form>
    </div>

    <script>
        document.addEventListener('DOMContentLoaded', function() {
            // Check if admin already exists
            checkAdminStatus();
        });

        function checkAdminStatus() {
            const setupStatus = document.getElementById('setupStatus');
            const form = document.getElementById('adminSetupForm');
            const checkMessage = document.getElementById('checkMessage');

            fetch('check_admin_setup.php')
                .then(response => response.json())
                .then(data => {
                    if (data.admin_exists) {
                        setupStatus.innerHTML = `
                            <div class="status-item">
                                <div class="icon success">✓</div>
                                <div>Admin account already exists</div>
                            </div>
                            <p style="margin-top: 15px; color: #666;">Redirecting to login page...</p>
                        `;
                        setTimeout(() => {
                            window.location.href = 'login.php';
                        }, 2000);
                    } else {
                        setupStatus.innerHTML = `
                            <div class="status-item">
                                <div class="icon success">✓</div>
                                <div>Database setup complete</div>
                            </div>
                            <div class="status-item">
                                <div class="icon pending">!</div>
                                <div>Admin account pending creation</div>
                            </div>
                            <p style="margin-top: 15px; color: #666;">Fill in the form below to create your first admin account.</p>
                        `;
                        form.classList.add('active');
                    }
                })
                .catch(error => {
                    setupStatus.innerHTML = `
                        <div style="color: #d32f2f;">
                            <strong>Error:</strong> ${error.message}
                        </div>
                    `;
                    console.error('Error:', error);
                });
        }

        document.getElementById('adminSetupForm').addEventListener('submit', function(e) {
            e.preventDefault();

            const name = document.getElementById('adminName').value;
            const email = document.getElementById('adminEmail').value;
            const position = document.getElementById('adminPosition').value;
            const phone = document.getElementById('adminPhone').value;
            const password = document.getElementById('adminPassword').value;
            const confirmPassword = document.getElementById('adminConfirmPassword').value;

            // Validate passwords match
            if (password !== confirmPassword) {
                alert('Passwords do not match!');
                return;
            }

            // Validate password strength
            if (password.length < 8) {
                alert('Password must be at least 8 characters long!');
                return;
            }

            const formData = {
                name: name,
                email: email,
                position: position,
                phone: phone,
                password: password
            };

            const setupBtn = document.getElementById('setupBtn');
            setupBtn.disabled = true;
            setupBtn.textContent = 'Creating Admin Account...';

            fetch('create_admin_account.php', {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json'
                },
                body: JSON.stringify(formData)
            })
            .then(response => response.json())
            .then(data => {
                if (data.success) {
                    document.getElementById('setupMessage').style.display = 'block';
                    setTimeout(() => {
                        window.location.href = 'login.php';
                    }, 2000);
                } else {
                    alert('Error: ' + data.message);
                    setupBtn.disabled = false;
                    setupBtn.textContent = 'Create Admin Account';
                }
            })
            .catch(error => {
                alert('Error: ' + error.message);
                setupBtn.disabled = false;
                setupBtn.textContent = 'Create Admin Account';
            });
        });
    </script>
</body>
</html>
