<!DOCTYPE html>
<html dir="ltr" lang="en-US">

<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="author" content="Granny Restaurant">
    <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1">
    <meta name="description" content="Admin Portal - Granny Restaurant">
    <link href="../assets/images/favicon/favicon.png" rel="icon">

    <!-- Fonts -->
    <link href="https://fonts.googleapis.com/css?family=Raleway:100,100i,200,200i,300,300i,400,400i,500,500i,600,600i,700,700i,800,800i,900,900i" rel="stylesheet" type="text/css">

    <!-- Font Awesome Icons -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">

    <!-- SweetAlert2 CSS -->
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/sweetalert2@11/dist/sweetalert2.min.css">

    <title>Admin Login - Granny Restaurant</title>

    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            font-family: 'Raleway', sans-serif;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            min-height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
            padding: 20px;
        }

        .login-wrapper {
            width: 100%;
            max-width: 1200px;
            display: grid;
            grid-template-columns: 1fr 1fr;
            gap: 0;
            border-radius: 20px;
            overflow: hidden;
            box-shadow: 0 30px 60px rgba(0, 0, 0, 0.3);
            background: white;
            min-height: 500px;
        }

        /* Left Side - Welcome Section */
        .login-welcome {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            padding: 60px 50px;
            display: flex;
            flex-direction: column;
            justify-content: center;
            color: white;
            position: relative;
            overflow: hidden;
        }

        .login-welcome::before {
            content: '';
            position: absolute;
            top: -50%;
            right: -50%;
            width: 600px;
            height: 600px;
            background: radial-gradient(circle, rgba(255,255,255,0.1) 1px, transparent 1px);
            background-size: 30px 30px;
            animation: moveBackground 15s linear infinite;
        }

        @keyframes moveBackground {
            0% { transform: translate(0, 0); }
            100% { transform: translate(30px, 30px); }
        }

        .welcome-content {
            position: relative;
            z-index: 1;
        }

        .welcome-title {
            font-size: 48px;
            font-weight: 700;
            margin-bottom: 20px;
            line-height: 1.2;
        }

        .welcome-emoji {
            font-size: 48px;
            margin-left: 10px;
            display: inline-block;
            animation: wave 2s ease-in-out infinite;
        }

        @keyframes wave {
            0%, 100% { transform: rotate(0deg); }
            25% { transform: rotate(20deg); }
            75% { transform: rotate(-20deg); }
        }

        .welcome-text {
            font-size: 16px;
            opacity: 0.95;
            margin-bottom: 40px;
            line-height: 1.6;
            font-weight: 300;
        }

        .features-list {
            list-style: none;
            padding: 0;
        }

        .features-list li {
            font-size: 14px;
            margin-bottom: 18px;
            display: flex;
            align-items: center;
            gap: 12px;
            font-weight: 500;
        }

        .features-list i {
            width: 24px;
            height: 24px;
            background: white;
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            color: #667eea;
            font-size: 12px;
        }

        /* Right Side - Login Form */
        .login-form-section {
            padding: 60px 50px;
            display: flex;
            flex-direction: column;
            justify-content: center;
        }

        .login-form-container {
            max-width: 100%;
        }

        .login-form-title {
            font-size: 32px;
            font-weight: 700;
            color: #333;
            margin-bottom: 10px;
        }

        .login-form-subtitle {
            font-size: 15px;
            color: #999;
            margin-bottom: 30px;
        }

        .form-message {
            padding: 15px;
            border-radius: 8px;
            margin-bottom: 20px;
            display: none;
            align-items: center;
            gap: 12px;
            font-weight: 500;
            font-size: 13px;
        }

        .form-message.success {
            background: #d4edda;
            color: #155724;
            border: 1px solid #c3e6cb;
        }

        .form-message.error {
            background: #f8d7da;
            color: #721c24;
            border: 1px solid #f5c6cb;
        }

        .form-group {
            margin-bottom: 25px;
        }

        .form-group label {
            display: block;
            font-weight: 600;
            color: #333;
            margin-bottom: 10px;
            font-size: 14px;
        }

        .input-wrapper {
            position: relative;
            display: flex;
            align-items: center;
        }

        .input-icon {
            position: absolute;
            left: 15px;
            color: #667eea;
            font-size: 16px;
            cursor: pointer;
            z-index: 2;
        }

        .login-input {
            width: 100%;
            padding: 14px 15px 14px 45px;
            border: 2px solid #e8e8e8;
            border-radius: 10px;
            font-size: 14px;
            font-family: 'Raleway', sans-serif;
            transition: all 0.3s ease;
            background: #f8f9fb;
        }

        .login-input:focus {
            outline: none;
            border-color: #667eea;
            background: white;
            box-shadow: 0 0 0 3px rgba(102, 126, 234, 0.1);
        }

        .login-input::placeholder {
            color: #999;
        }

        .form-bottom {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 25px;
            font-size: 13px;
        }

        .remember-me {
            display: flex;
            align-items: center;
            gap: 8px;
        }

        .remember-me input[type="checkbox"] {
            width: 16px;
            height: 16px;
            cursor: pointer;
            accent-color: #667eea;
        }

        .remember-me label {
            margin: 0;
            color: #666;
            cursor: pointer;
            font-weight: 400;
        }

        .forgot-password {
            color: #667eea;
            text-decoration: none;
            font-weight: 600;
            transition: color 0.3s ease;
        }

        .forgot-password:hover {
            color: #764ba2;
            text-decoration: underline;
        }

        .login-btn {
            width: 100%;
            padding: 16px;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            border: none;
            border-radius: 10px;
            font-size: 16px;
            font-weight: 700;
            cursor: pointer;
            text-transform: capitalize;
            letter-spacing: 0.5px;
            transition: all 0.3s cubic-bezier(0.25, 0.46, 0.45, 0.94);
            box-shadow: 0 8px 20px rgba(102, 126, 234, 0.3);
            position: relative;
            overflow: hidden;
            display: flex;
            align-items: center;
            justify-content: center;
            gap: 10px;
        }

        .login-btn::before {
            content: '';
            position: absolute;
            top: 0;
            left: -100%;
            width: 100%;
            height: 100%;
            background: rgba(255, 255, 255, 0.2);
            transition: left 0.3s ease;
            z-index: 0;
        }

        .login-btn:hover::before {
            left: 100%;
        }

        .login-btn:hover {
            transform: translateY(-3px);
            box-shadow: 0 12px 30px rgba(102, 126, 234, 0.4);
        }

        .login-btn:active {
            transform: translateY(-1px);
        }

        .login-btn:disabled {
            opacity: 0.7;
            cursor: not-allowed;
            transform: none;
        }

        .btn-text {
            position: relative;
            z-index: 1;
        }

        .loader {
            display: none;
            width: 16px;
            height: 16px;
            border: 2px solid rgba(255, 255, 255, 0.3);
            border-top: 2px solid white;
            border-radius: 50%;
            animation: spin 0.8s linear infinite;
            position: relative;
            z-index: 1;
        }

        .login-btn.loading .loader {
            display: block;
        }

        @keyframes spin {
            0% { transform: rotate(0deg); }
            100% { transform: rotate(360deg); }
        }

        /* Responsive Design */
        @media (max-width: 1024px) {
            .login-welcome {
                padding: 40px 30px;
            }

            .login-form-section {
                padding: 40px 30px;
            }

            .welcome-title {
                font-size: 36px;
            }

            .login-form-title {
                font-size: 28px;
            }
        }

        @media (max-width: 768px) {
            .login-wrapper {
                grid-template-columns: 1fr;
                min-height: auto;
            }

            .login-welcome {
                padding: 40px 30px;
                min-height: 300px;
            }

            .login-form-section {
                padding: 40px 30px;
            }

            .welcome-title {
                font-size: 32px;
            }

            .login-form-title {
                font-size: 24px;
            }

            .features-list li {
                font-size: 13px;
                margin-bottom: 14px;
            }
        }

        @media (max-width: 576px) {
            .login-wrapper {
                border-radius: 15px;
            }

            .login-welcome {
                padding: 30px 20px;
            }

            .login-form-section {
                padding: 30px 20px;
            }

            .welcome-title {
                font-size: 28px;
                margin-bottom: 15px;
            }

            .welcome-emoji {
                font-size: 36px;
            }

            .welcome-text {
                font-size: 14px;
                margin-bottom: 25px;
            }

            .login-form-title {
                font-size: 22px;
            }

            .login-form-subtitle {
                font-size: 13px;
            }

            .form-group {
                margin-bottom: 18px;
            }

            .form-bottom {
                flex-direction: column;
                align-items: flex-start;
                gap: 12px;
            }

            .features-list li {
                font-size: 12px;
                margin-bottom: 12px;
            }
        }

        @media (max-width: 360px) {
            .login-welcome {
                padding: 25px 15px;
                min-height: 250px;
            }

            .login-form-section {
                padding: 25px 15px;
            }

            .welcome-title {
                font-size: 24px;
            }

            .login-form-title {
                font-size: 20px;
            }

            .login-btn {
                padding: 14px;
                font-size: 14px;
            }
        }
    </style>
</head>

<body>
    <div class="login-wrapper">
        <!-- Left Side - Welcome Section -->
        <div class="login-welcome">
            <div class="welcome-content">
                <h1 class="welcome-title">
                    Welcome Back!
                    <span class="welcome-emoji">👋</span>
                </h1>

                <p class="welcome-text">
                    Access your Granny Restaurant Admin Dashboard to manage bookings, orders, and gallery.
                </p>

                <ul class="features-list">
                    <li>
                        <i class="fas fa-check"></i>
                        Manage Reservations
                    </li>
                    <li>
                        <i class="fas fa-check"></i>
                        Control Orders
                    </li>
                    <li>
                        <i class="fas fa-check"></i>
                        Update Menu
                    </li>
                    <li>
                        <i class="fas fa-check"></i>
                        Send Notifications
                    </li>
                </ul>
            </div>
        </div>

        <!-- Right Side - Login Form -->
        <div class="login-form-section">
            <div class="login-form-container">
                <h2 class="login-form-title">Admin Login</h2>
                <p class="login-form-subtitle">Sign in to your account to continue</p>

                <div id="loginMessage" class="form-message">
                    <i class="fas fa-check-circle"></i>
                    <span id="messageText"></span>
                </div>

                <form id="adminLoginForm">
                    <!-- Email Field -->
                    <div class="form-group">
                        <label for="adminEmail">Email Address</label>
                        <div class="input-wrapper">
                            <i class="fas fa-envelope input-icon"></i>
                            <input 
                                type="email" 
                                id="adminEmail" 
                                class="login-input" 
                                name="email" 
                                placeholder="admin@restaurant.com" 
                                required>
                        </div>
                    </div>

                    <!-- Password Field -->
                    <div class="form-group">
                        <label for="adminPassword">Password</label>
                        <div class="input-wrapper">
                            <i class="fas fa-lock input-icon" style="cursor: pointer;"></i>
                            <input 
                                type="password" 
                                id="adminPassword" 
                                class="login-input" 
                                name="password" 
                                placeholder="Enter your password" 
                                required>
                        </div>
                    </div>

                    <!-- Remember & Forgot -->
                    <div class="form-bottom">
                        <div class="remember-me">
                            <input type="checkbox" id="rememberAdmin" name="rememberMe">
                            <label for="rememberAdmin">Remember me</label>
                        </div>
                        <a href="#" class="forgot-password" onclick="handleForgotPassword(); return false;">Forgot password?</a>
                    </div>

                    <!-- Login Button -->
                    <button type="submit" class="login-btn" id="loginBtn">
                        <span class="loader"></span>
                        <span class="btn-text">Sign In</span>
                    </button>
                </form>
            </div>
        </div>
    </div>

    <!-- jQuery -->
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>

    <!-- SweetAlert2 JS -->
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11/dist/sweetalert2.all.min.js"></script>

    <!-- Admin Login Script -->
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            // Check if admin is already logged in via server session
            fetch('../backend/admin_session_check.php')
                .then(response => response.json())
                .then(data => {
                    if (data.valid === true) {
                        window.location.href = 'dashboard.php';
                    }
                })
                .catch(error => {
                    console.log('Session check failed:', error);
                    // Continue to show login form if check fails
                });

            const adminLoginForm = document.getElementById('adminLoginForm');
            const loginMessage = document.getElementById('loginMessage');
            const messageText = document.getElementById('messageText');
            const loginBtn = document.getElementById('loginBtn');
            const btnText = loginBtn.querySelector('.btn-text');
            const passwordInput = document.getElementById('adminPassword');
            const passwordIcon = passwordInput.parentElement.querySelector('.input-icon');

            // Password visibility toggle
            passwordIcon.addEventListener('click', function() {
                if (passwordInput.type === 'password') {
                    passwordInput.type = 'text';
                    passwordIcon.classList.remove('fa-lock');
                    passwordIcon.classList.add('fa-lock-open');
                } else {
                    passwordInput.type = 'password';
                    passwordIcon.classList.remove('fa-lock-open');
                    passwordIcon.classList.add('fa-lock');
                }
            });

            // Form submission
            adminLoginForm.addEventListener('submit', function(e) {
                e.preventDefault();

                const email = document.getElementById('adminEmail').value;
                const password = document.getElementById('adminPassword').value;
                const rememberMe = document.getElementById('rememberAdmin').checked;

                // Show loading state
                loginBtn.disabled = true;
                loginBtn.classList.add('loading');

                const formData = {
                    email: email,
                    password: password,
                    rememberMe: rememberMe
                };

                fetch('../backend/admin_signin.php', {
                    method: 'POST',
                    headers: {
                        'Content-Type': 'application/json'
                    },
                    body: JSON.stringify(formData)
                })
                .then(response => response.json())
                .then(data => {
                    loginBtn.disabled = false;
                    loginBtn.classList.remove('loading');

                    if (data.success) {
                        // Store admin data
                        localStorage.setItem('admin_user', JSON.stringify(data.data));
                        localStorage.setItem('admin_token', data.token || '');

                        // Show success alert
                        Swal.fire({
                            icon: 'success',
                            title: 'Welcome!',
                            text: 'Login successful. Redirecting to dashboard...',
                            confirmButtonColor: '#667eea',
                            allowOutsideClick: false,
                            didClose: function() {
                                window.location.href = 'dashboard.php';
                            }
                        });
                    } else {
                        // Show error alert
                        Swal.fire({
                            icon: 'error',
                            title: 'Authentication Failed',
                            text: data.message || 'Invalid email or password',
                            confirmButtonColor: '#667eea'
                        });
                    }
                })
                .catch(error => {
                    loginBtn.disabled = false;
                    loginBtn.classList.remove('loading');

                    Swal.fire({
                        icon: 'error',
                        title: 'Connection Error',
                        text: 'Error: ' + error.message,
                        confirmButtonColor: '#667eea'
                    });
                });
            });
        });

        function handleForgotPassword() {
            Swal.fire({
                icon: 'info',
                title: 'Password Recovery',
                text: 'Please contact the system administrator to reset your password.',
                confirmButtonColor: '#667eea'
            });
        }
    </script>
</body>

</html>
